/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.config.v1.AzurePlatformStatus;
import io.fabric8.openshift.api.model.config.v1.AzureResourceTag;
import io.fabric8.openshift.api.model.config.v1.AzureResourceTagBuilder;
import io.fabric8.openshift.api.model.config.v1.AzureResourceTagFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class AzurePlatformStatusFluent<A extends AzurePlatformStatusFluent<A>>
extends BaseFluent<A> {
    private String armEndpoint;
    private String cloudName;
    private String networkResourceGroupName;
    private String resourceGroupName;
    private ArrayList<AzureResourceTagBuilder> resourceTags = new ArrayList();
    private Map<String, Object> additionalProperties;

    public AzurePlatformStatusFluent() {
    }

    public AzurePlatformStatusFluent(AzurePlatformStatus instance) {
        AzurePlatformStatus azurePlatformStatus = instance = instance != null ? instance : new AzurePlatformStatus();
        if (instance != null) {
            this.withArmEndpoint(instance.getArmEndpoint());
            this.withCloudName(instance.getCloudName());
            this.withNetworkResourceGroupName(instance.getNetworkResourceGroupName());
            this.withResourceGroupName(instance.getResourceGroupName());
            this.withResourceTags(instance.getResourceTags());
            this.withArmEndpoint(instance.getArmEndpoint());
            this.withCloudName(instance.getCloudName());
            this.withNetworkResourceGroupName(instance.getNetworkResourceGroupName());
            this.withResourceGroupName(instance.getResourceGroupName());
            this.withResourceTags(instance.getResourceTags());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getArmEndpoint() {
        return this.armEndpoint;
    }

    public A withArmEndpoint(String armEndpoint) {
        this.armEndpoint = armEndpoint;
        return (A)this;
    }

    public boolean hasArmEndpoint() {
        return this.armEndpoint != null;
    }

    public String getCloudName() {
        return this.cloudName;
    }

    public A withCloudName(String cloudName) {
        this.cloudName = cloudName;
        return (A)this;
    }

    public boolean hasCloudName() {
        return this.cloudName != null;
    }

    public String getNetworkResourceGroupName() {
        return this.networkResourceGroupName;
    }

    public A withNetworkResourceGroupName(String networkResourceGroupName) {
        this.networkResourceGroupName = networkResourceGroupName;
        return (A)this;
    }

    public boolean hasNetworkResourceGroupName() {
        return this.networkResourceGroupName != null;
    }

    public String getResourceGroupName() {
        return this.resourceGroupName;
    }

    public A withResourceGroupName(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return (A)this;
    }

    public boolean hasResourceGroupName() {
        return this.resourceGroupName != null;
    }

    public A addToResourceTags(int index, AzureResourceTag item) {
        if (this.resourceTags == null) {
            this.resourceTags = new ArrayList();
        }
        AzureResourceTagBuilder builder = new AzureResourceTagBuilder(item);
        if (index < 0 || index >= this.resourceTags.size()) {
            this._visitables.get("resourceTags").add(builder);
            this.resourceTags.add(builder);
        } else {
            this._visitables.get("resourceTags").add(index, builder);
            this.resourceTags.add(index, builder);
        }
        return (A)this;
    }

    public A setToResourceTags(int index, AzureResourceTag item) {
        if (this.resourceTags == null) {
            this.resourceTags = new ArrayList();
        }
        AzureResourceTagBuilder builder = new AzureResourceTagBuilder(item);
        if (index < 0 || index >= this.resourceTags.size()) {
            this._visitables.get("resourceTags").add(builder);
            this.resourceTags.add(builder);
        } else {
            this._visitables.get("resourceTags").set(index, builder);
            this.resourceTags.set(index, builder);
        }
        return (A)this;
    }

    public A addToResourceTags(AzureResourceTag ... items) {
        if (this.resourceTags == null) {
            this.resourceTags = new ArrayList();
        }
        for (AzureResourceTag item : items) {
            AzureResourceTagBuilder builder = new AzureResourceTagBuilder(item);
            this._visitables.get("resourceTags").add(builder);
            this.resourceTags.add(builder);
        }
        return (A)this;
    }

    public A addAllToResourceTags(Collection<AzureResourceTag> items) {
        if (this.resourceTags == null) {
            this.resourceTags = new ArrayList();
        }
        for (AzureResourceTag item : items) {
            AzureResourceTagBuilder builder = new AzureResourceTagBuilder(item);
            this._visitables.get("resourceTags").add(builder);
            this.resourceTags.add(builder);
        }
        return (A)this;
    }

    public A removeFromResourceTags(AzureResourceTag ... items) {
        if (this.resourceTags == null) {
            return (A)this;
        }
        for (AzureResourceTag item : items) {
            AzureResourceTagBuilder builder = new AzureResourceTagBuilder(item);
            this._visitables.get("resourceTags").remove(builder);
            this.resourceTags.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromResourceTags(Collection<AzureResourceTag> items) {
        if (this.resourceTags == null) {
            return (A)this;
        }
        for (AzureResourceTag item : items) {
            AzureResourceTagBuilder builder = new AzureResourceTagBuilder(item);
            this._visitables.get("resourceTags").remove(builder);
            this.resourceTags.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromResourceTags(Predicate<AzureResourceTagBuilder> predicate) {
        if (this.resourceTags == null) {
            return (A)this;
        }
        Iterator<AzureResourceTagBuilder> each = this.resourceTags.iterator();
        Object visitables = this._visitables.get("resourceTags");
        while (each.hasNext()) {
            AzureResourceTagBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<AzureResourceTag> buildResourceTags() {
        return this.resourceTags != null ? AzurePlatformStatusFluent.build(this.resourceTags) : null;
    }

    public AzureResourceTag buildResourceTag(int index) {
        return this.resourceTags.get(index).build();
    }

    public AzureResourceTag buildFirstResourceTag() {
        return this.resourceTags.get(0).build();
    }

    public AzureResourceTag buildLastResourceTag() {
        return this.resourceTags.get(this.resourceTags.size() - 1).build();
    }

    public AzureResourceTag buildMatchingResourceTag(Predicate<AzureResourceTagBuilder> predicate) {
        for (AzureResourceTagBuilder item : this.resourceTags) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingResourceTag(Predicate<AzureResourceTagBuilder> predicate) {
        for (AzureResourceTagBuilder item : this.resourceTags) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withResourceTags(List<AzureResourceTag> resourceTags) {
        if (this.resourceTags != null) {
            this._visitables.get("resourceTags").clear();
        }
        if (resourceTags != null) {
            this.resourceTags = new ArrayList();
            for (AzureResourceTag item : resourceTags) {
                this.addToResourceTags(item);
            }
        } else {
            this.resourceTags = null;
        }
        return (A)this;
    }

    public A withResourceTags(AzureResourceTag ... resourceTags) {
        if (this.resourceTags != null) {
            this.resourceTags.clear();
            this._visitables.remove("resourceTags");
        }
        if (resourceTags != null) {
            for (AzureResourceTag item : resourceTags) {
                this.addToResourceTags(item);
            }
        }
        return (A)this;
    }

    public boolean hasResourceTags() {
        return this.resourceTags != null && !this.resourceTags.isEmpty();
    }

    public A addNewResourceTag(String key, String value) {
        return this.addToResourceTags(new AzureResourceTag(key, value));
    }

    public ResourceTagsNested<A> addNewResourceTag() {
        return new ResourceTagsNested(-1, null);
    }

    public ResourceTagsNested<A> addNewResourceTagLike(AzureResourceTag item) {
        return new ResourceTagsNested(-1, item);
    }

    public ResourceTagsNested<A> setNewResourceTagLike(int index, AzureResourceTag item) {
        return new ResourceTagsNested(index, item);
    }

    public ResourceTagsNested<A> editResourceTag(int index) {
        if (this.resourceTags.size() <= index) {
            throw new RuntimeException("Can't edit resourceTags. Index exceeds size.");
        }
        return this.setNewResourceTagLike(index, this.buildResourceTag(index));
    }

    public ResourceTagsNested<A> editFirstResourceTag() {
        if (this.resourceTags.size() == 0) {
            throw new RuntimeException("Can't edit first resourceTags. The list is empty.");
        }
        return this.setNewResourceTagLike(0, this.buildResourceTag(0));
    }

    public ResourceTagsNested<A> editLastResourceTag() {
        int index = this.resourceTags.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last resourceTags. The list is empty.");
        }
        return this.setNewResourceTagLike(index, this.buildResourceTag(index));
    }

    public ResourceTagsNested<A> editMatchingResourceTag(Predicate<AzureResourceTagBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.resourceTags.size(); ++i) {
            if (!predicate.test(this.resourceTags.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching resourceTags. No match found.");
        }
        return this.setNewResourceTagLike(index, this.buildResourceTag(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AzurePlatformStatusFluent that = (AzurePlatformStatusFluent)o;
        if (!Objects.equals(this.armEndpoint, that.armEndpoint)) {
            return false;
        }
        if (!Objects.equals(this.cloudName, that.cloudName)) {
            return false;
        }
        if (!Objects.equals(this.networkResourceGroupName, that.networkResourceGroupName)) {
            return false;
        }
        if (!Objects.equals(this.resourceGroupName, that.resourceGroupName)) {
            return false;
        }
        if (!Objects.equals(this.resourceTags, that.resourceTags)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.armEndpoint, this.cloudName, this.networkResourceGroupName, this.resourceGroupName, this.resourceTags, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.armEndpoint != null) {
            sb.append("armEndpoint:");
            sb.append(this.armEndpoint + ",");
        }
        if (this.cloudName != null) {
            sb.append("cloudName:");
            sb.append(this.cloudName + ",");
        }
        if (this.networkResourceGroupName != null) {
            sb.append("networkResourceGroupName:");
            sb.append(this.networkResourceGroupName + ",");
        }
        if (this.resourceGroupName != null) {
            sb.append("resourceGroupName:");
            sb.append(this.resourceGroupName + ",");
        }
        if (this.resourceTags != null && !this.resourceTags.isEmpty()) {
            sb.append("resourceTags:");
            sb.append(this.resourceTags + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ResourceTagsNested<N>
    extends AzureResourceTagFluent<ResourceTagsNested<N>>
    implements Nested<N> {
        AzureResourceTagBuilder builder;
        int index;

        ResourceTagsNested(int index, AzureResourceTag item) {
            this.index = index;
            this.builder = new AzureResourceTagBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)AzurePlatformStatusFluent.this.setToResourceTags(this.index, this.builder.build());
        }

        public N endResourceTag() {
            return this.and();
        }
    }
}

