/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.OAuthClient;
import io.fabric8.openshift.api.model.OAuthClientFluent;

public class OAuthClientBuilder
extends OAuthClientFluent<OAuthClientBuilder>
implements VisitableBuilder<OAuthClient, OAuthClientBuilder> {
    OAuthClientFluent<?> fluent;
    Boolean validationEnabled;

    public OAuthClientBuilder() {
        this(false);
    }

    public OAuthClientBuilder(Boolean validationEnabled) {
        this(new OAuthClient(), validationEnabled);
    }

    public OAuthClientBuilder(OAuthClientFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public OAuthClientBuilder(OAuthClientFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new OAuthClient(), validationEnabled);
    }

    public OAuthClientBuilder(OAuthClientFluent<?> fluent, OAuthClient instance) {
        this(fluent, instance, false);
    }

    public OAuthClientBuilder(OAuthClientFluent<?> fluent, OAuthClient instance, Boolean validationEnabled) {
        this.fluent = fluent;
        OAuthClient oAuthClient = instance = instance != null ? instance : new OAuthClient();
        if (instance != null) {
            fluent.withAccessTokenInactivityTimeoutSeconds(instance.getAccessTokenInactivityTimeoutSeconds());
            fluent.withAccessTokenMaxAgeSeconds(instance.getAccessTokenMaxAgeSeconds());
            fluent.withAdditionalSecrets(instance.getAdditionalSecrets());
            fluent.withApiVersion(instance.getApiVersion());
            fluent.withGrantMethod(instance.getGrantMethod());
            fluent.withKind(instance.getKind());
            fluent.withMetadata(instance.getMetadata());
            fluent.withRedirectURIs(instance.getRedirectURIs());
            fluent.withRespondWithChallenges(instance.getRespondWithChallenges());
            fluent.withScopeRestrictions(instance.getScopeRestrictions());
            fluent.withSecret(instance.getSecret());
            fluent.withAccessTokenInactivityTimeoutSeconds(instance.getAccessTokenInactivityTimeoutSeconds());
            fluent.withAccessTokenMaxAgeSeconds(instance.getAccessTokenMaxAgeSeconds());
            fluent.withAdditionalSecrets(instance.getAdditionalSecrets());
            fluent.withApiVersion(instance.getApiVersion());
            fluent.withGrantMethod(instance.getGrantMethod());
            fluent.withKind(instance.getKind());
            fluent.withMetadata(instance.getMetadata());
            fluent.withRedirectURIs(instance.getRedirectURIs());
            fluent.withRespondWithChallenges(instance.getRespondWithChallenges());
            fluent.withScopeRestrictions(instance.getScopeRestrictions());
            fluent.withSecret(instance.getSecret());
            fluent.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    public OAuthClientBuilder(OAuthClient instance) {
        this(instance, (Boolean)false);
    }

    public OAuthClientBuilder(OAuthClient instance, Boolean validationEnabled) {
        this.fluent = this;
        OAuthClient oAuthClient = instance = instance != null ? instance : new OAuthClient();
        if (instance != null) {
            this.withAccessTokenInactivityTimeoutSeconds(instance.getAccessTokenInactivityTimeoutSeconds());
            this.withAccessTokenMaxAgeSeconds(instance.getAccessTokenMaxAgeSeconds());
            this.withAdditionalSecrets(instance.getAdditionalSecrets());
            this.withApiVersion(instance.getApiVersion());
            this.withGrantMethod(instance.getGrantMethod());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withRedirectURIs(instance.getRedirectURIs());
            this.withRespondWithChallenges(instance.getRespondWithChallenges());
            this.withScopeRestrictions(instance.getScopeRestrictions());
            this.withSecret(instance.getSecret());
            this.withAccessTokenInactivityTimeoutSeconds(instance.getAccessTokenInactivityTimeoutSeconds());
            this.withAccessTokenMaxAgeSeconds(instance.getAccessTokenMaxAgeSeconds());
            this.withAdditionalSecrets(instance.getAdditionalSecrets());
            this.withApiVersion(instance.getApiVersion());
            this.withGrantMethod(instance.getGrantMethod());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withRedirectURIs(instance.getRedirectURIs());
            this.withRespondWithChallenges(instance.getRespondWithChallenges());
            this.withScopeRestrictions(instance.getScopeRestrictions());
            this.withSecret(instance.getSecret());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    @Override
    public OAuthClient build() {
        OAuthClient buildable = new OAuthClient(this.fluent.getAccessTokenInactivityTimeoutSeconds(), this.fluent.getAccessTokenMaxAgeSeconds(), this.fluent.getAdditionalSecrets(), this.fluent.getApiVersion(), this.fluent.getGrantMethod(), this.fluent.getKind(), this.fluent.buildMetadata(), this.fluent.getRedirectURIs(), this.fluent.getRespondWithChallenges(), this.fluent.buildScopeRestrictions(), this.fluent.getSecret());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }
}

