/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.ImageStreamStatus;
import io.fabric8.openshift.api.model.NamedTagEventList;
import io.fabric8.openshift.api.model.NamedTagEventListBuilder;
import io.fabric8.openshift.api.model.NamedTagEventListFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ImageStreamStatusFluent<A extends ImageStreamStatusFluent<A>>
extends BaseFluent<A> {
    private String dockerImageRepository;
    private String publicDockerImageRepository;
    private ArrayList<NamedTagEventListBuilder> tags = new ArrayList();
    private Map<String, Object> additionalProperties;

    public ImageStreamStatusFluent() {
    }

    public ImageStreamStatusFluent(ImageStreamStatus instance) {
        ImageStreamStatus imageStreamStatus = instance = instance != null ? instance : new ImageStreamStatus();
        if (instance != null) {
            this.withDockerImageRepository(instance.getDockerImageRepository());
            this.withPublicDockerImageRepository(instance.getPublicDockerImageRepository());
            this.withTags(instance.getTags());
            this.withDockerImageRepository(instance.getDockerImageRepository());
            this.withPublicDockerImageRepository(instance.getPublicDockerImageRepository());
            this.withTags(instance.getTags());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getDockerImageRepository() {
        return this.dockerImageRepository;
    }

    public A withDockerImageRepository(String dockerImageRepository) {
        this.dockerImageRepository = dockerImageRepository;
        return (A)this;
    }

    public boolean hasDockerImageRepository() {
        return this.dockerImageRepository != null;
    }

    public String getPublicDockerImageRepository() {
        return this.publicDockerImageRepository;
    }

    public A withPublicDockerImageRepository(String publicDockerImageRepository) {
        this.publicDockerImageRepository = publicDockerImageRepository;
        return (A)this;
    }

    public boolean hasPublicDockerImageRepository() {
        return this.publicDockerImageRepository != null;
    }

    public A addToTags(int index, NamedTagEventList item) {
        if (this.tags == null) {
            this.tags = new ArrayList();
        }
        NamedTagEventListBuilder builder = new NamedTagEventListBuilder(item);
        if (index < 0 || index >= this.tags.size()) {
            this._visitables.get("tags").add(builder);
            this.tags.add(builder);
        } else {
            this._visitables.get("tags").add(index, builder);
            this.tags.add(index, builder);
        }
        return (A)this;
    }

    public A setToTags(int index, NamedTagEventList item) {
        if (this.tags == null) {
            this.tags = new ArrayList();
        }
        NamedTagEventListBuilder builder = new NamedTagEventListBuilder(item);
        if (index < 0 || index >= this.tags.size()) {
            this._visitables.get("tags").add(builder);
            this.tags.add(builder);
        } else {
            this._visitables.get("tags").set(index, builder);
            this.tags.set(index, builder);
        }
        return (A)this;
    }

    public A addToTags(NamedTagEventList ... items) {
        if (this.tags == null) {
            this.tags = new ArrayList();
        }
        for (NamedTagEventList item : items) {
            NamedTagEventListBuilder builder = new NamedTagEventListBuilder(item);
            this._visitables.get("tags").add(builder);
            this.tags.add(builder);
        }
        return (A)this;
    }

    public A addAllToTags(Collection<NamedTagEventList> items) {
        if (this.tags == null) {
            this.tags = new ArrayList();
        }
        for (NamedTagEventList item : items) {
            NamedTagEventListBuilder builder = new NamedTagEventListBuilder(item);
            this._visitables.get("tags").add(builder);
            this.tags.add(builder);
        }
        return (A)this;
    }

    public A removeFromTags(NamedTagEventList ... items) {
        if (this.tags == null) {
            return (A)this;
        }
        for (NamedTagEventList item : items) {
            NamedTagEventListBuilder builder = new NamedTagEventListBuilder(item);
            this._visitables.get("tags").remove(builder);
            this.tags.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromTags(Collection<NamedTagEventList> items) {
        if (this.tags == null) {
            return (A)this;
        }
        for (NamedTagEventList item : items) {
            NamedTagEventListBuilder builder = new NamedTagEventListBuilder(item);
            this._visitables.get("tags").remove(builder);
            this.tags.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromTags(Predicate<NamedTagEventListBuilder> predicate) {
        if (this.tags == null) {
            return (A)this;
        }
        Iterator<NamedTagEventListBuilder> each = this.tags.iterator();
        Object visitables = this._visitables.get("tags");
        while (each.hasNext()) {
            NamedTagEventListBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<NamedTagEventList> buildTags() {
        return this.tags != null ? ImageStreamStatusFluent.build(this.tags) : null;
    }

    public NamedTagEventList buildTag(int index) {
        return this.tags.get(index).build();
    }

    public NamedTagEventList buildFirstTag() {
        return this.tags.get(0).build();
    }

    public NamedTagEventList buildLastTag() {
        return this.tags.get(this.tags.size() - 1).build();
    }

    public NamedTagEventList buildMatchingTag(Predicate<NamedTagEventListBuilder> predicate) {
        for (NamedTagEventListBuilder item : this.tags) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingTag(Predicate<NamedTagEventListBuilder> predicate) {
        for (NamedTagEventListBuilder item : this.tags) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withTags(List<NamedTagEventList> tags) {
        if (this.tags != null) {
            this._visitables.get("tags").clear();
        }
        if (tags != null) {
            this.tags = new ArrayList();
            for (NamedTagEventList item : tags) {
                this.addToTags(item);
            }
        } else {
            this.tags = null;
        }
        return (A)this;
    }

    public A withTags(NamedTagEventList ... tags) {
        if (this.tags != null) {
            this.tags.clear();
            this._visitables.remove("tags");
        }
        if (tags != null) {
            for (NamedTagEventList item : tags) {
                this.addToTags(item);
            }
        }
        return (A)this;
    }

    public boolean hasTags() {
        return this.tags != null && !this.tags.isEmpty();
    }

    public TagsNested<A> addNewTag() {
        return new TagsNested(-1, null);
    }

    public TagsNested<A> addNewTagLike(NamedTagEventList item) {
        return new TagsNested(-1, item);
    }

    public TagsNested<A> setNewTagLike(int index, NamedTagEventList item) {
        return new TagsNested(index, item);
    }

    public TagsNested<A> editTag(int index) {
        if (this.tags.size() <= index) {
            throw new RuntimeException("Can't edit tags. Index exceeds size.");
        }
        return this.setNewTagLike(index, this.buildTag(index));
    }

    public TagsNested<A> editFirstTag() {
        if (this.tags.size() == 0) {
            throw new RuntimeException("Can't edit first tags. The list is empty.");
        }
        return this.setNewTagLike(0, this.buildTag(0));
    }

    public TagsNested<A> editLastTag() {
        int index = this.tags.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last tags. The list is empty.");
        }
        return this.setNewTagLike(index, this.buildTag(index));
    }

    public TagsNested<A> editMatchingTag(Predicate<NamedTagEventListBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.tags.size(); ++i) {
            if (!predicate.test(this.tags.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching tags. No match found.");
        }
        return this.setNewTagLike(index, this.buildTag(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ImageStreamStatusFluent that = (ImageStreamStatusFluent)o;
        if (!Objects.equals(this.dockerImageRepository, that.dockerImageRepository)) {
            return false;
        }
        if (!Objects.equals(this.publicDockerImageRepository, that.publicDockerImageRepository)) {
            return false;
        }
        if (!Objects.equals(this.tags, that.tags)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.dockerImageRepository, this.publicDockerImageRepository, this.tags, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.dockerImageRepository != null) {
            sb.append("dockerImageRepository:");
            sb.append(this.dockerImageRepository + ",");
        }
        if (this.publicDockerImageRepository != null) {
            sb.append("publicDockerImageRepository:");
            sb.append(this.publicDockerImageRepository + ",");
        }
        if (this.tags != null && !this.tags.isEmpty()) {
            sb.append("tags:");
            sb.append(this.tags + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class TagsNested<N>
    extends NamedTagEventListFluent<TagsNested<N>>
    implements Nested<N> {
        NamedTagEventListBuilder builder;
        int index;

        TagsNested(int index, NamedTagEventList item) {
            this.index = index;
            this.builder = new NamedTagEventListBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ImageStreamStatusFluent.this.setToTags(this.index, this.builder.build());
        }

        public N endTag() {
            return this.and();
        }
    }
}

