/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_8.tuned.v1;

import io.fabric8.kubernetes.api.builder.v6_8.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_8.Nested;
import io.fabric8.openshift.api.model.v6_8.tuned.v1.TunedProfile;
import io.fabric8.openshift.api.model.v6_8.tuned.v1.TunedProfileBuilder;
import io.fabric8.openshift.api.model.v6_8.tuned.v1.TunedProfileFluent;
import io.fabric8.openshift.api.model.v6_8.tuned.v1.TunedRecommend;
import io.fabric8.openshift.api.model.v6_8.tuned.v1.TunedRecommendBuilder;
import io.fabric8.openshift.api.model.v6_8.tuned.v1.TunedRecommendFluent;
import io.fabric8.openshift.api.model.v6_8.tuned.v1.TunedSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class TunedSpecFluent<A extends TunedSpecFluent<A>>
extends BaseFluent<A> {
    private String managementState;
    private ArrayList<TunedProfileBuilder> profile = new ArrayList();
    private ArrayList<TunedRecommendBuilder> recommend = new ArrayList();
    private Map<String, Object> additionalProperties;

    public TunedSpecFluent() {
    }

    public TunedSpecFluent(TunedSpec instance) {
        TunedSpec tunedSpec = instance = instance != null ? instance : new TunedSpec();
        if (instance != null) {
            this.withManagementState(instance.getManagementState());
            this.withProfile(instance.getProfile());
            this.withRecommend(instance.getRecommend());
            this.withManagementState(instance.getManagementState());
            this.withProfile(instance.getProfile());
            this.withRecommend(instance.getRecommend());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getManagementState() {
        return this.managementState;
    }

    public A withManagementState(String managementState) {
        this.managementState = managementState;
        return (A)this;
    }

    public boolean hasManagementState() {
        return this.managementState != null;
    }

    public A addToProfile(int index, TunedProfile item) {
        if (this.profile == null) {
            this.profile = new ArrayList();
        }
        TunedProfileBuilder builder = new TunedProfileBuilder(item);
        if (index < 0 || index >= this.profile.size()) {
            this._visitables.get("profile").add(builder);
            this.profile.add(builder);
        } else {
            this._visitables.get("profile").add(index, builder);
            this.profile.add(index, builder);
        }
        return (A)this;
    }

    public A setToProfile(int index, TunedProfile item) {
        if (this.profile == null) {
            this.profile = new ArrayList();
        }
        TunedProfileBuilder builder = new TunedProfileBuilder(item);
        if (index < 0 || index >= this.profile.size()) {
            this._visitables.get("profile").add(builder);
            this.profile.add(builder);
        } else {
            this._visitables.get("profile").set(index, builder);
            this.profile.set(index, builder);
        }
        return (A)this;
    }

    public A addToProfile(TunedProfile ... items) {
        if (this.profile == null) {
            this.profile = new ArrayList();
        }
        for (TunedProfile item : items) {
            TunedProfileBuilder builder = new TunedProfileBuilder(item);
            this._visitables.get("profile").add(builder);
            this.profile.add(builder);
        }
        return (A)this;
    }

    public A addAllToProfile(Collection<TunedProfile> items) {
        if (this.profile == null) {
            this.profile = new ArrayList();
        }
        for (TunedProfile item : items) {
            TunedProfileBuilder builder = new TunedProfileBuilder(item);
            this._visitables.get("profile").add(builder);
            this.profile.add(builder);
        }
        return (A)this;
    }

    public A removeFromProfile(TunedProfile ... items) {
        if (this.profile == null) {
            return (A)this;
        }
        for (TunedProfile item : items) {
            TunedProfileBuilder builder = new TunedProfileBuilder(item);
            this._visitables.get("profile").remove(builder);
            this.profile.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromProfile(Collection<TunedProfile> items) {
        if (this.profile == null) {
            return (A)this;
        }
        for (TunedProfile item : items) {
            TunedProfileBuilder builder = new TunedProfileBuilder(item);
            this._visitables.get("profile").remove(builder);
            this.profile.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromProfile(Predicate<TunedProfileBuilder> predicate) {
        if (this.profile == null) {
            return (A)this;
        }
        Iterator<TunedProfileBuilder> each = this.profile.iterator();
        Object visitables = this._visitables.get("profile");
        while (each.hasNext()) {
            TunedProfileBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<TunedProfile> buildProfile() {
        return this.profile != null ? TunedSpecFluent.build(this.profile) : null;
    }

    public TunedProfile buildProfile(int index) {
        return this.profile.get(index).build();
    }

    public TunedProfile buildFirstProfile() {
        return this.profile.get(0).build();
    }

    public TunedProfile buildLastProfile() {
        return this.profile.get(this.profile.size() - 1).build();
    }

    public TunedProfile buildMatchingProfile(Predicate<TunedProfileBuilder> predicate) {
        for (TunedProfileBuilder item : this.profile) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingProfile(Predicate<TunedProfileBuilder> predicate) {
        for (TunedProfileBuilder item : this.profile) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withProfile(List<TunedProfile> profile) {
        if (this.profile != null) {
            this._visitables.get("profile").clear();
        }
        if (profile != null) {
            this.profile = new ArrayList();
            for (TunedProfile item : profile) {
                this.addToProfile(item);
            }
        } else {
            this.profile = null;
        }
        return (A)this;
    }

    public A withProfile(TunedProfile ... profile) {
        if (this.profile != null) {
            this.profile.clear();
            this._visitables.remove("profile");
        }
        if (profile != null) {
            for (TunedProfile item : profile) {
                this.addToProfile(item);
            }
        }
        return (A)this;
    }

    public boolean hasProfile() {
        return this.profile != null && !this.profile.isEmpty();
    }

    public A addNewProfile(String data, String name) {
        return this.addToProfile(new TunedProfile(data, name));
    }

    public ProfileNested<A> addNewProfile() {
        return new ProfileNested(-1, null);
    }

    public ProfileNested<A> addNewProfileLike(TunedProfile item) {
        return new ProfileNested(-1, item);
    }

    public ProfileNested<A> setNewProfileLike(int index, TunedProfile item) {
        return new ProfileNested(index, item);
    }

    public ProfileNested<A> editProfile(int index) {
        if (this.profile.size() <= index) {
            throw new RuntimeException("Can't edit profile. Index exceeds size.");
        }
        return this.setNewProfileLike(index, this.buildProfile(index));
    }

    public ProfileNested<A> editFirstProfile() {
        if (this.profile.size() == 0) {
            throw new RuntimeException("Can't edit first profile. The list is empty.");
        }
        return this.setNewProfileLike(0, this.buildProfile(0));
    }

    public ProfileNested<A> editLastProfile() {
        int index = this.profile.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last profile. The list is empty.");
        }
        return this.setNewProfileLike(index, this.buildProfile(index));
    }

    public ProfileNested<A> editMatchingProfile(Predicate<TunedProfileBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.profile.size(); ++i) {
            if (!predicate.test(this.profile.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching profile. No match found.");
        }
        return this.setNewProfileLike(index, this.buildProfile(index));
    }

    public A addToRecommend(int index, TunedRecommend item) {
        if (this.recommend == null) {
            this.recommend = new ArrayList();
        }
        TunedRecommendBuilder builder = new TunedRecommendBuilder(item);
        if (index < 0 || index >= this.recommend.size()) {
            this._visitables.get("recommend").add(builder);
            this.recommend.add(builder);
        } else {
            this._visitables.get("recommend").add(index, builder);
            this.recommend.add(index, builder);
        }
        return (A)this;
    }

    public A setToRecommend(int index, TunedRecommend item) {
        if (this.recommend == null) {
            this.recommend = new ArrayList();
        }
        TunedRecommendBuilder builder = new TunedRecommendBuilder(item);
        if (index < 0 || index >= this.recommend.size()) {
            this._visitables.get("recommend").add(builder);
            this.recommend.add(builder);
        } else {
            this._visitables.get("recommend").set(index, builder);
            this.recommend.set(index, builder);
        }
        return (A)this;
    }

    public A addToRecommend(TunedRecommend ... items) {
        if (this.recommend == null) {
            this.recommend = new ArrayList();
        }
        for (TunedRecommend item : items) {
            TunedRecommendBuilder builder = new TunedRecommendBuilder(item);
            this._visitables.get("recommend").add(builder);
            this.recommend.add(builder);
        }
        return (A)this;
    }

    public A addAllToRecommend(Collection<TunedRecommend> items) {
        if (this.recommend == null) {
            this.recommend = new ArrayList();
        }
        for (TunedRecommend item : items) {
            TunedRecommendBuilder builder = new TunedRecommendBuilder(item);
            this._visitables.get("recommend").add(builder);
            this.recommend.add(builder);
        }
        return (A)this;
    }

    public A removeFromRecommend(TunedRecommend ... items) {
        if (this.recommend == null) {
            return (A)this;
        }
        for (TunedRecommend item : items) {
            TunedRecommendBuilder builder = new TunedRecommendBuilder(item);
            this._visitables.get("recommend").remove(builder);
            this.recommend.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromRecommend(Collection<TunedRecommend> items) {
        if (this.recommend == null) {
            return (A)this;
        }
        for (TunedRecommend item : items) {
            TunedRecommendBuilder builder = new TunedRecommendBuilder(item);
            this._visitables.get("recommend").remove(builder);
            this.recommend.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromRecommend(Predicate<TunedRecommendBuilder> predicate) {
        if (this.recommend == null) {
            return (A)this;
        }
        Iterator<TunedRecommendBuilder> each = this.recommend.iterator();
        Object visitables = this._visitables.get("recommend");
        while (each.hasNext()) {
            TunedRecommendBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<TunedRecommend> buildRecommend() {
        return this.recommend != null ? TunedSpecFluent.build(this.recommend) : null;
    }

    public TunedRecommend buildRecommend(int index) {
        return this.recommend.get(index).build();
    }

    public TunedRecommend buildFirstRecommend() {
        return this.recommend.get(0).build();
    }

    public TunedRecommend buildLastRecommend() {
        return this.recommend.get(this.recommend.size() - 1).build();
    }

    public TunedRecommend buildMatchingRecommend(Predicate<TunedRecommendBuilder> predicate) {
        for (TunedRecommendBuilder item : this.recommend) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingRecommend(Predicate<TunedRecommendBuilder> predicate) {
        for (TunedRecommendBuilder item : this.recommend) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withRecommend(List<TunedRecommend> recommend) {
        if (this.recommend != null) {
            this._visitables.get("recommend").clear();
        }
        if (recommend != null) {
            this.recommend = new ArrayList();
            for (TunedRecommend item : recommend) {
                this.addToRecommend(item);
            }
        } else {
            this.recommend = null;
        }
        return (A)this;
    }

    public A withRecommend(TunedRecommend ... recommend) {
        if (this.recommend != null) {
            this.recommend.clear();
            this._visitables.remove("recommend");
        }
        if (recommend != null) {
            for (TunedRecommend item : recommend) {
                this.addToRecommend(item);
            }
        }
        return (A)this;
    }

    public boolean hasRecommend() {
        return this.recommend != null && !this.recommend.isEmpty();
    }

    public RecommendNested<A> addNewRecommend() {
        return new RecommendNested(-1, null);
    }

    public RecommendNested<A> addNewRecommendLike(TunedRecommend item) {
        return new RecommendNested(-1, item);
    }

    public RecommendNested<A> setNewRecommendLike(int index, TunedRecommend item) {
        return new RecommendNested(index, item);
    }

    public RecommendNested<A> editRecommend(int index) {
        if (this.recommend.size() <= index) {
            throw new RuntimeException("Can't edit recommend. Index exceeds size.");
        }
        return this.setNewRecommendLike(index, this.buildRecommend(index));
    }

    public RecommendNested<A> editFirstRecommend() {
        if (this.recommend.size() == 0) {
            throw new RuntimeException("Can't edit first recommend. The list is empty.");
        }
        return this.setNewRecommendLike(0, this.buildRecommend(0));
    }

    public RecommendNested<A> editLastRecommend() {
        int index = this.recommend.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last recommend. The list is empty.");
        }
        return this.setNewRecommendLike(index, this.buildRecommend(index));
    }

    public RecommendNested<A> editMatchingRecommend(Predicate<TunedRecommendBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.recommend.size(); ++i) {
            if (!predicate.test(this.recommend.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching recommend. No match found.");
        }
        return this.setNewRecommendLike(index, this.buildRecommend(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TunedSpecFluent that = (TunedSpecFluent)o;
        if (!Objects.equals(this.managementState, that.managementState)) {
            return false;
        }
        if (!Objects.equals(this.profile, that.profile)) {
            return false;
        }
        if (!Objects.equals(this.recommend, that.recommend)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.managementState, this.profile, this.recommend, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.managementState != null) {
            sb.append("managementState:");
            sb.append(this.managementState + ",");
        }
        if (this.profile != null && !this.profile.isEmpty()) {
            sb.append("profile:");
            sb.append(this.profile + ",");
        }
        if (this.recommend != null && !this.recommend.isEmpty()) {
            sb.append("recommend:");
            sb.append(this.recommend + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class RecommendNested<N>
    extends TunedRecommendFluent<RecommendNested<N>>
    implements Nested<N> {
        TunedRecommendBuilder builder;
        int index;

        RecommendNested(int index, TunedRecommend item) {
            this.index = index;
            this.builder = new TunedRecommendBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)TunedSpecFluent.this.setToRecommend(this.index, this.builder.build());
        }

        public N endRecommend() {
            return this.and();
        }
    }

    public class ProfileNested<N>
    extends TunedProfileFluent<ProfileNested<N>>
    implements Nested<N> {
        TunedProfileBuilder builder;
        int index;

        ProfileNested(int index, TunedProfile item) {
            this.index = index;
            this.builder = new TunedProfileBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)TunedSpecFluent.this.setToProfile(this.index, this.builder.build());
        }

        public N endProfile() {
            return this.and();
        }
    }
}

