/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_8.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.v6_8.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_8.Nested;
import io.fabric8.openshift.api.model.v6_8.operatorhub.v1alpha1.ResourceInstance;
import io.fabric8.openshift.api.model.v6_8.operatorhub.v1alpha1.ResourceInstanceBuilder;
import io.fabric8.openshift.api.model.v6_8.operatorhub.v1alpha1.ResourceInstanceFluent;
import io.fabric8.openshift.api.model.v6_8.operatorhub.v1alpha1.ResourceList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ResourceListFluent<A extends ResourceListFluent<A>>
extends BaseFluent<A> {
    private String group;
    private ArrayList<ResourceInstanceBuilder> instances = new ArrayList();
    private String kind;
    private Map<String, Object> additionalProperties;

    public ResourceListFluent() {
    }

    public ResourceListFluent(ResourceList instance) {
        ResourceList resourceList = instance = instance != null ? instance : new ResourceList();
        if (instance != null) {
            this.withGroup(instance.getGroup());
            this.withInstances(instance.getInstances());
            this.withKind(instance.getKind());
            this.withGroup(instance.getGroup());
            this.withInstances(instance.getInstances());
            this.withKind(instance.getKind());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getGroup() {
        return this.group;
    }

    public A withGroup(String group) {
        this.group = group;
        return (A)this;
    }

    public boolean hasGroup() {
        return this.group != null;
    }

    public A addToInstances(int index, ResourceInstance item) {
        if (this.instances == null) {
            this.instances = new ArrayList();
        }
        ResourceInstanceBuilder builder = new ResourceInstanceBuilder(item);
        if (index < 0 || index >= this.instances.size()) {
            this._visitables.get("instances").add(builder);
            this.instances.add(builder);
        } else {
            this._visitables.get("instances").add(index, builder);
            this.instances.add(index, builder);
        }
        return (A)this;
    }

    public A setToInstances(int index, ResourceInstance item) {
        if (this.instances == null) {
            this.instances = new ArrayList();
        }
        ResourceInstanceBuilder builder = new ResourceInstanceBuilder(item);
        if (index < 0 || index >= this.instances.size()) {
            this._visitables.get("instances").add(builder);
            this.instances.add(builder);
        } else {
            this._visitables.get("instances").set(index, builder);
            this.instances.set(index, builder);
        }
        return (A)this;
    }

    public A addToInstances(ResourceInstance ... items) {
        if (this.instances == null) {
            this.instances = new ArrayList();
        }
        for (ResourceInstance item : items) {
            ResourceInstanceBuilder builder = new ResourceInstanceBuilder(item);
            this._visitables.get("instances").add(builder);
            this.instances.add(builder);
        }
        return (A)this;
    }

    public A addAllToInstances(Collection<ResourceInstance> items) {
        if (this.instances == null) {
            this.instances = new ArrayList();
        }
        for (ResourceInstance item : items) {
            ResourceInstanceBuilder builder = new ResourceInstanceBuilder(item);
            this._visitables.get("instances").add(builder);
            this.instances.add(builder);
        }
        return (A)this;
    }

    public A removeFromInstances(ResourceInstance ... items) {
        if (this.instances == null) {
            return (A)this;
        }
        for (ResourceInstance item : items) {
            ResourceInstanceBuilder builder = new ResourceInstanceBuilder(item);
            this._visitables.get("instances").remove(builder);
            this.instances.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromInstances(Collection<ResourceInstance> items) {
        if (this.instances == null) {
            return (A)this;
        }
        for (ResourceInstance item : items) {
            ResourceInstanceBuilder builder = new ResourceInstanceBuilder(item);
            this._visitables.get("instances").remove(builder);
            this.instances.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromInstances(Predicate<ResourceInstanceBuilder> predicate) {
        if (this.instances == null) {
            return (A)this;
        }
        Iterator<ResourceInstanceBuilder> each = this.instances.iterator();
        Object visitables = this._visitables.get("instances");
        while (each.hasNext()) {
            ResourceInstanceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<ResourceInstance> buildInstances() {
        return this.instances != null ? ResourceListFluent.build(this.instances) : null;
    }

    public ResourceInstance buildInstance(int index) {
        return this.instances.get(index).build();
    }

    public ResourceInstance buildFirstInstance() {
        return this.instances.get(0).build();
    }

    public ResourceInstance buildLastInstance() {
        return this.instances.get(this.instances.size() - 1).build();
    }

    public ResourceInstance buildMatchingInstance(Predicate<ResourceInstanceBuilder> predicate) {
        for (ResourceInstanceBuilder item : this.instances) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingInstance(Predicate<ResourceInstanceBuilder> predicate) {
        for (ResourceInstanceBuilder item : this.instances) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withInstances(List<ResourceInstance> instances) {
        if (this.instances != null) {
            this._visitables.get("instances").clear();
        }
        if (instances != null) {
            this.instances = new ArrayList();
            for (ResourceInstance item : instances) {
                this.addToInstances(item);
            }
        } else {
            this.instances = null;
        }
        return (A)this;
    }

    public A withInstances(ResourceInstance ... instances) {
        if (this.instances != null) {
            this.instances.clear();
            this._visitables.remove("instances");
        }
        if (instances != null) {
            for (ResourceInstance item : instances) {
                this.addToInstances(item);
            }
        }
        return (A)this;
    }

    public boolean hasInstances() {
        return this.instances != null && !this.instances.isEmpty();
    }

    public A addNewInstance(String name, String namespace) {
        return this.addToInstances(new ResourceInstance(name, namespace));
    }

    public InstancesNested<A> addNewInstance() {
        return new InstancesNested(-1, null);
    }

    public InstancesNested<A> addNewInstanceLike(ResourceInstance item) {
        return new InstancesNested(-1, item);
    }

    public InstancesNested<A> setNewInstanceLike(int index, ResourceInstance item) {
        return new InstancesNested(index, item);
    }

    public InstancesNested<A> editInstance(int index) {
        if (this.instances.size() <= index) {
            throw new RuntimeException("Can't edit instances. Index exceeds size.");
        }
        return this.setNewInstanceLike(index, this.buildInstance(index));
    }

    public InstancesNested<A> editFirstInstance() {
        if (this.instances.size() == 0) {
            throw new RuntimeException("Can't edit first instances. The list is empty.");
        }
        return this.setNewInstanceLike(0, this.buildInstance(0));
    }

    public InstancesNested<A> editLastInstance() {
        int index = this.instances.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last instances. The list is empty.");
        }
        return this.setNewInstanceLike(index, this.buildInstance(index));
    }

    public InstancesNested<A> editMatchingInstance(Predicate<ResourceInstanceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.instances.size(); ++i) {
            if (!predicate.test(this.instances.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching instances. No match found.");
        }
        return this.setNewInstanceLike(index, this.buildInstance(index));
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ResourceListFluent that = (ResourceListFluent)o;
        if (!Objects.equals(this.group, that.group)) {
            return false;
        }
        if (!Objects.equals(this.instances, that.instances)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.group, this.instances, this.kind, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.group != null) {
            sb.append("group:");
            sb.append(this.group + ",");
        }
        if (this.instances != null && !this.instances.isEmpty()) {
            sb.append("instances:");
            sb.append(this.instances + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class InstancesNested<N>
    extends ResourceInstanceFluent<InstancesNested<N>>
    implements Nested<N> {
        ResourceInstanceBuilder builder;
        int index;

        InstancesNested(int index, ResourceInstance item) {
            this.index = index;
            this.builder = new ResourceInstanceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ResourceListFluent.this.setToInstances(this.index, this.builder.build());
        }

        public N endInstance() {
            return this.and();
        }
    }
}

