/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_8.operator.v1;

import io.fabric8.kubernetes.api.builder.v6_8.BaseFluent;
import io.fabric8.openshift.api.model.v6_8.operator.v1.HTTPCompressionPolicy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class HTTPCompressionPolicyFluent<A extends HTTPCompressionPolicyFluent<A>>
extends BaseFluent<A> {
    private List<String> mimeTypes = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public HTTPCompressionPolicyFluent() {
    }

    public HTTPCompressionPolicyFluent(HTTPCompressionPolicy instance) {
        HTTPCompressionPolicy hTTPCompressionPolicy = instance = instance != null ? instance : new HTTPCompressionPolicy();
        if (instance != null) {
            this.withMimeTypes(instance.getMimeTypes());
            this.withMimeTypes(instance.getMimeTypes());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToMimeTypes(int index, String item) {
        if (this.mimeTypes == null) {
            this.mimeTypes = new ArrayList<String>();
        }
        this.mimeTypes.add(index, item);
        return (A)this;
    }

    public A setToMimeTypes(int index, String item) {
        if (this.mimeTypes == null) {
            this.mimeTypes = new ArrayList<String>();
        }
        this.mimeTypes.set(index, item);
        return (A)this;
    }

    public A addToMimeTypes(String ... items) {
        if (this.mimeTypes == null) {
            this.mimeTypes = new ArrayList<String>();
        }
        for (String item : items) {
            this.mimeTypes.add(item);
        }
        return (A)this;
    }

    public A addAllToMimeTypes(Collection<String> items) {
        if (this.mimeTypes == null) {
            this.mimeTypes = new ArrayList<String>();
        }
        for (String item : items) {
            this.mimeTypes.add(item);
        }
        return (A)this;
    }

    public A removeFromMimeTypes(String ... items) {
        if (this.mimeTypes == null) {
            return (A)this;
        }
        for (String item : items) {
            this.mimeTypes.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromMimeTypes(Collection<String> items) {
        if (this.mimeTypes == null) {
            return (A)this;
        }
        for (String item : items) {
            this.mimeTypes.remove(item);
        }
        return (A)this;
    }

    public List<String> getMimeTypes() {
        return this.mimeTypes;
    }

    public String getMimeType(int index) {
        return this.mimeTypes.get(index);
    }

    public String getFirstMimeType() {
        return this.mimeTypes.get(0);
    }

    public String getLastMimeType() {
        return this.mimeTypes.get(this.mimeTypes.size() - 1);
    }

    public String getMatchingMimeType(Predicate<String> predicate) {
        for (String item : this.mimeTypes) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingMimeType(Predicate<String> predicate) {
        for (String item : this.mimeTypes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withMimeTypes(List<String> mimeTypes) {
        if (mimeTypes != null) {
            this.mimeTypes = new ArrayList<String>();
            for (String item : mimeTypes) {
                this.addToMimeTypes(item);
            }
        } else {
            this.mimeTypes = null;
        }
        return (A)this;
    }

    public A withMimeTypes(String ... mimeTypes) {
        if (this.mimeTypes != null) {
            this.mimeTypes.clear();
            this._visitables.remove("mimeTypes");
        }
        if (mimeTypes != null) {
            for (String item : mimeTypes) {
                this.addToMimeTypes(item);
            }
        }
        return (A)this;
    }

    public boolean hasMimeTypes() {
        return this.mimeTypes != null && !this.mimeTypes.isEmpty();
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HTTPCompressionPolicyFluent that = (HTTPCompressionPolicyFluent)o;
        if (!Objects.equals(this.mimeTypes, that.mimeTypes)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.mimeTypes, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.mimeTypes != null && !this.mimeTypes.isEmpty()) {
            sb.append("mimeTypes:");
            sb.append(this.mimeTypes + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

