/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_8.monitoring.v1;

import io.fabric8.kubernetes.api.builder.v6_8.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_8.Nested;
import io.fabric8.kubernetes.api.model.v6_8.ResourceRequirements;
import io.fabric8.kubernetes.api.model.v6_8.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.model.v6_8.ResourceRequirementsFluent;
import io.fabric8.kubernetes.api.model.v6_8.SecretKeySelector;
import io.fabric8.kubernetes.api.model.v6_8.VolumeMount;
import io.fabric8.openshift.api.model.v6_8.monitoring.v1.TLSConfig;
import io.fabric8.openshift.api.model.v6_8.monitoring.v1.TLSConfigBuilder;
import io.fabric8.openshift.api.model.v6_8.monitoring.v1.TLSConfigFluent;
import io.fabric8.openshift.api.model.v6_8.monitoring.v1.ThanosSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class ThanosSpecFluent<A extends ThanosSpecFluent<A>>
extends BaseFluent<A> {
    private String baseImage;
    private TLSConfigBuilder grpcServerTlsConfig;
    private String image;
    private Boolean listenLocal;
    private String logFormat;
    private String logLevel;
    private String minTime;
    private SecretKeySelector objectStorageConfig;
    private String objectStorageConfigFile;
    private String readyTimeout;
    private ResourceRequirementsBuilder resources;
    private String sha;
    private String tag;
    private SecretKeySelector tracingConfig;
    private String tracingConfigFile;
    private String version;
    private List<VolumeMount> volumeMounts = new ArrayList<VolumeMount>();
    private Map<String, Object> additionalProperties;

    public ThanosSpecFluent() {
    }

    public ThanosSpecFluent(ThanosSpec instance) {
        ThanosSpec thanosSpec = instance = instance != null ? instance : new ThanosSpec();
        if (instance != null) {
            this.withBaseImage(instance.getBaseImage());
            this.withGrpcServerTlsConfig(instance.getGrpcServerTlsConfig());
            this.withImage(instance.getImage());
            this.withListenLocal(instance.getListenLocal());
            this.withLogFormat(instance.getLogFormat());
            this.withLogLevel(instance.getLogLevel());
            this.withMinTime(instance.getMinTime());
            this.withObjectStorageConfig(instance.getObjectStorageConfig());
            this.withObjectStorageConfigFile(instance.getObjectStorageConfigFile());
            this.withReadyTimeout(instance.getReadyTimeout());
            this.withResources(instance.getResources());
            this.withSha(instance.getSha());
            this.withTag(instance.getTag());
            this.withTracingConfig(instance.getTracingConfig());
            this.withTracingConfigFile(instance.getTracingConfigFile());
            this.withVersion(instance.getVersion());
            this.withVolumeMounts(instance.getVolumeMounts());
            this.withBaseImage(instance.getBaseImage());
            this.withGrpcServerTlsConfig(instance.getGrpcServerTlsConfig());
            this.withImage(instance.getImage());
            this.withListenLocal(instance.getListenLocal());
            this.withLogFormat(instance.getLogFormat());
            this.withLogLevel(instance.getLogLevel());
            this.withMinTime(instance.getMinTime());
            this.withObjectStorageConfig(instance.getObjectStorageConfig());
            this.withObjectStorageConfigFile(instance.getObjectStorageConfigFile());
            this.withReadyTimeout(instance.getReadyTimeout());
            this.withResources(instance.getResources());
            this.withSha(instance.getSha());
            this.withTag(instance.getTag());
            this.withTracingConfig(instance.getTracingConfig());
            this.withTracingConfigFile(instance.getTracingConfigFile());
            this.withVersion(instance.getVersion());
            this.withVolumeMounts(instance.getVolumeMounts());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getBaseImage() {
        return this.baseImage;
    }

    public A withBaseImage(String baseImage) {
        this.baseImage = baseImage;
        return (A)this;
    }

    public boolean hasBaseImage() {
        return this.baseImage != null;
    }

    public TLSConfig buildGrpcServerTlsConfig() {
        return this.grpcServerTlsConfig != null ? this.grpcServerTlsConfig.build() : null;
    }

    public A withGrpcServerTlsConfig(TLSConfig grpcServerTlsConfig) {
        this._visitables.get("grpcServerTlsConfig").remove(this.grpcServerTlsConfig);
        if (grpcServerTlsConfig != null) {
            this.grpcServerTlsConfig = new TLSConfigBuilder(grpcServerTlsConfig);
            this._visitables.get("grpcServerTlsConfig").add(this.grpcServerTlsConfig);
        } else {
            this.grpcServerTlsConfig = null;
            this._visitables.get("grpcServerTlsConfig").remove(this.grpcServerTlsConfig);
        }
        return (A)this;
    }

    public boolean hasGrpcServerTlsConfig() {
        return this.grpcServerTlsConfig != null;
    }

    public GrpcServerTlsConfigNested<A> withNewGrpcServerTlsConfig() {
        return new GrpcServerTlsConfigNested(null);
    }

    public GrpcServerTlsConfigNested<A> withNewGrpcServerTlsConfigLike(TLSConfig item) {
        return new GrpcServerTlsConfigNested(item);
    }

    public GrpcServerTlsConfigNested<A> editGrpcServerTlsConfig() {
        return this.withNewGrpcServerTlsConfigLike(Optional.ofNullable(this.buildGrpcServerTlsConfig()).orElse(null));
    }

    public GrpcServerTlsConfigNested<A> editOrNewGrpcServerTlsConfig() {
        return this.withNewGrpcServerTlsConfigLike(Optional.ofNullable(this.buildGrpcServerTlsConfig()).orElse(new TLSConfigBuilder().build()));
    }

    public GrpcServerTlsConfigNested<A> editOrNewGrpcServerTlsConfigLike(TLSConfig item) {
        return this.withNewGrpcServerTlsConfigLike(Optional.ofNullable(this.buildGrpcServerTlsConfig()).orElse(item));
    }

    public String getImage() {
        return this.image;
    }

    public A withImage(String image) {
        this.image = image;
        return (A)this;
    }

    public boolean hasImage() {
        return this.image != null;
    }

    public Boolean getListenLocal() {
        return this.listenLocal;
    }

    public A withListenLocal(Boolean listenLocal) {
        this.listenLocal = listenLocal;
        return (A)this;
    }

    public boolean hasListenLocal() {
        return this.listenLocal != null;
    }

    public String getLogFormat() {
        return this.logFormat;
    }

    public A withLogFormat(String logFormat) {
        this.logFormat = logFormat;
        return (A)this;
    }

    public boolean hasLogFormat() {
        return this.logFormat != null;
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public A withLogLevel(String logLevel) {
        this.logLevel = logLevel;
        return (A)this;
    }

    public boolean hasLogLevel() {
        return this.logLevel != null;
    }

    public String getMinTime() {
        return this.minTime;
    }

    public A withMinTime(String minTime) {
        this.minTime = minTime;
        return (A)this;
    }

    public boolean hasMinTime() {
        return this.minTime != null;
    }

    public SecretKeySelector getObjectStorageConfig() {
        return this.objectStorageConfig;
    }

    public A withObjectStorageConfig(SecretKeySelector objectStorageConfig) {
        this.objectStorageConfig = objectStorageConfig;
        return (A)this;
    }

    public boolean hasObjectStorageConfig() {
        return this.objectStorageConfig != null;
    }

    public A withNewObjectStorageConfig(String key, String name, Boolean optional) {
        return this.withObjectStorageConfig(new SecretKeySelector(key, name, optional));
    }

    public String getObjectStorageConfigFile() {
        return this.objectStorageConfigFile;
    }

    public A withObjectStorageConfigFile(String objectStorageConfigFile) {
        this.objectStorageConfigFile = objectStorageConfigFile;
        return (A)this;
    }

    public boolean hasObjectStorageConfigFile() {
        return this.objectStorageConfigFile != null;
    }

    public String getReadyTimeout() {
        return this.readyTimeout;
    }

    public A withReadyTimeout(String readyTimeout) {
        this.readyTimeout = readyTimeout;
        return (A)this;
    }

    public boolean hasReadyTimeout() {
        return this.readyTimeout != null;
    }

    public ResourceRequirements buildResources() {
        return this.resources != null ? this.resources.build() : null;
    }

    public A withResources(ResourceRequirements resources) {
        this._visitables.get("resources").remove(this.resources);
        if (resources != null) {
            this.resources = new ResourceRequirementsBuilder(resources);
            this._visitables.get("resources").add(this.resources);
        } else {
            this.resources = null;
            this._visitables.get("resources").remove(this.resources);
        }
        return (A)this;
    }

    public boolean hasResources() {
        return this.resources != null;
    }

    public ResourcesNested<A> withNewResources() {
        return new ResourcesNested(null);
    }

    public ResourcesNested<A> withNewResourcesLike(ResourceRequirements item) {
        return new ResourcesNested(item);
    }

    public ResourcesNested<A> editResources() {
        return this.withNewResourcesLike(Optional.ofNullable(this.buildResources()).orElse(null));
    }

    public ResourcesNested<A> editOrNewResources() {
        return this.withNewResourcesLike(Optional.ofNullable(this.buildResources()).orElse(new ResourceRequirementsBuilder().build()));
    }

    public ResourcesNested<A> editOrNewResourcesLike(ResourceRequirements item) {
        return this.withNewResourcesLike(Optional.ofNullable(this.buildResources()).orElse(item));
    }

    public String getSha() {
        return this.sha;
    }

    public A withSha(String sha) {
        this.sha = sha;
        return (A)this;
    }

    public boolean hasSha() {
        return this.sha != null;
    }

    public String getTag() {
        return this.tag;
    }

    public A withTag(String tag) {
        this.tag = tag;
        return (A)this;
    }

    public boolean hasTag() {
        return this.tag != null;
    }

    public SecretKeySelector getTracingConfig() {
        return this.tracingConfig;
    }

    public A withTracingConfig(SecretKeySelector tracingConfig) {
        this.tracingConfig = tracingConfig;
        return (A)this;
    }

    public boolean hasTracingConfig() {
        return this.tracingConfig != null;
    }

    public A withNewTracingConfig(String key, String name, Boolean optional) {
        return this.withTracingConfig(new SecretKeySelector(key, name, optional));
    }

    public String getTracingConfigFile() {
        return this.tracingConfigFile;
    }

    public A withTracingConfigFile(String tracingConfigFile) {
        this.tracingConfigFile = tracingConfigFile;
        return (A)this;
    }

    public boolean hasTracingConfigFile() {
        return this.tracingConfigFile != null;
    }

    public String getVersion() {
        return this.version;
    }

    public A withVersion(String version) {
        this.version = version;
        return (A)this;
    }

    public boolean hasVersion() {
        return this.version != null;
    }

    public A addToVolumeMounts(int index, VolumeMount item) {
        if (this.volumeMounts == null) {
            this.volumeMounts = new ArrayList<VolumeMount>();
        }
        this.volumeMounts.add(index, item);
        return (A)this;
    }

    public A setToVolumeMounts(int index, VolumeMount item) {
        if (this.volumeMounts == null) {
            this.volumeMounts = new ArrayList<VolumeMount>();
        }
        this.volumeMounts.set(index, item);
        return (A)this;
    }

    public A addToVolumeMounts(VolumeMount ... items) {
        if (this.volumeMounts == null) {
            this.volumeMounts = new ArrayList<VolumeMount>();
        }
        for (VolumeMount item : items) {
            this.volumeMounts.add(item);
        }
        return (A)this;
    }

    public A addAllToVolumeMounts(Collection<VolumeMount> items) {
        if (this.volumeMounts == null) {
            this.volumeMounts = new ArrayList<VolumeMount>();
        }
        for (VolumeMount item : items) {
            this.volumeMounts.add(item);
        }
        return (A)this;
    }

    public A removeFromVolumeMounts(VolumeMount ... items) {
        if (this.volumeMounts == null) {
            return (A)this;
        }
        for (VolumeMount item : items) {
            this.volumeMounts.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromVolumeMounts(Collection<VolumeMount> items) {
        if (this.volumeMounts == null) {
            return (A)this;
        }
        for (VolumeMount item : items) {
            this.volumeMounts.remove(item);
        }
        return (A)this;
    }

    public List<VolumeMount> getVolumeMounts() {
        return this.volumeMounts;
    }

    public VolumeMount getVolumeMount(int index) {
        return this.volumeMounts.get(index);
    }

    public VolumeMount getFirstVolumeMount() {
        return this.volumeMounts.get(0);
    }

    public VolumeMount getLastVolumeMount() {
        return this.volumeMounts.get(this.volumeMounts.size() - 1);
    }

    public VolumeMount getMatchingVolumeMount(Predicate<VolumeMount> predicate) {
        for (VolumeMount item : this.volumeMounts) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingVolumeMount(Predicate<VolumeMount> predicate) {
        for (VolumeMount item : this.volumeMounts) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withVolumeMounts(List<VolumeMount> volumeMounts) {
        if (volumeMounts != null) {
            this.volumeMounts = new ArrayList<VolumeMount>();
            for (VolumeMount item : volumeMounts) {
                this.addToVolumeMounts(item);
            }
        } else {
            this.volumeMounts = null;
        }
        return (A)this;
    }

    public A withVolumeMounts(VolumeMount ... volumeMounts) {
        if (this.volumeMounts != null) {
            this.volumeMounts.clear();
            this._visitables.remove("volumeMounts");
        }
        if (volumeMounts != null) {
            for (VolumeMount item : volumeMounts) {
                this.addToVolumeMounts(item);
            }
        }
        return (A)this;
    }

    public boolean hasVolumeMounts() {
        return this.volumeMounts != null && !this.volumeMounts.isEmpty();
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ThanosSpecFluent that = (ThanosSpecFluent)o;
        if (!Objects.equals(this.baseImage, that.baseImage)) {
            return false;
        }
        if (!Objects.equals(this.grpcServerTlsConfig, that.grpcServerTlsConfig)) {
            return false;
        }
        if (!Objects.equals(this.image, that.image)) {
            return false;
        }
        if (!Objects.equals(this.listenLocal, that.listenLocal)) {
            return false;
        }
        if (!Objects.equals(this.logFormat, that.logFormat)) {
            return false;
        }
        if (!Objects.equals(this.logLevel, that.logLevel)) {
            return false;
        }
        if (!Objects.equals(this.minTime, that.minTime)) {
            return false;
        }
        if (!Objects.equals(this.objectStorageConfig, that.objectStorageConfig)) {
            return false;
        }
        if (!Objects.equals(this.objectStorageConfigFile, that.objectStorageConfigFile)) {
            return false;
        }
        if (!Objects.equals(this.readyTimeout, that.readyTimeout)) {
            return false;
        }
        if (!Objects.equals(this.resources, that.resources)) {
            return false;
        }
        if (!Objects.equals(this.sha, that.sha)) {
            return false;
        }
        if (!Objects.equals(this.tag, that.tag)) {
            return false;
        }
        if (!Objects.equals(this.tracingConfig, that.tracingConfig)) {
            return false;
        }
        if (!Objects.equals(this.tracingConfigFile, that.tracingConfigFile)) {
            return false;
        }
        if (!Objects.equals(this.version, that.version)) {
            return false;
        }
        if (!Objects.equals(this.volumeMounts, that.volumeMounts)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.baseImage, this.grpcServerTlsConfig, this.image, this.listenLocal, this.logFormat, this.logLevel, this.minTime, this.objectStorageConfig, this.objectStorageConfigFile, this.readyTimeout, this.resources, this.sha, this.tag, this.tracingConfig, this.tracingConfigFile, this.version, this.volumeMounts, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.baseImage != null) {
            sb.append("baseImage:");
            sb.append(this.baseImage + ",");
        }
        if (this.grpcServerTlsConfig != null) {
            sb.append("grpcServerTlsConfig:");
            sb.append(this.grpcServerTlsConfig + ",");
        }
        if (this.image != null) {
            sb.append("image:");
            sb.append(this.image + ",");
        }
        if (this.listenLocal != null) {
            sb.append("listenLocal:");
            sb.append(this.listenLocal + ",");
        }
        if (this.logFormat != null) {
            sb.append("logFormat:");
            sb.append(this.logFormat + ",");
        }
        if (this.logLevel != null) {
            sb.append("logLevel:");
            sb.append(this.logLevel + ",");
        }
        if (this.minTime != null) {
            sb.append("minTime:");
            sb.append(this.minTime + ",");
        }
        if (this.objectStorageConfig != null) {
            sb.append("objectStorageConfig:");
            sb.append(this.objectStorageConfig + ",");
        }
        if (this.objectStorageConfigFile != null) {
            sb.append("objectStorageConfigFile:");
            sb.append(this.objectStorageConfigFile + ",");
        }
        if (this.readyTimeout != null) {
            sb.append("readyTimeout:");
            sb.append(this.readyTimeout + ",");
        }
        if (this.resources != null) {
            sb.append("resources:");
            sb.append(this.resources + ",");
        }
        if (this.sha != null) {
            sb.append("sha:");
            sb.append(this.sha + ",");
        }
        if (this.tag != null) {
            sb.append("tag:");
            sb.append(this.tag + ",");
        }
        if (this.tracingConfig != null) {
            sb.append("tracingConfig:");
            sb.append(this.tracingConfig + ",");
        }
        if (this.tracingConfigFile != null) {
            sb.append("tracingConfigFile:");
            sb.append(this.tracingConfigFile + ",");
        }
        if (this.version != null) {
            sb.append("version:");
            sb.append(this.version + ",");
        }
        if (this.volumeMounts != null && !this.volumeMounts.isEmpty()) {
            sb.append("volumeMounts:");
            sb.append(this.volumeMounts + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withListenLocal() {
        return this.withListenLocal(true);
    }

    public class ResourcesNested<N>
    extends ResourceRequirementsFluent<ResourcesNested<N>>
    implements Nested<N> {
        ResourceRequirementsBuilder builder;

        ResourcesNested(ResourceRequirements item) {
            this.builder = new ResourceRequirementsBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ThanosSpecFluent.this.withResources(this.builder.build());
        }

        public N endResources() {
            return this.and();
        }
    }

    public class GrpcServerTlsConfigNested<N>
    extends TLSConfigFluent<GrpcServerTlsConfigNested<N>>
    implements Nested<N> {
        TLSConfigBuilder builder;

        GrpcServerTlsConfigNested(TLSConfig item) {
            this.builder = new TLSConfigBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ThanosSpecFluent.this.withGrpcServerTlsConfig(this.builder.build());
        }

        public N endGrpcServerTlsConfig() {
            return this.and();
        }
    }
}

