/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_8.config.v1;

import io.fabric8.kubernetes.api.builder.v6_8.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_8.Nested;
import io.fabric8.openshift.api.model.v6_8.config.v1.IdentityProvider;
import io.fabric8.openshift.api.model.v6_8.config.v1.IdentityProviderBuilder;
import io.fabric8.openshift.api.model.v6_8.config.v1.IdentityProviderFluent;
import io.fabric8.openshift.api.model.v6_8.config.v1.OAuthSpec;
import io.fabric8.openshift.api.model.v6_8.config.v1.OAuthTemplates;
import io.fabric8.openshift.api.model.v6_8.config.v1.OAuthTemplatesBuilder;
import io.fabric8.openshift.api.model.v6_8.config.v1.OAuthTemplatesFluent;
import io.fabric8.openshift.api.model.v6_8.config.v1.TokenConfig;
import io.fabric8.openshift.api.model.v6_8.config.v1.TokenConfigBuilder;
import io.fabric8.openshift.api.model.v6_8.config.v1.TokenConfigFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class OAuthSpecFluent<A extends OAuthSpecFluent<A>>
extends BaseFluent<A> {
    private ArrayList<IdentityProviderBuilder> identityProviders = new ArrayList();
    private OAuthTemplatesBuilder templates;
    private TokenConfigBuilder tokenConfig;
    private Map<String, Object> additionalProperties;

    public OAuthSpecFluent() {
    }

    public OAuthSpecFluent(OAuthSpec instance) {
        OAuthSpec oAuthSpec = instance = instance != null ? instance : new OAuthSpec();
        if (instance != null) {
            this.withIdentityProviders(instance.getIdentityProviders());
            this.withTemplates(instance.getTemplates());
            this.withTokenConfig(instance.getTokenConfig());
            this.withIdentityProviders(instance.getIdentityProviders());
            this.withTemplates(instance.getTemplates());
            this.withTokenConfig(instance.getTokenConfig());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToIdentityProviders(int index, IdentityProvider item) {
        if (this.identityProviders == null) {
            this.identityProviders = new ArrayList();
        }
        IdentityProviderBuilder builder = new IdentityProviderBuilder(item);
        if (index < 0 || index >= this.identityProviders.size()) {
            this._visitables.get("identityProviders").add(builder);
            this.identityProviders.add(builder);
        } else {
            this._visitables.get("identityProviders").add(index, builder);
            this.identityProviders.add(index, builder);
        }
        return (A)this;
    }

    public A setToIdentityProviders(int index, IdentityProvider item) {
        if (this.identityProviders == null) {
            this.identityProviders = new ArrayList();
        }
        IdentityProviderBuilder builder = new IdentityProviderBuilder(item);
        if (index < 0 || index >= this.identityProviders.size()) {
            this._visitables.get("identityProviders").add(builder);
            this.identityProviders.add(builder);
        } else {
            this._visitables.get("identityProviders").set(index, builder);
            this.identityProviders.set(index, builder);
        }
        return (A)this;
    }

    public A addToIdentityProviders(IdentityProvider ... items) {
        if (this.identityProviders == null) {
            this.identityProviders = new ArrayList();
        }
        for (IdentityProvider item : items) {
            IdentityProviderBuilder builder = new IdentityProviderBuilder(item);
            this._visitables.get("identityProviders").add(builder);
            this.identityProviders.add(builder);
        }
        return (A)this;
    }

    public A addAllToIdentityProviders(Collection<IdentityProvider> items) {
        if (this.identityProviders == null) {
            this.identityProviders = new ArrayList();
        }
        for (IdentityProvider item : items) {
            IdentityProviderBuilder builder = new IdentityProviderBuilder(item);
            this._visitables.get("identityProviders").add(builder);
            this.identityProviders.add(builder);
        }
        return (A)this;
    }

    public A removeFromIdentityProviders(IdentityProvider ... items) {
        if (this.identityProviders == null) {
            return (A)this;
        }
        for (IdentityProvider item : items) {
            IdentityProviderBuilder builder = new IdentityProviderBuilder(item);
            this._visitables.get("identityProviders").remove(builder);
            this.identityProviders.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromIdentityProviders(Collection<IdentityProvider> items) {
        if (this.identityProviders == null) {
            return (A)this;
        }
        for (IdentityProvider item : items) {
            IdentityProviderBuilder builder = new IdentityProviderBuilder(item);
            this._visitables.get("identityProviders").remove(builder);
            this.identityProviders.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromIdentityProviders(Predicate<IdentityProviderBuilder> predicate) {
        if (this.identityProviders == null) {
            return (A)this;
        }
        Iterator<IdentityProviderBuilder> each = this.identityProviders.iterator();
        Object visitables = this._visitables.get("identityProviders");
        while (each.hasNext()) {
            IdentityProviderBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<IdentityProvider> buildIdentityProviders() {
        return this.identityProviders != null ? OAuthSpecFluent.build(this.identityProviders) : null;
    }

    public IdentityProvider buildIdentityProvider(int index) {
        return this.identityProviders.get(index).build();
    }

    public IdentityProvider buildFirstIdentityProvider() {
        return this.identityProviders.get(0).build();
    }

    public IdentityProvider buildLastIdentityProvider() {
        return this.identityProviders.get(this.identityProviders.size() - 1).build();
    }

    public IdentityProvider buildMatchingIdentityProvider(Predicate<IdentityProviderBuilder> predicate) {
        for (IdentityProviderBuilder item : this.identityProviders) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingIdentityProvider(Predicate<IdentityProviderBuilder> predicate) {
        for (IdentityProviderBuilder item : this.identityProviders) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withIdentityProviders(List<IdentityProvider> identityProviders) {
        if (this.identityProviders != null) {
            this._visitables.get("identityProviders").clear();
        }
        if (identityProviders != null) {
            this.identityProviders = new ArrayList();
            for (IdentityProvider item : identityProviders) {
                this.addToIdentityProviders(item);
            }
        } else {
            this.identityProviders = null;
        }
        return (A)this;
    }

    public A withIdentityProviders(IdentityProvider ... identityProviders) {
        if (this.identityProviders != null) {
            this.identityProviders.clear();
            this._visitables.remove("identityProviders");
        }
        if (identityProviders != null) {
            for (IdentityProvider item : identityProviders) {
                this.addToIdentityProviders(item);
            }
        }
        return (A)this;
    }

    public boolean hasIdentityProviders() {
        return this.identityProviders != null && !this.identityProviders.isEmpty();
    }

    public IdentityProvidersNested<A> addNewIdentityProvider() {
        return new IdentityProvidersNested(-1, null);
    }

    public IdentityProvidersNested<A> addNewIdentityProviderLike(IdentityProvider item) {
        return new IdentityProvidersNested(-1, item);
    }

    public IdentityProvidersNested<A> setNewIdentityProviderLike(int index, IdentityProvider item) {
        return new IdentityProvidersNested(index, item);
    }

    public IdentityProvidersNested<A> editIdentityProvider(int index) {
        if (this.identityProviders.size() <= index) {
            throw new RuntimeException("Can't edit identityProviders. Index exceeds size.");
        }
        return this.setNewIdentityProviderLike(index, this.buildIdentityProvider(index));
    }

    public IdentityProvidersNested<A> editFirstIdentityProvider() {
        if (this.identityProviders.size() == 0) {
            throw new RuntimeException("Can't edit first identityProviders. The list is empty.");
        }
        return this.setNewIdentityProviderLike(0, this.buildIdentityProvider(0));
    }

    public IdentityProvidersNested<A> editLastIdentityProvider() {
        int index = this.identityProviders.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last identityProviders. The list is empty.");
        }
        return this.setNewIdentityProviderLike(index, this.buildIdentityProvider(index));
    }

    public IdentityProvidersNested<A> editMatchingIdentityProvider(Predicate<IdentityProviderBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.identityProviders.size(); ++i) {
            if (!predicate.test(this.identityProviders.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching identityProviders. No match found.");
        }
        return this.setNewIdentityProviderLike(index, this.buildIdentityProvider(index));
    }

    public OAuthTemplates buildTemplates() {
        return this.templates != null ? this.templates.build() : null;
    }

    public A withTemplates(OAuthTemplates templates) {
        this._visitables.get("templates").remove(this.templates);
        if (templates != null) {
            this.templates = new OAuthTemplatesBuilder(templates);
            this._visitables.get("templates").add(this.templates);
        } else {
            this.templates = null;
            this._visitables.get("templates").remove(this.templates);
        }
        return (A)this;
    }

    public boolean hasTemplates() {
        return this.templates != null;
    }

    public TemplatesNested<A> withNewTemplates() {
        return new TemplatesNested(null);
    }

    public TemplatesNested<A> withNewTemplatesLike(OAuthTemplates item) {
        return new TemplatesNested(item);
    }

    public TemplatesNested<A> editTemplates() {
        return this.withNewTemplatesLike(Optional.ofNullable(this.buildTemplates()).orElse(null));
    }

    public TemplatesNested<A> editOrNewTemplates() {
        return this.withNewTemplatesLike(Optional.ofNullable(this.buildTemplates()).orElse(new OAuthTemplatesBuilder().build()));
    }

    public TemplatesNested<A> editOrNewTemplatesLike(OAuthTemplates item) {
        return this.withNewTemplatesLike(Optional.ofNullable(this.buildTemplates()).orElse(item));
    }

    public TokenConfig buildTokenConfig() {
        return this.tokenConfig != null ? this.tokenConfig.build() : null;
    }

    public A withTokenConfig(TokenConfig tokenConfig) {
        this._visitables.get("tokenConfig").remove(this.tokenConfig);
        if (tokenConfig != null) {
            this.tokenConfig = new TokenConfigBuilder(tokenConfig);
            this._visitables.get("tokenConfig").add(this.tokenConfig);
        } else {
            this.tokenConfig = null;
            this._visitables.get("tokenConfig").remove(this.tokenConfig);
        }
        return (A)this;
    }

    public boolean hasTokenConfig() {
        return this.tokenConfig != null;
    }

    public TokenConfigNested<A> withNewTokenConfig() {
        return new TokenConfigNested(null);
    }

    public TokenConfigNested<A> withNewTokenConfigLike(TokenConfig item) {
        return new TokenConfigNested(item);
    }

    public TokenConfigNested<A> editTokenConfig() {
        return this.withNewTokenConfigLike(Optional.ofNullable(this.buildTokenConfig()).orElse(null));
    }

    public TokenConfigNested<A> editOrNewTokenConfig() {
        return this.withNewTokenConfigLike(Optional.ofNullable(this.buildTokenConfig()).orElse(new TokenConfigBuilder().build()));
    }

    public TokenConfigNested<A> editOrNewTokenConfigLike(TokenConfig item) {
        return this.withNewTokenConfigLike(Optional.ofNullable(this.buildTokenConfig()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OAuthSpecFluent that = (OAuthSpecFluent)o;
        if (!Objects.equals(this.identityProviders, that.identityProviders)) {
            return false;
        }
        if (!Objects.equals(this.templates, that.templates)) {
            return false;
        }
        if (!Objects.equals(this.tokenConfig, that.tokenConfig)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.identityProviders, this.templates, this.tokenConfig, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.identityProviders != null && !this.identityProviders.isEmpty()) {
            sb.append("identityProviders:");
            sb.append(this.identityProviders + ",");
        }
        if (this.templates != null) {
            sb.append("templates:");
            sb.append(this.templates + ",");
        }
        if (this.tokenConfig != null) {
            sb.append("tokenConfig:");
            sb.append(this.tokenConfig + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class TokenConfigNested<N>
    extends TokenConfigFluent<TokenConfigNested<N>>
    implements Nested<N> {
        TokenConfigBuilder builder;

        TokenConfigNested(TokenConfig item) {
            this.builder = new TokenConfigBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)OAuthSpecFluent.this.withTokenConfig(this.builder.build());
        }

        public N endTokenConfig() {
            return this.and();
        }
    }

    public class TemplatesNested<N>
    extends OAuthTemplatesFluent<TemplatesNested<N>>
    implements Nested<N> {
        OAuthTemplatesBuilder builder;

        TemplatesNested(OAuthTemplates item) {
            this.builder = new OAuthTemplatesBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)OAuthSpecFluent.this.withTemplates(this.builder.build());
        }

        public N endTemplates() {
            return this.and();
        }
    }

    public class IdentityProvidersNested<N>
    extends IdentityProviderFluent<IdentityProvidersNested<N>>
    implements Nested<N> {
        IdentityProviderBuilder builder;
        int index;

        IdentityProvidersNested(int index, IdentityProvider item) {
            this.index = index;
            this.builder = new IdentityProviderBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)OAuthSpecFluent.this.setToIdentityProviders(this.index, this.builder.build());
        }

        public N endIdentityProvider() {
            return this.and();
        }
    }
}

