/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_8.config.v1;

import io.fabric8.kubernetes.api.builder.v6_8.VisitableBuilder;
import io.fabric8.openshift.api.model.v6_8.config.v1.NetworkStatus;
import io.fabric8.openshift.api.model.v6_8.config.v1.NetworkStatusFluent;

public class NetworkStatusBuilder
extends NetworkStatusFluent<NetworkStatusBuilder>
implements VisitableBuilder<NetworkStatus, NetworkStatusBuilder> {
    NetworkStatusFluent<?> fluent;
    Boolean validationEnabled;

    public NetworkStatusBuilder() {
        this(false);
    }

    public NetworkStatusBuilder(Boolean validationEnabled) {
        this(new NetworkStatus(), validationEnabled);
    }

    public NetworkStatusBuilder(NetworkStatusFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public NetworkStatusBuilder(NetworkStatusFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new NetworkStatus(), validationEnabled);
    }

    public NetworkStatusBuilder(NetworkStatusFluent<?> fluent, NetworkStatus instance) {
        this(fluent, instance, false);
    }

    public NetworkStatusBuilder(NetworkStatusFluent<?> fluent, NetworkStatus instance, Boolean validationEnabled) {
        this.fluent = fluent;
        NetworkStatus networkStatus = instance = instance != null ? instance : new NetworkStatus();
        if (instance != null) {
            fluent.withClusterNetwork(instance.getClusterNetwork());
            fluent.withClusterNetworkMTU(instance.getClusterNetworkMTU());
            fluent.withMigration(instance.getMigration());
            fluent.withNetworkType(instance.getNetworkType());
            fluent.withServiceNetwork(instance.getServiceNetwork());
            fluent.withClusterNetwork(instance.getClusterNetwork());
            fluent.withClusterNetworkMTU(instance.getClusterNetworkMTU());
            fluent.withMigration(instance.getMigration());
            fluent.withNetworkType(instance.getNetworkType());
            fluent.withServiceNetwork(instance.getServiceNetwork());
            fluent.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    public NetworkStatusBuilder(NetworkStatus instance) {
        this(instance, (Boolean)false);
    }

    public NetworkStatusBuilder(NetworkStatus instance, Boolean validationEnabled) {
        this.fluent = this;
        NetworkStatus networkStatus = instance = instance != null ? instance : new NetworkStatus();
        if (instance != null) {
            this.withClusterNetwork(instance.getClusterNetwork());
            this.withClusterNetworkMTU(instance.getClusterNetworkMTU());
            this.withMigration(instance.getMigration());
            this.withNetworkType(instance.getNetworkType());
            this.withServiceNetwork(instance.getServiceNetwork());
            this.withClusterNetwork(instance.getClusterNetwork());
            this.withClusterNetworkMTU(instance.getClusterNetworkMTU());
            this.withMigration(instance.getMigration());
            this.withNetworkType(instance.getNetworkType());
            this.withServiceNetwork(instance.getServiceNetwork());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    @Override
    public NetworkStatus build() {
        NetworkStatus buildable = new NetworkStatus(this.fluent.buildClusterNetwork(), this.fluent.getClusterNetworkMTU(), this.fluent.buildMigration(), this.fluent.getNetworkType(), this.fluent.getServiceNetwork());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }
}

