/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_8.config.v1;

import io.fabric8.kubernetes.api.builder.v6_8.VisitableBuilder;
import io.fabric8.openshift.api.model.v6_8.config.v1.NetworkSpec;
import io.fabric8.openshift.api.model.v6_8.config.v1.NetworkSpecFluent;

public class NetworkSpecBuilder
extends NetworkSpecFluent<NetworkSpecBuilder>
implements VisitableBuilder<NetworkSpec, NetworkSpecBuilder> {
    NetworkSpecFluent<?> fluent;
    Boolean validationEnabled;

    public NetworkSpecBuilder() {
        this(false);
    }

    public NetworkSpecBuilder(Boolean validationEnabled) {
        this(new NetworkSpec(), validationEnabled);
    }

    public NetworkSpecBuilder(NetworkSpecFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public NetworkSpecBuilder(NetworkSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new NetworkSpec(), validationEnabled);
    }

    public NetworkSpecBuilder(NetworkSpecFluent<?> fluent, NetworkSpec instance) {
        this(fluent, instance, false);
    }

    public NetworkSpecBuilder(NetworkSpecFluent<?> fluent, NetworkSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        NetworkSpec networkSpec = instance = instance != null ? instance : new NetworkSpec();
        if (instance != null) {
            fluent.withClusterNetwork(instance.getClusterNetwork());
            fluent.withExternalIP(instance.getExternalIP());
            fluent.withNetworkType(instance.getNetworkType());
            fluent.withServiceNetwork(instance.getServiceNetwork());
            fluent.withServiceNodePortRange(instance.getServiceNodePortRange());
            fluent.withClusterNetwork(instance.getClusterNetwork());
            fluent.withExternalIP(instance.getExternalIP());
            fluent.withNetworkType(instance.getNetworkType());
            fluent.withServiceNetwork(instance.getServiceNetwork());
            fluent.withServiceNodePortRange(instance.getServiceNodePortRange());
            fluent.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    public NetworkSpecBuilder(NetworkSpec instance) {
        this(instance, (Boolean)false);
    }

    public NetworkSpecBuilder(NetworkSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        NetworkSpec networkSpec = instance = instance != null ? instance : new NetworkSpec();
        if (instance != null) {
            this.withClusterNetwork(instance.getClusterNetwork());
            this.withExternalIP(instance.getExternalIP());
            this.withNetworkType(instance.getNetworkType());
            this.withServiceNetwork(instance.getServiceNetwork());
            this.withServiceNodePortRange(instance.getServiceNodePortRange());
            this.withClusterNetwork(instance.getClusterNetwork());
            this.withExternalIP(instance.getExternalIP());
            this.withNetworkType(instance.getNetworkType());
            this.withServiceNetwork(instance.getServiceNetwork());
            this.withServiceNodePortRange(instance.getServiceNodePortRange());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    @Override
    public NetworkSpec build() {
        NetworkSpec buildable = new NetworkSpec(this.fluent.buildClusterNetwork(), this.fluent.buildExternalIP(), this.fluent.getNetworkType(), this.fluent.getServiceNetwork(), this.fluent.getServiceNodePortRange());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }
}

