/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_8;

import io.fabric8.kubernetes.api.builder.v6_8.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_8.Nested;
import io.fabric8.openshift.api.model.v6_8.StageInfo;
import io.fabric8.openshift.api.model.v6_8.StepInfo;
import io.fabric8.openshift.api.model.v6_8.StepInfoBuilder;
import io.fabric8.openshift.api.model.v6_8.StepInfoFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class StageInfoFluent<A extends StageInfoFluent<A>>
extends BaseFluent<A> {
    private Long durationMilliseconds;
    private String name;
    private String startTime;
    private ArrayList<StepInfoBuilder> steps = new ArrayList();
    private Map<String, Object> additionalProperties;

    public StageInfoFluent() {
    }

    public StageInfoFluent(StageInfo instance) {
        StageInfo stageInfo = instance = instance != null ? instance : new StageInfo();
        if (instance != null) {
            this.withDurationMilliseconds(instance.getDurationMilliseconds());
            this.withName(instance.getName());
            this.withStartTime(instance.getStartTime());
            this.withSteps(instance.getSteps());
            this.withDurationMilliseconds(instance.getDurationMilliseconds());
            this.withName(instance.getName());
            this.withStartTime(instance.getStartTime());
            this.withSteps(instance.getSteps());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public Long getDurationMilliseconds() {
        return this.durationMilliseconds;
    }

    public A withDurationMilliseconds(Long durationMilliseconds) {
        this.durationMilliseconds = durationMilliseconds;
        return (A)this;
    }

    public boolean hasDurationMilliseconds() {
        return this.durationMilliseconds != null;
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public A withStartTime(String startTime) {
        this.startTime = startTime;
        return (A)this;
    }

    public boolean hasStartTime() {
        return this.startTime != null;
    }

    public A addToSteps(int index, StepInfo item) {
        if (this.steps == null) {
            this.steps = new ArrayList();
        }
        StepInfoBuilder builder = new StepInfoBuilder(item);
        if (index < 0 || index >= this.steps.size()) {
            this._visitables.get("steps").add(builder);
            this.steps.add(builder);
        } else {
            this._visitables.get("steps").add(index, builder);
            this.steps.add(index, builder);
        }
        return (A)this;
    }

    public A setToSteps(int index, StepInfo item) {
        if (this.steps == null) {
            this.steps = new ArrayList();
        }
        StepInfoBuilder builder = new StepInfoBuilder(item);
        if (index < 0 || index >= this.steps.size()) {
            this._visitables.get("steps").add(builder);
            this.steps.add(builder);
        } else {
            this._visitables.get("steps").set(index, builder);
            this.steps.set(index, builder);
        }
        return (A)this;
    }

    public A addToSteps(StepInfo ... items) {
        if (this.steps == null) {
            this.steps = new ArrayList();
        }
        for (StepInfo item : items) {
            StepInfoBuilder builder = new StepInfoBuilder(item);
            this._visitables.get("steps").add(builder);
            this.steps.add(builder);
        }
        return (A)this;
    }

    public A addAllToSteps(Collection<StepInfo> items) {
        if (this.steps == null) {
            this.steps = new ArrayList();
        }
        for (StepInfo item : items) {
            StepInfoBuilder builder = new StepInfoBuilder(item);
            this._visitables.get("steps").add(builder);
            this.steps.add(builder);
        }
        return (A)this;
    }

    public A removeFromSteps(StepInfo ... items) {
        if (this.steps == null) {
            return (A)this;
        }
        for (StepInfo item : items) {
            StepInfoBuilder builder = new StepInfoBuilder(item);
            this._visitables.get("steps").remove(builder);
            this.steps.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromSteps(Collection<StepInfo> items) {
        if (this.steps == null) {
            return (A)this;
        }
        for (StepInfo item : items) {
            StepInfoBuilder builder = new StepInfoBuilder(item);
            this._visitables.get("steps").remove(builder);
            this.steps.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromSteps(Predicate<StepInfoBuilder> predicate) {
        if (this.steps == null) {
            return (A)this;
        }
        Iterator<StepInfoBuilder> each = this.steps.iterator();
        Object visitables = this._visitables.get("steps");
        while (each.hasNext()) {
            StepInfoBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<StepInfo> buildSteps() {
        return this.steps != null ? StageInfoFluent.build(this.steps) : null;
    }

    public StepInfo buildStep(int index) {
        return this.steps.get(index).build();
    }

    public StepInfo buildFirstStep() {
        return this.steps.get(0).build();
    }

    public StepInfo buildLastStep() {
        return this.steps.get(this.steps.size() - 1).build();
    }

    public StepInfo buildMatchingStep(Predicate<StepInfoBuilder> predicate) {
        for (StepInfoBuilder item : this.steps) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingStep(Predicate<StepInfoBuilder> predicate) {
        for (StepInfoBuilder item : this.steps) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withSteps(List<StepInfo> steps) {
        if (this.steps != null) {
            this._visitables.get("steps").clear();
        }
        if (steps != null) {
            this.steps = new ArrayList();
            for (StepInfo item : steps) {
                this.addToSteps(item);
            }
        } else {
            this.steps = null;
        }
        return (A)this;
    }

    public A withSteps(StepInfo ... steps) {
        if (this.steps != null) {
            this.steps.clear();
            this._visitables.remove("steps");
        }
        if (steps != null) {
            for (StepInfo item : steps) {
                this.addToSteps(item);
            }
        }
        return (A)this;
    }

    public boolean hasSteps() {
        return this.steps != null && !this.steps.isEmpty();
    }

    public A addNewStep(Long durationMilliseconds, String name, String startTime) {
        return this.addToSteps(new StepInfo(durationMilliseconds, name, startTime));
    }

    public StepsNested<A> addNewStep() {
        return new StepsNested(-1, null);
    }

    public StepsNested<A> addNewStepLike(StepInfo item) {
        return new StepsNested(-1, item);
    }

    public StepsNested<A> setNewStepLike(int index, StepInfo item) {
        return new StepsNested(index, item);
    }

    public StepsNested<A> editStep(int index) {
        if (this.steps.size() <= index) {
            throw new RuntimeException("Can't edit steps. Index exceeds size.");
        }
        return this.setNewStepLike(index, this.buildStep(index));
    }

    public StepsNested<A> editFirstStep() {
        if (this.steps.size() == 0) {
            throw new RuntimeException("Can't edit first steps. The list is empty.");
        }
        return this.setNewStepLike(0, this.buildStep(0));
    }

    public StepsNested<A> editLastStep() {
        int index = this.steps.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last steps. The list is empty.");
        }
        return this.setNewStepLike(index, this.buildStep(index));
    }

    public StepsNested<A> editMatchingStep(Predicate<StepInfoBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.steps.size(); ++i) {
            if (!predicate.test(this.steps.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching steps. No match found.");
        }
        return this.setNewStepLike(index, this.buildStep(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StageInfoFluent that = (StageInfoFluent)o;
        if (!Objects.equals(this.durationMilliseconds, that.durationMilliseconds)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.startTime, that.startTime)) {
            return false;
        }
        if (!Objects.equals(this.steps, that.steps)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.durationMilliseconds, this.name, this.startTime, this.steps, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.durationMilliseconds != null) {
            sb.append("durationMilliseconds:");
            sb.append(this.durationMilliseconds + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.startTime != null) {
            sb.append("startTime:");
            sb.append(this.startTime + ",");
        }
        if (this.steps != null && !this.steps.isEmpty()) {
            sb.append("steps:");
            sb.append(this.steps + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class StepsNested<N>
    extends StepInfoFluent<StepsNested<N>>
    implements Nested<N> {
        StepInfoBuilder builder;
        int index;

        StepsNested(int index, StepInfo item) {
            this.index = index;
            this.builder = new StepInfoBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)StageInfoFluent.this.setToSteps(this.index, this.builder.build());
        }

        public N endStep() {
            return this.and();
        }
    }
}

