/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_8;

import io.fabric8.kubernetes.api.builder.v6_8.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_8.Nested;
import io.fabric8.openshift.api.model.v6_8.ImageChangeTriggerStatus;
import io.fabric8.openshift.api.model.v6_8.ImageStreamTagReference;
import io.fabric8.openshift.api.model.v6_8.ImageStreamTagReferenceBuilder;
import io.fabric8.openshift.api.model.v6_8.ImageStreamTagReferenceFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ImageChangeTriggerStatusFluent<A extends ImageChangeTriggerStatusFluent<A>>
extends BaseFluent<A> {
    private ImageStreamTagReferenceBuilder from;
    private String lastTriggerTime;
    private String lastTriggeredImageID;
    private Map<String, Object> additionalProperties;

    public ImageChangeTriggerStatusFluent() {
    }

    public ImageChangeTriggerStatusFluent(ImageChangeTriggerStatus instance) {
        ImageChangeTriggerStatus imageChangeTriggerStatus = instance = instance != null ? instance : new ImageChangeTriggerStatus();
        if (instance != null) {
            this.withFrom(instance.getFrom());
            this.withLastTriggerTime(instance.getLastTriggerTime());
            this.withLastTriggeredImageID(instance.getLastTriggeredImageID());
            this.withFrom(instance.getFrom());
            this.withLastTriggerTime(instance.getLastTriggerTime());
            this.withLastTriggeredImageID(instance.getLastTriggeredImageID());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ImageStreamTagReference buildFrom() {
        return this.from != null ? this.from.build() : null;
    }

    public A withFrom(ImageStreamTagReference from) {
        this._visitables.get("from").remove(this.from);
        if (from != null) {
            this.from = new ImageStreamTagReferenceBuilder(from);
            this._visitables.get("from").add(this.from);
        } else {
            this.from = null;
            this._visitables.get("from").remove(this.from);
        }
        return (A)this;
    }

    public boolean hasFrom() {
        return this.from != null;
    }

    public A withNewFrom(String name, String namespace) {
        return this.withFrom(new ImageStreamTagReference(name, namespace));
    }

    public FromNested<A> withNewFrom() {
        return new FromNested(null);
    }

    public FromNested<A> withNewFromLike(ImageStreamTagReference item) {
        return new FromNested(item);
    }

    public FromNested<A> editFrom() {
        return this.withNewFromLike(Optional.ofNullable(this.buildFrom()).orElse(null));
    }

    public FromNested<A> editOrNewFrom() {
        return this.withNewFromLike(Optional.ofNullable(this.buildFrom()).orElse(new ImageStreamTagReferenceBuilder().build()));
    }

    public FromNested<A> editOrNewFromLike(ImageStreamTagReference item) {
        return this.withNewFromLike(Optional.ofNullable(this.buildFrom()).orElse(item));
    }

    public String getLastTriggerTime() {
        return this.lastTriggerTime;
    }

    public A withLastTriggerTime(String lastTriggerTime) {
        this.lastTriggerTime = lastTriggerTime;
        return (A)this;
    }

    public boolean hasLastTriggerTime() {
        return this.lastTriggerTime != null;
    }

    public String getLastTriggeredImageID() {
        return this.lastTriggeredImageID;
    }

    public A withLastTriggeredImageID(String lastTriggeredImageID) {
        this.lastTriggeredImageID = lastTriggeredImageID;
        return (A)this;
    }

    public boolean hasLastTriggeredImageID() {
        return this.lastTriggeredImageID != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ImageChangeTriggerStatusFluent that = (ImageChangeTriggerStatusFluent)o;
        if (!Objects.equals(this.from, that.from)) {
            return false;
        }
        if (!Objects.equals(this.lastTriggerTime, that.lastTriggerTime)) {
            return false;
        }
        if (!Objects.equals(this.lastTriggeredImageID, that.lastTriggeredImageID)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.from, this.lastTriggerTime, this.lastTriggeredImageID, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.from != null) {
            sb.append("from:");
            sb.append(this.from + ",");
        }
        if (this.lastTriggerTime != null) {
            sb.append("lastTriggerTime:");
            sb.append(this.lastTriggerTime + ",");
        }
        if (this.lastTriggeredImageID != null) {
            sb.append("lastTriggeredImageID:");
            sb.append(this.lastTriggeredImageID + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class FromNested<N>
    extends ImageStreamTagReferenceFluent<FromNested<N>>
    implements Nested<N> {
        ImageStreamTagReferenceBuilder builder;

        FromNested(ImageStreamTagReference item) {
            this.builder = new ImageStreamTagReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ImageChangeTriggerStatusFluent.this.withFrom(this.builder.build());
        }

        public N endFrom() {
            return this.and();
        }
    }
}

