/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_8;

import io.fabric8.kubernetes.api.builder.v6_8.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_8.Nested;
import io.fabric8.kubernetes.api.model.v6_8.ObjectMeta;
import io.fabric8.kubernetes.api.model.v6_8.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.v6_8.ObjectMetaFluent;
import io.fabric8.openshift.api.model.v6_8.ClusterNetwork;
import io.fabric8.openshift.api.model.v6_8.ClusterNetworkEntry;
import io.fabric8.openshift.api.model.v6_8.ClusterNetworkEntryBuilder;
import io.fabric8.openshift.api.model.v6_8.ClusterNetworkEntryFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class ClusterNetworkFluent<A extends ClusterNetworkFluent<A>>
extends BaseFluent<A> {
    private String apiVersion;
    private ArrayList<ClusterNetworkEntryBuilder> clusterNetworks = new ArrayList();
    private Integer hostsubnetlength;
    private String kind;
    private ObjectMetaBuilder metadata;
    private Integer mtu;
    private String network;
    private String pluginName;
    private String serviceNetwork;
    private Integer vxlanPort;
    private Map<String, Object> additionalProperties;

    public ClusterNetworkFluent() {
    }

    public ClusterNetworkFluent(ClusterNetwork instance) {
        ClusterNetwork clusterNetwork = instance = instance != null ? instance : new ClusterNetwork();
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withClusterNetworks(instance.getClusterNetworks());
            this.withHostsubnetlength(instance.getHostsubnetlength());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withMtu(instance.getMtu());
            this.withNetwork(instance.getNetwork());
            this.withPluginName(instance.getPluginName());
            this.withServiceNetwork(instance.getServiceNetwork());
            this.withVxlanPort(instance.getVxlanPort());
            this.withApiVersion(instance.getApiVersion());
            this.withClusterNetworks(instance.getClusterNetworks());
            this.withHostsubnetlength(instance.getHostsubnetlength());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withMtu(instance.getMtu());
            this.withNetwork(instance.getNetwork());
            this.withPluginName(instance.getPluginName());
            this.withServiceNetwork(instance.getServiceNetwork());
            this.withVxlanPort(instance.getVxlanPort());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public A addToClusterNetworks(int index, ClusterNetworkEntry item) {
        if (this.clusterNetworks == null) {
            this.clusterNetworks = new ArrayList();
        }
        ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
        if (index < 0 || index >= this.clusterNetworks.size()) {
            this._visitables.get("clusterNetworks").add(builder);
            this.clusterNetworks.add(builder);
        } else {
            this._visitables.get("clusterNetworks").add(index, builder);
            this.clusterNetworks.add(index, builder);
        }
        return (A)this;
    }

    public A setToClusterNetworks(int index, ClusterNetworkEntry item) {
        if (this.clusterNetworks == null) {
            this.clusterNetworks = new ArrayList();
        }
        ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
        if (index < 0 || index >= this.clusterNetworks.size()) {
            this._visitables.get("clusterNetworks").add(builder);
            this.clusterNetworks.add(builder);
        } else {
            this._visitables.get("clusterNetworks").set(index, builder);
            this.clusterNetworks.set(index, builder);
        }
        return (A)this;
    }

    public A addToClusterNetworks(ClusterNetworkEntry ... items) {
        if (this.clusterNetworks == null) {
            this.clusterNetworks = new ArrayList();
        }
        for (ClusterNetworkEntry item : items) {
            ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
            this._visitables.get("clusterNetworks").add(builder);
            this.clusterNetworks.add(builder);
        }
        return (A)this;
    }

    public A addAllToClusterNetworks(Collection<ClusterNetworkEntry> items) {
        if (this.clusterNetworks == null) {
            this.clusterNetworks = new ArrayList();
        }
        for (ClusterNetworkEntry item : items) {
            ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
            this._visitables.get("clusterNetworks").add(builder);
            this.clusterNetworks.add(builder);
        }
        return (A)this;
    }

    public A removeFromClusterNetworks(ClusterNetworkEntry ... items) {
        if (this.clusterNetworks == null) {
            return (A)this;
        }
        for (ClusterNetworkEntry item : items) {
            ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
            this._visitables.get("clusterNetworks").remove(builder);
            this.clusterNetworks.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromClusterNetworks(Collection<ClusterNetworkEntry> items) {
        if (this.clusterNetworks == null) {
            return (A)this;
        }
        for (ClusterNetworkEntry item : items) {
            ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
            this._visitables.get("clusterNetworks").remove(builder);
            this.clusterNetworks.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromClusterNetworks(Predicate<ClusterNetworkEntryBuilder> predicate) {
        if (this.clusterNetworks == null) {
            return (A)this;
        }
        Iterator<ClusterNetworkEntryBuilder> each = this.clusterNetworks.iterator();
        Object visitables = this._visitables.get("clusterNetworks");
        while (each.hasNext()) {
            ClusterNetworkEntryBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<ClusterNetworkEntry> buildClusterNetworks() {
        return this.clusterNetworks != null ? ClusterNetworkFluent.build(this.clusterNetworks) : null;
    }

    public ClusterNetworkEntry buildClusterNetwork(int index) {
        return this.clusterNetworks.get(index).build();
    }

    public ClusterNetworkEntry buildFirstClusterNetwork() {
        return this.clusterNetworks.get(0).build();
    }

    public ClusterNetworkEntry buildLastClusterNetwork() {
        return this.clusterNetworks.get(this.clusterNetworks.size() - 1).build();
    }

    public ClusterNetworkEntry buildMatchingClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate) {
        for (ClusterNetworkEntryBuilder item : this.clusterNetworks) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate) {
        for (ClusterNetworkEntryBuilder item : this.clusterNetworks) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withClusterNetworks(List<ClusterNetworkEntry> clusterNetworks) {
        if (this.clusterNetworks != null) {
            this._visitables.get("clusterNetworks").clear();
        }
        if (clusterNetworks != null) {
            this.clusterNetworks = new ArrayList();
            for (ClusterNetworkEntry item : clusterNetworks) {
                this.addToClusterNetworks(item);
            }
        } else {
            this.clusterNetworks = null;
        }
        return (A)this;
    }

    public A withClusterNetworks(ClusterNetworkEntry ... clusterNetworks) {
        if (this.clusterNetworks != null) {
            this.clusterNetworks.clear();
            this._visitables.remove("clusterNetworks");
        }
        if (clusterNetworks != null) {
            for (ClusterNetworkEntry item : clusterNetworks) {
                this.addToClusterNetworks(item);
            }
        }
        return (A)this;
    }

    public boolean hasClusterNetworks() {
        return this.clusterNetworks != null && !this.clusterNetworks.isEmpty();
    }

    public A addNewClusterNetwork(String cidr, Integer hostSubnetLength) {
        return this.addToClusterNetworks(new ClusterNetworkEntry(cidr, hostSubnetLength));
    }

    public ClusterNetworksNested<A> addNewClusterNetwork() {
        return new ClusterNetworksNested(-1, null);
    }

    public ClusterNetworksNested<A> addNewClusterNetworkLike(ClusterNetworkEntry item) {
        return new ClusterNetworksNested(-1, item);
    }

    public ClusterNetworksNested<A> setNewClusterNetworkLike(int index, ClusterNetworkEntry item) {
        return new ClusterNetworksNested(index, item);
    }

    public ClusterNetworksNested<A> editClusterNetwork(int index) {
        if (this.clusterNetworks.size() <= index) {
            throw new RuntimeException("Can't edit clusterNetworks. Index exceeds size.");
        }
        return this.setNewClusterNetworkLike(index, this.buildClusterNetwork(index));
    }

    public ClusterNetworksNested<A> editFirstClusterNetwork() {
        if (this.clusterNetworks.size() == 0) {
            throw new RuntimeException("Can't edit first clusterNetworks. The list is empty.");
        }
        return this.setNewClusterNetworkLike(0, this.buildClusterNetwork(0));
    }

    public ClusterNetworksNested<A> editLastClusterNetwork() {
        int index = this.clusterNetworks.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last clusterNetworks. The list is empty.");
        }
        return this.setNewClusterNetworkLike(index, this.buildClusterNetwork(index));
    }

    public ClusterNetworksNested<A> editMatchingClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.clusterNetworks.size(); ++i) {
            if (!predicate.test(this.clusterNetworks.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching clusterNetworks. No match found.");
        }
        return this.setNewClusterNetworkLike(index, this.buildClusterNetwork(index));
    }

    public Integer getHostsubnetlength() {
        return this.hostsubnetlength;
    }

    public A withHostsubnetlength(Integer hostsubnetlength) {
        this.hostsubnetlength = hostsubnetlength;
        return (A)this;
    }

    public boolean hasHostsubnetlength() {
        return this.hostsubnetlength != null;
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    public A withMetadata(ObjectMeta metadata) {
        this._visitables.get("metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get("metadata").remove(this.metadata);
        }
        return (A)this;
    }

    public boolean hasMetadata() {
        return this.metadata != null;
    }

    public MetadataNested<A> withNewMetadata() {
        return new MetadataNested(null);
    }

    public MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNested(item);
    }

    public MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(null));
    }

    public MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(new ObjectMetaBuilder().build()));
    }

    public MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(item));
    }

    public Integer getMtu() {
        return this.mtu;
    }

    public A withMtu(Integer mtu) {
        this.mtu = mtu;
        return (A)this;
    }

    public boolean hasMtu() {
        return this.mtu != null;
    }

    public String getNetwork() {
        return this.network;
    }

    public A withNetwork(String network) {
        this.network = network;
        return (A)this;
    }

    public boolean hasNetwork() {
        return this.network != null;
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public A withPluginName(String pluginName) {
        this.pluginName = pluginName;
        return (A)this;
    }

    public boolean hasPluginName() {
        return this.pluginName != null;
    }

    public String getServiceNetwork() {
        return this.serviceNetwork;
    }

    public A withServiceNetwork(String serviceNetwork) {
        this.serviceNetwork = serviceNetwork;
        return (A)this;
    }

    public boolean hasServiceNetwork() {
        return this.serviceNetwork != null;
    }

    public Integer getVxlanPort() {
        return this.vxlanPort;
    }

    public A withVxlanPort(Integer vxlanPort) {
        this.vxlanPort = vxlanPort;
        return (A)this;
    }

    public boolean hasVxlanPort() {
        return this.vxlanPort != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClusterNetworkFluent that = (ClusterNetworkFluent)o;
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.clusterNetworks, that.clusterNetworks)) {
            return false;
        }
        if (!Objects.equals(this.hostsubnetlength, that.hostsubnetlength)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.metadata, that.metadata)) {
            return false;
        }
        if (!Objects.equals(this.mtu, that.mtu)) {
            return false;
        }
        if (!Objects.equals(this.network, that.network)) {
            return false;
        }
        if (!Objects.equals(this.pluginName, that.pluginName)) {
            return false;
        }
        if (!Objects.equals(this.serviceNetwork, that.serviceNetwork)) {
            return false;
        }
        if (!Objects.equals(this.vxlanPort, that.vxlanPort)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiVersion, this.clusterNetworks, this.hostsubnetlength, this.kind, this.metadata, this.mtu, this.network, this.pluginName, this.serviceNetwork, this.vxlanPort, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.clusterNetworks != null && !this.clusterNetworks.isEmpty()) {
            sb.append("clusterNetworks:");
            sb.append(this.clusterNetworks + ",");
        }
        if (this.hostsubnetlength != null) {
            sb.append("hostsubnetlength:");
            sb.append(this.hostsubnetlength + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata + ",");
        }
        if (this.mtu != null) {
            sb.append("mtu:");
            sb.append(this.mtu + ",");
        }
        if (this.network != null) {
            sb.append("network:");
            sb.append(this.network + ",");
        }
        if (this.pluginName != null) {
            sb.append("pluginName:");
            sb.append(this.pluginName + ",");
        }
        if (this.serviceNetwork != null) {
            sb.append("serviceNetwork:");
            sb.append(this.serviceNetwork + ",");
        }
        if (this.vxlanPort != null) {
            sb.append("vxlanPort:");
            sb.append(this.vxlanPort + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class MetadataNested<N>
    extends ObjectMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        ObjectMetaBuilder builder;

        MetadataNested(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ClusterNetworkFluent.this.withMetadata(this.builder.build());
        }

        public N endMetadata() {
            return this.and();
        }
    }

    public class ClusterNetworksNested<N>
    extends ClusterNetworkEntryFluent<ClusterNetworksNested<N>>
    implements Nested<N> {
        ClusterNetworkEntryBuilder builder;
        int index;

        ClusterNetworksNested(int index, ClusterNetworkEntry item) {
            this.index = index;
            this.builder = new ClusterNetworkEntryBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ClusterNetworkFluent.this.setToClusterNetworks(this.index, this.builder.build());
        }

        public N endClusterNetwork() {
            return this.and();
        }
    }
}

