/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v6_8.dsl.internal.core.v1;

import io.fabric8.kubernetes.api.model.v6_8.ServiceAccount;
import io.fabric8.kubernetes.api.model.v6_8.ServiceAccountList;
import io.fabric8.kubernetes.api.model.v6_8.authentication.TokenRequest;
import io.fabric8.kubernetes.clnt.v6_8.Client;
import io.fabric8.kubernetes.clnt.v6_8.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v6_8.OperationInfo;
import io.fabric8.kubernetes.clnt.v6_8.dsl.ServiceAccountResource;
import io.fabric8.kubernetes.clnt.v6_8.dsl.internal.HasMetadataOperation;
import io.fabric8.kubernetes.clnt.v6_8.dsl.internal.HasMetadataOperationsImpl;
import io.fabric8.kubernetes.clnt.v6_8.dsl.internal.OperationContext;
import io.fabric8.kubernetes.clnt.v6_8.http.HttpRequest;
import io.fabric8.kubernetes.clnt.v6_8.utils.URLUtils;
import java.io.IOException;
import java.net.URL;

public class ServiceAccountOperationsImpl
extends HasMetadataOperation<ServiceAccount, ServiceAccountList, ServiceAccountResource>
implements ServiceAccountResource {
    public ServiceAccountOperationsImpl(Client client) {
        this(HasMetadataOperationsImpl.defaultContext(client));
    }

    private ServiceAccountOperationsImpl(OperationContext context) {
        super(context.withPlural("serviceaccounts"), ServiceAccount.class, ServiceAccountList.class);
    }

    @Override
    public ServiceAccountOperationsImpl newInstance(OperationContext context) {
        return new ServiceAccountOperationsImpl(context);
    }

    public TokenRequest tokenRequest(TokenRequest tokenRequest) {
        return this.handleTokenRequest(tokenRequest);
    }

    private TokenRequest handleTokenRequest(TokenRequest tokenRequest) {
        try {
            URL requestUrl = new URL(URLUtils.join((String[])new String[]{this.getResourceUrl().toString(), "token"}));
            HttpRequest.Builder requestBuilder = this.httpClient.newHttpRequestBuilder().post("application/json", this.getKubernetesSerialization().asJson((Object)tokenRequest)).url(requestUrl);
            return this.handleResponse(requestBuilder, TokenRequest.class);
        }
        catch (IOException exception) {
            throw KubernetesClientException.launderThrowable((OperationInfo)this.forOperationType("token request"), (Throwable)exception);
        }
    }
}

