/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_8.apps;

import io.fabric8.kubernetes.api.builder.v6_8.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v6_8.apps.StatefulSetStatus;
import io.fabric8.kubernetes.api.model.v6_8.apps.StatefulSetStatusFluent;

public class StatefulSetStatusBuilder
extends StatefulSetStatusFluent<StatefulSetStatusBuilder>
implements VisitableBuilder<StatefulSetStatus, StatefulSetStatusBuilder> {
    StatefulSetStatusFluent<?> fluent;
    Boolean validationEnabled;

    public StatefulSetStatusBuilder() {
        this(false);
    }

    public StatefulSetStatusBuilder(Boolean validationEnabled) {
        this(new StatefulSetStatus(), validationEnabled);
    }

    public StatefulSetStatusBuilder(StatefulSetStatusFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public StatefulSetStatusBuilder(StatefulSetStatusFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new StatefulSetStatus(), validationEnabled);
    }

    public StatefulSetStatusBuilder(StatefulSetStatusFluent<?> fluent, StatefulSetStatus instance) {
        this(fluent, instance, false);
    }

    public StatefulSetStatusBuilder(StatefulSetStatusFluent<?> fluent, StatefulSetStatus instance, Boolean validationEnabled) {
        this.fluent = fluent;
        StatefulSetStatus statefulSetStatus = instance = instance != null ? instance : new StatefulSetStatus();
        if (instance != null) {
            fluent.withAvailableReplicas(instance.getAvailableReplicas());
            fluent.withCollisionCount(instance.getCollisionCount());
            fluent.withConditions(instance.getConditions());
            fluent.withCurrentReplicas(instance.getCurrentReplicas());
            fluent.withCurrentRevision(instance.getCurrentRevision());
            fluent.withObservedGeneration(instance.getObservedGeneration());
            fluent.withReadyReplicas(instance.getReadyReplicas());
            fluent.withReplicas(instance.getReplicas());
            fluent.withUpdateRevision(instance.getUpdateRevision());
            fluent.withUpdatedReplicas(instance.getUpdatedReplicas());
            fluent.withAvailableReplicas(instance.getAvailableReplicas());
            fluent.withCollisionCount(instance.getCollisionCount());
            fluent.withConditions(instance.getConditions());
            fluent.withCurrentReplicas(instance.getCurrentReplicas());
            fluent.withCurrentRevision(instance.getCurrentRevision());
            fluent.withObservedGeneration(instance.getObservedGeneration());
            fluent.withReadyReplicas(instance.getReadyReplicas());
            fluent.withReplicas(instance.getReplicas());
            fluent.withUpdateRevision(instance.getUpdateRevision());
            fluent.withUpdatedReplicas(instance.getUpdatedReplicas());
            fluent.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    public StatefulSetStatusBuilder(StatefulSetStatus instance) {
        this(instance, (Boolean)false);
    }

    public StatefulSetStatusBuilder(StatefulSetStatus instance, Boolean validationEnabled) {
        this.fluent = this;
        StatefulSetStatus statefulSetStatus = instance = instance != null ? instance : new StatefulSetStatus();
        if (instance != null) {
            this.withAvailableReplicas(instance.getAvailableReplicas());
            this.withCollisionCount(instance.getCollisionCount());
            this.withConditions(instance.getConditions());
            this.withCurrentReplicas(instance.getCurrentReplicas());
            this.withCurrentRevision(instance.getCurrentRevision());
            this.withObservedGeneration(instance.getObservedGeneration());
            this.withReadyReplicas(instance.getReadyReplicas());
            this.withReplicas(instance.getReplicas());
            this.withUpdateRevision(instance.getUpdateRevision());
            this.withUpdatedReplicas(instance.getUpdatedReplicas());
            this.withAvailableReplicas(instance.getAvailableReplicas());
            this.withCollisionCount(instance.getCollisionCount());
            this.withConditions(instance.getConditions());
            this.withCurrentReplicas(instance.getCurrentReplicas());
            this.withCurrentRevision(instance.getCurrentRevision());
            this.withObservedGeneration(instance.getObservedGeneration());
            this.withReadyReplicas(instance.getReadyReplicas());
            this.withReplicas(instance.getReplicas());
            this.withUpdateRevision(instance.getUpdateRevision());
            this.withUpdatedReplicas(instance.getUpdatedReplicas());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    @Override
    public StatefulSetStatus build() {
        StatefulSetStatus buildable = new StatefulSetStatus(this.fluent.getAvailableReplicas(), this.fluent.getCollisionCount(), this.fluent.buildConditions(), this.fluent.getCurrentReplicas(), this.fluent.getCurrentRevision(), this.fluent.getObservedGeneration(), this.fluent.getReadyReplicas(), this.fluent.getReplicas(), this.fluent.getUpdateRevision(), this.fluent.getUpdatedReplicas());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }
}

