/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_8.apps;

import io.fabric8.kubernetes.api.builder.v6_8.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v6_8.apps.StatefulSet;
import io.fabric8.kubernetes.api.model.v6_8.apps.StatefulSetFluent;

public class StatefulSetBuilder
extends StatefulSetFluent<StatefulSetBuilder>
implements VisitableBuilder<StatefulSet, StatefulSetBuilder> {
    StatefulSetFluent<?> fluent;
    Boolean validationEnabled;

    public StatefulSetBuilder() {
        this(false);
    }

    public StatefulSetBuilder(Boolean validationEnabled) {
        this(new StatefulSet(), validationEnabled);
    }

    public StatefulSetBuilder(StatefulSetFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public StatefulSetBuilder(StatefulSetFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new StatefulSet(), validationEnabled);
    }

    public StatefulSetBuilder(StatefulSetFluent<?> fluent, StatefulSet instance) {
        this(fluent, instance, false);
    }

    public StatefulSetBuilder(StatefulSetFluent<?> fluent, StatefulSet instance, Boolean validationEnabled) {
        this.fluent = fluent;
        StatefulSet statefulSet = instance = instance != null ? instance : new StatefulSet();
        if (instance != null) {
            fluent.withApiVersion(instance.getApiVersion());
            fluent.withKind(instance.getKind());
            fluent.withMetadata(instance.getMetadata());
            fluent.withSpec(instance.getSpec());
            fluent.withStatus(instance.getStatus());
            fluent.withApiVersion(instance.getApiVersion());
            fluent.withKind(instance.getKind());
            fluent.withMetadata(instance.getMetadata());
            fluent.withSpec(instance.getSpec());
            fluent.withStatus(instance.getStatus());
            fluent.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    public StatefulSetBuilder(StatefulSet instance) {
        this(instance, (Boolean)false);
    }

    public StatefulSetBuilder(StatefulSet instance, Boolean validationEnabled) {
        this.fluent = this;
        StatefulSet statefulSet = instance = instance != null ? instance : new StatefulSet();
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withSpec(instance.getSpec());
            this.withStatus(instance.getStatus());
            this.withApiVersion(instance.getApiVersion());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withSpec(instance.getSpec());
            this.withStatus(instance.getStatus());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    @Override
    public StatefulSet build() {
        StatefulSet buildable = new StatefulSet(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.buildMetadata(), this.fluent.buildSpec(), this.fluent.buildStatus());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }
}

