/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_8;

import io.fabric8.kubernetes.api.builder.v6_8.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_8.Nested;
import io.fabric8.kubernetes.api.model.v6_8.FieldsV1;
import io.fabric8.kubernetes.api.model.v6_8.FieldsV1Builder;
import io.fabric8.kubernetes.api.model.v6_8.FieldsV1Fluent;
import io.fabric8.kubernetes.api.model.v6_8.ManagedFieldsEntry;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ManagedFieldsEntryFluent<A extends ManagedFieldsEntryFluent<A>>
extends BaseFluent<A> {
    private String apiVersion;
    private String fieldsType;
    private FieldsV1Builder fieldsV1;
    private String manager;
    private String operation;
    private String subresource;
    private String time;
    private Map<String, Object> additionalProperties;

    public ManagedFieldsEntryFluent() {
    }

    public ManagedFieldsEntryFluent(ManagedFieldsEntry instance) {
        ManagedFieldsEntry managedFieldsEntry = instance = instance != null ? instance : new ManagedFieldsEntry();
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withFieldsType(instance.getFieldsType());
            this.withFieldsV1(instance.getFieldsV1());
            this.withManager(instance.getManager());
            this.withOperation(instance.getOperation());
            this.withSubresource(instance.getSubresource());
            this.withTime(instance.getTime());
            this.withApiVersion(instance.getApiVersion());
            this.withFieldsType(instance.getFieldsType());
            this.withFieldsV1(instance.getFieldsV1());
            this.withManager(instance.getManager());
            this.withOperation(instance.getOperation());
            this.withSubresource(instance.getSubresource());
            this.withTime(instance.getTime());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public String getFieldsType() {
        return this.fieldsType;
    }

    public A withFieldsType(String fieldsType) {
        this.fieldsType = fieldsType;
        return (A)this;
    }

    public boolean hasFieldsType() {
        return this.fieldsType != null;
    }

    public FieldsV1 buildFieldsV1() {
        return this.fieldsV1 != null ? this.fieldsV1.build() : null;
    }

    public A withFieldsV1(FieldsV1 fieldsV1) {
        this._visitables.get("fieldsV1").remove(this.fieldsV1);
        if (fieldsV1 != null) {
            this.fieldsV1 = new FieldsV1Builder(fieldsV1);
            this._visitables.get("fieldsV1").add(this.fieldsV1);
        } else {
            this.fieldsV1 = null;
            this._visitables.get("fieldsV1").remove(this.fieldsV1);
        }
        return (A)this;
    }

    public boolean hasFieldsV1() {
        return this.fieldsV1 != null;
    }

    public FieldsV1Nested<A> withNewFieldsV1() {
        return new FieldsV1Nested(null);
    }

    public FieldsV1Nested<A> withNewFieldsV1Like(FieldsV1 item) {
        return new FieldsV1Nested(item);
    }

    public FieldsV1Nested<A> editFieldsV1() {
        return this.withNewFieldsV1Like(Optional.ofNullable(this.buildFieldsV1()).orElse(null));
    }

    public FieldsV1Nested<A> editOrNewFieldsV1() {
        return this.withNewFieldsV1Like(Optional.ofNullable(this.buildFieldsV1()).orElse(new FieldsV1Builder().build()));
    }

    public FieldsV1Nested<A> editOrNewFieldsV1Like(FieldsV1 item) {
        return this.withNewFieldsV1Like(Optional.ofNullable(this.buildFieldsV1()).orElse(item));
    }

    public String getManager() {
        return this.manager;
    }

    public A withManager(String manager) {
        this.manager = manager;
        return (A)this;
    }

    public boolean hasManager() {
        return this.manager != null;
    }

    public String getOperation() {
        return this.operation;
    }

    public A withOperation(String operation) {
        this.operation = operation;
        return (A)this;
    }

    public boolean hasOperation() {
        return this.operation != null;
    }

    public String getSubresource() {
        return this.subresource;
    }

    public A withSubresource(String subresource) {
        this.subresource = subresource;
        return (A)this;
    }

    public boolean hasSubresource() {
        return this.subresource != null;
    }

    public String getTime() {
        return this.time;
    }

    public A withTime(String time) {
        this.time = time;
        return (A)this;
    }

    public boolean hasTime() {
        return this.time != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ManagedFieldsEntryFluent that = (ManagedFieldsEntryFluent)o;
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.fieldsType, that.fieldsType)) {
            return false;
        }
        if (!Objects.equals(this.fieldsV1, that.fieldsV1)) {
            return false;
        }
        if (!Objects.equals(this.manager, that.manager)) {
            return false;
        }
        if (!Objects.equals(this.operation, that.operation)) {
            return false;
        }
        if (!Objects.equals(this.subresource, that.subresource)) {
            return false;
        }
        if (!Objects.equals(this.time, that.time)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiVersion, this.fieldsType, this.fieldsV1, this.manager, this.operation, this.subresource, this.time, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.fieldsType != null) {
            sb.append("fieldsType:");
            sb.append(this.fieldsType + ",");
        }
        if (this.fieldsV1 != null) {
            sb.append("fieldsV1:");
            sb.append(this.fieldsV1 + ",");
        }
        if (this.manager != null) {
            sb.append("manager:");
            sb.append(this.manager + ",");
        }
        if (this.operation != null) {
            sb.append("operation:");
            sb.append(this.operation + ",");
        }
        if (this.subresource != null) {
            sb.append("subresource:");
            sb.append(this.subresource + ",");
        }
        if (this.time != null) {
            sb.append("time:");
            sb.append(this.time + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class FieldsV1Nested<N>
    extends FieldsV1Fluent<FieldsV1Nested<N>>
    implements Nested<N> {
        FieldsV1Builder builder;

        FieldsV1Nested(FieldsV1 item) {
            this.builder = new FieldsV1Builder(this, item);
        }

        @Override
        public N and() {
            return (N)ManagedFieldsEntryFluent.this.withFieldsV1(this.builder.build());
        }

        public N endFieldsV1() {
            return this.and();
        }
    }
}

