/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import io.fabric8.openshift.api.model.config.v1.TLSProfileSpec;
import io.fabric8.openshift.api.model.operator.v1.EndpointPublishingStrategy;
import io.fabric8.openshift.api.model.operator.v1.EndpointPublishingStrategyBuilder;
import io.fabric8.openshift.api.model.operator.v1.EndpointPublishingStrategyFluent;
import io.fabric8.openshift.api.model.operator.v1.IngressControllerStatus;
import io.fabric8.openshift.api.model.operator.v1.OperatorCondition;
import io.fabric8.openshift.api.model.operator.v1.OperatorConditionBuilder;
import io.fabric8.openshift.api.model.operator.v1.OperatorConditionFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class IngressControllerStatusFluent<A extends IngressControllerStatusFluent<A>>
extends BaseFluent<A> {
    private Integer availableReplicas;
    private ArrayList<OperatorConditionBuilder> conditions = new ArrayList();
    private String domain;
    private EndpointPublishingStrategyBuilder endpointPublishingStrategy;
    private LabelSelectorBuilder namespaceSelector;
    private Long observedGeneration;
    private LabelSelectorBuilder routeSelector;
    private String selector;
    private TLSProfileSpec tlsProfile;
    private Map<String, Object> additionalProperties;

    public IngressControllerStatusFluent() {
    }

    public IngressControllerStatusFluent(IngressControllerStatus instance) {
        IngressControllerStatus ingressControllerStatus = instance = instance != null ? instance : new IngressControllerStatus();
        if (instance != null) {
            this.withAvailableReplicas(instance.getAvailableReplicas());
            this.withConditions(instance.getConditions());
            this.withDomain(instance.getDomain());
            this.withEndpointPublishingStrategy(instance.getEndpointPublishingStrategy());
            this.withNamespaceSelector(instance.getNamespaceSelector());
            this.withObservedGeneration(instance.getObservedGeneration());
            this.withRouteSelector(instance.getRouteSelector());
            this.withSelector(instance.getSelector());
            this.withTlsProfile(instance.getTlsProfile());
            this.withAvailableReplicas(instance.getAvailableReplicas());
            this.withConditions(instance.getConditions());
            this.withDomain(instance.getDomain());
            this.withEndpointPublishingStrategy(instance.getEndpointPublishingStrategy());
            this.withNamespaceSelector(instance.getNamespaceSelector());
            this.withObservedGeneration(instance.getObservedGeneration());
            this.withRouteSelector(instance.getRouteSelector());
            this.withSelector(instance.getSelector());
            this.withTlsProfile(instance.getTlsProfile());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public Integer getAvailableReplicas() {
        return this.availableReplicas;
    }

    public A withAvailableReplicas(Integer availableReplicas) {
        this.availableReplicas = availableReplicas;
        return (A)this;
    }

    public boolean hasAvailableReplicas() {
        return this.availableReplicas != null;
    }

    public A addToConditions(int index, OperatorCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        OperatorConditionBuilder builder = new OperatorConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get("conditions").add(index, builder);
            this.conditions.add(index, builder);
        }
        return (A)this;
    }

    public A setToConditions(int index, OperatorCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        OperatorConditionBuilder builder = new OperatorConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get("conditions").set(index, builder);
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    public A addToConditions(OperatorCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (OperatorCondition item : items) {
            OperatorConditionBuilder builder = new OperatorConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    public A addAllToConditions(Collection<OperatorCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (OperatorCondition item : items) {
            OperatorConditionBuilder builder = new OperatorConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    public A removeFromConditions(OperatorCondition ... items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (OperatorCondition item : items) {
            OperatorConditionBuilder builder = new OperatorConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromConditions(Collection<OperatorCondition> items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (OperatorCondition item : items) {
            OperatorConditionBuilder builder = new OperatorConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromConditions(Predicate<OperatorConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)this;
        }
        Iterator<OperatorConditionBuilder> each = this.conditions.iterator();
        Object visitables = this._visitables.get("conditions");
        while (each.hasNext()) {
            OperatorConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<OperatorCondition> buildConditions() {
        return this.conditions != null ? IngressControllerStatusFluent.build(this.conditions) : null;
    }

    public OperatorCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public OperatorCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public OperatorCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    public OperatorCondition buildMatchingCondition(Predicate<OperatorConditionBuilder> predicate) {
        for (OperatorConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingCondition(Predicate<OperatorConditionBuilder> predicate) {
        for (OperatorConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConditions(List<OperatorCondition> conditions) {
        if (this.conditions != null) {
            this._visitables.get("conditions").clear();
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (OperatorCondition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    public A withConditions(OperatorCondition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove("conditions");
        }
        if (conditions != null) {
            for (OperatorCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public A addNewCondition(String lastTransitionTime, String message, String reason, String status, String type) {
        return this.addToConditions(new OperatorCondition(lastTransitionTime, message, reason, status, type));
    }

    public ConditionsNested<A> addNewCondition() {
        return new ConditionsNested(-1, null);
    }

    public ConditionsNested<A> addNewConditionLike(OperatorCondition item) {
        return new ConditionsNested(-1, item);
    }

    public ConditionsNested<A> setNewConditionLike(int index, OperatorCondition item) {
        return new ConditionsNested(index, item);
    }

    public ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    public ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editMatchingCondition(Predicate<OperatorConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public String getDomain() {
        return this.domain;
    }

    public A withDomain(String domain) {
        this.domain = domain;
        return (A)this;
    }

    public boolean hasDomain() {
        return this.domain != null;
    }

    public EndpointPublishingStrategy buildEndpointPublishingStrategy() {
        return this.endpointPublishingStrategy != null ? this.endpointPublishingStrategy.build() : null;
    }

    public A withEndpointPublishingStrategy(EndpointPublishingStrategy endpointPublishingStrategy) {
        this._visitables.get("endpointPublishingStrategy").remove(this.endpointPublishingStrategy);
        if (endpointPublishingStrategy != null) {
            this.endpointPublishingStrategy = new EndpointPublishingStrategyBuilder(endpointPublishingStrategy);
            this._visitables.get("endpointPublishingStrategy").add(this.endpointPublishingStrategy);
        } else {
            this.endpointPublishingStrategy = null;
            this._visitables.get("endpointPublishingStrategy").remove(this.endpointPublishingStrategy);
        }
        return (A)this;
    }

    public boolean hasEndpointPublishingStrategy() {
        return this.endpointPublishingStrategy != null;
    }

    public EndpointPublishingStrategyNested<A> withNewEndpointPublishingStrategy() {
        return new EndpointPublishingStrategyNested(null);
    }

    public EndpointPublishingStrategyNested<A> withNewEndpointPublishingStrategyLike(EndpointPublishingStrategy item) {
        return new EndpointPublishingStrategyNested(item);
    }

    public EndpointPublishingStrategyNested<A> editEndpointPublishingStrategy() {
        return this.withNewEndpointPublishingStrategyLike(Optional.ofNullable(this.buildEndpointPublishingStrategy()).orElse(null));
    }

    public EndpointPublishingStrategyNested<A> editOrNewEndpointPublishingStrategy() {
        return this.withNewEndpointPublishingStrategyLike(Optional.ofNullable(this.buildEndpointPublishingStrategy()).orElse(new EndpointPublishingStrategyBuilder().build()));
    }

    public EndpointPublishingStrategyNested<A> editOrNewEndpointPublishingStrategyLike(EndpointPublishingStrategy item) {
        return this.withNewEndpointPublishingStrategyLike(Optional.ofNullable(this.buildEndpointPublishingStrategy()).orElse(item));
    }

    public LabelSelector buildNamespaceSelector() {
        return this.namespaceSelector != null ? this.namespaceSelector.build() : null;
    }

    public A withNamespaceSelector(LabelSelector namespaceSelector) {
        this._visitables.get("namespaceSelector").remove(this.namespaceSelector);
        if (namespaceSelector != null) {
            this.namespaceSelector = new LabelSelectorBuilder(namespaceSelector);
            this._visitables.get("namespaceSelector").add(this.namespaceSelector);
        } else {
            this.namespaceSelector = null;
            this._visitables.get("namespaceSelector").remove(this.namespaceSelector);
        }
        return (A)this;
    }

    public boolean hasNamespaceSelector() {
        return this.namespaceSelector != null;
    }

    public NamespaceSelectorNested<A> withNewNamespaceSelector() {
        return new NamespaceSelectorNested(null);
    }

    public NamespaceSelectorNested<A> withNewNamespaceSelectorLike(LabelSelector item) {
        return new NamespaceSelectorNested(item);
    }

    public NamespaceSelectorNested<A> editNamespaceSelector() {
        return this.withNewNamespaceSelectorLike(Optional.ofNullable(this.buildNamespaceSelector()).orElse(null));
    }

    public NamespaceSelectorNested<A> editOrNewNamespaceSelector() {
        return this.withNewNamespaceSelectorLike(Optional.ofNullable(this.buildNamespaceSelector()).orElse(new LabelSelectorBuilder().build()));
    }

    public NamespaceSelectorNested<A> editOrNewNamespaceSelectorLike(LabelSelector item) {
        return this.withNewNamespaceSelectorLike(Optional.ofNullable(this.buildNamespaceSelector()).orElse(item));
    }

    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public A withObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return (A)this;
    }

    public boolean hasObservedGeneration() {
        return this.observedGeneration != null;
    }

    public LabelSelector buildRouteSelector() {
        return this.routeSelector != null ? this.routeSelector.build() : null;
    }

    public A withRouteSelector(LabelSelector routeSelector) {
        this._visitables.get("routeSelector").remove(this.routeSelector);
        if (routeSelector != null) {
            this.routeSelector = new LabelSelectorBuilder(routeSelector);
            this._visitables.get("routeSelector").add(this.routeSelector);
        } else {
            this.routeSelector = null;
            this._visitables.get("routeSelector").remove(this.routeSelector);
        }
        return (A)this;
    }

    public boolean hasRouteSelector() {
        return this.routeSelector != null;
    }

    public RouteSelectorNested<A> withNewRouteSelector() {
        return new RouteSelectorNested(null);
    }

    public RouteSelectorNested<A> withNewRouteSelectorLike(LabelSelector item) {
        return new RouteSelectorNested(item);
    }

    public RouteSelectorNested<A> editRouteSelector() {
        return this.withNewRouteSelectorLike(Optional.ofNullable(this.buildRouteSelector()).orElse(null));
    }

    public RouteSelectorNested<A> editOrNewRouteSelector() {
        return this.withNewRouteSelectorLike(Optional.ofNullable(this.buildRouteSelector()).orElse(new LabelSelectorBuilder().build()));
    }

    public RouteSelectorNested<A> editOrNewRouteSelectorLike(LabelSelector item) {
        return this.withNewRouteSelectorLike(Optional.ofNullable(this.buildRouteSelector()).orElse(item));
    }

    public String getSelector() {
        return this.selector;
    }

    public A withSelector(String selector) {
        this.selector = selector;
        return (A)this;
    }

    public boolean hasSelector() {
        return this.selector != null;
    }

    public TLSProfileSpec getTlsProfile() {
        return this.tlsProfile;
    }

    public A withTlsProfile(TLSProfileSpec tlsProfile) {
        this.tlsProfile = tlsProfile;
        return (A)this;
    }

    public boolean hasTlsProfile() {
        return this.tlsProfile != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IngressControllerStatusFluent that = (IngressControllerStatusFluent)o;
        if (!Objects.equals(this.availableReplicas, that.availableReplicas)) {
            return false;
        }
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.domain, that.domain)) {
            return false;
        }
        if (!Objects.equals(this.endpointPublishingStrategy, that.endpointPublishingStrategy)) {
            return false;
        }
        if (!Objects.equals(this.namespaceSelector, that.namespaceSelector)) {
            return false;
        }
        if (!Objects.equals(this.observedGeneration, that.observedGeneration)) {
            return false;
        }
        if (!Objects.equals(this.routeSelector, that.routeSelector)) {
            return false;
        }
        if (!Objects.equals(this.selector, that.selector)) {
            return false;
        }
        if (!Objects.equals(this.tlsProfile, that.tlsProfile)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.availableReplicas, this.conditions, this.domain, this.endpointPublishingStrategy, this.namespaceSelector, this.observedGeneration, this.routeSelector, this.selector, this.tlsProfile, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.availableReplicas != null) {
            sb.append("availableReplicas:");
            sb.append(this.availableReplicas + ",");
        }
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions + ",");
        }
        if (this.domain != null) {
            sb.append("domain:");
            sb.append(this.domain + ",");
        }
        if (this.endpointPublishingStrategy != null) {
            sb.append("endpointPublishingStrategy:");
            sb.append(this.endpointPublishingStrategy + ",");
        }
        if (this.namespaceSelector != null) {
            sb.append("namespaceSelector:");
            sb.append(this.namespaceSelector + ",");
        }
        if (this.observedGeneration != null) {
            sb.append("observedGeneration:");
            sb.append(this.observedGeneration + ",");
        }
        if (this.routeSelector != null) {
            sb.append("routeSelector:");
            sb.append(this.routeSelector + ",");
        }
        if (this.selector != null) {
            sb.append("selector:");
            sb.append(this.selector + ",");
        }
        if (this.tlsProfile != null) {
            sb.append("tlsProfile:");
            sb.append(this.tlsProfile + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class RouteSelectorNested<N>
    extends LabelSelectorFluent<RouteSelectorNested<N>>
    implements Nested<N> {
        LabelSelectorBuilder builder;

        RouteSelectorNested(LabelSelector item) {
            this.builder = new LabelSelectorBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)IngressControllerStatusFluent.this.withRouteSelector(this.builder.build());
        }

        public N endRouteSelector() {
            return this.and();
        }
    }

    public class NamespaceSelectorNested<N>
    extends LabelSelectorFluent<NamespaceSelectorNested<N>>
    implements Nested<N> {
        LabelSelectorBuilder builder;

        NamespaceSelectorNested(LabelSelector item) {
            this.builder = new LabelSelectorBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)IngressControllerStatusFluent.this.withNamespaceSelector(this.builder.build());
        }

        public N endNamespaceSelector() {
            return this.and();
        }
    }

    public class EndpointPublishingStrategyNested<N>
    extends EndpointPublishingStrategyFluent<EndpointPublishingStrategyNested<N>>
    implements Nested<N> {
        EndpointPublishingStrategyBuilder builder;

        EndpointPublishingStrategyNested(EndpointPublishingStrategy item) {
            this.builder = new EndpointPublishingStrategyBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)IngressControllerStatusFluent.this.withEndpointPublishingStrategy(this.builder.build());
        }

        public N endEndpointPublishingStrategy() {
            return this.and();
        }
    }

    public class ConditionsNested<N>
    extends OperatorConditionFluent<ConditionsNested<N>>
    implements Nested<N> {
        OperatorConditionBuilder builder;
        int index;

        ConditionsNested(int index, OperatorCondition item) {
            this.index = index;
            this.builder = new OperatorConditionBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)IngressControllerStatusFluent.this.setToConditions(this.index, this.builder.build());
        }

        public N endCondition() {
            return this.and();
        }
    }
}

