/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.config.v1.ConfigMapNameReference;
import io.fabric8.openshift.api.model.config.v1.ConfigMapNameReferenceBuilder;
import io.fabric8.openshift.api.model.config.v1.ConfigMapNameReferenceFluent;
import io.fabric8.openshift.api.model.config.v1.RequestHeaderIdentityProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class RequestHeaderIdentityProviderFluent<A extends RequestHeaderIdentityProviderFluent<A>>
extends BaseFluent<A> {
    private ConfigMapNameReferenceBuilder ca;
    private String challengeURL;
    private List<String> clientCommonNames = new ArrayList<String>();
    private List<String> emailHeaders = new ArrayList<String>();
    private List<String> headers = new ArrayList<String>();
    private String loginURL;
    private List<String> nameHeaders = new ArrayList<String>();
    private List<String> preferredUsernameHeaders = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public RequestHeaderIdentityProviderFluent() {
    }

    public RequestHeaderIdentityProviderFluent(RequestHeaderIdentityProvider instance) {
        RequestHeaderIdentityProvider requestHeaderIdentityProvider = instance = instance != null ? instance : new RequestHeaderIdentityProvider();
        if (instance != null) {
            this.withCa(instance.getCa());
            this.withChallengeURL(instance.getChallengeURL());
            this.withClientCommonNames(instance.getClientCommonNames());
            this.withEmailHeaders(instance.getEmailHeaders());
            this.withHeaders(instance.getHeaders());
            this.withLoginURL(instance.getLoginURL());
            this.withNameHeaders(instance.getNameHeaders());
            this.withPreferredUsernameHeaders(instance.getPreferredUsernameHeaders());
            this.withCa(instance.getCa());
            this.withChallengeURL(instance.getChallengeURL());
            this.withClientCommonNames(instance.getClientCommonNames());
            this.withEmailHeaders(instance.getEmailHeaders());
            this.withHeaders(instance.getHeaders());
            this.withLoginURL(instance.getLoginURL());
            this.withNameHeaders(instance.getNameHeaders());
            this.withPreferredUsernameHeaders(instance.getPreferredUsernameHeaders());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ConfigMapNameReference buildCa() {
        return this.ca != null ? this.ca.build() : null;
    }

    public A withCa(ConfigMapNameReference ca) {
        this._visitables.get("ca").remove(this.ca);
        if (ca != null) {
            this.ca = new ConfigMapNameReferenceBuilder(ca);
            this._visitables.get("ca").add(this.ca);
        } else {
            this.ca = null;
            this._visitables.get("ca").remove(this.ca);
        }
        return (A)this;
    }

    public boolean hasCa() {
        return this.ca != null;
    }

    public A withNewCa(String name) {
        return this.withCa(new ConfigMapNameReference(name));
    }

    public CaNested<A> withNewCa() {
        return new CaNested(null);
    }

    public CaNested<A> withNewCaLike(ConfigMapNameReference item) {
        return new CaNested(item);
    }

    public CaNested<A> editCa() {
        return this.withNewCaLike(Optional.ofNullable(this.buildCa()).orElse(null));
    }

    public CaNested<A> editOrNewCa() {
        return this.withNewCaLike(Optional.ofNullable(this.buildCa()).orElse(new ConfigMapNameReferenceBuilder().build()));
    }

    public CaNested<A> editOrNewCaLike(ConfigMapNameReference item) {
        return this.withNewCaLike(Optional.ofNullable(this.buildCa()).orElse(item));
    }

    public String getChallengeURL() {
        return this.challengeURL;
    }

    public A withChallengeURL(String challengeURL) {
        this.challengeURL = challengeURL;
        return (A)this;
    }

    public boolean hasChallengeURL() {
        return this.challengeURL != null;
    }

    public A addToClientCommonNames(int index, String item) {
        if (this.clientCommonNames == null) {
            this.clientCommonNames = new ArrayList<String>();
        }
        this.clientCommonNames.add(index, item);
        return (A)this;
    }

    public A setToClientCommonNames(int index, String item) {
        if (this.clientCommonNames == null) {
            this.clientCommonNames = new ArrayList<String>();
        }
        this.clientCommonNames.set(index, item);
        return (A)this;
    }

    public A addToClientCommonNames(String ... items) {
        if (this.clientCommonNames == null) {
            this.clientCommonNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.clientCommonNames.add(item);
        }
        return (A)this;
    }

    public A addAllToClientCommonNames(Collection<String> items) {
        if (this.clientCommonNames == null) {
            this.clientCommonNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.clientCommonNames.add(item);
        }
        return (A)this;
    }

    public A removeFromClientCommonNames(String ... items) {
        if (this.clientCommonNames == null) {
            return (A)this;
        }
        for (String item : items) {
            this.clientCommonNames.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromClientCommonNames(Collection<String> items) {
        if (this.clientCommonNames == null) {
            return (A)this;
        }
        for (String item : items) {
            this.clientCommonNames.remove(item);
        }
        return (A)this;
    }

    public List<String> getClientCommonNames() {
        return this.clientCommonNames;
    }

    public String getClientCommonName(int index) {
        return this.clientCommonNames.get(index);
    }

    public String getFirstClientCommonName() {
        return this.clientCommonNames.get(0);
    }

    public String getLastClientCommonName() {
        return this.clientCommonNames.get(this.clientCommonNames.size() - 1);
    }

    public String getMatchingClientCommonName(Predicate<String> predicate) {
        for (String item : this.clientCommonNames) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingClientCommonName(Predicate<String> predicate) {
        for (String item : this.clientCommonNames) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withClientCommonNames(List<String> clientCommonNames) {
        if (clientCommonNames != null) {
            this.clientCommonNames = new ArrayList<String>();
            for (String item : clientCommonNames) {
                this.addToClientCommonNames(item);
            }
        } else {
            this.clientCommonNames = null;
        }
        return (A)this;
    }

    public A withClientCommonNames(String ... clientCommonNames) {
        if (this.clientCommonNames != null) {
            this.clientCommonNames.clear();
            this._visitables.remove("clientCommonNames");
        }
        if (clientCommonNames != null) {
            for (String item : clientCommonNames) {
                this.addToClientCommonNames(item);
            }
        }
        return (A)this;
    }

    public boolean hasClientCommonNames() {
        return this.clientCommonNames != null && !this.clientCommonNames.isEmpty();
    }

    public A addToEmailHeaders(int index, String item) {
        if (this.emailHeaders == null) {
            this.emailHeaders = new ArrayList<String>();
        }
        this.emailHeaders.add(index, item);
        return (A)this;
    }

    public A setToEmailHeaders(int index, String item) {
        if (this.emailHeaders == null) {
            this.emailHeaders = new ArrayList<String>();
        }
        this.emailHeaders.set(index, item);
        return (A)this;
    }

    public A addToEmailHeaders(String ... items) {
        if (this.emailHeaders == null) {
            this.emailHeaders = new ArrayList<String>();
        }
        for (String item : items) {
            this.emailHeaders.add(item);
        }
        return (A)this;
    }

    public A addAllToEmailHeaders(Collection<String> items) {
        if (this.emailHeaders == null) {
            this.emailHeaders = new ArrayList<String>();
        }
        for (String item : items) {
            this.emailHeaders.add(item);
        }
        return (A)this;
    }

    public A removeFromEmailHeaders(String ... items) {
        if (this.emailHeaders == null) {
            return (A)this;
        }
        for (String item : items) {
            this.emailHeaders.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromEmailHeaders(Collection<String> items) {
        if (this.emailHeaders == null) {
            return (A)this;
        }
        for (String item : items) {
            this.emailHeaders.remove(item);
        }
        return (A)this;
    }

    public List<String> getEmailHeaders() {
        return this.emailHeaders;
    }

    public String getEmailHeader(int index) {
        return this.emailHeaders.get(index);
    }

    public String getFirstEmailHeader() {
        return this.emailHeaders.get(0);
    }

    public String getLastEmailHeader() {
        return this.emailHeaders.get(this.emailHeaders.size() - 1);
    }

    public String getMatchingEmailHeader(Predicate<String> predicate) {
        for (String item : this.emailHeaders) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingEmailHeader(Predicate<String> predicate) {
        for (String item : this.emailHeaders) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withEmailHeaders(List<String> emailHeaders) {
        if (emailHeaders != null) {
            this.emailHeaders = new ArrayList<String>();
            for (String item : emailHeaders) {
                this.addToEmailHeaders(item);
            }
        } else {
            this.emailHeaders = null;
        }
        return (A)this;
    }

    public A withEmailHeaders(String ... emailHeaders) {
        if (this.emailHeaders != null) {
            this.emailHeaders.clear();
            this._visitables.remove("emailHeaders");
        }
        if (emailHeaders != null) {
            for (String item : emailHeaders) {
                this.addToEmailHeaders(item);
            }
        }
        return (A)this;
    }

    public boolean hasEmailHeaders() {
        return this.emailHeaders != null && !this.emailHeaders.isEmpty();
    }

    public A addToHeaders(int index, String item) {
        if (this.headers == null) {
            this.headers = new ArrayList<String>();
        }
        this.headers.add(index, item);
        return (A)this;
    }

    public A setToHeaders(int index, String item) {
        if (this.headers == null) {
            this.headers = new ArrayList<String>();
        }
        this.headers.set(index, item);
        return (A)this;
    }

    public A addToHeaders(String ... items) {
        if (this.headers == null) {
            this.headers = new ArrayList<String>();
        }
        for (String item : items) {
            this.headers.add(item);
        }
        return (A)this;
    }

    public A addAllToHeaders(Collection<String> items) {
        if (this.headers == null) {
            this.headers = new ArrayList<String>();
        }
        for (String item : items) {
            this.headers.add(item);
        }
        return (A)this;
    }

    public A removeFromHeaders(String ... items) {
        if (this.headers == null) {
            return (A)this;
        }
        for (String item : items) {
            this.headers.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromHeaders(Collection<String> items) {
        if (this.headers == null) {
            return (A)this;
        }
        for (String item : items) {
            this.headers.remove(item);
        }
        return (A)this;
    }

    public List<String> getHeaders() {
        return this.headers;
    }

    public String getHeader(int index) {
        return this.headers.get(index);
    }

    public String getFirstHeader() {
        return this.headers.get(0);
    }

    public String getLastHeader() {
        return this.headers.get(this.headers.size() - 1);
    }

    public String getMatchingHeader(Predicate<String> predicate) {
        for (String item : this.headers) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingHeader(Predicate<String> predicate) {
        for (String item : this.headers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withHeaders(List<String> headers) {
        if (headers != null) {
            this.headers = new ArrayList<String>();
            for (String item : headers) {
                this.addToHeaders(item);
            }
        } else {
            this.headers = null;
        }
        return (A)this;
    }

    public A withHeaders(String ... headers) {
        if (this.headers != null) {
            this.headers.clear();
            this._visitables.remove("headers");
        }
        if (headers != null) {
            for (String item : headers) {
                this.addToHeaders(item);
            }
        }
        return (A)this;
    }

    public boolean hasHeaders() {
        return this.headers != null && !this.headers.isEmpty();
    }

    public String getLoginURL() {
        return this.loginURL;
    }

    public A withLoginURL(String loginURL) {
        this.loginURL = loginURL;
        return (A)this;
    }

    public boolean hasLoginURL() {
        return this.loginURL != null;
    }

    public A addToNameHeaders(int index, String item) {
        if (this.nameHeaders == null) {
            this.nameHeaders = new ArrayList<String>();
        }
        this.nameHeaders.add(index, item);
        return (A)this;
    }

    public A setToNameHeaders(int index, String item) {
        if (this.nameHeaders == null) {
            this.nameHeaders = new ArrayList<String>();
        }
        this.nameHeaders.set(index, item);
        return (A)this;
    }

    public A addToNameHeaders(String ... items) {
        if (this.nameHeaders == null) {
            this.nameHeaders = new ArrayList<String>();
        }
        for (String item : items) {
            this.nameHeaders.add(item);
        }
        return (A)this;
    }

    public A addAllToNameHeaders(Collection<String> items) {
        if (this.nameHeaders == null) {
            this.nameHeaders = new ArrayList<String>();
        }
        for (String item : items) {
            this.nameHeaders.add(item);
        }
        return (A)this;
    }

    public A removeFromNameHeaders(String ... items) {
        if (this.nameHeaders == null) {
            return (A)this;
        }
        for (String item : items) {
            this.nameHeaders.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromNameHeaders(Collection<String> items) {
        if (this.nameHeaders == null) {
            return (A)this;
        }
        for (String item : items) {
            this.nameHeaders.remove(item);
        }
        return (A)this;
    }

    public List<String> getNameHeaders() {
        return this.nameHeaders;
    }

    public String getNameHeader(int index) {
        return this.nameHeaders.get(index);
    }

    public String getFirstNameHeader() {
        return this.nameHeaders.get(0);
    }

    public String getLastNameHeader() {
        return this.nameHeaders.get(this.nameHeaders.size() - 1);
    }

    public String getMatchingNameHeader(Predicate<String> predicate) {
        for (String item : this.nameHeaders) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingNameHeader(Predicate<String> predicate) {
        for (String item : this.nameHeaders) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withNameHeaders(List<String> nameHeaders) {
        if (nameHeaders != null) {
            this.nameHeaders = new ArrayList<String>();
            for (String item : nameHeaders) {
                this.addToNameHeaders(item);
            }
        } else {
            this.nameHeaders = null;
        }
        return (A)this;
    }

    public A withNameHeaders(String ... nameHeaders) {
        if (this.nameHeaders != null) {
            this.nameHeaders.clear();
            this._visitables.remove("nameHeaders");
        }
        if (nameHeaders != null) {
            for (String item : nameHeaders) {
                this.addToNameHeaders(item);
            }
        }
        return (A)this;
    }

    public boolean hasNameHeaders() {
        return this.nameHeaders != null && !this.nameHeaders.isEmpty();
    }

    public A addToPreferredUsernameHeaders(int index, String item) {
        if (this.preferredUsernameHeaders == null) {
            this.preferredUsernameHeaders = new ArrayList<String>();
        }
        this.preferredUsernameHeaders.add(index, item);
        return (A)this;
    }

    public A setToPreferredUsernameHeaders(int index, String item) {
        if (this.preferredUsernameHeaders == null) {
            this.preferredUsernameHeaders = new ArrayList<String>();
        }
        this.preferredUsernameHeaders.set(index, item);
        return (A)this;
    }

    public A addToPreferredUsernameHeaders(String ... items) {
        if (this.preferredUsernameHeaders == null) {
            this.preferredUsernameHeaders = new ArrayList<String>();
        }
        for (String item : items) {
            this.preferredUsernameHeaders.add(item);
        }
        return (A)this;
    }

    public A addAllToPreferredUsernameHeaders(Collection<String> items) {
        if (this.preferredUsernameHeaders == null) {
            this.preferredUsernameHeaders = new ArrayList<String>();
        }
        for (String item : items) {
            this.preferredUsernameHeaders.add(item);
        }
        return (A)this;
    }

    public A removeFromPreferredUsernameHeaders(String ... items) {
        if (this.preferredUsernameHeaders == null) {
            return (A)this;
        }
        for (String item : items) {
            this.preferredUsernameHeaders.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromPreferredUsernameHeaders(Collection<String> items) {
        if (this.preferredUsernameHeaders == null) {
            return (A)this;
        }
        for (String item : items) {
            this.preferredUsernameHeaders.remove(item);
        }
        return (A)this;
    }

    public List<String> getPreferredUsernameHeaders() {
        return this.preferredUsernameHeaders;
    }

    public String getPreferredUsernameHeader(int index) {
        return this.preferredUsernameHeaders.get(index);
    }

    public String getFirstPreferredUsernameHeader() {
        return this.preferredUsernameHeaders.get(0);
    }

    public String getLastPreferredUsernameHeader() {
        return this.preferredUsernameHeaders.get(this.preferredUsernameHeaders.size() - 1);
    }

    public String getMatchingPreferredUsernameHeader(Predicate<String> predicate) {
        for (String item : this.preferredUsernameHeaders) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingPreferredUsernameHeader(Predicate<String> predicate) {
        for (String item : this.preferredUsernameHeaders) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withPreferredUsernameHeaders(List<String> preferredUsernameHeaders) {
        if (preferredUsernameHeaders != null) {
            this.preferredUsernameHeaders = new ArrayList<String>();
            for (String item : preferredUsernameHeaders) {
                this.addToPreferredUsernameHeaders(item);
            }
        } else {
            this.preferredUsernameHeaders = null;
        }
        return (A)this;
    }

    public A withPreferredUsernameHeaders(String ... preferredUsernameHeaders) {
        if (this.preferredUsernameHeaders != null) {
            this.preferredUsernameHeaders.clear();
            this._visitables.remove("preferredUsernameHeaders");
        }
        if (preferredUsernameHeaders != null) {
            for (String item : preferredUsernameHeaders) {
                this.addToPreferredUsernameHeaders(item);
            }
        }
        return (A)this;
    }

    public boolean hasPreferredUsernameHeaders() {
        return this.preferredUsernameHeaders != null && !this.preferredUsernameHeaders.isEmpty();
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RequestHeaderIdentityProviderFluent that = (RequestHeaderIdentityProviderFluent)o;
        if (!Objects.equals(this.ca, that.ca)) {
            return false;
        }
        if (!Objects.equals(this.challengeURL, that.challengeURL)) {
            return false;
        }
        if (!Objects.equals(this.clientCommonNames, that.clientCommonNames)) {
            return false;
        }
        if (!Objects.equals(this.emailHeaders, that.emailHeaders)) {
            return false;
        }
        if (!Objects.equals(this.headers, that.headers)) {
            return false;
        }
        if (!Objects.equals(this.loginURL, that.loginURL)) {
            return false;
        }
        if (!Objects.equals(this.nameHeaders, that.nameHeaders)) {
            return false;
        }
        if (!Objects.equals(this.preferredUsernameHeaders, that.preferredUsernameHeaders)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.ca, this.challengeURL, this.clientCommonNames, this.emailHeaders, this.headers, this.loginURL, this.nameHeaders, this.preferredUsernameHeaders, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.ca != null) {
            sb.append("ca:");
            sb.append(this.ca + ",");
        }
        if (this.challengeURL != null) {
            sb.append("challengeURL:");
            sb.append(this.challengeURL + ",");
        }
        if (this.clientCommonNames != null && !this.clientCommonNames.isEmpty()) {
            sb.append("clientCommonNames:");
            sb.append(this.clientCommonNames + ",");
        }
        if (this.emailHeaders != null && !this.emailHeaders.isEmpty()) {
            sb.append("emailHeaders:");
            sb.append(this.emailHeaders + ",");
        }
        if (this.headers != null && !this.headers.isEmpty()) {
            sb.append("headers:");
            sb.append(this.headers + ",");
        }
        if (this.loginURL != null) {
            sb.append("loginURL:");
            sb.append(this.loginURL + ",");
        }
        if (this.nameHeaders != null && !this.nameHeaders.isEmpty()) {
            sb.append("nameHeaders:");
            sb.append(this.nameHeaders + ",");
        }
        if (this.preferredUsernameHeaders != null && !this.preferredUsernameHeaders.isEmpty()) {
            sb.append("preferredUsernameHeaders:");
            sb.append(this.preferredUsernameHeaders + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class CaNested<N>
    extends ConfigMapNameReferenceFluent<CaNested<N>>
    implements Nested<N> {
        ConfigMapNameReferenceBuilder builder;

        CaNested(ConfigMapNameReference item) {
            this.builder = new ConfigMapNameReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)RequestHeaderIdentityProviderFluent.this.withCa(this.builder.build());
        }

        public N endCa() {
            return this.and();
        }
    }
}

