/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Condition;
import io.fabric8.openshift.api.model.config.v1.FeatureGateDetails;
import io.fabric8.openshift.api.model.config.v1.FeatureGateDetailsBuilder;
import io.fabric8.openshift.api.model.config.v1.FeatureGateDetailsFluent;
import io.fabric8.openshift.api.model.config.v1.FeatureGateStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class FeatureGateStatusFluent<A extends FeatureGateStatusFluent<A>>
extends BaseFluent<A> {
    private List<Condition> conditions = new ArrayList<Condition>();
    private ArrayList<FeatureGateDetailsBuilder> featureGates = new ArrayList();
    private Map<String, Object> additionalProperties;

    public FeatureGateStatusFluent() {
    }

    public FeatureGateStatusFluent(FeatureGateStatus instance) {
        FeatureGateStatus featureGateStatus = instance = instance != null ? instance : new FeatureGateStatus();
        if (instance != null) {
            this.withConditions(instance.getConditions());
            this.withFeatureGates(instance.getFeatureGates());
            this.withConditions(instance.getConditions());
            this.withFeatureGates(instance.getFeatureGates());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.add(index, item);
        return (A)this;
    }

    public A setToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.set(index, item);
        return (A)this;
    }

    public A addToConditions(Condition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)this;
    }

    public A addAllToConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)this;
    }

    public A removeFromConditions(Condition ... items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (Condition item : items) {
            this.conditions.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (Condition item : items) {
            this.conditions.remove(item);
        }
        return (A)this;
    }

    public List<Condition> getConditions() {
        return this.conditions;
    }

    public Condition getCondition(int index) {
        return this.conditions.get(index);
    }

    public Condition getFirstCondition() {
        return this.conditions.get(0);
    }

    public Condition getLastCondition() {
        return this.conditions.get(this.conditions.size() - 1);
    }

    public Condition getMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConditions(List<Condition> conditions) {
        if (conditions != null) {
            this.conditions = new ArrayList<Condition>();
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    public A withConditions(Condition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove("conditions");
        }
        if (conditions != null) {
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public A addToFeatureGates(int index, FeatureGateDetails item) {
        if (this.featureGates == null) {
            this.featureGates = new ArrayList();
        }
        FeatureGateDetailsBuilder builder = new FeatureGateDetailsBuilder(item);
        if (index < 0 || index >= this.featureGates.size()) {
            this._visitables.get("featureGates").add(builder);
            this.featureGates.add(builder);
        } else {
            this._visitables.get("featureGates").add(index, builder);
            this.featureGates.add(index, builder);
        }
        return (A)this;
    }

    public A setToFeatureGates(int index, FeatureGateDetails item) {
        if (this.featureGates == null) {
            this.featureGates = new ArrayList();
        }
        FeatureGateDetailsBuilder builder = new FeatureGateDetailsBuilder(item);
        if (index < 0 || index >= this.featureGates.size()) {
            this._visitables.get("featureGates").add(builder);
            this.featureGates.add(builder);
        } else {
            this._visitables.get("featureGates").set(index, builder);
            this.featureGates.set(index, builder);
        }
        return (A)this;
    }

    public A addToFeatureGates(FeatureGateDetails ... items) {
        if (this.featureGates == null) {
            this.featureGates = new ArrayList();
        }
        for (FeatureGateDetails item : items) {
            FeatureGateDetailsBuilder builder = new FeatureGateDetailsBuilder(item);
            this._visitables.get("featureGates").add(builder);
            this.featureGates.add(builder);
        }
        return (A)this;
    }

    public A addAllToFeatureGates(Collection<FeatureGateDetails> items) {
        if (this.featureGates == null) {
            this.featureGates = new ArrayList();
        }
        for (FeatureGateDetails item : items) {
            FeatureGateDetailsBuilder builder = new FeatureGateDetailsBuilder(item);
            this._visitables.get("featureGates").add(builder);
            this.featureGates.add(builder);
        }
        return (A)this;
    }

    public A removeFromFeatureGates(FeatureGateDetails ... items) {
        if (this.featureGates == null) {
            return (A)this;
        }
        for (FeatureGateDetails item : items) {
            FeatureGateDetailsBuilder builder = new FeatureGateDetailsBuilder(item);
            this._visitables.get("featureGates").remove(builder);
            this.featureGates.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromFeatureGates(Collection<FeatureGateDetails> items) {
        if (this.featureGates == null) {
            return (A)this;
        }
        for (FeatureGateDetails item : items) {
            FeatureGateDetailsBuilder builder = new FeatureGateDetailsBuilder(item);
            this._visitables.get("featureGates").remove(builder);
            this.featureGates.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromFeatureGates(Predicate<FeatureGateDetailsBuilder> predicate) {
        if (this.featureGates == null) {
            return (A)this;
        }
        Iterator<FeatureGateDetailsBuilder> each = this.featureGates.iterator();
        Object visitables = this._visitables.get("featureGates");
        while (each.hasNext()) {
            FeatureGateDetailsBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<FeatureGateDetails> buildFeatureGates() {
        return this.featureGates != null ? FeatureGateStatusFluent.build(this.featureGates) : null;
    }

    public FeatureGateDetails buildFeatureGate(int index) {
        return this.featureGates.get(index).build();
    }

    public FeatureGateDetails buildFirstFeatureGate() {
        return this.featureGates.get(0).build();
    }

    public FeatureGateDetails buildLastFeatureGate() {
        return this.featureGates.get(this.featureGates.size() - 1).build();
    }

    public FeatureGateDetails buildMatchingFeatureGate(Predicate<FeatureGateDetailsBuilder> predicate) {
        for (FeatureGateDetailsBuilder item : this.featureGates) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingFeatureGate(Predicate<FeatureGateDetailsBuilder> predicate) {
        for (FeatureGateDetailsBuilder item : this.featureGates) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withFeatureGates(List<FeatureGateDetails> featureGates) {
        if (this.featureGates != null) {
            this._visitables.get("featureGates").clear();
        }
        if (featureGates != null) {
            this.featureGates = new ArrayList();
            for (FeatureGateDetails item : featureGates) {
                this.addToFeatureGates(item);
            }
        } else {
            this.featureGates = null;
        }
        return (A)this;
    }

    public A withFeatureGates(FeatureGateDetails ... featureGates) {
        if (this.featureGates != null) {
            this.featureGates.clear();
            this._visitables.remove("featureGates");
        }
        if (featureGates != null) {
            for (FeatureGateDetails item : featureGates) {
                this.addToFeatureGates(item);
            }
        }
        return (A)this;
    }

    public boolean hasFeatureGates() {
        return this.featureGates != null && !this.featureGates.isEmpty();
    }

    public FeatureGatesNested<A> addNewFeatureGate() {
        return new FeatureGatesNested(-1, null);
    }

    public FeatureGatesNested<A> addNewFeatureGateLike(FeatureGateDetails item) {
        return new FeatureGatesNested(-1, item);
    }

    public FeatureGatesNested<A> setNewFeatureGateLike(int index, FeatureGateDetails item) {
        return new FeatureGatesNested(index, item);
    }

    public FeatureGatesNested<A> editFeatureGate(int index) {
        if (this.featureGates.size() <= index) {
            throw new RuntimeException("Can't edit featureGates. Index exceeds size.");
        }
        return this.setNewFeatureGateLike(index, this.buildFeatureGate(index));
    }

    public FeatureGatesNested<A> editFirstFeatureGate() {
        if (this.featureGates.size() == 0) {
            throw new RuntimeException("Can't edit first featureGates. The list is empty.");
        }
        return this.setNewFeatureGateLike(0, this.buildFeatureGate(0));
    }

    public FeatureGatesNested<A> editLastFeatureGate() {
        int index = this.featureGates.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last featureGates. The list is empty.");
        }
        return this.setNewFeatureGateLike(index, this.buildFeatureGate(index));
    }

    public FeatureGatesNested<A> editMatchingFeatureGate(Predicate<FeatureGateDetailsBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.featureGates.size(); ++i) {
            if (!predicate.test(this.featureGates.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching featureGates. No match found.");
        }
        return this.setNewFeatureGateLike(index, this.buildFeatureGate(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FeatureGateStatusFluent that = (FeatureGateStatusFluent)o;
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.featureGates, that.featureGates)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.conditions, this.featureGates, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions + ",");
        }
        if (this.featureGates != null && !this.featureGates.isEmpty()) {
            sb.append("featureGates:");
            sb.append(this.featureGates + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class FeatureGatesNested<N>
    extends FeatureGateDetailsFluent<FeatureGatesNested<N>>
    implements Nested<N> {
        FeatureGateDetailsBuilder builder;
        int index;

        FeatureGatesNested(int index, FeatureGateDetails item) {
            this.index = index;
            this.builder = new FeatureGateDetailsBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)FeatureGateStatusFluent.this.setToFeatureGates(this.index, this.builder.build());
        }

        public N endFeatureGate() {
            return this.and();
        }
    }
}

