/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.openshift.api.model.OAuthClientAuthorization;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class OAuthClientAuthorizationFluent<A extends OAuthClientAuthorizationFluent<A>>
extends BaseFluent<A> {
    private String apiVersion;
    private String clientName;
    private String kind;
    private ObjectMetaBuilder metadata;
    private List<String> scopes = new ArrayList<String>();
    private String userName;
    private String userUID;
    private Map<String, Object> additionalProperties;

    public OAuthClientAuthorizationFluent() {
    }

    public OAuthClientAuthorizationFluent(OAuthClientAuthorization instance) {
        OAuthClientAuthorization oAuthClientAuthorization = instance = instance != null ? instance : new OAuthClientAuthorization();
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withClientName(instance.getClientName());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withScopes(instance.getScopes());
            this.withUserName(instance.getUserName());
            this.withUserUID(instance.getUserUID());
            this.withApiVersion(instance.getApiVersion());
            this.withClientName(instance.getClientName());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withScopes(instance.getScopes());
            this.withUserName(instance.getUserName());
            this.withUserUID(instance.getUserUID());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public String getClientName() {
        return this.clientName;
    }

    public A withClientName(String clientName) {
        this.clientName = clientName;
        return (A)this;
    }

    public boolean hasClientName() {
        return this.clientName != null;
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    public A withMetadata(ObjectMeta metadata) {
        this._visitables.get("metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get("metadata").remove(this.metadata);
        }
        return (A)this;
    }

    public boolean hasMetadata() {
        return this.metadata != null;
    }

    public MetadataNested<A> withNewMetadata() {
        return new MetadataNested(null);
    }

    public MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNested(item);
    }

    public MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(null));
    }

    public MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(new ObjectMetaBuilder().build()));
    }

    public MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(item));
    }

    public A addToScopes(int index, String item) {
        if (this.scopes == null) {
            this.scopes = new ArrayList<String>();
        }
        this.scopes.add(index, item);
        return (A)this;
    }

    public A setToScopes(int index, String item) {
        if (this.scopes == null) {
            this.scopes = new ArrayList<String>();
        }
        this.scopes.set(index, item);
        return (A)this;
    }

    public A addToScopes(String ... items) {
        if (this.scopes == null) {
            this.scopes = new ArrayList<String>();
        }
        for (String item : items) {
            this.scopes.add(item);
        }
        return (A)this;
    }

    public A addAllToScopes(Collection<String> items) {
        if (this.scopes == null) {
            this.scopes = new ArrayList<String>();
        }
        for (String item : items) {
            this.scopes.add(item);
        }
        return (A)this;
    }

    public A removeFromScopes(String ... items) {
        if (this.scopes == null) {
            return (A)this;
        }
        for (String item : items) {
            this.scopes.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromScopes(Collection<String> items) {
        if (this.scopes == null) {
            return (A)this;
        }
        for (String item : items) {
            this.scopes.remove(item);
        }
        return (A)this;
    }

    public List<String> getScopes() {
        return this.scopes;
    }

    public String getScope(int index) {
        return this.scopes.get(index);
    }

    public String getFirstScope() {
        return this.scopes.get(0);
    }

    public String getLastScope() {
        return this.scopes.get(this.scopes.size() - 1);
    }

    public String getMatchingScope(Predicate<String> predicate) {
        for (String item : this.scopes) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingScope(Predicate<String> predicate) {
        for (String item : this.scopes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withScopes(List<String> scopes) {
        if (scopes != null) {
            this.scopes = new ArrayList<String>();
            for (String item : scopes) {
                this.addToScopes(item);
            }
        } else {
            this.scopes = null;
        }
        return (A)this;
    }

    public A withScopes(String ... scopes) {
        if (this.scopes != null) {
            this.scopes.clear();
            this._visitables.remove("scopes");
        }
        if (scopes != null) {
            for (String item : scopes) {
                this.addToScopes(item);
            }
        }
        return (A)this;
    }

    public boolean hasScopes() {
        return this.scopes != null && !this.scopes.isEmpty();
    }

    public String getUserName() {
        return this.userName;
    }

    public A withUserName(String userName) {
        this.userName = userName;
        return (A)this;
    }

    public boolean hasUserName() {
        return this.userName != null;
    }

    public String getUserUID() {
        return this.userUID;
    }

    public A withUserUID(String userUID) {
        this.userUID = userUID;
        return (A)this;
    }

    public boolean hasUserUID() {
        return this.userUID != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OAuthClientAuthorizationFluent that = (OAuthClientAuthorizationFluent)o;
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.clientName, that.clientName)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.metadata, that.metadata)) {
            return false;
        }
        if (!Objects.equals(this.scopes, that.scopes)) {
            return false;
        }
        if (!Objects.equals(this.userName, that.userName)) {
            return false;
        }
        if (!Objects.equals(this.userUID, that.userUID)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiVersion, this.clientName, this.kind, this.metadata, this.scopes, this.userName, this.userUID, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.clientName != null) {
            sb.append("clientName:");
            sb.append(this.clientName + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata + ",");
        }
        if (this.scopes != null && !this.scopes.isEmpty()) {
            sb.append("scopes:");
            sb.append(this.scopes + ",");
        }
        if (this.userName != null) {
            sb.append("userName:");
            sb.append(this.userName + ",");
        }
        if (this.userUID != null) {
            sb.append("userUID:");
            sb.append(this.userUID + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class MetadataNested<N>
    extends ObjectMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        ObjectMetaBuilder builder;

        MetadataNested(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)OAuthClientAuthorizationFluent.this.withMetadata(this.builder.build());
        }

        public N endMetadata() {
            return this.and();
        }
    }
}

