/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_8.operatorhub.v1;

import io.fabric8.kubernetes.api.builder.v6_8.BaseFluent;
import io.fabric8.kubernetes.api.model.v6_8.Condition;
import io.fabric8.openshift.api.model.v6_8.operatorhub.v1.OperatorConditionSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class OperatorConditionSpecFluent<A extends OperatorConditionSpecFluent<A>>
extends BaseFluent<A> {
    private List<String> deployments = new ArrayList<String>();
    private List<Condition> overrides = new ArrayList<Condition>();
    private List<String> serviceAccounts = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public OperatorConditionSpecFluent() {
    }

    public OperatorConditionSpecFluent(OperatorConditionSpec instance) {
        OperatorConditionSpec operatorConditionSpec = instance = instance != null ? instance : new OperatorConditionSpec();
        if (instance != null) {
            this.withDeployments(instance.getDeployments());
            this.withOverrides(instance.getOverrides());
            this.withServiceAccounts(instance.getServiceAccounts());
            this.withDeployments(instance.getDeployments());
            this.withOverrides(instance.getOverrides());
            this.withServiceAccounts(instance.getServiceAccounts());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToDeployments(int index, String item) {
        if (this.deployments == null) {
            this.deployments = new ArrayList<String>();
        }
        this.deployments.add(index, item);
        return (A)this;
    }

    public A setToDeployments(int index, String item) {
        if (this.deployments == null) {
            this.deployments = new ArrayList<String>();
        }
        this.deployments.set(index, item);
        return (A)this;
    }

    public A addToDeployments(String ... items) {
        if (this.deployments == null) {
            this.deployments = new ArrayList<String>();
        }
        for (String item : items) {
            this.deployments.add(item);
        }
        return (A)this;
    }

    public A addAllToDeployments(Collection<String> items) {
        if (this.deployments == null) {
            this.deployments = new ArrayList<String>();
        }
        for (String item : items) {
            this.deployments.add(item);
        }
        return (A)this;
    }

    public A removeFromDeployments(String ... items) {
        if (this.deployments == null) {
            return (A)this;
        }
        for (String item : items) {
            this.deployments.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromDeployments(Collection<String> items) {
        if (this.deployments == null) {
            return (A)this;
        }
        for (String item : items) {
            this.deployments.remove(item);
        }
        return (A)this;
    }

    public List<String> getDeployments() {
        return this.deployments;
    }

    public String getDeployment(int index) {
        return this.deployments.get(index);
    }

    public String getFirstDeployment() {
        return this.deployments.get(0);
    }

    public String getLastDeployment() {
        return this.deployments.get(this.deployments.size() - 1);
    }

    public String getMatchingDeployment(Predicate<String> predicate) {
        for (String item : this.deployments) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingDeployment(Predicate<String> predicate) {
        for (String item : this.deployments) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withDeployments(List<String> deployments) {
        if (deployments != null) {
            this.deployments = new ArrayList<String>();
            for (String item : deployments) {
                this.addToDeployments(item);
            }
        } else {
            this.deployments = null;
        }
        return (A)this;
    }

    public A withDeployments(String ... deployments) {
        if (this.deployments != null) {
            this.deployments.clear();
            this._visitables.remove("deployments");
        }
        if (deployments != null) {
            for (String item : deployments) {
                this.addToDeployments(item);
            }
        }
        return (A)this;
    }

    public boolean hasDeployments() {
        return this.deployments != null && !this.deployments.isEmpty();
    }

    public A addToOverrides(int index, Condition item) {
        if (this.overrides == null) {
            this.overrides = new ArrayList<Condition>();
        }
        this.overrides.add(index, item);
        return (A)this;
    }

    public A setToOverrides(int index, Condition item) {
        if (this.overrides == null) {
            this.overrides = new ArrayList<Condition>();
        }
        this.overrides.set(index, item);
        return (A)this;
    }

    public A addToOverrides(Condition ... items) {
        if (this.overrides == null) {
            this.overrides = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.overrides.add(item);
        }
        return (A)this;
    }

    public A addAllToOverrides(Collection<Condition> items) {
        if (this.overrides == null) {
            this.overrides = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.overrides.add(item);
        }
        return (A)this;
    }

    public A removeFromOverrides(Condition ... items) {
        if (this.overrides == null) {
            return (A)this;
        }
        for (Condition item : items) {
            this.overrides.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromOverrides(Collection<Condition> items) {
        if (this.overrides == null) {
            return (A)this;
        }
        for (Condition item : items) {
            this.overrides.remove(item);
        }
        return (A)this;
    }

    public List<Condition> getOverrides() {
        return this.overrides;
    }

    public Condition getOverride(int index) {
        return this.overrides.get(index);
    }

    public Condition getFirstOverride() {
        return this.overrides.get(0);
    }

    public Condition getLastOverride() {
        return this.overrides.get(this.overrides.size() - 1);
    }

    public Condition getMatchingOverride(Predicate<Condition> predicate) {
        for (Condition item : this.overrides) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingOverride(Predicate<Condition> predicate) {
        for (Condition item : this.overrides) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withOverrides(List<Condition> overrides) {
        if (overrides != null) {
            this.overrides = new ArrayList<Condition>();
            for (Condition item : overrides) {
                this.addToOverrides(item);
            }
        } else {
            this.overrides = null;
        }
        return (A)this;
    }

    public A withOverrides(Condition ... overrides) {
        if (this.overrides != null) {
            this.overrides.clear();
            this._visitables.remove("overrides");
        }
        if (overrides != null) {
            for (Condition item : overrides) {
                this.addToOverrides(item);
            }
        }
        return (A)this;
    }

    public boolean hasOverrides() {
        return this.overrides != null && !this.overrides.isEmpty();
    }

    public A addToServiceAccounts(int index, String item) {
        if (this.serviceAccounts == null) {
            this.serviceAccounts = new ArrayList<String>();
        }
        this.serviceAccounts.add(index, item);
        return (A)this;
    }

    public A setToServiceAccounts(int index, String item) {
        if (this.serviceAccounts == null) {
            this.serviceAccounts = new ArrayList<String>();
        }
        this.serviceAccounts.set(index, item);
        return (A)this;
    }

    public A addToServiceAccounts(String ... items) {
        if (this.serviceAccounts == null) {
            this.serviceAccounts = new ArrayList<String>();
        }
        for (String item : items) {
            this.serviceAccounts.add(item);
        }
        return (A)this;
    }

    public A addAllToServiceAccounts(Collection<String> items) {
        if (this.serviceAccounts == null) {
            this.serviceAccounts = new ArrayList<String>();
        }
        for (String item : items) {
            this.serviceAccounts.add(item);
        }
        return (A)this;
    }

    public A removeFromServiceAccounts(String ... items) {
        if (this.serviceAccounts == null) {
            return (A)this;
        }
        for (String item : items) {
            this.serviceAccounts.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromServiceAccounts(Collection<String> items) {
        if (this.serviceAccounts == null) {
            return (A)this;
        }
        for (String item : items) {
            this.serviceAccounts.remove(item);
        }
        return (A)this;
    }

    public List<String> getServiceAccounts() {
        return this.serviceAccounts;
    }

    public String getServiceAccount(int index) {
        return this.serviceAccounts.get(index);
    }

    public String getFirstServiceAccount() {
        return this.serviceAccounts.get(0);
    }

    public String getLastServiceAccount() {
        return this.serviceAccounts.get(this.serviceAccounts.size() - 1);
    }

    public String getMatchingServiceAccount(Predicate<String> predicate) {
        for (String item : this.serviceAccounts) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingServiceAccount(Predicate<String> predicate) {
        for (String item : this.serviceAccounts) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withServiceAccounts(List<String> serviceAccounts) {
        if (serviceAccounts != null) {
            this.serviceAccounts = new ArrayList<String>();
            for (String item : serviceAccounts) {
                this.addToServiceAccounts(item);
            }
        } else {
            this.serviceAccounts = null;
        }
        return (A)this;
    }

    public A withServiceAccounts(String ... serviceAccounts) {
        if (this.serviceAccounts != null) {
            this.serviceAccounts.clear();
            this._visitables.remove("serviceAccounts");
        }
        if (serviceAccounts != null) {
            for (String item : serviceAccounts) {
                this.addToServiceAccounts(item);
            }
        }
        return (A)this;
    }

    public boolean hasServiceAccounts() {
        return this.serviceAccounts != null && !this.serviceAccounts.isEmpty();
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OperatorConditionSpecFluent that = (OperatorConditionSpecFluent)o;
        if (!Objects.equals(this.deployments, that.deployments)) {
            return false;
        }
        if (!Objects.equals(this.overrides, that.overrides)) {
            return false;
        }
        if (!Objects.equals(this.serviceAccounts, that.serviceAccounts)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.deployments, this.overrides, this.serviceAccounts, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.deployments != null && !this.deployments.isEmpty()) {
            sb.append("deployments:");
            sb.append(this.deployments + ",");
        }
        if (this.overrides != null && !this.overrides.isEmpty()) {
            sb.append("overrides:");
            sb.append(this.overrides + ",");
        }
        if (this.serviceAccounts != null && !this.serviceAccounts.isEmpty()) {
            sb.append("serviceAccounts:");
            sb.append(this.serviceAccounts + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

