/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_8.installer.openstack.v1;

import io.fabric8.kubernetes.api.builder.v6_8.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_8.Nested;
import io.fabric8.openshift.api.model.v6_8.installer.openstack.v1.FixedIP;
import io.fabric8.openshift.api.model.v6_8.installer.openstack.v1.FixedIPBuilder;
import io.fabric8.openshift.api.model.v6_8.installer.openstack.v1.FixedIPFluent;
import io.fabric8.openshift.api.model.v6_8.installer.openstack.v1.NamedPortTarget;
import io.fabric8.openshift.api.model.v6_8.installer.openstack.v1.NetworkFilter;
import io.fabric8.openshift.api.model.v6_8.installer.openstack.v1.NetworkFilterBuilder;
import io.fabric8.openshift.api.model.v6_8.installer.openstack.v1.NetworkFilterFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class NamedPortTargetFluent<A extends NamedPortTargetFluent<A>>
extends BaseFluent<A> {
    private ArrayList<FixedIPBuilder> fixedIPs = new ArrayList();
    private String id;
    private NetworkFilterBuilder network;
    private Map<String, Object> additionalProperties;

    public NamedPortTargetFluent() {
    }

    public NamedPortTargetFluent(NamedPortTarget instance) {
        NamedPortTarget namedPortTarget = instance = instance != null ? instance : new NamedPortTarget();
        if (instance != null) {
            this.withFixedIPs(instance.getFixedIPs());
            this.withId(instance.getId());
            this.withNetwork(instance.getNetwork());
            this.withFixedIPs(instance.getFixedIPs());
            this.withId(instance.getId());
            this.withNetwork(instance.getNetwork());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToFixedIPs(int index, FixedIP item) {
        if (this.fixedIPs == null) {
            this.fixedIPs = new ArrayList();
        }
        FixedIPBuilder builder = new FixedIPBuilder(item);
        if (index < 0 || index >= this.fixedIPs.size()) {
            this._visitables.get("fixedIPs").add(builder);
            this.fixedIPs.add(builder);
        } else {
            this._visitables.get("fixedIPs").add(index, builder);
            this.fixedIPs.add(index, builder);
        }
        return (A)this;
    }

    public A setToFixedIPs(int index, FixedIP item) {
        if (this.fixedIPs == null) {
            this.fixedIPs = new ArrayList();
        }
        FixedIPBuilder builder = new FixedIPBuilder(item);
        if (index < 0 || index >= this.fixedIPs.size()) {
            this._visitables.get("fixedIPs").add(builder);
            this.fixedIPs.add(builder);
        } else {
            this._visitables.get("fixedIPs").set(index, builder);
            this.fixedIPs.set(index, builder);
        }
        return (A)this;
    }

    public A addToFixedIPs(FixedIP ... items) {
        if (this.fixedIPs == null) {
            this.fixedIPs = new ArrayList();
        }
        for (FixedIP item : items) {
            FixedIPBuilder builder = new FixedIPBuilder(item);
            this._visitables.get("fixedIPs").add(builder);
            this.fixedIPs.add(builder);
        }
        return (A)this;
    }

    public A addAllToFixedIPs(Collection<FixedIP> items) {
        if (this.fixedIPs == null) {
            this.fixedIPs = new ArrayList();
        }
        for (FixedIP item : items) {
            FixedIPBuilder builder = new FixedIPBuilder(item);
            this._visitables.get("fixedIPs").add(builder);
            this.fixedIPs.add(builder);
        }
        return (A)this;
    }

    public A removeFromFixedIPs(FixedIP ... items) {
        if (this.fixedIPs == null) {
            return (A)this;
        }
        for (FixedIP item : items) {
            FixedIPBuilder builder = new FixedIPBuilder(item);
            this._visitables.get("fixedIPs").remove(builder);
            this.fixedIPs.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromFixedIPs(Collection<FixedIP> items) {
        if (this.fixedIPs == null) {
            return (A)this;
        }
        for (FixedIP item : items) {
            FixedIPBuilder builder = new FixedIPBuilder(item);
            this._visitables.get("fixedIPs").remove(builder);
            this.fixedIPs.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromFixedIPs(Predicate<FixedIPBuilder> predicate) {
        if (this.fixedIPs == null) {
            return (A)this;
        }
        Iterator<FixedIPBuilder> each = this.fixedIPs.iterator();
        Object visitables = this._visitables.get("fixedIPs");
        while (each.hasNext()) {
            FixedIPBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<FixedIP> buildFixedIPs() {
        return this.fixedIPs != null ? NamedPortTargetFluent.build(this.fixedIPs) : null;
    }

    public FixedIP buildFixedIP(int index) {
        return this.fixedIPs.get(index).build();
    }

    public FixedIP buildFirstFixedIP() {
        return this.fixedIPs.get(0).build();
    }

    public FixedIP buildLastFixedIP() {
        return this.fixedIPs.get(this.fixedIPs.size() - 1).build();
    }

    public FixedIP buildMatchingFixedIP(Predicate<FixedIPBuilder> predicate) {
        for (FixedIPBuilder item : this.fixedIPs) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingFixedIP(Predicate<FixedIPBuilder> predicate) {
        for (FixedIPBuilder item : this.fixedIPs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withFixedIPs(List<FixedIP> fixedIPs) {
        if (this.fixedIPs != null) {
            this._visitables.get("fixedIPs").clear();
        }
        if (fixedIPs != null) {
            this.fixedIPs = new ArrayList();
            for (FixedIP item : fixedIPs) {
                this.addToFixedIPs(item);
            }
        } else {
            this.fixedIPs = null;
        }
        return (A)this;
    }

    public A withFixedIPs(FixedIP ... fixedIPs) {
        if (this.fixedIPs != null) {
            this.fixedIPs.clear();
            this._visitables.remove("fixedIPs");
        }
        if (fixedIPs != null) {
            for (FixedIP item : fixedIPs) {
                this.addToFixedIPs(item);
            }
        }
        return (A)this;
    }

    public boolean hasFixedIPs() {
        return this.fixedIPs != null && !this.fixedIPs.isEmpty();
    }

    public FixedIPsNested<A> addNewFixedIP() {
        return new FixedIPsNested(-1, null);
    }

    public FixedIPsNested<A> addNewFixedIPLike(FixedIP item) {
        return new FixedIPsNested(-1, item);
    }

    public FixedIPsNested<A> setNewFixedIPLike(int index, FixedIP item) {
        return new FixedIPsNested(index, item);
    }

    public FixedIPsNested<A> editFixedIP(int index) {
        if (this.fixedIPs.size() <= index) {
            throw new RuntimeException("Can't edit fixedIPs. Index exceeds size.");
        }
        return this.setNewFixedIPLike(index, this.buildFixedIP(index));
    }

    public FixedIPsNested<A> editFirstFixedIP() {
        if (this.fixedIPs.size() == 0) {
            throw new RuntimeException("Can't edit first fixedIPs. The list is empty.");
        }
        return this.setNewFixedIPLike(0, this.buildFixedIP(0));
    }

    public FixedIPsNested<A> editLastFixedIP() {
        int index = this.fixedIPs.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last fixedIPs. The list is empty.");
        }
        return this.setNewFixedIPLike(index, this.buildFixedIP(index));
    }

    public FixedIPsNested<A> editMatchingFixedIP(Predicate<FixedIPBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.fixedIPs.size(); ++i) {
            if (!predicate.test(this.fixedIPs.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching fixedIPs. No match found.");
        }
        return this.setNewFixedIPLike(index, this.buildFixedIP(index));
    }

    public String getId() {
        return this.id;
    }

    public A withId(String id) {
        this.id = id;
        return (A)this;
    }

    public boolean hasId() {
        return this.id != null;
    }

    public NetworkFilter buildNetwork() {
        return this.network != null ? this.network.build() : null;
    }

    public A withNetwork(NetworkFilter network) {
        this._visitables.get("network").remove(this.network);
        if (network != null) {
            this.network = new NetworkFilterBuilder(network);
            this._visitables.get("network").add(this.network);
        } else {
            this.network = null;
            this._visitables.get("network").remove(this.network);
        }
        return (A)this;
    }

    public boolean hasNetwork() {
        return this.network != null;
    }

    public A withNewNetwork(String id, String name) {
        return this.withNetwork(new NetworkFilter(id, name));
    }

    public NetworkNested<A> withNewNetwork() {
        return new NetworkNested(null);
    }

    public NetworkNested<A> withNewNetworkLike(NetworkFilter item) {
        return new NetworkNested(item);
    }

    public NetworkNested<A> editNetwork() {
        return this.withNewNetworkLike(Optional.ofNullable(this.buildNetwork()).orElse(null));
    }

    public NetworkNested<A> editOrNewNetwork() {
        return this.withNewNetworkLike(Optional.ofNullable(this.buildNetwork()).orElse(new NetworkFilterBuilder().build()));
    }

    public NetworkNested<A> editOrNewNetworkLike(NetworkFilter item) {
        return this.withNewNetworkLike(Optional.ofNullable(this.buildNetwork()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NamedPortTargetFluent that = (NamedPortTargetFluent)o;
        if (!Objects.equals(this.fixedIPs, that.fixedIPs)) {
            return false;
        }
        if (!Objects.equals(this.id, that.id)) {
            return false;
        }
        if (!Objects.equals(this.network, that.network)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fixedIPs, this.id, this.network, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.fixedIPs != null && !this.fixedIPs.isEmpty()) {
            sb.append("fixedIPs:");
            sb.append(this.fixedIPs + ",");
        }
        if (this.id != null) {
            sb.append("id:");
            sb.append(this.id + ",");
        }
        if (this.network != null) {
            sb.append("network:");
            sb.append(this.network + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class NetworkNested<N>
    extends NetworkFilterFluent<NetworkNested<N>>
    implements Nested<N> {
        NetworkFilterBuilder builder;

        NetworkNested(NetworkFilter item) {
            this.builder = new NetworkFilterBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)NamedPortTargetFluent.this.withNetwork(this.builder.build());
        }

        public N endNetwork() {
            return this.and();
        }
    }

    public class FixedIPsNested<N>
    extends FixedIPFluent<FixedIPsNested<N>>
    implements Nested<N> {
        FixedIPBuilder builder;
        int index;

        FixedIPsNested(int index, FixedIP item) {
            this.index = index;
            this.builder = new FixedIPBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)NamedPortTargetFluent.this.setToFixedIPs(this.index, this.builder.build());
        }

        public N endFixedIP() {
            return this.and();
        }
    }
}

