/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_8.installer.aws.v1;

import io.fabric8.kubernetes.api.builder.v6_8.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_8.Nested;
import io.fabric8.openshift.api.model.v6_8.installer.aws.v1.MachinePool;
import io.fabric8.openshift.api.model.v6_8.installer.aws.v1.MachinePoolBuilder;
import io.fabric8.openshift.api.model.v6_8.installer.aws.v1.MachinePoolFluent;
import io.fabric8.openshift.api.model.v6_8.installer.aws.v1.Platform;
import io.fabric8.openshift.api.model.v6_8.installer.aws.v1.ServiceEndpoint;
import io.fabric8.openshift.api.model.v6_8.installer.aws.v1.ServiceEndpointBuilder;
import io.fabric8.openshift.api.model.v6_8.installer.aws.v1.ServiceEndpointFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class PlatformFluent<A extends PlatformFluent<A>>
extends BaseFluent<A> {
    private String amiID;
    private MachinePoolBuilder defaultMachinePlatform;
    private Boolean experimentalPropagateUserTags;
    private String hostedZone;
    private String lbType;
    private Boolean propagateUserTags;
    private String region;
    private ArrayList<ServiceEndpointBuilder> serviceEndpoints = new ArrayList();
    private List<String> subnets = new ArrayList<String>();
    private Map<String, String> userTags;
    private Map<String, Object> additionalProperties;

    public PlatformFluent() {
    }

    public PlatformFluent(Platform instance) {
        Platform platform = instance = instance != null ? instance : new Platform();
        if (instance != null) {
            this.withAmiID(instance.getAmiID());
            this.withDefaultMachinePlatform(instance.getDefaultMachinePlatform());
            this.withExperimentalPropagateUserTags(instance.getExperimentalPropagateUserTags());
            this.withHostedZone(instance.getHostedZone());
            this.withLbType(instance.getLbType());
            this.withPropagateUserTags(instance.getPropagateUserTags());
            this.withRegion(instance.getRegion());
            this.withServiceEndpoints(instance.getServiceEndpoints());
            this.withSubnets(instance.getSubnets());
            this.withUserTags(instance.getUserTags());
            this.withAmiID(instance.getAmiID());
            this.withDefaultMachinePlatform(instance.getDefaultMachinePlatform());
            this.withExperimentalPropagateUserTags(instance.getExperimentalPropagateUserTags());
            this.withHostedZone(instance.getHostedZone());
            this.withLbType(instance.getLbType());
            this.withPropagateUserTags(instance.getPropagateUserTags());
            this.withRegion(instance.getRegion());
            this.withServiceEndpoints(instance.getServiceEndpoints());
            this.withSubnets(instance.getSubnets());
            this.withUserTags(instance.getUserTags());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getAmiID() {
        return this.amiID;
    }

    public A withAmiID(String amiID) {
        this.amiID = amiID;
        return (A)this;
    }

    public boolean hasAmiID() {
        return this.amiID != null;
    }

    public MachinePool buildDefaultMachinePlatform() {
        return this.defaultMachinePlatform != null ? this.defaultMachinePlatform.build() : null;
    }

    public A withDefaultMachinePlatform(MachinePool defaultMachinePlatform) {
        this._visitables.get("defaultMachinePlatform").remove(this.defaultMachinePlatform);
        if (defaultMachinePlatform != null) {
            this.defaultMachinePlatform = new MachinePoolBuilder(defaultMachinePlatform);
            this._visitables.get("defaultMachinePlatform").add(this.defaultMachinePlatform);
        } else {
            this.defaultMachinePlatform = null;
            this._visitables.get("defaultMachinePlatform").remove(this.defaultMachinePlatform);
        }
        return (A)this;
    }

    public boolean hasDefaultMachinePlatform() {
        return this.defaultMachinePlatform != null;
    }

    public DefaultMachinePlatformNested<A> withNewDefaultMachinePlatform() {
        return new DefaultMachinePlatformNested(null);
    }

    public DefaultMachinePlatformNested<A> withNewDefaultMachinePlatformLike(MachinePool item) {
        return new DefaultMachinePlatformNested(item);
    }

    public DefaultMachinePlatformNested<A> editDefaultMachinePlatform() {
        return this.withNewDefaultMachinePlatformLike(Optional.ofNullable(this.buildDefaultMachinePlatform()).orElse(null));
    }

    public DefaultMachinePlatformNested<A> editOrNewDefaultMachinePlatform() {
        return this.withNewDefaultMachinePlatformLike(Optional.ofNullable(this.buildDefaultMachinePlatform()).orElse(new MachinePoolBuilder().build()));
    }

    public DefaultMachinePlatformNested<A> editOrNewDefaultMachinePlatformLike(MachinePool item) {
        return this.withNewDefaultMachinePlatformLike(Optional.ofNullable(this.buildDefaultMachinePlatform()).orElse(item));
    }

    public Boolean getExperimentalPropagateUserTags() {
        return this.experimentalPropagateUserTags;
    }

    public A withExperimentalPropagateUserTags(Boolean experimentalPropagateUserTags) {
        this.experimentalPropagateUserTags = experimentalPropagateUserTags;
        return (A)this;
    }

    public boolean hasExperimentalPropagateUserTags() {
        return this.experimentalPropagateUserTags != null;
    }

    public String getHostedZone() {
        return this.hostedZone;
    }

    public A withHostedZone(String hostedZone) {
        this.hostedZone = hostedZone;
        return (A)this;
    }

    public boolean hasHostedZone() {
        return this.hostedZone != null;
    }

    public String getLbType() {
        return this.lbType;
    }

    public A withLbType(String lbType) {
        this.lbType = lbType;
        return (A)this;
    }

    public boolean hasLbType() {
        return this.lbType != null;
    }

    public Boolean getPropagateUserTags() {
        return this.propagateUserTags;
    }

    public A withPropagateUserTags(Boolean propagateUserTags) {
        this.propagateUserTags = propagateUserTags;
        return (A)this;
    }

    public boolean hasPropagateUserTags() {
        return this.propagateUserTags != null;
    }

    public String getRegion() {
        return this.region;
    }

    public A withRegion(String region) {
        this.region = region;
        return (A)this;
    }

    public boolean hasRegion() {
        return this.region != null;
    }

    public A addToServiceEndpoints(int index, ServiceEndpoint item) {
        if (this.serviceEndpoints == null) {
            this.serviceEndpoints = new ArrayList();
        }
        ServiceEndpointBuilder builder = new ServiceEndpointBuilder(item);
        if (index < 0 || index >= this.serviceEndpoints.size()) {
            this._visitables.get("serviceEndpoints").add(builder);
            this.serviceEndpoints.add(builder);
        } else {
            this._visitables.get("serviceEndpoints").add(index, builder);
            this.serviceEndpoints.add(index, builder);
        }
        return (A)this;
    }

    public A setToServiceEndpoints(int index, ServiceEndpoint item) {
        if (this.serviceEndpoints == null) {
            this.serviceEndpoints = new ArrayList();
        }
        ServiceEndpointBuilder builder = new ServiceEndpointBuilder(item);
        if (index < 0 || index >= this.serviceEndpoints.size()) {
            this._visitables.get("serviceEndpoints").add(builder);
            this.serviceEndpoints.add(builder);
        } else {
            this._visitables.get("serviceEndpoints").set(index, builder);
            this.serviceEndpoints.set(index, builder);
        }
        return (A)this;
    }

    public A addToServiceEndpoints(ServiceEndpoint ... items) {
        if (this.serviceEndpoints == null) {
            this.serviceEndpoints = new ArrayList();
        }
        for (ServiceEndpoint item : items) {
            ServiceEndpointBuilder builder = new ServiceEndpointBuilder(item);
            this._visitables.get("serviceEndpoints").add(builder);
            this.serviceEndpoints.add(builder);
        }
        return (A)this;
    }

    public A addAllToServiceEndpoints(Collection<ServiceEndpoint> items) {
        if (this.serviceEndpoints == null) {
            this.serviceEndpoints = new ArrayList();
        }
        for (ServiceEndpoint item : items) {
            ServiceEndpointBuilder builder = new ServiceEndpointBuilder(item);
            this._visitables.get("serviceEndpoints").add(builder);
            this.serviceEndpoints.add(builder);
        }
        return (A)this;
    }

    public A removeFromServiceEndpoints(ServiceEndpoint ... items) {
        if (this.serviceEndpoints == null) {
            return (A)this;
        }
        for (ServiceEndpoint item : items) {
            ServiceEndpointBuilder builder = new ServiceEndpointBuilder(item);
            this._visitables.get("serviceEndpoints").remove(builder);
            this.serviceEndpoints.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromServiceEndpoints(Collection<ServiceEndpoint> items) {
        if (this.serviceEndpoints == null) {
            return (A)this;
        }
        for (ServiceEndpoint item : items) {
            ServiceEndpointBuilder builder = new ServiceEndpointBuilder(item);
            this._visitables.get("serviceEndpoints").remove(builder);
            this.serviceEndpoints.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromServiceEndpoints(Predicate<ServiceEndpointBuilder> predicate) {
        if (this.serviceEndpoints == null) {
            return (A)this;
        }
        Iterator<ServiceEndpointBuilder> each = this.serviceEndpoints.iterator();
        Object visitables = this._visitables.get("serviceEndpoints");
        while (each.hasNext()) {
            ServiceEndpointBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<ServiceEndpoint> buildServiceEndpoints() {
        return this.serviceEndpoints != null ? PlatformFluent.build(this.serviceEndpoints) : null;
    }

    public ServiceEndpoint buildServiceEndpoint(int index) {
        return this.serviceEndpoints.get(index).build();
    }

    public ServiceEndpoint buildFirstServiceEndpoint() {
        return this.serviceEndpoints.get(0).build();
    }

    public ServiceEndpoint buildLastServiceEndpoint() {
        return this.serviceEndpoints.get(this.serviceEndpoints.size() - 1).build();
    }

    public ServiceEndpoint buildMatchingServiceEndpoint(Predicate<ServiceEndpointBuilder> predicate) {
        for (ServiceEndpointBuilder item : this.serviceEndpoints) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingServiceEndpoint(Predicate<ServiceEndpointBuilder> predicate) {
        for (ServiceEndpointBuilder item : this.serviceEndpoints) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withServiceEndpoints(List<ServiceEndpoint> serviceEndpoints) {
        if (this.serviceEndpoints != null) {
            this._visitables.get("serviceEndpoints").clear();
        }
        if (serviceEndpoints != null) {
            this.serviceEndpoints = new ArrayList();
            for (ServiceEndpoint item : serviceEndpoints) {
                this.addToServiceEndpoints(item);
            }
        } else {
            this.serviceEndpoints = null;
        }
        return (A)this;
    }

    public A withServiceEndpoints(ServiceEndpoint ... serviceEndpoints) {
        if (this.serviceEndpoints != null) {
            this.serviceEndpoints.clear();
            this._visitables.remove("serviceEndpoints");
        }
        if (serviceEndpoints != null) {
            for (ServiceEndpoint item : serviceEndpoints) {
                this.addToServiceEndpoints(item);
            }
        }
        return (A)this;
    }

    public boolean hasServiceEndpoints() {
        return this.serviceEndpoints != null && !this.serviceEndpoints.isEmpty();
    }

    public A addNewServiceEndpoint(String name, String url) {
        return this.addToServiceEndpoints(new ServiceEndpoint(name, url));
    }

    public ServiceEndpointsNested<A> addNewServiceEndpoint() {
        return new ServiceEndpointsNested(-1, null);
    }

    public ServiceEndpointsNested<A> addNewServiceEndpointLike(ServiceEndpoint item) {
        return new ServiceEndpointsNested(-1, item);
    }

    public ServiceEndpointsNested<A> setNewServiceEndpointLike(int index, ServiceEndpoint item) {
        return new ServiceEndpointsNested(index, item);
    }

    public ServiceEndpointsNested<A> editServiceEndpoint(int index) {
        if (this.serviceEndpoints.size() <= index) {
            throw new RuntimeException("Can't edit serviceEndpoints. Index exceeds size.");
        }
        return this.setNewServiceEndpointLike(index, this.buildServiceEndpoint(index));
    }

    public ServiceEndpointsNested<A> editFirstServiceEndpoint() {
        if (this.serviceEndpoints.size() == 0) {
            throw new RuntimeException("Can't edit first serviceEndpoints. The list is empty.");
        }
        return this.setNewServiceEndpointLike(0, this.buildServiceEndpoint(0));
    }

    public ServiceEndpointsNested<A> editLastServiceEndpoint() {
        int index = this.serviceEndpoints.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last serviceEndpoints. The list is empty.");
        }
        return this.setNewServiceEndpointLike(index, this.buildServiceEndpoint(index));
    }

    public ServiceEndpointsNested<A> editMatchingServiceEndpoint(Predicate<ServiceEndpointBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.serviceEndpoints.size(); ++i) {
            if (!predicate.test(this.serviceEndpoints.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching serviceEndpoints. No match found.");
        }
        return this.setNewServiceEndpointLike(index, this.buildServiceEndpoint(index));
    }

    public A addToSubnets(int index, String item) {
        if (this.subnets == null) {
            this.subnets = new ArrayList<String>();
        }
        this.subnets.add(index, item);
        return (A)this;
    }

    public A setToSubnets(int index, String item) {
        if (this.subnets == null) {
            this.subnets = new ArrayList<String>();
        }
        this.subnets.set(index, item);
        return (A)this;
    }

    public A addToSubnets(String ... items) {
        if (this.subnets == null) {
            this.subnets = new ArrayList<String>();
        }
        for (String item : items) {
            this.subnets.add(item);
        }
        return (A)this;
    }

    public A addAllToSubnets(Collection<String> items) {
        if (this.subnets == null) {
            this.subnets = new ArrayList<String>();
        }
        for (String item : items) {
            this.subnets.add(item);
        }
        return (A)this;
    }

    public A removeFromSubnets(String ... items) {
        if (this.subnets == null) {
            return (A)this;
        }
        for (String item : items) {
            this.subnets.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromSubnets(Collection<String> items) {
        if (this.subnets == null) {
            return (A)this;
        }
        for (String item : items) {
            this.subnets.remove(item);
        }
        return (A)this;
    }

    public List<String> getSubnets() {
        return this.subnets;
    }

    public String getSubnet(int index) {
        return this.subnets.get(index);
    }

    public String getFirstSubnet() {
        return this.subnets.get(0);
    }

    public String getLastSubnet() {
        return this.subnets.get(this.subnets.size() - 1);
    }

    public String getMatchingSubnet(Predicate<String> predicate) {
        for (String item : this.subnets) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingSubnet(Predicate<String> predicate) {
        for (String item : this.subnets) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withSubnets(List<String> subnets) {
        if (subnets != null) {
            this.subnets = new ArrayList<String>();
            for (String item : subnets) {
                this.addToSubnets(item);
            }
        } else {
            this.subnets = null;
        }
        return (A)this;
    }

    public A withSubnets(String ... subnets) {
        if (this.subnets != null) {
            this.subnets.clear();
            this._visitables.remove("subnets");
        }
        if (subnets != null) {
            for (String item : subnets) {
                this.addToSubnets(item);
            }
        }
        return (A)this;
    }

    public boolean hasSubnets() {
        return this.subnets != null && !this.subnets.isEmpty();
    }

    public A addToUserTags(String key, String value) {
        if (this.userTags == null && key != null && value != null) {
            this.userTags = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.userTags.put(key, value);
        }
        return (A)this;
    }

    public A addToUserTags(Map<String, String> map) {
        if (this.userTags == null && map != null) {
            this.userTags = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.userTags.putAll(map);
        }
        return (A)this;
    }

    public A removeFromUserTags(String key) {
        if (this.userTags == null) {
            return (A)this;
        }
        if (key != null && this.userTags != null) {
            this.userTags.remove(key);
        }
        return (A)this;
    }

    public A removeFromUserTags(Map<String, String> map) {
        if (this.userTags == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.userTags == null) continue;
                this.userTags.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, String> getUserTags() {
        return this.userTags;
    }

    public <K, V> A withUserTags(Map<String, String> userTags) {
        this.userTags = userTags == null ? null : new LinkedHashMap<String, String>(userTags);
        return (A)this;
    }

    public boolean hasUserTags() {
        return this.userTags != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PlatformFluent that = (PlatformFluent)o;
        if (!Objects.equals(this.amiID, that.amiID)) {
            return false;
        }
        if (!Objects.equals(this.defaultMachinePlatform, that.defaultMachinePlatform)) {
            return false;
        }
        if (!Objects.equals(this.experimentalPropagateUserTags, that.experimentalPropagateUserTags)) {
            return false;
        }
        if (!Objects.equals(this.hostedZone, that.hostedZone)) {
            return false;
        }
        if (!Objects.equals(this.lbType, that.lbType)) {
            return false;
        }
        if (!Objects.equals(this.propagateUserTags, that.propagateUserTags)) {
            return false;
        }
        if (!Objects.equals(this.region, that.region)) {
            return false;
        }
        if (!Objects.equals(this.serviceEndpoints, that.serviceEndpoints)) {
            return false;
        }
        if (!Objects.equals(this.subnets, that.subnets)) {
            return false;
        }
        if (!Objects.equals(this.userTags, that.userTags)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.amiID, this.defaultMachinePlatform, this.experimentalPropagateUserTags, this.hostedZone, this.lbType, this.propagateUserTags, this.region, this.serviceEndpoints, this.subnets, this.userTags, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.amiID != null) {
            sb.append("amiID:");
            sb.append(this.amiID + ",");
        }
        if (this.defaultMachinePlatform != null) {
            sb.append("defaultMachinePlatform:");
            sb.append(this.defaultMachinePlatform + ",");
        }
        if (this.experimentalPropagateUserTags != null) {
            sb.append("experimentalPropagateUserTags:");
            sb.append(this.experimentalPropagateUserTags + ",");
        }
        if (this.hostedZone != null) {
            sb.append("hostedZone:");
            sb.append(this.hostedZone + ",");
        }
        if (this.lbType != null) {
            sb.append("lbType:");
            sb.append(this.lbType + ",");
        }
        if (this.propagateUserTags != null) {
            sb.append("propagateUserTags:");
            sb.append(this.propagateUserTags + ",");
        }
        if (this.region != null) {
            sb.append("region:");
            sb.append(this.region + ",");
        }
        if (this.serviceEndpoints != null && !this.serviceEndpoints.isEmpty()) {
            sb.append("serviceEndpoints:");
            sb.append(this.serviceEndpoints + ",");
        }
        if (this.subnets != null && !this.subnets.isEmpty()) {
            sb.append("subnets:");
            sb.append(this.subnets + ",");
        }
        if (this.userTags != null && !this.userTags.isEmpty()) {
            sb.append("userTags:");
            sb.append(this.userTags + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withExperimentalPropagateUserTags() {
        return this.withExperimentalPropagateUserTags(true);
    }

    public A withPropagateUserTags() {
        return this.withPropagateUserTags(true);
    }

    public class ServiceEndpointsNested<N>
    extends ServiceEndpointFluent<ServiceEndpointsNested<N>>
    implements Nested<N> {
        ServiceEndpointBuilder builder;
        int index;

        ServiceEndpointsNested(int index, ServiceEndpoint item) {
            this.index = index;
            this.builder = new ServiceEndpointBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PlatformFluent.this.setToServiceEndpoints(this.index, this.builder.build());
        }

        public N endServiceEndpoint() {
            return this.and();
        }
    }

    public class DefaultMachinePlatformNested<N>
    extends MachinePoolFluent<DefaultMachinePlatformNested<N>>
    implements Nested<N> {
        MachinePoolBuilder builder;

        DefaultMachinePlatformNested(MachinePool item) {
            this.builder = new MachinePoolBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PlatformFluent.this.withDefaultMachinePlatform(this.builder.build());
        }

        public N endDefaultMachinePlatform() {
            return this.and();
        }
    }
}

