/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_8.hive.v1;

import io.fabric8.kubernetes.api.builder.v6_8.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_8.Nested;
import io.fabric8.kubernetes.api.model.v6_8.LocalObjectReference;
import io.fabric8.kubernetes.api.model.v6_8.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.v6_8.LocalObjectReferenceFluent;
import io.fabric8.openshift.api.model.v6_8.hive.v1.ClusterProvisionCondition;
import io.fabric8.openshift.api.model.v6_8.hive.v1.ClusterProvisionConditionBuilder;
import io.fabric8.openshift.api.model.v6_8.hive.v1.ClusterProvisionConditionFluent;
import io.fabric8.openshift.api.model.v6_8.hive.v1.ClusterProvisionStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class ClusterProvisionStatusFluent<A extends ClusterProvisionStatusFluent<A>>
extends BaseFluent<A> {
    private ArrayList<ClusterProvisionConditionBuilder> conditions = new ArrayList();
    private LocalObjectReferenceBuilder jobRef;
    private Map<String, Object> additionalProperties;

    public ClusterProvisionStatusFluent() {
    }

    public ClusterProvisionStatusFluent(ClusterProvisionStatus instance) {
        ClusterProvisionStatus clusterProvisionStatus = instance = instance != null ? instance : new ClusterProvisionStatus();
        if (instance != null) {
            this.withConditions(instance.getConditions());
            this.withJobRef(instance.getJobRef());
            this.withConditions(instance.getConditions());
            this.withJobRef(instance.getJobRef());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToConditions(int index, ClusterProvisionCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        ClusterProvisionConditionBuilder builder = new ClusterProvisionConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get("conditions").add(index, builder);
            this.conditions.add(index, builder);
        }
        return (A)this;
    }

    public A setToConditions(int index, ClusterProvisionCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        ClusterProvisionConditionBuilder builder = new ClusterProvisionConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get("conditions").set(index, builder);
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    public A addToConditions(ClusterProvisionCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (ClusterProvisionCondition item : items) {
            ClusterProvisionConditionBuilder builder = new ClusterProvisionConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    public A addAllToConditions(Collection<ClusterProvisionCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (ClusterProvisionCondition item : items) {
            ClusterProvisionConditionBuilder builder = new ClusterProvisionConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    public A removeFromConditions(ClusterProvisionCondition ... items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (ClusterProvisionCondition item : items) {
            ClusterProvisionConditionBuilder builder = new ClusterProvisionConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromConditions(Collection<ClusterProvisionCondition> items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (ClusterProvisionCondition item : items) {
            ClusterProvisionConditionBuilder builder = new ClusterProvisionConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromConditions(Predicate<ClusterProvisionConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)this;
        }
        Iterator<ClusterProvisionConditionBuilder> each = this.conditions.iterator();
        Object visitables = this._visitables.get("conditions");
        while (each.hasNext()) {
            ClusterProvisionConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<ClusterProvisionCondition> buildConditions() {
        return this.conditions != null ? ClusterProvisionStatusFluent.build(this.conditions) : null;
    }

    public ClusterProvisionCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public ClusterProvisionCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public ClusterProvisionCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    public ClusterProvisionCondition buildMatchingCondition(Predicate<ClusterProvisionConditionBuilder> predicate) {
        for (ClusterProvisionConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingCondition(Predicate<ClusterProvisionConditionBuilder> predicate) {
        for (ClusterProvisionConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConditions(List<ClusterProvisionCondition> conditions) {
        if (this.conditions != null) {
            this._visitables.get("conditions").clear();
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (ClusterProvisionCondition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    public A withConditions(ClusterProvisionCondition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove("conditions");
        }
        if (conditions != null) {
            for (ClusterProvisionCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public ConditionsNested<A> addNewCondition() {
        return new ConditionsNested(-1, null);
    }

    public ConditionsNested<A> addNewConditionLike(ClusterProvisionCondition item) {
        return new ConditionsNested(-1, item);
    }

    public ConditionsNested<A> setNewConditionLike(int index, ClusterProvisionCondition item) {
        return new ConditionsNested(index, item);
    }

    public ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    public ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editMatchingCondition(Predicate<ClusterProvisionConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public LocalObjectReference buildJobRef() {
        return this.jobRef != null ? this.jobRef.build() : null;
    }

    public A withJobRef(LocalObjectReference jobRef) {
        this._visitables.get("jobRef").remove(this.jobRef);
        if (jobRef != null) {
            this.jobRef = new LocalObjectReferenceBuilder(jobRef);
            this._visitables.get("jobRef").add(this.jobRef);
        } else {
            this.jobRef = null;
            this._visitables.get("jobRef").remove(this.jobRef);
        }
        return (A)this;
    }

    public boolean hasJobRef() {
        return this.jobRef != null;
    }

    public A withNewJobRef(String name) {
        return this.withJobRef(new LocalObjectReference(name));
    }

    public JobRefNested<A> withNewJobRef() {
        return new JobRefNested(null);
    }

    public JobRefNested<A> withNewJobRefLike(LocalObjectReference item) {
        return new JobRefNested(item);
    }

    public JobRefNested<A> editJobRef() {
        return this.withNewJobRefLike(Optional.ofNullable(this.buildJobRef()).orElse(null));
    }

    public JobRefNested<A> editOrNewJobRef() {
        return this.withNewJobRefLike(Optional.ofNullable(this.buildJobRef()).orElse(new LocalObjectReferenceBuilder().build()));
    }

    public JobRefNested<A> editOrNewJobRefLike(LocalObjectReference item) {
        return this.withNewJobRefLike(Optional.ofNullable(this.buildJobRef()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClusterProvisionStatusFluent that = (ClusterProvisionStatusFluent)o;
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.jobRef, that.jobRef)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.conditions, this.jobRef, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions + ",");
        }
        if (this.jobRef != null) {
            sb.append("jobRef:");
            sb.append(this.jobRef + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class JobRefNested<N>
    extends LocalObjectReferenceFluent<JobRefNested<N>>
    implements Nested<N> {
        LocalObjectReferenceBuilder builder;

        JobRefNested(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ClusterProvisionStatusFluent.this.withJobRef(this.builder.build());
        }

        public N endJobRef() {
            return this.and();
        }
    }

    public class ConditionsNested<N>
    extends ClusterProvisionConditionFluent<ConditionsNested<N>>
    implements Nested<N> {
        ClusterProvisionConditionBuilder builder;
        int index;

        ConditionsNested(int index, ClusterProvisionCondition item) {
            this.index = index;
            this.builder = new ClusterProvisionConditionBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ClusterProvisionStatusFluent.this.setToConditions(this.index, this.builder.build());
        }

        public N endCondition() {
            return this.and();
        }
    }
}

