/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_8.config.v1;

import io.fabric8.kubernetes.api.builder.v6_8.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_8.Nested;
import io.fabric8.openshift.api.model.v6_8.config.v1.ConfigMapNameReference;
import io.fabric8.openshift.api.model.v6_8.config.v1.ConfigMapNameReferenceBuilder;
import io.fabric8.openshift.api.model.v6_8.config.v1.ConfigMapNameReferenceFluent;
import io.fabric8.openshift.api.model.v6_8.config.v1.OpenIDClaims;
import io.fabric8.openshift.api.model.v6_8.config.v1.OpenIDClaimsBuilder;
import io.fabric8.openshift.api.model.v6_8.config.v1.OpenIDClaimsFluent;
import io.fabric8.openshift.api.model.v6_8.config.v1.OpenIDIdentityProvider;
import io.fabric8.openshift.api.model.v6_8.config.v1.SecretNameReference;
import io.fabric8.openshift.api.model.v6_8.config.v1.SecretNameReferenceBuilder;
import io.fabric8.openshift.api.model.v6_8.config.v1.SecretNameReferenceFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class OpenIDIdentityProviderFluent<A extends OpenIDIdentityProviderFluent<A>>
extends BaseFluent<A> {
    private ConfigMapNameReferenceBuilder ca;
    private OpenIDClaimsBuilder claims;
    private String clientID;
    private SecretNameReferenceBuilder clientSecret;
    private Map<String, String> extraAuthorizeParameters;
    private List<String> extraScopes = new ArrayList<String>();
    private String issuer;
    private Map<String, Object> additionalProperties;

    public OpenIDIdentityProviderFluent() {
    }

    public OpenIDIdentityProviderFluent(OpenIDIdentityProvider instance) {
        OpenIDIdentityProvider openIDIdentityProvider = instance = instance != null ? instance : new OpenIDIdentityProvider();
        if (instance != null) {
            this.withCa(instance.getCa());
            this.withClaims(instance.getClaims());
            this.withClientID(instance.getClientID());
            this.withClientSecret(instance.getClientSecret());
            this.withExtraAuthorizeParameters(instance.getExtraAuthorizeParameters());
            this.withExtraScopes(instance.getExtraScopes());
            this.withIssuer(instance.getIssuer());
            this.withCa(instance.getCa());
            this.withClaims(instance.getClaims());
            this.withClientID(instance.getClientID());
            this.withClientSecret(instance.getClientSecret());
            this.withExtraAuthorizeParameters(instance.getExtraAuthorizeParameters());
            this.withExtraScopes(instance.getExtraScopes());
            this.withIssuer(instance.getIssuer());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ConfigMapNameReference buildCa() {
        return this.ca != null ? this.ca.build() : null;
    }

    public A withCa(ConfigMapNameReference ca) {
        this._visitables.get("ca").remove(this.ca);
        if (ca != null) {
            this.ca = new ConfigMapNameReferenceBuilder(ca);
            this._visitables.get("ca").add(this.ca);
        } else {
            this.ca = null;
            this._visitables.get("ca").remove(this.ca);
        }
        return (A)this;
    }

    public boolean hasCa() {
        return this.ca != null;
    }

    public A withNewCa(String name) {
        return this.withCa(new ConfigMapNameReference(name));
    }

    public CaNested<A> withNewCa() {
        return new CaNested(null);
    }

    public CaNested<A> withNewCaLike(ConfigMapNameReference item) {
        return new CaNested(item);
    }

    public CaNested<A> editCa() {
        return this.withNewCaLike(Optional.ofNullable(this.buildCa()).orElse(null));
    }

    public CaNested<A> editOrNewCa() {
        return this.withNewCaLike(Optional.ofNullable(this.buildCa()).orElse(new ConfigMapNameReferenceBuilder().build()));
    }

    public CaNested<A> editOrNewCaLike(ConfigMapNameReference item) {
        return this.withNewCaLike(Optional.ofNullable(this.buildCa()).orElse(item));
    }

    public OpenIDClaims buildClaims() {
        return this.claims != null ? this.claims.build() : null;
    }

    public A withClaims(OpenIDClaims claims) {
        this._visitables.get("claims").remove(this.claims);
        if (claims != null) {
            this.claims = new OpenIDClaimsBuilder(claims);
            this._visitables.get("claims").add(this.claims);
        } else {
            this.claims = null;
            this._visitables.get("claims").remove(this.claims);
        }
        return (A)this;
    }

    public boolean hasClaims() {
        return this.claims != null;
    }

    public ClaimsNested<A> withNewClaims() {
        return new ClaimsNested(null);
    }

    public ClaimsNested<A> withNewClaimsLike(OpenIDClaims item) {
        return new ClaimsNested(item);
    }

    public ClaimsNested<A> editClaims() {
        return this.withNewClaimsLike(Optional.ofNullable(this.buildClaims()).orElse(null));
    }

    public ClaimsNested<A> editOrNewClaims() {
        return this.withNewClaimsLike(Optional.ofNullable(this.buildClaims()).orElse(new OpenIDClaimsBuilder().build()));
    }

    public ClaimsNested<A> editOrNewClaimsLike(OpenIDClaims item) {
        return this.withNewClaimsLike(Optional.ofNullable(this.buildClaims()).orElse(item));
    }

    public String getClientID() {
        return this.clientID;
    }

    public A withClientID(String clientID) {
        this.clientID = clientID;
        return (A)this;
    }

    public boolean hasClientID() {
        return this.clientID != null;
    }

    public SecretNameReference buildClientSecret() {
        return this.clientSecret != null ? this.clientSecret.build() : null;
    }

    public A withClientSecret(SecretNameReference clientSecret) {
        this._visitables.get("clientSecret").remove(this.clientSecret);
        if (clientSecret != null) {
            this.clientSecret = new SecretNameReferenceBuilder(clientSecret);
            this._visitables.get("clientSecret").add(this.clientSecret);
        } else {
            this.clientSecret = null;
            this._visitables.get("clientSecret").remove(this.clientSecret);
        }
        return (A)this;
    }

    public boolean hasClientSecret() {
        return this.clientSecret != null;
    }

    public A withNewClientSecret(String name) {
        return this.withClientSecret(new SecretNameReference(name));
    }

    public ClientSecretNested<A> withNewClientSecret() {
        return new ClientSecretNested(null);
    }

    public ClientSecretNested<A> withNewClientSecretLike(SecretNameReference item) {
        return new ClientSecretNested(item);
    }

    public ClientSecretNested<A> editClientSecret() {
        return this.withNewClientSecretLike(Optional.ofNullable(this.buildClientSecret()).orElse(null));
    }

    public ClientSecretNested<A> editOrNewClientSecret() {
        return this.withNewClientSecretLike(Optional.ofNullable(this.buildClientSecret()).orElse(new SecretNameReferenceBuilder().build()));
    }

    public ClientSecretNested<A> editOrNewClientSecretLike(SecretNameReference item) {
        return this.withNewClientSecretLike(Optional.ofNullable(this.buildClientSecret()).orElse(item));
    }

    public A addToExtraAuthorizeParameters(String key, String value) {
        if (this.extraAuthorizeParameters == null && key != null && value != null) {
            this.extraAuthorizeParameters = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.extraAuthorizeParameters.put(key, value);
        }
        return (A)this;
    }

    public A addToExtraAuthorizeParameters(Map<String, String> map) {
        if (this.extraAuthorizeParameters == null && map != null) {
            this.extraAuthorizeParameters = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.extraAuthorizeParameters.putAll(map);
        }
        return (A)this;
    }

    public A removeFromExtraAuthorizeParameters(String key) {
        if (this.extraAuthorizeParameters == null) {
            return (A)this;
        }
        if (key != null && this.extraAuthorizeParameters != null) {
            this.extraAuthorizeParameters.remove(key);
        }
        return (A)this;
    }

    public A removeFromExtraAuthorizeParameters(Map<String, String> map) {
        if (this.extraAuthorizeParameters == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.extraAuthorizeParameters == null) continue;
                this.extraAuthorizeParameters.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, String> getExtraAuthorizeParameters() {
        return this.extraAuthorizeParameters;
    }

    public <K, V> A withExtraAuthorizeParameters(Map<String, String> extraAuthorizeParameters) {
        this.extraAuthorizeParameters = extraAuthorizeParameters == null ? null : new LinkedHashMap<String, String>(extraAuthorizeParameters);
        return (A)this;
    }

    public boolean hasExtraAuthorizeParameters() {
        return this.extraAuthorizeParameters != null;
    }

    public A addToExtraScopes(int index, String item) {
        if (this.extraScopes == null) {
            this.extraScopes = new ArrayList<String>();
        }
        this.extraScopes.add(index, item);
        return (A)this;
    }

    public A setToExtraScopes(int index, String item) {
        if (this.extraScopes == null) {
            this.extraScopes = new ArrayList<String>();
        }
        this.extraScopes.set(index, item);
        return (A)this;
    }

    public A addToExtraScopes(String ... items) {
        if (this.extraScopes == null) {
            this.extraScopes = new ArrayList<String>();
        }
        for (String item : items) {
            this.extraScopes.add(item);
        }
        return (A)this;
    }

    public A addAllToExtraScopes(Collection<String> items) {
        if (this.extraScopes == null) {
            this.extraScopes = new ArrayList<String>();
        }
        for (String item : items) {
            this.extraScopes.add(item);
        }
        return (A)this;
    }

    public A removeFromExtraScopes(String ... items) {
        if (this.extraScopes == null) {
            return (A)this;
        }
        for (String item : items) {
            this.extraScopes.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromExtraScopes(Collection<String> items) {
        if (this.extraScopes == null) {
            return (A)this;
        }
        for (String item : items) {
            this.extraScopes.remove(item);
        }
        return (A)this;
    }

    public List<String> getExtraScopes() {
        return this.extraScopes;
    }

    public String getExtraScope(int index) {
        return this.extraScopes.get(index);
    }

    public String getFirstExtraScope() {
        return this.extraScopes.get(0);
    }

    public String getLastExtraScope() {
        return this.extraScopes.get(this.extraScopes.size() - 1);
    }

    public String getMatchingExtraScope(Predicate<String> predicate) {
        for (String item : this.extraScopes) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingExtraScope(Predicate<String> predicate) {
        for (String item : this.extraScopes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withExtraScopes(List<String> extraScopes) {
        if (extraScopes != null) {
            this.extraScopes = new ArrayList<String>();
            for (String item : extraScopes) {
                this.addToExtraScopes(item);
            }
        } else {
            this.extraScopes = null;
        }
        return (A)this;
    }

    public A withExtraScopes(String ... extraScopes) {
        if (this.extraScopes != null) {
            this.extraScopes.clear();
            this._visitables.remove("extraScopes");
        }
        if (extraScopes != null) {
            for (String item : extraScopes) {
                this.addToExtraScopes(item);
            }
        }
        return (A)this;
    }

    public boolean hasExtraScopes() {
        return this.extraScopes != null && !this.extraScopes.isEmpty();
    }

    public String getIssuer() {
        return this.issuer;
    }

    public A withIssuer(String issuer) {
        this.issuer = issuer;
        return (A)this;
    }

    public boolean hasIssuer() {
        return this.issuer != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OpenIDIdentityProviderFluent that = (OpenIDIdentityProviderFluent)o;
        if (!Objects.equals(this.ca, that.ca)) {
            return false;
        }
        if (!Objects.equals(this.claims, that.claims)) {
            return false;
        }
        if (!Objects.equals(this.clientID, that.clientID)) {
            return false;
        }
        if (!Objects.equals(this.clientSecret, that.clientSecret)) {
            return false;
        }
        if (!Objects.equals(this.extraAuthorizeParameters, that.extraAuthorizeParameters)) {
            return false;
        }
        if (!Objects.equals(this.extraScopes, that.extraScopes)) {
            return false;
        }
        if (!Objects.equals(this.issuer, that.issuer)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.ca, this.claims, this.clientID, this.clientSecret, this.extraAuthorizeParameters, this.extraScopes, this.issuer, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.ca != null) {
            sb.append("ca:");
            sb.append(this.ca + ",");
        }
        if (this.claims != null) {
            sb.append("claims:");
            sb.append(this.claims + ",");
        }
        if (this.clientID != null) {
            sb.append("clientID:");
            sb.append(this.clientID + ",");
        }
        if (this.clientSecret != null) {
            sb.append("clientSecret:");
            sb.append(this.clientSecret + ",");
        }
        if (this.extraAuthorizeParameters != null && !this.extraAuthorizeParameters.isEmpty()) {
            sb.append("extraAuthorizeParameters:");
            sb.append(this.extraAuthorizeParameters + ",");
        }
        if (this.extraScopes != null && !this.extraScopes.isEmpty()) {
            sb.append("extraScopes:");
            sb.append(this.extraScopes + ",");
        }
        if (this.issuer != null) {
            sb.append("issuer:");
            sb.append(this.issuer + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ClientSecretNested<N>
    extends SecretNameReferenceFluent<ClientSecretNested<N>>
    implements Nested<N> {
        SecretNameReferenceBuilder builder;

        ClientSecretNested(SecretNameReference item) {
            this.builder = new SecretNameReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)OpenIDIdentityProviderFluent.this.withClientSecret(this.builder.build());
        }

        public N endClientSecret() {
            return this.and();
        }
    }

    public class ClaimsNested<N>
    extends OpenIDClaimsFluent<ClaimsNested<N>>
    implements Nested<N> {
        OpenIDClaimsBuilder builder;

        ClaimsNested(OpenIDClaims item) {
            this.builder = new OpenIDClaimsBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)OpenIDIdentityProviderFluent.this.withClaims(this.builder.build());
        }

        public N endClaims() {
            return this.and();
        }
    }

    public class CaNested<N>
    extends ConfigMapNameReferenceFluent<CaNested<N>>
    implements Nested<N> {
        ConfigMapNameReferenceBuilder builder;

        CaNested(ConfigMapNameReference item) {
            this.builder = new ConfigMapNameReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)OpenIDIdentityProviderFluent.this.withCa(this.builder.build());
        }

        public N endCa() {
            return this.and();
        }
    }
}

