/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_8.config.v1;

import io.fabric8.kubernetes.api.builder.v6_8.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_8.Nested;
import io.fabric8.kubernetes.api.model.v6_8.EnvVar;
import io.fabric8.kubernetes.api.model.v6_8.ResourceRequirements;
import io.fabric8.kubernetes.api.model.v6_8.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.model.v6_8.ResourceRequirementsFluent;
import io.fabric8.openshift.api.model.v6_8.config.v1.BuildDefaults;
import io.fabric8.openshift.api.model.v6_8.config.v1.ImageLabel;
import io.fabric8.openshift.api.model.v6_8.config.v1.ImageLabelBuilder;
import io.fabric8.openshift.api.model.v6_8.config.v1.ImageLabelFluent;
import io.fabric8.openshift.api.model.v6_8.config.v1.ProxySpec;
import io.fabric8.openshift.api.model.v6_8.config.v1.ProxySpecBuilder;
import io.fabric8.openshift.api.model.v6_8.config.v1.ProxySpecFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class BuildDefaultsFluent<A extends BuildDefaultsFluent<A>>
extends BaseFluent<A> {
    private ProxySpecBuilder defaultProxy;
    private List<EnvVar> env = new ArrayList<EnvVar>();
    private ProxySpecBuilder gitProxy;
    private ArrayList<ImageLabelBuilder> imageLabels = new ArrayList();
    private ResourceRequirementsBuilder resources;
    private Map<String, Object> additionalProperties;

    public BuildDefaultsFluent() {
    }

    public BuildDefaultsFluent(BuildDefaults instance) {
        BuildDefaults buildDefaults = instance = instance != null ? instance : new BuildDefaults();
        if (instance != null) {
            this.withDefaultProxy(instance.getDefaultProxy());
            this.withEnv(instance.getEnv());
            this.withGitProxy(instance.getGitProxy());
            this.withImageLabels(instance.getImageLabels());
            this.withResources(instance.getResources());
            this.withDefaultProxy(instance.getDefaultProxy());
            this.withEnv(instance.getEnv());
            this.withGitProxy(instance.getGitProxy());
            this.withImageLabels(instance.getImageLabels());
            this.withResources(instance.getResources());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ProxySpec buildDefaultProxy() {
        return this.defaultProxy != null ? this.defaultProxy.build() : null;
    }

    public A withDefaultProxy(ProxySpec defaultProxy) {
        this._visitables.get("defaultProxy").remove(this.defaultProxy);
        if (defaultProxy != null) {
            this.defaultProxy = new ProxySpecBuilder(defaultProxy);
            this._visitables.get("defaultProxy").add(this.defaultProxy);
        } else {
            this.defaultProxy = null;
            this._visitables.get("defaultProxy").remove(this.defaultProxy);
        }
        return (A)this;
    }

    public boolean hasDefaultProxy() {
        return this.defaultProxy != null;
    }

    public DefaultProxyNested<A> withNewDefaultProxy() {
        return new DefaultProxyNested(null);
    }

    public DefaultProxyNested<A> withNewDefaultProxyLike(ProxySpec item) {
        return new DefaultProxyNested(item);
    }

    public DefaultProxyNested<A> editDefaultProxy() {
        return this.withNewDefaultProxyLike(Optional.ofNullable(this.buildDefaultProxy()).orElse(null));
    }

    public DefaultProxyNested<A> editOrNewDefaultProxy() {
        return this.withNewDefaultProxyLike(Optional.ofNullable(this.buildDefaultProxy()).orElse(new ProxySpecBuilder().build()));
    }

    public DefaultProxyNested<A> editOrNewDefaultProxyLike(ProxySpec item) {
        return this.withNewDefaultProxyLike(Optional.ofNullable(this.buildDefaultProxy()).orElse(item));
    }

    public A addToEnv(int index, EnvVar item) {
        if (this.env == null) {
            this.env = new ArrayList<EnvVar>();
        }
        this.env.add(index, item);
        return (A)this;
    }

    public A setToEnv(int index, EnvVar item) {
        if (this.env == null) {
            this.env = new ArrayList<EnvVar>();
        }
        this.env.set(index, item);
        return (A)this;
    }

    public A addToEnv(EnvVar ... items) {
        if (this.env == null) {
            this.env = new ArrayList<EnvVar>();
        }
        for (EnvVar item : items) {
            this.env.add(item);
        }
        return (A)this;
    }

    public A addAllToEnv(Collection<EnvVar> items) {
        if (this.env == null) {
            this.env = new ArrayList<EnvVar>();
        }
        for (EnvVar item : items) {
            this.env.add(item);
        }
        return (A)this;
    }

    public A removeFromEnv(EnvVar ... items) {
        if (this.env == null) {
            return (A)this;
        }
        for (EnvVar item : items) {
            this.env.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromEnv(Collection<EnvVar> items) {
        if (this.env == null) {
            return (A)this;
        }
        for (EnvVar item : items) {
            this.env.remove(item);
        }
        return (A)this;
    }

    public List<EnvVar> getEnv() {
        return this.env;
    }

    public EnvVar getEnv(int index) {
        return this.env.get(index);
    }

    public EnvVar getFirstEnv() {
        return this.env.get(0);
    }

    public EnvVar getLastEnv() {
        return this.env.get(this.env.size() - 1);
    }

    public EnvVar getMatchingEnv(Predicate<EnvVar> predicate) {
        for (EnvVar item : this.env) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingEnv(Predicate<EnvVar> predicate) {
        for (EnvVar item : this.env) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withEnv(List<EnvVar> env) {
        if (env != null) {
            this.env = new ArrayList<EnvVar>();
            for (EnvVar item : env) {
                this.addToEnv(item);
            }
        } else {
            this.env = null;
        }
        return (A)this;
    }

    public A withEnv(EnvVar ... env) {
        if (this.env != null) {
            this.env.clear();
            this._visitables.remove("env");
        }
        if (env != null) {
            for (EnvVar item : env) {
                this.addToEnv(item);
            }
        }
        return (A)this;
    }

    public boolean hasEnv() {
        return this.env != null && !this.env.isEmpty();
    }

    public ProxySpec buildGitProxy() {
        return this.gitProxy != null ? this.gitProxy.build() : null;
    }

    public A withGitProxy(ProxySpec gitProxy) {
        this._visitables.get("gitProxy").remove(this.gitProxy);
        if (gitProxy != null) {
            this.gitProxy = new ProxySpecBuilder(gitProxy);
            this._visitables.get("gitProxy").add(this.gitProxy);
        } else {
            this.gitProxy = null;
            this._visitables.get("gitProxy").remove(this.gitProxy);
        }
        return (A)this;
    }

    public boolean hasGitProxy() {
        return this.gitProxy != null;
    }

    public GitProxyNested<A> withNewGitProxy() {
        return new GitProxyNested(null);
    }

    public GitProxyNested<A> withNewGitProxyLike(ProxySpec item) {
        return new GitProxyNested(item);
    }

    public GitProxyNested<A> editGitProxy() {
        return this.withNewGitProxyLike(Optional.ofNullable(this.buildGitProxy()).orElse(null));
    }

    public GitProxyNested<A> editOrNewGitProxy() {
        return this.withNewGitProxyLike(Optional.ofNullable(this.buildGitProxy()).orElse(new ProxySpecBuilder().build()));
    }

    public GitProxyNested<A> editOrNewGitProxyLike(ProxySpec item) {
        return this.withNewGitProxyLike(Optional.ofNullable(this.buildGitProxy()).orElse(item));
    }

    public A addToImageLabels(int index, ImageLabel item) {
        if (this.imageLabels == null) {
            this.imageLabels = new ArrayList();
        }
        ImageLabelBuilder builder = new ImageLabelBuilder(item);
        if (index < 0 || index >= this.imageLabels.size()) {
            this._visitables.get("imageLabels").add(builder);
            this.imageLabels.add(builder);
        } else {
            this._visitables.get("imageLabels").add(index, builder);
            this.imageLabels.add(index, builder);
        }
        return (A)this;
    }

    public A setToImageLabels(int index, ImageLabel item) {
        if (this.imageLabels == null) {
            this.imageLabels = new ArrayList();
        }
        ImageLabelBuilder builder = new ImageLabelBuilder(item);
        if (index < 0 || index >= this.imageLabels.size()) {
            this._visitables.get("imageLabels").add(builder);
            this.imageLabels.add(builder);
        } else {
            this._visitables.get("imageLabels").set(index, builder);
            this.imageLabels.set(index, builder);
        }
        return (A)this;
    }

    public A addToImageLabels(ImageLabel ... items) {
        if (this.imageLabels == null) {
            this.imageLabels = new ArrayList();
        }
        for (ImageLabel item : items) {
            ImageLabelBuilder builder = new ImageLabelBuilder(item);
            this._visitables.get("imageLabels").add(builder);
            this.imageLabels.add(builder);
        }
        return (A)this;
    }

    public A addAllToImageLabels(Collection<ImageLabel> items) {
        if (this.imageLabels == null) {
            this.imageLabels = new ArrayList();
        }
        for (ImageLabel item : items) {
            ImageLabelBuilder builder = new ImageLabelBuilder(item);
            this._visitables.get("imageLabels").add(builder);
            this.imageLabels.add(builder);
        }
        return (A)this;
    }

    public A removeFromImageLabels(ImageLabel ... items) {
        if (this.imageLabels == null) {
            return (A)this;
        }
        for (ImageLabel item : items) {
            ImageLabelBuilder builder = new ImageLabelBuilder(item);
            this._visitables.get("imageLabels").remove(builder);
            this.imageLabels.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromImageLabels(Collection<ImageLabel> items) {
        if (this.imageLabels == null) {
            return (A)this;
        }
        for (ImageLabel item : items) {
            ImageLabelBuilder builder = new ImageLabelBuilder(item);
            this._visitables.get("imageLabels").remove(builder);
            this.imageLabels.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromImageLabels(Predicate<ImageLabelBuilder> predicate) {
        if (this.imageLabels == null) {
            return (A)this;
        }
        Iterator<ImageLabelBuilder> each = this.imageLabels.iterator();
        Object visitables = this._visitables.get("imageLabels");
        while (each.hasNext()) {
            ImageLabelBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<ImageLabel> buildImageLabels() {
        return this.imageLabels != null ? BuildDefaultsFluent.build(this.imageLabels) : null;
    }

    public ImageLabel buildImageLabel(int index) {
        return this.imageLabels.get(index).build();
    }

    public ImageLabel buildFirstImageLabel() {
        return this.imageLabels.get(0).build();
    }

    public ImageLabel buildLastImageLabel() {
        return this.imageLabels.get(this.imageLabels.size() - 1).build();
    }

    public ImageLabel buildMatchingImageLabel(Predicate<ImageLabelBuilder> predicate) {
        for (ImageLabelBuilder item : this.imageLabels) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingImageLabel(Predicate<ImageLabelBuilder> predicate) {
        for (ImageLabelBuilder item : this.imageLabels) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withImageLabels(List<ImageLabel> imageLabels) {
        if (this.imageLabels != null) {
            this._visitables.get("imageLabels").clear();
        }
        if (imageLabels != null) {
            this.imageLabels = new ArrayList();
            for (ImageLabel item : imageLabels) {
                this.addToImageLabels(item);
            }
        } else {
            this.imageLabels = null;
        }
        return (A)this;
    }

    public A withImageLabels(ImageLabel ... imageLabels) {
        if (this.imageLabels != null) {
            this.imageLabels.clear();
            this._visitables.remove("imageLabels");
        }
        if (imageLabels != null) {
            for (ImageLabel item : imageLabels) {
                this.addToImageLabels(item);
            }
        }
        return (A)this;
    }

    public boolean hasImageLabels() {
        return this.imageLabels != null && !this.imageLabels.isEmpty();
    }

    public A addNewImageLabel(String name, String value) {
        return this.addToImageLabels(new ImageLabel(name, value));
    }

    public ImageLabelsNested<A> addNewImageLabel() {
        return new ImageLabelsNested(-1, null);
    }

    public ImageLabelsNested<A> addNewImageLabelLike(ImageLabel item) {
        return new ImageLabelsNested(-1, item);
    }

    public ImageLabelsNested<A> setNewImageLabelLike(int index, ImageLabel item) {
        return new ImageLabelsNested(index, item);
    }

    public ImageLabelsNested<A> editImageLabel(int index) {
        if (this.imageLabels.size() <= index) {
            throw new RuntimeException("Can't edit imageLabels. Index exceeds size.");
        }
        return this.setNewImageLabelLike(index, this.buildImageLabel(index));
    }

    public ImageLabelsNested<A> editFirstImageLabel() {
        if (this.imageLabels.size() == 0) {
            throw new RuntimeException("Can't edit first imageLabels. The list is empty.");
        }
        return this.setNewImageLabelLike(0, this.buildImageLabel(0));
    }

    public ImageLabelsNested<A> editLastImageLabel() {
        int index = this.imageLabels.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last imageLabels. The list is empty.");
        }
        return this.setNewImageLabelLike(index, this.buildImageLabel(index));
    }

    public ImageLabelsNested<A> editMatchingImageLabel(Predicate<ImageLabelBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.imageLabels.size(); ++i) {
            if (!predicate.test(this.imageLabels.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching imageLabels. No match found.");
        }
        return this.setNewImageLabelLike(index, this.buildImageLabel(index));
    }

    public ResourceRequirements buildResources() {
        return this.resources != null ? this.resources.build() : null;
    }

    public A withResources(ResourceRequirements resources) {
        this._visitables.get("resources").remove(this.resources);
        if (resources != null) {
            this.resources = new ResourceRequirementsBuilder(resources);
            this._visitables.get("resources").add(this.resources);
        } else {
            this.resources = null;
            this._visitables.get("resources").remove(this.resources);
        }
        return (A)this;
    }

    public boolean hasResources() {
        return this.resources != null;
    }

    public ResourcesNested<A> withNewResources() {
        return new ResourcesNested(null);
    }

    public ResourcesNested<A> withNewResourcesLike(ResourceRequirements item) {
        return new ResourcesNested(item);
    }

    public ResourcesNested<A> editResources() {
        return this.withNewResourcesLike(Optional.ofNullable(this.buildResources()).orElse(null));
    }

    public ResourcesNested<A> editOrNewResources() {
        return this.withNewResourcesLike(Optional.ofNullable(this.buildResources()).orElse(new ResourceRequirementsBuilder().build()));
    }

    public ResourcesNested<A> editOrNewResourcesLike(ResourceRequirements item) {
        return this.withNewResourcesLike(Optional.ofNullable(this.buildResources()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BuildDefaultsFluent that = (BuildDefaultsFluent)o;
        if (!Objects.equals(this.defaultProxy, that.defaultProxy)) {
            return false;
        }
        if (!Objects.equals(this.env, that.env)) {
            return false;
        }
        if (!Objects.equals(this.gitProxy, that.gitProxy)) {
            return false;
        }
        if (!Objects.equals(this.imageLabels, that.imageLabels)) {
            return false;
        }
        if (!Objects.equals(this.resources, that.resources)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.defaultProxy, this.env, this.gitProxy, this.imageLabels, this.resources, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.defaultProxy != null) {
            sb.append("defaultProxy:");
            sb.append(this.defaultProxy + ",");
        }
        if (this.env != null && !this.env.isEmpty()) {
            sb.append("env:");
            sb.append(this.env + ",");
        }
        if (this.gitProxy != null) {
            sb.append("gitProxy:");
            sb.append(this.gitProxy + ",");
        }
        if (this.imageLabels != null && !this.imageLabels.isEmpty()) {
            sb.append("imageLabels:");
            sb.append(this.imageLabels + ",");
        }
        if (this.resources != null) {
            sb.append("resources:");
            sb.append(this.resources + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ResourcesNested<N>
    extends ResourceRequirementsFluent<ResourcesNested<N>>
    implements Nested<N> {
        ResourceRequirementsBuilder builder;

        ResourcesNested(ResourceRequirements item) {
            this.builder = new ResourceRequirementsBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)BuildDefaultsFluent.this.withResources(this.builder.build());
        }

        public N endResources() {
            return this.and();
        }
    }

    public class ImageLabelsNested<N>
    extends ImageLabelFluent<ImageLabelsNested<N>>
    implements Nested<N> {
        ImageLabelBuilder builder;
        int index;

        ImageLabelsNested(int index, ImageLabel item) {
            this.index = index;
            this.builder = new ImageLabelBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)BuildDefaultsFluent.this.setToImageLabels(this.index, this.builder.build());
        }

        public N endImageLabel() {
            return this.and();
        }
    }

    public class GitProxyNested<N>
    extends ProxySpecFluent<GitProxyNested<N>>
    implements Nested<N> {
        ProxySpecBuilder builder;

        GitProxyNested(ProxySpec item) {
            this.builder = new ProxySpecBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)BuildDefaultsFluent.this.withGitProxy(this.builder.build());
        }

        public N endGitProxy() {
            return this.and();
        }
    }

    public class DefaultProxyNested<N>
    extends ProxySpecFluent<DefaultProxyNested<N>>
    implements Nested<N> {
        ProxySpecBuilder builder;

        DefaultProxyNested(ProxySpec item) {
            this.builder = new ProxySpecBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)BuildDefaultsFluent.this.withDefaultProxy(this.builder.build());
        }

        public N endDefaultProxy() {
            return this.and();
        }
    }
}

