/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_8;

import io.fabric8.kubernetes.api.builder.v6_8.VisitableBuilder;
import io.fabric8.openshift.api.model.v6_8.SecretSpec;
import io.fabric8.openshift.api.model.v6_8.SecretSpecFluent;

public class SecretSpecBuilder
extends SecretSpecFluent<SecretSpecBuilder>
implements VisitableBuilder<SecretSpec, SecretSpecBuilder> {
    SecretSpecFluent<?> fluent;
    Boolean validationEnabled;

    public SecretSpecBuilder() {
        this(false);
    }

    public SecretSpecBuilder(Boolean validationEnabled) {
        this(new SecretSpec(), validationEnabled);
    }

    public SecretSpecBuilder(SecretSpecFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public SecretSpecBuilder(SecretSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new SecretSpec(), validationEnabled);
    }

    public SecretSpecBuilder(SecretSpecFluent<?> fluent, SecretSpec instance) {
        this(fluent, instance, false);
    }

    public SecretSpecBuilder(SecretSpecFluent<?> fluent, SecretSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        SecretSpec secretSpec = instance = instance != null ? instance : new SecretSpec();
        if (instance != null) {
            fluent.withMountPath(instance.getMountPath());
            fluent.withSecretSource(instance.getSecretSource());
            fluent.withMountPath(instance.getMountPath());
            fluent.withSecretSource(instance.getSecretSource());
            fluent.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    public SecretSpecBuilder(SecretSpec instance) {
        this(instance, (Boolean)false);
    }

    public SecretSpecBuilder(SecretSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        SecretSpec secretSpec = instance = instance != null ? instance : new SecretSpec();
        if (instance != null) {
            this.withMountPath(instance.getMountPath());
            this.withSecretSource(instance.getSecretSource());
            this.withMountPath(instance.getMountPath());
            this.withSecretSource(instance.getSecretSource());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    @Override
    public SecretSpec build() {
        SecretSpec buildable = new SecretSpec(this.fluent.getMountPath(), this.fluent.buildSecretSource());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }
}

