/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_8;

import io.fabric8.kubernetes.api.builder.v6_8.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_8.Nested;
import io.fabric8.kubernetes.api.model.v6_8.LocalObjectReference;
import io.fabric8.kubernetes.api.model.v6_8.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.v6_8.LocalObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.v6_8.ObjectReference;
import io.fabric8.kubernetes.api.model.v6_8.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.v6_8.ObjectReferenceFluent;
import io.fabric8.openshift.api.model.v6_8.ImageImportSpec;
import io.fabric8.openshift.api.model.v6_8.TagImportPolicy;
import io.fabric8.openshift.api.model.v6_8.TagImportPolicyBuilder;
import io.fabric8.openshift.api.model.v6_8.TagImportPolicyFluent;
import io.fabric8.openshift.api.model.v6_8.TagReferencePolicy;
import io.fabric8.openshift.api.model.v6_8.TagReferencePolicyBuilder;
import io.fabric8.openshift.api.model.v6_8.TagReferencePolicyFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ImageImportSpecFluent<A extends ImageImportSpecFluent<A>>
extends BaseFluent<A> {
    private ObjectReferenceBuilder from;
    private TagImportPolicyBuilder importPolicy;
    private Boolean includeManifest;
    private TagReferencePolicyBuilder referencePolicy;
    private LocalObjectReferenceBuilder to;
    private Map<String, Object> additionalProperties;

    public ImageImportSpecFluent() {
    }

    public ImageImportSpecFluent(ImageImportSpec instance) {
        ImageImportSpec imageImportSpec = instance = instance != null ? instance : new ImageImportSpec();
        if (instance != null) {
            this.withFrom(instance.getFrom());
            this.withImportPolicy(instance.getImportPolicy());
            this.withIncludeManifest(instance.getIncludeManifest());
            this.withReferencePolicy(instance.getReferencePolicy());
            this.withTo(instance.getTo());
            this.withFrom(instance.getFrom());
            this.withImportPolicy(instance.getImportPolicy());
            this.withIncludeManifest(instance.getIncludeManifest());
            this.withReferencePolicy(instance.getReferencePolicy());
            this.withTo(instance.getTo());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ObjectReference buildFrom() {
        return this.from != null ? this.from.build() : null;
    }

    public A withFrom(ObjectReference from) {
        this._visitables.get("from").remove(this.from);
        if (from != null) {
            this.from = new ObjectReferenceBuilder(from);
            this._visitables.get("from").add(this.from);
        } else {
            this.from = null;
            this._visitables.get("from").remove(this.from);
        }
        return (A)this;
    }

    public boolean hasFrom() {
        return this.from != null;
    }

    public FromNested<A> withNewFrom() {
        return new FromNested(null);
    }

    public FromNested<A> withNewFromLike(ObjectReference item) {
        return new FromNested(item);
    }

    public FromNested<A> editFrom() {
        return this.withNewFromLike(Optional.ofNullable(this.buildFrom()).orElse(null));
    }

    public FromNested<A> editOrNewFrom() {
        return this.withNewFromLike(Optional.ofNullable(this.buildFrom()).orElse(new ObjectReferenceBuilder().build()));
    }

    public FromNested<A> editOrNewFromLike(ObjectReference item) {
        return this.withNewFromLike(Optional.ofNullable(this.buildFrom()).orElse(item));
    }

    public TagImportPolicy buildImportPolicy() {
        return this.importPolicy != null ? this.importPolicy.build() : null;
    }

    public A withImportPolicy(TagImportPolicy importPolicy) {
        this._visitables.get("importPolicy").remove(this.importPolicy);
        if (importPolicy != null) {
            this.importPolicy = new TagImportPolicyBuilder(importPolicy);
            this._visitables.get("importPolicy").add(this.importPolicy);
        } else {
            this.importPolicy = null;
            this._visitables.get("importPolicy").remove(this.importPolicy);
        }
        return (A)this;
    }

    public boolean hasImportPolicy() {
        return this.importPolicy != null;
    }

    public A withNewImportPolicy(String importMode, Boolean insecure, Boolean scheduled) {
        return this.withImportPolicy(new TagImportPolicy(importMode, insecure, scheduled));
    }

    public ImportPolicyNested<A> withNewImportPolicy() {
        return new ImportPolicyNested(null);
    }

    public ImportPolicyNested<A> withNewImportPolicyLike(TagImportPolicy item) {
        return new ImportPolicyNested(item);
    }

    public ImportPolicyNested<A> editImportPolicy() {
        return this.withNewImportPolicyLike(Optional.ofNullable(this.buildImportPolicy()).orElse(null));
    }

    public ImportPolicyNested<A> editOrNewImportPolicy() {
        return this.withNewImportPolicyLike(Optional.ofNullable(this.buildImportPolicy()).orElse(new TagImportPolicyBuilder().build()));
    }

    public ImportPolicyNested<A> editOrNewImportPolicyLike(TagImportPolicy item) {
        return this.withNewImportPolicyLike(Optional.ofNullable(this.buildImportPolicy()).orElse(item));
    }

    public Boolean getIncludeManifest() {
        return this.includeManifest;
    }

    public A withIncludeManifest(Boolean includeManifest) {
        this.includeManifest = includeManifest;
        return (A)this;
    }

    public boolean hasIncludeManifest() {
        return this.includeManifest != null;
    }

    public TagReferencePolicy buildReferencePolicy() {
        return this.referencePolicy != null ? this.referencePolicy.build() : null;
    }

    public A withReferencePolicy(TagReferencePolicy referencePolicy) {
        this._visitables.get("referencePolicy").remove(this.referencePolicy);
        if (referencePolicy != null) {
            this.referencePolicy = new TagReferencePolicyBuilder(referencePolicy);
            this._visitables.get("referencePolicy").add(this.referencePolicy);
        } else {
            this.referencePolicy = null;
            this._visitables.get("referencePolicy").remove(this.referencePolicy);
        }
        return (A)this;
    }

    public boolean hasReferencePolicy() {
        return this.referencePolicy != null;
    }

    public A withNewReferencePolicy(String type) {
        return this.withReferencePolicy(new TagReferencePolicy(type));
    }

    public ReferencePolicyNested<A> withNewReferencePolicy() {
        return new ReferencePolicyNested(null);
    }

    public ReferencePolicyNested<A> withNewReferencePolicyLike(TagReferencePolicy item) {
        return new ReferencePolicyNested(item);
    }

    public ReferencePolicyNested<A> editReferencePolicy() {
        return this.withNewReferencePolicyLike(Optional.ofNullable(this.buildReferencePolicy()).orElse(null));
    }

    public ReferencePolicyNested<A> editOrNewReferencePolicy() {
        return this.withNewReferencePolicyLike(Optional.ofNullable(this.buildReferencePolicy()).orElse(new TagReferencePolicyBuilder().build()));
    }

    public ReferencePolicyNested<A> editOrNewReferencePolicyLike(TagReferencePolicy item) {
        return this.withNewReferencePolicyLike(Optional.ofNullable(this.buildReferencePolicy()).orElse(item));
    }

    public LocalObjectReference buildTo() {
        return this.to != null ? this.to.build() : null;
    }

    public A withTo(LocalObjectReference to) {
        this._visitables.get("to").remove(this.to);
        if (to != null) {
            this.to = new LocalObjectReferenceBuilder(to);
            this._visitables.get("to").add(this.to);
        } else {
            this.to = null;
            this._visitables.get("to").remove(this.to);
        }
        return (A)this;
    }

    public boolean hasTo() {
        return this.to != null;
    }

    public A withNewTo(String name) {
        return this.withTo(new LocalObjectReference(name));
    }

    public ToNested<A> withNewTo() {
        return new ToNested(null);
    }

    public ToNested<A> withNewToLike(LocalObjectReference item) {
        return new ToNested(item);
    }

    public ToNested<A> editTo() {
        return this.withNewToLike(Optional.ofNullable(this.buildTo()).orElse(null));
    }

    public ToNested<A> editOrNewTo() {
        return this.withNewToLike(Optional.ofNullable(this.buildTo()).orElse(new LocalObjectReferenceBuilder().build()));
    }

    public ToNested<A> editOrNewToLike(LocalObjectReference item) {
        return this.withNewToLike(Optional.ofNullable(this.buildTo()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ImageImportSpecFluent that = (ImageImportSpecFluent)o;
        if (!Objects.equals(this.from, that.from)) {
            return false;
        }
        if (!Objects.equals(this.importPolicy, that.importPolicy)) {
            return false;
        }
        if (!Objects.equals(this.includeManifest, that.includeManifest)) {
            return false;
        }
        if (!Objects.equals(this.referencePolicy, that.referencePolicy)) {
            return false;
        }
        if (!Objects.equals(this.to, that.to)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.from, this.importPolicy, this.includeManifest, this.referencePolicy, this.to, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.from != null) {
            sb.append("from:");
            sb.append(this.from + ",");
        }
        if (this.importPolicy != null) {
            sb.append("importPolicy:");
            sb.append(this.importPolicy + ",");
        }
        if (this.includeManifest != null) {
            sb.append("includeManifest:");
            sb.append(this.includeManifest + ",");
        }
        if (this.referencePolicy != null) {
            sb.append("referencePolicy:");
            sb.append(this.referencePolicy + ",");
        }
        if (this.to != null) {
            sb.append("to:");
            sb.append(this.to + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withIncludeManifest() {
        return this.withIncludeManifest(true);
    }

    public class ToNested<N>
    extends LocalObjectReferenceFluent<ToNested<N>>
    implements Nested<N> {
        LocalObjectReferenceBuilder builder;

        ToNested(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ImageImportSpecFluent.this.withTo(this.builder.build());
        }

        public N endTo() {
            return this.and();
        }
    }

    public class ReferencePolicyNested<N>
    extends TagReferencePolicyFluent<ReferencePolicyNested<N>>
    implements Nested<N> {
        TagReferencePolicyBuilder builder;

        ReferencePolicyNested(TagReferencePolicy item) {
            this.builder = new TagReferencePolicyBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ImageImportSpecFluent.this.withReferencePolicy(this.builder.build());
        }

        public N endReferencePolicy() {
            return this.and();
        }
    }

    public class ImportPolicyNested<N>
    extends TagImportPolicyFluent<ImportPolicyNested<N>>
    implements Nested<N> {
        TagImportPolicyBuilder builder;

        ImportPolicyNested(TagImportPolicy item) {
            this.builder = new TagImportPolicyBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ImageImportSpecFluent.this.withImportPolicy(this.builder.build());
        }

        public N endImportPolicy() {
            return this.and();
        }
    }

    public class FromNested<N>
    extends ObjectReferenceFluent<FromNested<N>>
    implements Nested<N> {
        ObjectReferenceBuilder builder;

        FromNested(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ImageImportSpecFluent.this.withFrom(this.builder.build());
        }

        public N endFrom() {
            return this.and();
        }
    }
}

