/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_8;

import io.fabric8.kubernetes.api.builder.v6_8.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_8.Nested;
import io.fabric8.openshift.api.model.v6_8.EgressNetworkPolicyRule;
import io.fabric8.openshift.api.model.v6_8.EgressNetworkPolicyRuleBuilder;
import io.fabric8.openshift.api.model.v6_8.EgressNetworkPolicyRuleFluent;
import io.fabric8.openshift.api.model.v6_8.EgressNetworkPolicySpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class EgressNetworkPolicySpecFluent<A extends EgressNetworkPolicySpecFluent<A>>
extends BaseFluent<A> {
    private ArrayList<EgressNetworkPolicyRuleBuilder> egress = new ArrayList();
    private Map<String, Object> additionalProperties;

    public EgressNetworkPolicySpecFluent() {
    }

    public EgressNetworkPolicySpecFluent(EgressNetworkPolicySpec instance) {
        EgressNetworkPolicySpec egressNetworkPolicySpec = instance = instance != null ? instance : new EgressNetworkPolicySpec();
        if (instance != null) {
            this.withEgress(instance.getEgress());
            this.withEgress(instance.getEgress());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToEgress(int index, EgressNetworkPolicyRule item) {
        if (this.egress == null) {
            this.egress = new ArrayList();
        }
        EgressNetworkPolicyRuleBuilder builder = new EgressNetworkPolicyRuleBuilder(item);
        if (index < 0 || index >= this.egress.size()) {
            this._visitables.get("egress").add(builder);
            this.egress.add(builder);
        } else {
            this._visitables.get("egress").add(index, builder);
            this.egress.add(index, builder);
        }
        return (A)this;
    }

    public A setToEgress(int index, EgressNetworkPolicyRule item) {
        if (this.egress == null) {
            this.egress = new ArrayList();
        }
        EgressNetworkPolicyRuleBuilder builder = new EgressNetworkPolicyRuleBuilder(item);
        if (index < 0 || index >= this.egress.size()) {
            this._visitables.get("egress").add(builder);
            this.egress.add(builder);
        } else {
            this._visitables.get("egress").set(index, builder);
            this.egress.set(index, builder);
        }
        return (A)this;
    }

    public A addToEgress(EgressNetworkPolicyRule ... items) {
        if (this.egress == null) {
            this.egress = new ArrayList();
        }
        for (EgressNetworkPolicyRule item : items) {
            EgressNetworkPolicyRuleBuilder builder = new EgressNetworkPolicyRuleBuilder(item);
            this._visitables.get("egress").add(builder);
            this.egress.add(builder);
        }
        return (A)this;
    }

    public A addAllToEgress(Collection<EgressNetworkPolicyRule> items) {
        if (this.egress == null) {
            this.egress = new ArrayList();
        }
        for (EgressNetworkPolicyRule item : items) {
            EgressNetworkPolicyRuleBuilder builder = new EgressNetworkPolicyRuleBuilder(item);
            this._visitables.get("egress").add(builder);
            this.egress.add(builder);
        }
        return (A)this;
    }

    public A removeFromEgress(EgressNetworkPolicyRule ... items) {
        if (this.egress == null) {
            return (A)this;
        }
        for (EgressNetworkPolicyRule item : items) {
            EgressNetworkPolicyRuleBuilder builder = new EgressNetworkPolicyRuleBuilder(item);
            this._visitables.get("egress").remove(builder);
            this.egress.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromEgress(Collection<EgressNetworkPolicyRule> items) {
        if (this.egress == null) {
            return (A)this;
        }
        for (EgressNetworkPolicyRule item : items) {
            EgressNetworkPolicyRuleBuilder builder = new EgressNetworkPolicyRuleBuilder(item);
            this._visitables.get("egress").remove(builder);
            this.egress.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromEgress(Predicate<EgressNetworkPolicyRuleBuilder> predicate) {
        if (this.egress == null) {
            return (A)this;
        }
        Iterator<EgressNetworkPolicyRuleBuilder> each = this.egress.iterator();
        Object visitables = this._visitables.get("egress");
        while (each.hasNext()) {
            EgressNetworkPolicyRuleBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<EgressNetworkPolicyRule> buildEgress() {
        return this.egress != null ? EgressNetworkPolicySpecFluent.build(this.egress) : null;
    }

    public EgressNetworkPolicyRule buildEgress(int index) {
        return this.egress.get(index).build();
    }

    public EgressNetworkPolicyRule buildFirstEgress() {
        return this.egress.get(0).build();
    }

    public EgressNetworkPolicyRule buildLastEgress() {
        return this.egress.get(this.egress.size() - 1).build();
    }

    public EgressNetworkPolicyRule buildMatchingEgress(Predicate<EgressNetworkPolicyRuleBuilder> predicate) {
        for (EgressNetworkPolicyRuleBuilder item : this.egress) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingEgress(Predicate<EgressNetworkPolicyRuleBuilder> predicate) {
        for (EgressNetworkPolicyRuleBuilder item : this.egress) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withEgress(List<EgressNetworkPolicyRule> egress) {
        if (this.egress != null) {
            this._visitables.get("egress").clear();
        }
        if (egress != null) {
            this.egress = new ArrayList();
            for (EgressNetworkPolicyRule item : egress) {
                this.addToEgress(item);
            }
        } else {
            this.egress = null;
        }
        return (A)this;
    }

    public A withEgress(EgressNetworkPolicyRule ... egress) {
        if (this.egress != null) {
            this.egress.clear();
            this._visitables.remove("egress");
        }
        if (egress != null) {
            for (EgressNetworkPolicyRule item : egress) {
                this.addToEgress(item);
            }
        }
        return (A)this;
    }

    public boolean hasEgress() {
        return this.egress != null && !this.egress.isEmpty();
    }

    public EgressNested<A> addNewEgress() {
        return new EgressNested(-1, null);
    }

    public EgressNested<A> addNewEgressLike(EgressNetworkPolicyRule item) {
        return new EgressNested(-1, item);
    }

    public EgressNested<A> setNewEgressLike(int index, EgressNetworkPolicyRule item) {
        return new EgressNested(index, item);
    }

    public EgressNested<A> editEgress(int index) {
        if (this.egress.size() <= index) {
            throw new RuntimeException("Can't edit egress. Index exceeds size.");
        }
        return this.setNewEgressLike(index, this.buildEgress(index));
    }

    public EgressNested<A> editFirstEgress() {
        if (this.egress.size() == 0) {
            throw new RuntimeException("Can't edit first egress. The list is empty.");
        }
        return this.setNewEgressLike(0, this.buildEgress(0));
    }

    public EgressNested<A> editLastEgress() {
        int index = this.egress.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last egress. The list is empty.");
        }
        return this.setNewEgressLike(index, this.buildEgress(index));
    }

    public EgressNested<A> editMatchingEgress(Predicate<EgressNetworkPolicyRuleBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.egress.size(); ++i) {
            if (!predicate.test(this.egress.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching egress. No match found.");
        }
        return this.setNewEgressLike(index, this.buildEgress(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EgressNetworkPolicySpecFluent that = (EgressNetworkPolicySpecFluent)o;
        if (!Objects.equals(this.egress, that.egress)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.egress, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.egress != null && !this.egress.isEmpty()) {
            sb.append("egress:");
            sb.append(this.egress + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class EgressNested<N>
    extends EgressNetworkPolicyRuleFluent<EgressNested<N>>
    implements Nested<N> {
        EgressNetworkPolicyRuleBuilder builder;
        int index;

        EgressNested(int index, EgressNetworkPolicyRule item) {
            this.index = index;
            this.builder = new EgressNetworkPolicyRuleBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)EgressNetworkPolicySpecFluent.this.setToEgress(this.index, this.builder.build());
        }

        public N endEgress() {
            return this.and();
        }
    }
}

