/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v6_8.server.mock;

import io.fabric8.kubernetes.clnt.v6_8.NamespacedKubernetesClient;
import io.fabric8.kubernetes.clnt.v6_8.dsl.base.CustomResourceDefinitionContext;
import io.fabric8.kubernetes.clnt.v6_8.server.mock.KubernetesMixedDispatcher;
import io.fabric8.kubernetes.clnt.v6_8.server.mock.KubernetesMockServer;
import io.fabric8.mockwebserver.Context;
import io.fabric8.mockwebserver.ServerRequest;
import io.fabric8.mockwebserver.ServerResponse;
import io.fabric8.mockwebserver.dsl.MockServerExpectation;
import io.fabric8.mockwebserver.dsl.ReturnOrWebsocketable;
import io.fabric8.mockwebserver.dsl.TimesOnceableOrHttpHeaderable;
import java.net.InetAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Queue;
import okhttp3.mockwebserver.MockWebServer;
import okhttp3.mockwebserver.RecordedRequest;
import org.junit.rules.ExternalResource;

public class KubernetesServer
extends ExternalResource {
    private KubernetesMockServer mock;
    private NamespacedKubernetesClient client;
    private final boolean https;
    private final boolean crudMode;
    private final InetAddress address;
    private final int port;
    private final List<CustomResourceDefinitionContext> crdContextList;

    public KubernetesServer() {
        this(true);
    }

    public KubernetesServer(boolean https) {
        this(https, false);
    }

    public KubernetesServer(boolean https, boolean crudMode) {
        this(https, crudMode, InetAddress.getLoopbackAddress(), 0, Collections.emptyList());
    }

    public KubernetesServer(boolean https, boolean crudMode, List<CustomResourceDefinitionContext> crdContextList) {
        this(https, crudMode, InetAddress.getLoopbackAddress(), 0, crdContextList);
    }

    public KubernetesServer(boolean https, boolean crudMode, InetAddress address, int port, List<CustomResourceDefinitionContext> crdContextList) {
        this.https = https;
        this.crudMode = crudMode;
        this.address = address;
        this.port = port;
        this.crdContextList = crdContextList;
    }

    public void before() {
        HashMap<ServerRequest, Queue<ServerResponse>> responses = new HashMap<ServerRequest, Queue<ServerResponse>>();
        this.mock = this.crudMode ? new KubernetesMockServer(new Context(), new MockWebServer(), responses, new KubernetesMixedDispatcher(responses, this.crdContextList), this.https) : new KubernetesMockServer(this.https);
        this.mock.init(this.address, this.port);
        this.client = this.mock.createClient();
    }

    public void after() {
        this.mock.destroy();
        this.client.close();
    }

    public NamespacedKubernetesClient getClient() {
        return this.client;
    }

    public MockServerExpectation expect() {
        return this.mock.expect();
    }

    @Deprecated
    public <T> void expectAndReturnAsJson(String path, int code, T body) {
        ((TimesOnceableOrHttpHeaderable)((ReturnOrWebsocketable)this.expect().withPath(path)).andReturn(code, body)).always();
    }

    @Deprecated
    public void expectAndReturnAsString(String path, int code, String body) {
        ((TimesOnceableOrHttpHeaderable)((ReturnOrWebsocketable)this.expect().withPath(path)).andReturn(code, (Object)body)).always();
    }

    @Deprecated
    public <T> void expectAndReturnAsJson(String method, String path, int code, T body) {
        ((TimesOnceableOrHttpHeaderable)((ReturnOrWebsocketable)this.expect().withPath(path)).andReturn(code, body)).always();
    }

    @Deprecated
    public void expectAndReturnAsString(String method, String path, int code, String body) {
        ((TimesOnceableOrHttpHeaderable)((ReturnOrWebsocketable)this.expect().withPath(path)).andReturn(code, (Object)body)).always();
    }

    public KubernetesMockServer getKubernetesMockServer() {
        return this.mock;
    }

    public RecordedRequest getLastRequest() throws InterruptedException {
        return this.mock.getLastRequest();
    }
}

