/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v6_8.dsl.internal;

import io.fabric8.kubernetes.clnt.v6_8.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v6_8.dsl.MetricOperation;
import io.fabric8.kubernetes.clnt.v6_8.dsl.internal.OperationContext;
import io.fabric8.kubernetes.clnt.v6_8.dsl.internal.OperationSupport;
import io.fabric8.kubernetes.clnt.v6_8.utils.URLUtils;
import io.fabric8.kubernetes.clnt.v6_8.utils.Utils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public abstract class MetricOperationsImpl<T, L>
extends OperationSupport
implements MetricOperation<T, L> {
    public static final String METRIC_ENDPOINT_URL = "apis/metrics.k8s.io/v1beta1/";
    private final Class<L> apiTypeListClass;
    private final Class<T> apiTypeClass;

    public MetricOperationsImpl(OperationContext operationContext, Class<T> apiTypeClass, Class<L> apiTypeListClass) {
        super(operationContext);
        this.apiTypeClass = apiTypeClass;
        this.apiTypeListClass = apiTypeListClass;
    }

    public L metrics() {
        try {
            return this.handleMetric(this.getMetricEndpointUrl(), this.apiTypeListClass);
        }
        catch (IOException exception) {
            throw KubernetesClientException.launderThrowable((Throwable)exception);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw KubernetesClientException.launderThrowable((Throwable)interruptedException);
        }
    }

    public T metric() {
        try {
            return this.handleMetric(this.getMetricEndpointUrl(), this.apiTypeClass);
        }
        catch (IOException exception) {
            throw KubernetesClientException.launderThrowable((Throwable)exception);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw KubernetesClientException.launderThrowable((Throwable)interruptedException);
        }
    }

    public L metrics(Map<String, Object> labelsMap) {
        HashMap labels = new HashMap();
        labelsMap.forEach((k, v) -> labels.put(k, v.toString()));
        return (L)this.withLabels(labels).metrics();
    }

    protected String getMetricEndpointUrlWithPlural(String plural) {
        String result = URLUtils.join((String[])new String[]{this.config.getMasterUrl(), METRIC_ENDPOINT_URL});
        if (this.isResourceNamespaced() && this.namespace != null) {
            result = result + "namespaces/" + this.namespace + "/";
        }
        result = result + plural;
        if (this.context.getName() != null) {
            result = result + "/" + this.context.getName();
        }
        if (Utils.isNotNullOrEmpty(this.context.getLabels())) {
            result = this.getUrlWithLabels(result, this.context.getLabels());
        }
        return result;
    }

    private String getMetricEndpointUrl() {
        return this.getMetricEndpointUrlWithPlural(this.context.getPlural());
    }

    private String getUrlWithLabels(String baseUrl, Map<String, String> labels) {
        URLUtils.URLBuilder httpUrlBuilder = new URLUtils.URLBuilder(baseUrl);
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : labels.entrySet()) {
            sb.append(entry.getKey()).append("=").append(entry.getValue()).append(",");
        }
        httpUrlBuilder.addQueryParameter("labelSelector", sb.substring(0, sb.toString().length() - 1));
        return httpUrlBuilder.toString();
    }
}

