/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_8.policy.v1beta1;

import io.fabric8.kubernetes.api.builder.v6_8.BaseFluent;
import io.fabric8.kubernetes.api.model.v6_8.policy.v1beta1.RuntimeClassStrategyOptions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class RuntimeClassStrategyOptionsFluent<A extends RuntimeClassStrategyOptionsFluent<A>>
extends BaseFluent<A> {
    private List<String> allowedRuntimeClassNames = new ArrayList<String>();
    private String defaultRuntimeClassName;
    private Map<String, Object> additionalProperties;

    public RuntimeClassStrategyOptionsFluent() {
    }

    public RuntimeClassStrategyOptionsFluent(RuntimeClassStrategyOptions instance) {
        RuntimeClassStrategyOptions runtimeClassStrategyOptions = instance = instance != null ? instance : new RuntimeClassStrategyOptions();
        if (instance != null) {
            this.withAllowedRuntimeClassNames(instance.getAllowedRuntimeClassNames());
            this.withDefaultRuntimeClassName(instance.getDefaultRuntimeClassName());
            this.withAllowedRuntimeClassNames(instance.getAllowedRuntimeClassNames());
            this.withDefaultRuntimeClassName(instance.getDefaultRuntimeClassName());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToAllowedRuntimeClassNames(int index, String item) {
        if (this.allowedRuntimeClassNames == null) {
            this.allowedRuntimeClassNames = new ArrayList<String>();
        }
        this.allowedRuntimeClassNames.add(index, item);
        return (A)this;
    }

    public A setToAllowedRuntimeClassNames(int index, String item) {
        if (this.allowedRuntimeClassNames == null) {
            this.allowedRuntimeClassNames = new ArrayList<String>();
        }
        this.allowedRuntimeClassNames.set(index, item);
        return (A)this;
    }

    public A addToAllowedRuntimeClassNames(String ... items) {
        if (this.allowedRuntimeClassNames == null) {
            this.allowedRuntimeClassNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.allowedRuntimeClassNames.add(item);
        }
        return (A)this;
    }

    public A addAllToAllowedRuntimeClassNames(Collection<String> items) {
        if (this.allowedRuntimeClassNames == null) {
            this.allowedRuntimeClassNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.allowedRuntimeClassNames.add(item);
        }
        return (A)this;
    }

    public A removeFromAllowedRuntimeClassNames(String ... items) {
        if (this.allowedRuntimeClassNames == null) {
            return (A)this;
        }
        for (String item : items) {
            this.allowedRuntimeClassNames.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromAllowedRuntimeClassNames(Collection<String> items) {
        if (this.allowedRuntimeClassNames == null) {
            return (A)this;
        }
        for (String item : items) {
            this.allowedRuntimeClassNames.remove(item);
        }
        return (A)this;
    }

    public List<String> getAllowedRuntimeClassNames() {
        return this.allowedRuntimeClassNames;
    }

    public String getAllowedRuntimeClassName(int index) {
        return this.allowedRuntimeClassNames.get(index);
    }

    public String getFirstAllowedRuntimeClassName() {
        return this.allowedRuntimeClassNames.get(0);
    }

    public String getLastAllowedRuntimeClassName() {
        return this.allowedRuntimeClassNames.get(this.allowedRuntimeClassNames.size() - 1);
    }

    public String getMatchingAllowedRuntimeClassName(Predicate<String> predicate) {
        for (String item : this.allowedRuntimeClassNames) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingAllowedRuntimeClassName(Predicate<String> predicate) {
        for (String item : this.allowedRuntimeClassNames) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withAllowedRuntimeClassNames(List<String> allowedRuntimeClassNames) {
        if (allowedRuntimeClassNames != null) {
            this.allowedRuntimeClassNames = new ArrayList<String>();
            for (String item : allowedRuntimeClassNames) {
                this.addToAllowedRuntimeClassNames(item);
            }
        } else {
            this.allowedRuntimeClassNames = null;
        }
        return (A)this;
    }

    public A withAllowedRuntimeClassNames(String ... allowedRuntimeClassNames) {
        if (this.allowedRuntimeClassNames != null) {
            this.allowedRuntimeClassNames.clear();
            this._visitables.remove("allowedRuntimeClassNames");
        }
        if (allowedRuntimeClassNames != null) {
            for (String item : allowedRuntimeClassNames) {
                this.addToAllowedRuntimeClassNames(item);
            }
        }
        return (A)this;
    }

    public boolean hasAllowedRuntimeClassNames() {
        return this.allowedRuntimeClassNames != null && !this.allowedRuntimeClassNames.isEmpty();
    }

    public String getDefaultRuntimeClassName() {
        return this.defaultRuntimeClassName;
    }

    public A withDefaultRuntimeClassName(String defaultRuntimeClassName) {
        this.defaultRuntimeClassName = defaultRuntimeClassName;
        return (A)this;
    }

    public boolean hasDefaultRuntimeClassName() {
        return this.defaultRuntimeClassName != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RuntimeClassStrategyOptionsFluent that = (RuntimeClassStrategyOptionsFluent)o;
        if (!Objects.equals(this.allowedRuntimeClassNames, that.allowedRuntimeClassNames)) {
            return false;
        }
        if (!Objects.equals(this.defaultRuntimeClassName, that.defaultRuntimeClassName)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.allowedRuntimeClassNames, this.defaultRuntimeClassName, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.allowedRuntimeClassNames != null && !this.allowedRuntimeClassNames.isEmpty()) {
            sb.append("allowedRuntimeClassNames:");
            sb.append(this.allowedRuntimeClassNames + ",");
        }
        if (this.defaultRuntimeClassName != null) {
            sb.append("defaultRuntimeClassName:");
            sb.append(this.defaultRuntimeClassName + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

