/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_8.networking.v1;

import io.fabric8.kubernetes.api.builder.v6_8.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_8.Nested;
import io.fabric8.kubernetes.api.model.v6_8.networking.v1.NetworkPolicyIngressRule;
import io.fabric8.kubernetes.api.model.v6_8.networking.v1.NetworkPolicyPeer;
import io.fabric8.kubernetes.api.model.v6_8.networking.v1.NetworkPolicyPeerBuilder;
import io.fabric8.kubernetes.api.model.v6_8.networking.v1.NetworkPolicyPeerFluent;
import io.fabric8.kubernetes.api.model.v6_8.networking.v1.NetworkPolicyPort;
import io.fabric8.kubernetes.api.model.v6_8.networking.v1.NetworkPolicyPortBuilder;
import io.fabric8.kubernetes.api.model.v6_8.networking.v1.NetworkPolicyPortFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class NetworkPolicyIngressRuleFluent<A extends NetworkPolicyIngressRuleFluent<A>>
extends BaseFluent<A> {
    private ArrayList<NetworkPolicyPeerBuilder> from = new ArrayList();
    private ArrayList<NetworkPolicyPortBuilder> ports = new ArrayList();
    private Map<String, Object> additionalProperties;

    public NetworkPolicyIngressRuleFluent() {
    }

    public NetworkPolicyIngressRuleFluent(NetworkPolicyIngressRule instance) {
        NetworkPolicyIngressRule networkPolicyIngressRule = instance = instance != null ? instance : new NetworkPolicyIngressRule();
        if (instance != null) {
            this.withFrom(instance.getFrom());
            this.withPorts(instance.getPorts());
            this.withFrom(instance.getFrom());
            this.withPorts(instance.getPorts());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToFrom(int index, NetworkPolicyPeer item) {
        if (this.from == null) {
            this.from = new ArrayList();
        }
        NetworkPolicyPeerBuilder builder = new NetworkPolicyPeerBuilder(item);
        if (index < 0 || index >= this.from.size()) {
            this._visitables.get("from").add(builder);
            this.from.add(builder);
        } else {
            this._visitables.get("from").add(index, builder);
            this.from.add(index, builder);
        }
        return (A)this;
    }

    public A setToFrom(int index, NetworkPolicyPeer item) {
        if (this.from == null) {
            this.from = new ArrayList();
        }
        NetworkPolicyPeerBuilder builder = new NetworkPolicyPeerBuilder(item);
        if (index < 0 || index >= this.from.size()) {
            this._visitables.get("from").add(builder);
            this.from.add(builder);
        } else {
            this._visitables.get("from").set(index, builder);
            this.from.set(index, builder);
        }
        return (A)this;
    }

    public A addToFrom(NetworkPolicyPeer ... items) {
        if (this.from == null) {
            this.from = new ArrayList();
        }
        for (NetworkPolicyPeer item : items) {
            NetworkPolicyPeerBuilder builder = new NetworkPolicyPeerBuilder(item);
            this._visitables.get("from").add(builder);
            this.from.add(builder);
        }
        return (A)this;
    }

    public A addAllToFrom(Collection<NetworkPolicyPeer> items) {
        if (this.from == null) {
            this.from = new ArrayList();
        }
        for (NetworkPolicyPeer item : items) {
            NetworkPolicyPeerBuilder builder = new NetworkPolicyPeerBuilder(item);
            this._visitables.get("from").add(builder);
            this.from.add(builder);
        }
        return (A)this;
    }

    public A removeFromFrom(NetworkPolicyPeer ... items) {
        if (this.from == null) {
            return (A)this;
        }
        for (NetworkPolicyPeer item : items) {
            NetworkPolicyPeerBuilder builder = new NetworkPolicyPeerBuilder(item);
            this._visitables.get("from").remove(builder);
            this.from.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromFrom(Collection<NetworkPolicyPeer> items) {
        if (this.from == null) {
            return (A)this;
        }
        for (NetworkPolicyPeer item : items) {
            NetworkPolicyPeerBuilder builder = new NetworkPolicyPeerBuilder(item);
            this._visitables.get("from").remove(builder);
            this.from.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromFrom(Predicate<NetworkPolicyPeerBuilder> predicate) {
        if (this.from == null) {
            return (A)this;
        }
        Iterator<NetworkPolicyPeerBuilder> each = this.from.iterator();
        Object visitables = this._visitables.get("from");
        while (each.hasNext()) {
            NetworkPolicyPeerBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<NetworkPolicyPeer> buildFrom() {
        return this.from != null ? NetworkPolicyIngressRuleFluent.build(this.from) : null;
    }

    public NetworkPolicyPeer buildFrom(int index) {
        return this.from.get(index).build();
    }

    public NetworkPolicyPeer buildFirstFrom() {
        return this.from.get(0).build();
    }

    public NetworkPolicyPeer buildLastFrom() {
        return this.from.get(this.from.size() - 1).build();
    }

    public NetworkPolicyPeer buildMatchingFrom(Predicate<NetworkPolicyPeerBuilder> predicate) {
        for (NetworkPolicyPeerBuilder item : this.from) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingFrom(Predicate<NetworkPolicyPeerBuilder> predicate) {
        for (NetworkPolicyPeerBuilder item : this.from) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withFrom(List<NetworkPolicyPeer> from) {
        if (this.from != null) {
            this._visitables.get("from").clear();
        }
        if (from != null) {
            this.from = new ArrayList();
            for (NetworkPolicyPeer item : from) {
                this.addToFrom(item);
            }
        } else {
            this.from = null;
        }
        return (A)this;
    }

    public A withFrom(NetworkPolicyPeer ... from) {
        if (this.from != null) {
            this.from.clear();
            this._visitables.remove("from");
        }
        if (from != null) {
            for (NetworkPolicyPeer item : from) {
                this.addToFrom(item);
            }
        }
        return (A)this;
    }

    public boolean hasFrom() {
        return this.from != null && !this.from.isEmpty();
    }

    public FromNested<A> addNewFrom() {
        return new FromNested(-1, null);
    }

    public FromNested<A> addNewFromLike(NetworkPolicyPeer item) {
        return new FromNested(-1, item);
    }

    public FromNested<A> setNewFromLike(int index, NetworkPolicyPeer item) {
        return new FromNested(index, item);
    }

    public FromNested<A> editFrom(int index) {
        if (this.from.size() <= index) {
            throw new RuntimeException("Can't edit from. Index exceeds size.");
        }
        return this.setNewFromLike(index, this.buildFrom(index));
    }

    public FromNested<A> editFirstFrom() {
        if (this.from.size() == 0) {
            throw new RuntimeException("Can't edit first from. The list is empty.");
        }
        return this.setNewFromLike(0, this.buildFrom(0));
    }

    public FromNested<A> editLastFrom() {
        int index = this.from.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last from. The list is empty.");
        }
        return this.setNewFromLike(index, this.buildFrom(index));
    }

    public FromNested<A> editMatchingFrom(Predicate<NetworkPolicyPeerBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.from.size(); ++i) {
            if (!predicate.test(this.from.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching from. No match found.");
        }
        return this.setNewFromLike(index, this.buildFrom(index));
    }

    public A addToPorts(int index, NetworkPolicyPort item) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        NetworkPolicyPortBuilder builder = new NetworkPolicyPortBuilder(item);
        if (index < 0 || index >= this.ports.size()) {
            this._visitables.get("ports").add(builder);
            this.ports.add(builder);
        } else {
            this._visitables.get("ports").add(index, builder);
            this.ports.add(index, builder);
        }
        return (A)this;
    }

    public A setToPorts(int index, NetworkPolicyPort item) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        NetworkPolicyPortBuilder builder = new NetworkPolicyPortBuilder(item);
        if (index < 0 || index >= this.ports.size()) {
            this._visitables.get("ports").add(builder);
            this.ports.add(builder);
        } else {
            this._visitables.get("ports").set(index, builder);
            this.ports.set(index, builder);
        }
        return (A)this;
    }

    public A addToPorts(NetworkPolicyPort ... items) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        for (NetworkPolicyPort item : items) {
            NetworkPolicyPortBuilder builder = new NetworkPolicyPortBuilder(item);
            this._visitables.get("ports").add(builder);
            this.ports.add(builder);
        }
        return (A)this;
    }

    public A addAllToPorts(Collection<NetworkPolicyPort> items) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        for (NetworkPolicyPort item : items) {
            NetworkPolicyPortBuilder builder = new NetworkPolicyPortBuilder(item);
            this._visitables.get("ports").add(builder);
            this.ports.add(builder);
        }
        return (A)this;
    }

    public A removeFromPorts(NetworkPolicyPort ... items) {
        if (this.ports == null) {
            return (A)this;
        }
        for (NetworkPolicyPort item : items) {
            NetworkPolicyPortBuilder builder = new NetworkPolicyPortBuilder(item);
            this._visitables.get("ports").remove(builder);
            this.ports.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromPorts(Collection<NetworkPolicyPort> items) {
        if (this.ports == null) {
            return (A)this;
        }
        for (NetworkPolicyPort item : items) {
            NetworkPolicyPortBuilder builder = new NetworkPolicyPortBuilder(item);
            this._visitables.get("ports").remove(builder);
            this.ports.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromPorts(Predicate<NetworkPolicyPortBuilder> predicate) {
        if (this.ports == null) {
            return (A)this;
        }
        Iterator<NetworkPolicyPortBuilder> each = this.ports.iterator();
        Object visitables = this._visitables.get("ports");
        while (each.hasNext()) {
            NetworkPolicyPortBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<NetworkPolicyPort> buildPorts() {
        return this.ports != null ? NetworkPolicyIngressRuleFluent.build(this.ports) : null;
    }

    public NetworkPolicyPort buildPort(int index) {
        return this.ports.get(index).build();
    }

    public NetworkPolicyPort buildFirstPort() {
        return this.ports.get(0).build();
    }

    public NetworkPolicyPort buildLastPort() {
        return this.ports.get(this.ports.size() - 1).build();
    }

    public NetworkPolicyPort buildMatchingPort(Predicate<NetworkPolicyPortBuilder> predicate) {
        for (NetworkPolicyPortBuilder item : this.ports) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingPort(Predicate<NetworkPolicyPortBuilder> predicate) {
        for (NetworkPolicyPortBuilder item : this.ports) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withPorts(List<NetworkPolicyPort> ports) {
        if (this.ports != null) {
            this._visitables.get("ports").clear();
        }
        if (ports != null) {
            this.ports = new ArrayList();
            for (NetworkPolicyPort item : ports) {
                this.addToPorts(item);
            }
        } else {
            this.ports = null;
        }
        return (A)this;
    }

    public A withPorts(NetworkPolicyPort ... ports) {
        if (this.ports != null) {
            this.ports.clear();
            this._visitables.remove("ports");
        }
        if (ports != null) {
            for (NetworkPolicyPort item : ports) {
                this.addToPorts(item);
            }
        }
        return (A)this;
    }

    public boolean hasPorts() {
        return this.ports != null && !this.ports.isEmpty();
    }

    public PortsNested<A> addNewPort() {
        return new PortsNested(-1, null);
    }

    public PortsNested<A> addNewPortLike(NetworkPolicyPort item) {
        return new PortsNested(-1, item);
    }

    public PortsNested<A> setNewPortLike(int index, NetworkPolicyPort item) {
        return new PortsNested(index, item);
    }

    public PortsNested<A> editPort(int index) {
        if (this.ports.size() <= index) {
            throw new RuntimeException("Can't edit ports. Index exceeds size.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    public PortsNested<A> editFirstPort() {
        if (this.ports.size() == 0) {
            throw new RuntimeException("Can't edit first ports. The list is empty.");
        }
        return this.setNewPortLike(0, this.buildPort(0));
    }

    public PortsNested<A> editLastPort() {
        int index = this.ports.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last ports. The list is empty.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    public PortsNested<A> editMatchingPort(Predicate<NetworkPolicyPortBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.ports.size(); ++i) {
            if (!predicate.test(this.ports.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching ports. No match found.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NetworkPolicyIngressRuleFluent that = (NetworkPolicyIngressRuleFluent)o;
        if (!Objects.equals(this.from, that.from)) {
            return false;
        }
        if (!Objects.equals(this.ports, that.ports)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.from, this.ports, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.from != null && !this.from.isEmpty()) {
            sb.append("from:");
            sb.append(this.from + ",");
        }
        if (this.ports != null && !this.ports.isEmpty()) {
            sb.append("ports:");
            sb.append(this.ports + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class PortsNested<N>
    extends NetworkPolicyPortFluent<PortsNested<N>>
    implements Nested<N> {
        NetworkPolicyPortBuilder builder;
        int index;

        PortsNested(int index, NetworkPolicyPort item) {
            this.index = index;
            this.builder = new NetworkPolicyPortBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)NetworkPolicyIngressRuleFluent.this.setToPorts(this.index, this.builder.build());
        }

        public N endPort() {
            return this.and();
        }
    }

    public class FromNested<N>
    extends NetworkPolicyPeerFluent<FromNested<N>>
    implements Nested<N> {
        NetworkPolicyPeerBuilder builder;
        int index;

        FromNested(int index, NetworkPolicyPeer item) {
            this.index = index;
            this.builder = new NetworkPolicyPeerBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)NetworkPolicyIngressRuleFluent.this.setToFrom(this.index, this.builder.build());
        }

        public N endFrom() {
            return this.and();
        }
    }
}

