/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_8.flowcontrol.v1beta1;

import io.fabric8.kubernetes.api.builder.v6_8.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_8.Nested;
import io.fabric8.kubernetes.api.model.v6_8.flowcontrol.v1beta1.NonResourcePolicyRule;
import io.fabric8.kubernetes.api.model.v6_8.flowcontrol.v1beta1.NonResourcePolicyRuleBuilder;
import io.fabric8.kubernetes.api.model.v6_8.flowcontrol.v1beta1.NonResourcePolicyRuleFluent;
import io.fabric8.kubernetes.api.model.v6_8.flowcontrol.v1beta1.PolicyRulesWithSubjects;
import io.fabric8.kubernetes.api.model.v6_8.flowcontrol.v1beta1.ResourcePolicyRule;
import io.fabric8.kubernetes.api.model.v6_8.flowcontrol.v1beta1.ResourcePolicyRuleBuilder;
import io.fabric8.kubernetes.api.model.v6_8.flowcontrol.v1beta1.ResourcePolicyRuleFluent;
import io.fabric8.kubernetes.api.model.v6_8.flowcontrol.v1beta1.Subject;
import io.fabric8.kubernetes.api.model.v6_8.flowcontrol.v1beta1.SubjectBuilder;
import io.fabric8.kubernetes.api.model.v6_8.flowcontrol.v1beta1.SubjectFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class PolicyRulesWithSubjectsFluent<A extends PolicyRulesWithSubjectsFluent<A>>
extends BaseFluent<A> {
    private ArrayList<NonResourcePolicyRuleBuilder> nonResourceRules = new ArrayList();
    private ArrayList<ResourcePolicyRuleBuilder> resourceRules = new ArrayList();
    private ArrayList<SubjectBuilder> subjects = new ArrayList();
    private Map<String, Object> additionalProperties;

    public PolicyRulesWithSubjectsFluent() {
    }

    public PolicyRulesWithSubjectsFluent(PolicyRulesWithSubjects instance) {
        PolicyRulesWithSubjects policyRulesWithSubjects = instance = instance != null ? instance : new PolicyRulesWithSubjects();
        if (instance != null) {
            this.withNonResourceRules(instance.getNonResourceRules());
            this.withResourceRules(instance.getResourceRules());
            this.withSubjects(instance.getSubjects());
            this.withNonResourceRules(instance.getNonResourceRules());
            this.withResourceRules(instance.getResourceRules());
            this.withSubjects(instance.getSubjects());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToNonResourceRules(int index, NonResourcePolicyRule item) {
        if (this.nonResourceRules == null) {
            this.nonResourceRules = new ArrayList();
        }
        NonResourcePolicyRuleBuilder builder = new NonResourcePolicyRuleBuilder(item);
        if (index < 0 || index >= this.nonResourceRules.size()) {
            this._visitables.get("nonResourceRules").add(builder);
            this.nonResourceRules.add(builder);
        } else {
            this._visitables.get("nonResourceRules").add(index, builder);
            this.nonResourceRules.add(index, builder);
        }
        return (A)this;
    }

    public A setToNonResourceRules(int index, NonResourcePolicyRule item) {
        if (this.nonResourceRules == null) {
            this.nonResourceRules = new ArrayList();
        }
        NonResourcePolicyRuleBuilder builder = new NonResourcePolicyRuleBuilder(item);
        if (index < 0 || index >= this.nonResourceRules.size()) {
            this._visitables.get("nonResourceRules").add(builder);
            this.nonResourceRules.add(builder);
        } else {
            this._visitables.get("nonResourceRules").set(index, builder);
            this.nonResourceRules.set(index, builder);
        }
        return (A)this;
    }

    public A addToNonResourceRules(NonResourcePolicyRule ... items) {
        if (this.nonResourceRules == null) {
            this.nonResourceRules = new ArrayList();
        }
        for (NonResourcePolicyRule item : items) {
            NonResourcePolicyRuleBuilder builder = new NonResourcePolicyRuleBuilder(item);
            this._visitables.get("nonResourceRules").add(builder);
            this.nonResourceRules.add(builder);
        }
        return (A)this;
    }

    public A addAllToNonResourceRules(Collection<NonResourcePolicyRule> items) {
        if (this.nonResourceRules == null) {
            this.nonResourceRules = new ArrayList();
        }
        for (NonResourcePolicyRule item : items) {
            NonResourcePolicyRuleBuilder builder = new NonResourcePolicyRuleBuilder(item);
            this._visitables.get("nonResourceRules").add(builder);
            this.nonResourceRules.add(builder);
        }
        return (A)this;
    }

    public A removeFromNonResourceRules(NonResourcePolicyRule ... items) {
        if (this.nonResourceRules == null) {
            return (A)this;
        }
        for (NonResourcePolicyRule item : items) {
            NonResourcePolicyRuleBuilder builder = new NonResourcePolicyRuleBuilder(item);
            this._visitables.get("nonResourceRules").remove(builder);
            this.nonResourceRules.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromNonResourceRules(Collection<NonResourcePolicyRule> items) {
        if (this.nonResourceRules == null) {
            return (A)this;
        }
        for (NonResourcePolicyRule item : items) {
            NonResourcePolicyRuleBuilder builder = new NonResourcePolicyRuleBuilder(item);
            this._visitables.get("nonResourceRules").remove(builder);
            this.nonResourceRules.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromNonResourceRules(Predicate<NonResourcePolicyRuleBuilder> predicate) {
        if (this.nonResourceRules == null) {
            return (A)this;
        }
        Iterator<NonResourcePolicyRuleBuilder> each = this.nonResourceRules.iterator();
        Object visitables = this._visitables.get("nonResourceRules");
        while (each.hasNext()) {
            NonResourcePolicyRuleBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<NonResourcePolicyRule> buildNonResourceRules() {
        return this.nonResourceRules != null ? PolicyRulesWithSubjectsFluent.build(this.nonResourceRules) : null;
    }

    public NonResourcePolicyRule buildNonResourceRule(int index) {
        return this.nonResourceRules.get(index).build();
    }

    public NonResourcePolicyRule buildFirstNonResourceRule() {
        return this.nonResourceRules.get(0).build();
    }

    public NonResourcePolicyRule buildLastNonResourceRule() {
        return this.nonResourceRules.get(this.nonResourceRules.size() - 1).build();
    }

    public NonResourcePolicyRule buildMatchingNonResourceRule(Predicate<NonResourcePolicyRuleBuilder> predicate) {
        for (NonResourcePolicyRuleBuilder item : this.nonResourceRules) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingNonResourceRule(Predicate<NonResourcePolicyRuleBuilder> predicate) {
        for (NonResourcePolicyRuleBuilder item : this.nonResourceRules) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withNonResourceRules(List<NonResourcePolicyRule> nonResourceRules) {
        if (this.nonResourceRules != null) {
            this._visitables.get("nonResourceRules").clear();
        }
        if (nonResourceRules != null) {
            this.nonResourceRules = new ArrayList();
            for (NonResourcePolicyRule item : nonResourceRules) {
                this.addToNonResourceRules(item);
            }
        } else {
            this.nonResourceRules = null;
        }
        return (A)this;
    }

    public A withNonResourceRules(NonResourcePolicyRule ... nonResourceRules) {
        if (this.nonResourceRules != null) {
            this.nonResourceRules.clear();
            this._visitables.remove("nonResourceRules");
        }
        if (nonResourceRules != null) {
            for (NonResourcePolicyRule item : nonResourceRules) {
                this.addToNonResourceRules(item);
            }
        }
        return (A)this;
    }

    public boolean hasNonResourceRules() {
        return this.nonResourceRules != null && !this.nonResourceRules.isEmpty();
    }

    public NonResourceRulesNested<A> addNewNonResourceRule() {
        return new NonResourceRulesNested(-1, null);
    }

    public NonResourceRulesNested<A> addNewNonResourceRuleLike(NonResourcePolicyRule item) {
        return new NonResourceRulesNested(-1, item);
    }

    public NonResourceRulesNested<A> setNewNonResourceRuleLike(int index, NonResourcePolicyRule item) {
        return new NonResourceRulesNested(index, item);
    }

    public NonResourceRulesNested<A> editNonResourceRule(int index) {
        if (this.nonResourceRules.size() <= index) {
            throw new RuntimeException("Can't edit nonResourceRules. Index exceeds size.");
        }
        return this.setNewNonResourceRuleLike(index, this.buildNonResourceRule(index));
    }

    public NonResourceRulesNested<A> editFirstNonResourceRule() {
        if (this.nonResourceRules.size() == 0) {
            throw new RuntimeException("Can't edit first nonResourceRules. The list is empty.");
        }
        return this.setNewNonResourceRuleLike(0, this.buildNonResourceRule(0));
    }

    public NonResourceRulesNested<A> editLastNonResourceRule() {
        int index = this.nonResourceRules.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last nonResourceRules. The list is empty.");
        }
        return this.setNewNonResourceRuleLike(index, this.buildNonResourceRule(index));
    }

    public NonResourceRulesNested<A> editMatchingNonResourceRule(Predicate<NonResourcePolicyRuleBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.nonResourceRules.size(); ++i) {
            if (!predicate.test(this.nonResourceRules.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching nonResourceRules. No match found.");
        }
        return this.setNewNonResourceRuleLike(index, this.buildNonResourceRule(index));
    }

    public A addToResourceRules(int index, ResourcePolicyRule item) {
        if (this.resourceRules == null) {
            this.resourceRules = new ArrayList();
        }
        ResourcePolicyRuleBuilder builder = new ResourcePolicyRuleBuilder(item);
        if (index < 0 || index >= this.resourceRules.size()) {
            this._visitables.get("resourceRules").add(builder);
            this.resourceRules.add(builder);
        } else {
            this._visitables.get("resourceRules").add(index, builder);
            this.resourceRules.add(index, builder);
        }
        return (A)this;
    }

    public A setToResourceRules(int index, ResourcePolicyRule item) {
        if (this.resourceRules == null) {
            this.resourceRules = new ArrayList();
        }
        ResourcePolicyRuleBuilder builder = new ResourcePolicyRuleBuilder(item);
        if (index < 0 || index >= this.resourceRules.size()) {
            this._visitables.get("resourceRules").add(builder);
            this.resourceRules.add(builder);
        } else {
            this._visitables.get("resourceRules").set(index, builder);
            this.resourceRules.set(index, builder);
        }
        return (A)this;
    }

    public A addToResourceRules(ResourcePolicyRule ... items) {
        if (this.resourceRules == null) {
            this.resourceRules = new ArrayList();
        }
        for (ResourcePolicyRule item : items) {
            ResourcePolicyRuleBuilder builder = new ResourcePolicyRuleBuilder(item);
            this._visitables.get("resourceRules").add(builder);
            this.resourceRules.add(builder);
        }
        return (A)this;
    }

    public A addAllToResourceRules(Collection<ResourcePolicyRule> items) {
        if (this.resourceRules == null) {
            this.resourceRules = new ArrayList();
        }
        for (ResourcePolicyRule item : items) {
            ResourcePolicyRuleBuilder builder = new ResourcePolicyRuleBuilder(item);
            this._visitables.get("resourceRules").add(builder);
            this.resourceRules.add(builder);
        }
        return (A)this;
    }

    public A removeFromResourceRules(ResourcePolicyRule ... items) {
        if (this.resourceRules == null) {
            return (A)this;
        }
        for (ResourcePolicyRule item : items) {
            ResourcePolicyRuleBuilder builder = new ResourcePolicyRuleBuilder(item);
            this._visitables.get("resourceRules").remove(builder);
            this.resourceRules.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromResourceRules(Collection<ResourcePolicyRule> items) {
        if (this.resourceRules == null) {
            return (A)this;
        }
        for (ResourcePolicyRule item : items) {
            ResourcePolicyRuleBuilder builder = new ResourcePolicyRuleBuilder(item);
            this._visitables.get("resourceRules").remove(builder);
            this.resourceRules.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromResourceRules(Predicate<ResourcePolicyRuleBuilder> predicate) {
        if (this.resourceRules == null) {
            return (A)this;
        }
        Iterator<ResourcePolicyRuleBuilder> each = this.resourceRules.iterator();
        Object visitables = this._visitables.get("resourceRules");
        while (each.hasNext()) {
            ResourcePolicyRuleBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<ResourcePolicyRule> buildResourceRules() {
        return this.resourceRules != null ? PolicyRulesWithSubjectsFluent.build(this.resourceRules) : null;
    }

    public ResourcePolicyRule buildResourceRule(int index) {
        return this.resourceRules.get(index).build();
    }

    public ResourcePolicyRule buildFirstResourceRule() {
        return this.resourceRules.get(0).build();
    }

    public ResourcePolicyRule buildLastResourceRule() {
        return this.resourceRules.get(this.resourceRules.size() - 1).build();
    }

    public ResourcePolicyRule buildMatchingResourceRule(Predicate<ResourcePolicyRuleBuilder> predicate) {
        for (ResourcePolicyRuleBuilder item : this.resourceRules) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingResourceRule(Predicate<ResourcePolicyRuleBuilder> predicate) {
        for (ResourcePolicyRuleBuilder item : this.resourceRules) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withResourceRules(List<ResourcePolicyRule> resourceRules) {
        if (this.resourceRules != null) {
            this._visitables.get("resourceRules").clear();
        }
        if (resourceRules != null) {
            this.resourceRules = new ArrayList();
            for (ResourcePolicyRule item : resourceRules) {
                this.addToResourceRules(item);
            }
        } else {
            this.resourceRules = null;
        }
        return (A)this;
    }

    public A withResourceRules(ResourcePolicyRule ... resourceRules) {
        if (this.resourceRules != null) {
            this.resourceRules.clear();
            this._visitables.remove("resourceRules");
        }
        if (resourceRules != null) {
            for (ResourcePolicyRule item : resourceRules) {
                this.addToResourceRules(item);
            }
        }
        return (A)this;
    }

    public boolean hasResourceRules() {
        return this.resourceRules != null && !this.resourceRules.isEmpty();
    }

    public ResourceRulesNested<A> addNewResourceRule() {
        return new ResourceRulesNested(-1, null);
    }

    public ResourceRulesNested<A> addNewResourceRuleLike(ResourcePolicyRule item) {
        return new ResourceRulesNested(-1, item);
    }

    public ResourceRulesNested<A> setNewResourceRuleLike(int index, ResourcePolicyRule item) {
        return new ResourceRulesNested(index, item);
    }

    public ResourceRulesNested<A> editResourceRule(int index) {
        if (this.resourceRules.size() <= index) {
            throw new RuntimeException("Can't edit resourceRules. Index exceeds size.");
        }
        return this.setNewResourceRuleLike(index, this.buildResourceRule(index));
    }

    public ResourceRulesNested<A> editFirstResourceRule() {
        if (this.resourceRules.size() == 0) {
            throw new RuntimeException("Can't edit first resourceRules. The list is empty.");
        }
        return this.setNewResourceRuleLike(0, this.buildResourceRule(0));
    }

    public ResourceRulesNested<A> editLastResourceRule() {
        int index = this.resourceRules.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last resourceRules. The list is empty.");
        }
        return this.setNewResourceRuleLike(index, this.buildResourceRule(index));
    }

    public ResourceRulesNested<A> editMatchingResourceRule(Predicate<ResourcePolicyRuleBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.resourceRules.size(); ++i) {
            if (!predicate.test(this.resourceRules.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching resourceRules. No match found.");
        }
        return this.setNewResourceRuleLike(index, this.buildResourceRule(index));
    }

    public A addToSubjects(int index, Subject item) {
        if (this.subjects == null) {
            this.subjects = new ArrayList();
        }
        SubjectBuilder builder = new SubjectBuilder(item);
        if (index < 0 || index >= this.subjects.size()) {
            this._visitables.get("subjects").add(builder);
            this.subjects.add(builder);
        } else {
            this._visitables.get("subjects").add(index, builder);
            this.subjects.add(index, builder);
        }
        return (A)this;
    }

    public A setToSubjects(int index, Subject item) {
        if (this.subjects == null) {
            this.subjects = new ArrayList();
        }
        SubjectBuilder builder = new SubjectBuilder(item);
        if (index < 0 || index >= this.subjects.size()) {
            this._visitables.get("subjects").add(builder);
            this.subjects.add(builder);
        } else {
            this._visitables.get("subjects").set(index, builder);
            this.subjects.set(index, builder);
        }
        return (A)this;
    }

    public A addToSubjects(Subject ... items) {
        if (this.subjects == null) {
            this.subjects = new ArrayList();
        }
        for (Subject item : items) {
            SubjectBuilder builder = new SubjectBuilder(item);
            this._visitables.get("subjects").add(builder);
            this.subjects.add(builder);
        }
        return (A)this;
    }

    public A addAllToSubjects(Collection<Subject> items) {
        if (this.subjects == null) {
            this.subjects = new ArrayList();
        }
        for (Subject item : items) {
            SubjectBuilder builder = new SubjectBuilder(item);
            this._visitables.get("subjects").add(builder);
            this.subjects.add(builder);
        }
        return (A)this;
    }

    public A removeFromSubjects(Subject ... items) {
        if (this.subjects == null) {
            return (A)this;
        }
        for (Subject item : items) {
            SubjectBuilder builder = new SubjectBuilder(item);
            this._visitables.get("subjects").remove(builder);
            this.subjects.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromSubjects(Collection<Subject> items) {
        if (this.subjects == null) {
            return (A)this;
        }
        for (Subject item : items) {
            SubjectBuilder builder = new SubjectBuilder(item);
            this._visitables.get("subjects").remove(builder);
            this.subjects.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromSubjects(Predicate<SubjectBuilder> predicate) {
        if (this.subjects == null) {
            return (A)this;
        }
        Iterator<SubjectBuilder> each = this.subjects.iterator();
        Object visitables = this._visitables.get("subjects");
        while (each.hasNext()) {
            SubjectBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<Subject> buildSubjects() {
        return this.subjects != null ? PolicyRulesWithSubjectsFluent.build(this.subjects) : null;
    }

    public Subject buildSubject(int index) {
        return this.subjects.get(index).build();
    }

    public Subject buildFirstSubject() {
        return this.subjects.get(0).build();
    }

    public Subject buildLastSubject() {
        return this.subjects.get(this.subjects.size() - 1).build();
    }

    public Subject buildMatchingSubject(Predicate<SubjectBuilder> predicate) {
        for (SubjectBuilder item : this.subjects) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingSubject(Predicate<SubjectBuilder> predicate) {
        for (SubjectBuilder item : this.subjects) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withSubjects(List<Subject> subjects) {
        if (this.subjects != null) {
            this._visitables.get("subjects").clear();
        }
        if (subjects != null) {
            this.subjects = new ArrayList();
            for (Subject item : subjects) {
                this.addToSubjects(item);
            }
        } else {
            this.subjects = null;
        }
        return (A)this;
    }

    public A withSubjects(Subject ... subjects) {
        if (this.subjects != null) {
            this.subjects.clear();
            this._visitables.remove("subjects");
        }
        if (subjects != null) {
            for (Subject item : subjects) {
                this.addToSubjects(item);
            }
        }
        return (A)this;
    }

    public boolean hasSubjects() {
        return this.subjects != null && !this.subjects.isEmpty();
    }

    public SubjectsNested<A> addNewSubject() {
        return new SubjectsNested(-1, null);
    }

    public SubjectsNested<A> addNewSubjectLike(Subject item) {
        return new SubjectsNested(-1, item);
    }

    public SubjectsNested<A> setNewSubjectLike(int index, Subject item) {
        return new SubjectsNested(index, item);
    }

    public SubjectsNested<A> editSubject(int index) {
        if (this.subjects.size() <= index) {
            throw new RuntimeException("Can't edit subjects. Index exceeds size.");
        }
        return this.setNewSubjectLike(index, this.buildSubject(index));
    }

    public SubjectsNested<A> editFirstSubject() {
        if (this.subjects.size() == 0) {
            throw new RuntimeException("Can't edit first subjects. The list is empty.");
        }
        return this.setNewSubjectLike(0, this.buildSubject(0));
    }

    public SubjectsNested<A> editLastSubject() {
        int index = this.subjects.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last subjects. The list is empty.");
        }
        return this.setNewSubjectLike(index, this.buildSubject(index));
    }

    public SubjectsNested<A> editMatchingSubject(Predicate<SubjectBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.subjects.size(); ++i) {
            if (!predicate.test(this.subjects.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching subjects. No match found.");
        }
        return this.setNewSubjectLike(index, this.buildSubject(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PolicyRulesWithSubjectsFluent that = (PolicyRulesWithSubjectsFluent)o;
        if (!Objects.equals(this.nonResourceRules, that.nonResourceRules)) {
            return false;
        }
        if (!Objects.equals(this.resourceRules, that.resourceRules)) {
            return false;
        }
        if (!Objects.equals(this.subjects, that.subjects)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.nonResourceRules, this.resourceRules, this.subjects, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.nonResourceRules != null && !this.nonResourceRules.isEmpty()) {
            sb.append("nonResourceRules:");
            sb.append(this.nonResourceRules + ",");
        }
        if (this.resourceRules != null && !this.resourceRules.isEmpty()) {
            sb.append("resourceRules:");
            sb.append(this.resourceRules + ",");
        }
        if (this.subjects != null && !this.subjects.isEmpty()) {
            sb.append("subjects:");
            sb.append(this.subjects + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class SubjectsNested<N>
    extends SubjectFluent<SubjectsNested<N>>
    implements Nested<N> {
        SubjectBuilder builder;
        int index;

        SubjectsNested(int index, Subject item) {
            this.index = index;
            this.builder = new SubjectBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PolicyRulesWithSubjectsFluent.this.setToSubjects(this.index, this.builder.build());
        }

        public N endSubject() {
            return this.and();
        }
    }

    public class ResourceRulesNested<N>
    extends ResourcePolicyRuleFluent<ResourceRulesNested<N>>
    implements Nested<N> {
        ResourcePolicyRuleBuilder builder;
        int index;

        ResourceRulesNested(int index, ResourcePolicyRule item) {
            this.index = index;
            this.builder = new ResourcePolicyRuleBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PolicyRulesWithSubjectsFluent.this.setToResourceRules(this.index, this.builder.build());
        }

        public N endResourceRule() {
            return this.and();
        }
    }

    public class NonResourceRulesNested<N>
    extends NonResourcePolicyRuleFluent<NonResourceRulesNested<N>>
    implements Nested<N> {
        NonResourcePolicyRuleBuilder builder;
        int index;

        NonResourceRulesNested(int index, NonResourcePolicyRule item) {
            this.index = index;
            this.builder = new NonResourcePolicyRuleBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PolicyRulesWithSubjectsFluent.this.setToNonResourceRules(this.index, this.builder.build());
        }

        public N endNonResourceRule() {
            return this.and();
        }
    }
}

