/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_8.autoscaling.v2beta1;

import io.fabric8.kubernetes.api.builder.v6_8.BaseFluent;
import io.fabric8.kubernetes.api.model.v6_8.Quantity;
import io.fabric8.kubernetes.api.model.v6_8.autoscaling.v2beta1.ResourceMetricStatus;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class ResourceMetricStatusFluent<A extends ResourceMetricStatusFluent<A>>
extends BaseFluent<A> {
    private Integer currentAverageUtilization;
    private Quantity currentAverageValue;
    private String name;
    private Map<String, Object> additionalProperties;

    public ResourceMetricStatusFluent() {
    }

    public ResourceMetricStatusFluent(ResourceMetricStatus instance) {
        ResourceMetricStatus resourceMetricStatus = instance = instance != null ? instance : new ResourceMetricStatus();
        if (instance != null) {
            this.withCurrentAverageUtilization(instance.getCurrentAverageUtilization());
            this.withCurrentAverageValue(instance.getCurrentAverageValue());
            this.withName(instance.getName());
            this.withCurrentAverageUtilization(instance.getCurrentAverageUtilization());
            this.withCurrentAverageValue(instance.getCurrentAverageValue());
            this.withName(instance.getName());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public Integer getCurrentAverageUtilization() {
        return this.currentAverageUtilization;
    }

    public A withCurrentAverageUtilization(Integer currentAverageUtilization) {
        this.currentAverageUtilization = currentAverageUtilization;
        return (A)this;
    }

    public boolean hasCurrentAverageUtilization() {
        return this.currentAverageUtilization != null;
    }

    public Quantity getCurrentAverageValue() {
        return this.currentAverageValue;
    }

    public A withCurrentAverageValue(Quantity currentAverageValue) {
        this.currentAverageValue = currentAverageValue;
        return (A)this;
    }

    public boolean hasCurrentAverageValue() {
        return this.currentAverageValue != null;
    }

    public A withNewCurrentAverageValue(String amount, String format) {
        return this.withCurrentAverageValue(new Quantity(amount, format));
    }

    public A withNewCurrentAverageValue(String amount) {
        return this.withCurrentAverageValue(new Quantity(amount));
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ResourceMetricStatusFluent that = (ResourceMetricStatusFluent)o;
        if (!Objects.equals(this.currentAverageUtilization, that.currentAverageUtilization)) {
            return false;
        }
        if (!Objects.equals(this.currentAverageValue, that.currentAverageValue)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.currentAverageUtilization, this.currentAverageValue, this.name, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.currentAverageUtilization != null) {
            sb.append("currentAverageUtilization:");
            sb.append(this.currentAverageUtilization + ",");
        }
        if (this.currentAverageValue != null) {
            sb.append("currentAverageValue:");
            sb.append(this.currentAverageValue + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

