/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_8;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.v6_8.ContainerState;
import io.fabric8.kubernetes.api.model.v6_8.KubernetesResource;
import io.fabric8.kubernetes.api.model.v6_8.Quantity;
import io.fabric8.kubernetes.api.model.v6_8.ResourceRequirements;
import java.util.LinkedHashMap;
import java.util.Map;

@JsonDeserialize(using=JsonDeserializer.None.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"apiVersion", "kind", "metadata", "allocatedResources", "containerID", "image", "imageID", "lastState", "name", "ready", "resources", "restartCount", "started", "state"})
public class ContainerStatus
implements KubernetesResource {
    @JsonProperty(value="allocatedResources")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private Map<String, Quantity> allocatedResources = new LinkedHashMap<String, Quantity>();
    @JsonProperty(value="containerID")
    private String containerID;
    @JsonProperty(value="image")
    private String image;
    @JsonProperty(value="imageID")
    private String imageID;
    @JsonProperty(value="lastState")
    private ContainerState lastState;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="ready")
    private Boolean ready;
    @JsonProperty(value="resources")
    private ResourceRequirements resources;
    @JsonProperty(value="restartCount")
    private Integer restartCount;
    @JsonProperty(value="started")
    private Boolean started;
    @JsonProperty(value="state")
    private ContainerState state;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

    public ContainerStatus() {
    }

    public ContainerStatus(Map<String, Quantity> allocatedResources, String containerID, String image, String imageID, ContainerState lastState, String name, Boolean ready, ResourceRequirements resources, Integer restartCount, Boolean started, ContainerState state) {
        this.allocatedResources = allocatedResources;
        this.containerID = containerID;
        this.image = image;
        this.imageID = imageID;
        this.lastState = lastState;
        this.name = name;
        this.ready = ready;
        this.resources = resources;
        this.restartCount = restartCount;
        this.started = started;
        this.state = state;
    }

    @JsonProperty(value="allocatedResources")
    public Map<String, Quantity> getAllocatedResources() {
        return this.allocatedResources;
    }

    @JsonProperty(value="allocatedResources")
    public void setAllocatedResources(Map<String, Quantity> allocatedResources) {
        this.allocatedResources = allocatedResources;
    }

    @JsonProperty(value="containerID")
    public String getContainerID() {
        return this.containerID;
    }

    @JsonProperty(value="containerID")
    public void setContainerID(String containerID) {
        this.containerID = containerID;
    }

    @JsonProperty(value="image")
    public String getImage() {
        return this.image;
    }

    @JsonProperty(value="image")
    public void setImage(String image) {
        this.image = image;
    }

    @JsonProperty(value="imageID")
    public String getImageID() {
        return this.imageID;
    }

    @JsonProperty(value="imageID")
    public void setImageID(String imageID) {
        this.imageID = imageID;
    }

    @JsonProperty(value="lastState")
    public ContainerState getLastState() {
        return this.lastState;
    }

    @JsonProperty(value="lastState")
    public void setLastState(ContainerState lastState) {
        this.lastState = lastState;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="ready")
    public Boolean getReady() {
        return this.ready;
    }

    @JsonProperty(value="ready")
    public void setReady(Boolean ready) {
        this.ready = ready;
    }

    @JsonProperty(value="resources")
    public ResourceRequirements getResources() {
        return this.resources;
    }

    @JsonProperty(value="resources")
    public void setResources(ResourceRequirements resources) {
        this.resources = resources;
    }

    @JsonProperty(value="restartCount")
    public Integer getRestartCount() {
        return this.restartCount;
    }

    @JsonProperty(value="restartCount")
    public void setRestartCount(Integer restartCount) {
        this.restartCount = restartCount;
    }

    @JsonProperty(value="started")
    public Boolean getStarted() {
        return this.started;
    }

    @JsonProperty(value="started")
    public void setStarted(Boolean started) {
        this.started = started;
    }

    @JsonProperty(value="state")
    public ContainerState getState() {
        return this.state;
    }

    @JsonProperty(value="state")
    public void setState(ContainerState state) {
        this.state = state;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public String toString() {
        return "ContainerStatus(allocatedResources=" + this.getAllocatedResources() + ", containerID=" + this.getContainerID() + ", image=" + this.getImage() + ", imageID=" + this.getImageID() + ", lastState=" + this.getLastState() + ", name=" + this.getName() + ", ready=" + this.getReady() + ", resources=" + this.getResources() + ", restartCount=" + this.getRestartCount() + ", started=" + this.getStarted() + ", state=" + this.getState() + ", additionalProperties=" + this.getAdditionalProperties() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContainerStatus)) {
            return false;
        }
        ContainerStatus other = (ContainerStatus)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$ready = this.getReady();
        Boolean other$ready = other.getReady();
        if (this$ready == null ? other$ready != null : !((Object)this$ready).equals(other$ready)) {
            return false;
        }
        Integer this$restartCount = this.getRestartCount();
        Integer other$restartCount = other.getRestartCount();
        if (this$restartCount == null ? other$restartCount != null : !((Object)this$restartCount).equals(other$restartCount)) {
            return false;
        }
        Boolean this$started = this.getStarted();
        Boolean other$started = other.getStarted();
        if (this$started == null ? other$started != null : !((Object)this$started).equals(other$started)) {
            return false;
        }
        Map<String, Quantity> this$allocatedResources = this.getAllocatedResources();
        Map<String, Quantity> other$allocatedResources = other.getAllocatedResources();
        if (this$allocatedResources == null ? other$allocatedResources != null : !((Object)this$allocatedResources).equals(other$allocatedResources)) {
            return false;
        }
        String this$containerID = this.getContainerID();
        String other$containerID = other.getContainerID();
        if (this$containerID == null ? other$containerID != null : !this$containerID.equals(other$containerID)) {
            return false;
        }
        String this$image = this.getImage();
        String other$image = other.getImage();
        if (this$image == null ? other$image != null : !this$image.equals(other$image)) {
            return false;
        }
        String this$imageID = this.getImageID();
        String other$imageID = other.getImageID();
        if (this$imageID == null ? other$imageID != null : !this$imageID.equals(other$imageID)) {
            return false;
        }
        ContainerState this$lastState = this.getLastState();
        ContainerState other$lastState = other.getLastState();
        if (this$lastState == null ? other$lastState != null : !((Object)this$lastState).equals(other$lastState)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        ResourceRequirements this$resources = this.getResources();
        ResourceRequirements other$resources = other.getResources();
        if (this$resources == null ? other$resources != null : !((Object)this$resources).equals(other$resources)) {
            return false;
        }
        ContainerState this$state = this.getState();
        ContainerState other$state = other.getState();
        if (this$state == null ? other$state != null : !((Object)this$state).equals(other$state)) {
            return false;
        }
        Map<String, Object> this$additionalProperties = this.getAdditionalProperties();
        Map<String, Object> other$additionalProperties = other.getAdditionalProperties();
        return !(this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ContainerStatus;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $ready = this.getReady();
        result = result * 59 + ($ready == null ? 43 : ((Object)$ready).hashCode());
        Integer $restartCount = this.getRestartCount();
        result = result * 59 + ($restartCount == null ? 43 : ((Object)$restartCount).hashCode());
        Boolean $started = this.getStarted();
        result = result * 59 + ($started == null ? 43 : ((Object)$started).hashCode());
        Map<String, Quantity> $allocatedResources = this.getAllocatedResources();
        result = result * 59 + ($allocatedResources == null ? 43 : ((Object)$allocatedResources).hashCode());
        String $containerID = this.getContainerID();
        result = result * 59 + ($containerID == null ? 43 : $containerID.hashCode());
        String $image = this.getImage();
        result = result * 59 + ($image == null ? 43 : $image.hashCode());
        String $imageID = this.getImageID();
        result = result * 59 + ($imageID == null ? 43 : $imageID.hashCode());
        ContainerState $lastState = this.getLastState();
        result = result * 59 + ($lastState == null ? 43 : ((Object)$lastState).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        ResourceRequirements $resources = this.getResources();
        result = result * 59 + ($resources == null ? 43 : ((Object)$resources).hashCode());
        ContainerState $state = this.getState();
        result = result * 59 + ($state == null ? 43 : ((Object)$state).hashCode());
        Map<String, Object> $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 43 : ((Object)$additionalProperties).hashCode());
        return result;
    }

    @JsonIgnore
    public void setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
    }
}

