/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v6_7.server.mock.crud;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.fabric8.kubernetes.api.model.v6_7.GenericKubernetesResource;
import io.fabric8.kubernetes.clnt.v6_7.server.mock.crud.KubernetesCrudDispatcherException;
import io.fabric8.kubernetes.clnt.v6_7.utils.Serialization;
import io.fabric8.kubernetes.clnt.v6_7.utils.Utils;
import io.fabric8.mockwebserver.crud.AttributeSet;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.RecordedRequest;

@FunctionalInterface
public interface KubernetesCrudDispatcherHandler {
    public static final int HTTP_UNPROCESSABLE_ENTITY = 422;
    public static final String KIND = "kind";
    public static final String STATUS = "status";

    default public MockResponse handle(RecordedRequest request) throws KubernetesCrudDispatcherException {
        String path = request.getPath();
        String contentType = request.getHeader("Content-Type");
        String requestBody = request.getBody().readUtf8();
        return this.handle(path, contentType, requestBody);
    }

    public MockResponse handle(String var1, String var2, String var3) throws KubernetesCrudDispatcherException;

    default public void validatePath(AttributeSet query, JsonNode updatedResource) throws KubernetesCrudDispatcherException {
        String updatedName = updatedResource.path("metadata").path("name").asText();
        String pathName = query.getAttribute("name").getValue().toString();
        if (!updatedName.isEmpty() && !pathName.equals(updatedName)) {
            throw new KubernetesCrudDispatcherException("the name of the object (" + updatedName + ") does not match the name on the URL (" + pathName + ")", 400, updatedResource.path(KIND).asText(), new String[0]);
        }
        if (query.getAttribute("namespace") != null) {
            String updatedNamespace = updatedResource.path("metadata").path("namespace").asText();
            String pathNamespace = query.getAttribute("namespace").getValue().toString();
            if (!updatedNamespace.isEmpty() && !updatedNamespace.equals(pathNamespace)) {
                throw new KubernetesCrudDispatcherException("the namespace of the object (" + updatedNamespace + ") does not match the namespace on the URL (" + pathNamespace + ")", 400, updatedResource.path(KIND).asText(), new String[0]);
            }
        }
    }

    default public void validateResourceVersion(JsonNode currentResource, JsonNode updatedResource) throws KubernetesCrudDispatcherException {
        String currentVersion = currentResource.path("metadata").path("resourceVersion").asText();
        String updateBasedOnVersion = updatedResource.path("metadata").path("resourceVersion").asText();
        if (!updateBasedOnVersion.isEmpty() && !currentVersion.equals(updateBasedOnVersion)) {
            String kind = updatedResource.path(KIND).asText();
            String name = updatedResource.path("metadata").path("name").asText();
            throw new KubernetesCrudDispatcherException(String.format("Operation cannot be fulfilled on %s \"%s\": the object has been modified; please apply your changes to the latest version and try again", kind, name), 409, kind, new String[0]);
        }
    }

    default public GenericKubernetesResource validateRequestBody(String requestBody) throws KubernetesCrudDispatcherException {
        GenericKubernetesResource resource = (GenericKubernetesResource)Serialization.unmarshal((String)requestBody, GenericKubernetesResource.class);
        if (resource == null) {
            throw new KubernetesCrudDispatcherException("No resource or invalid resource provided", 400);
        }
        String kind = resource.getKind();
        if (Utils.isNullOrEmpty((String)kind)) {
            throw new KubernetesCrudDispatcherException("Invalid", 422, null, KIND);
        }
        if (Utils.isNullOrEmpty((String)resource.getApiVersion())) {
            throw new KubernetesCrudDispatcherException(kind + " is invalid", 422, kind, "apiVersion");
        }
        if (resource.getMetadata() == null) {
            throw new KubernetesCrudDispatcherException(kind + " is invalid", 422, kind, "metadata");
        }
        if (Utils.isNullOrEmpty((String)resource.getMetadata().getName()) && Utils.isNullOrEmpty((String)resource.getMetadata().getGenerateName())) {
            throw new KubernetesCrudDispatcherException(kind + " is invalid", 422, kind, "name or generateName");
        }
        return resource;
    }

    public static boolean isStatusPath(String path) {
        return path.endsWith("/status");
    }

    public static void setStatus(JsonNode source, JsonNode status) {
        if (status != null) {
            ((ObjectNode)source).set(STATUS, status);
        } else {
            ((ObjectNode)source).remove(STATUS);
        }
    }
}

