/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v6_7.server.mock.crud;

import io.fabric8.kubernetes.api.model.v6_7.Status;
import io.fabric8.kubernetes.api.model.v6_7.StatusBuilder;
import io.fabric8.kubernetes.api.model.v6_7.StatusCause;
import io.fabric8.kubernetes.api.model.v6_7.StatusCauseBuilder;
import io.fabric8.kubernetes.api.model.v6_7.StatusFluent;
import io.fabric8.kubernetes.clnt.v6_7.utils.Serialization;
import io.fabric8.kubernetes.clnt.v6_7.utils.Utils;
import java.util.Arrays;
import java.util.stream.Collectors;

public class KubernetesCrudDispatcherException
extends Exception {
    private final Integer code;
    private final String kind;
    private final String[] requiredFields;

    public KubernetesCrudDispatcherException(String message, Integer code) {
        this(message, code, null, new String[0]);
    }

    public KubernetesCrudDispatcherException(String message, Integer code, String kind, String ... requiredFields) {
        super(message);
        this.code = code;
        this.kind = Utils.isNullOrEmpty((String)kind) ? "Unknown" : kind;
        this.requiredFields = requiredFields;
    }

    public int getCode() {
        return this.code == null ? 400 : this.code;
    }

    public Status toStatus() {
        return ((StatusBuilder)((StatusBuilder)((StatusFluent.DetailsNested)((StatusFluent.DetailsNested)((StatusBuilder)((StatusBuilder)((StatusBuilder)new StatusBuilder().withStatus("Failure")).withReason("Invalid")).withMessage(this.getMessage())).withNewDetails().withKind(this.kind)).withCauses(Arrays.stream(this.requiredFields).map(KubernetesCrudDispatcherException::toStatusCause).collect(Collectors.toList()))).endDetails()).withCode(this.getCode())).build();
    }

    public String toStatusBody() {
        return Serialization.asJson((Object)this.toStatus());
    }

    private static StatusCause toStatusCause(String requiredField) {
        return ((StatusCauseBuilder)((StatusCauseBuilder)new StatusCauseBuilder().withMessage("Required value: " + requiredField + " is required")).withReason("ValueRequired")).build();
    }
}

