/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v6_7.impl;

import io.fabric8.kubernetes.api.model.v6_7.Service;
import io.fabric8.kubernetes.api.model.v6_7.ServicePort;
import io.fabric8.kubernetes.api.model.v6_7.networking.v1.Ingress;
import io.fabric8.kubernetes.api.model.v6_7.networking.v1.IngressList;
import io.fabric8.kubernetes.clnt.v6_7.KubernetesClient;
import io.fabric8.kubernetes.clnt.v6_7.ServiceToURLProvider;
import io.fabric8.kubernetes.clnt.v6_7.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.clnt.v6_7.utils.internal.URLFromServiceUtil;

public class URLFromIngressImpl
implements ServiceToURLProvider {
    public String getURL(Service service, String portName, String namespace, KubernetesClient client) {
        IngressList ingresses;
        ServicePort port = URLFromServiceUtil.getServicePortByName(service, portName);
        String serviceName = service.getMetadata().getName();
        if (port == null) {
            throw new RuntimeException("Couldn't find port: " + portName + " for service " + service.getMetadata().getName());
        }
        if (client.supports(io.fabric8.kubernetes.api.model.v6_7.extensions.Ingress.class)) {
            io.fabric8.kubernetes.api.model.v6_7.extensions.IngressList ingresses2 = (io.fabric8.kubernetes.api.model.v6_7.extensions.IngressList)((NonNamespaceOperation)client.extensions().ingresses().inNamespace(namespace)).list();
            if (ingresses2 != null && !ingresses2.getItems().isEmpty()) {
                return URLFromServiceUtil.getURLFromExtensionsV1beta1IngressList(ingresses2.getItems(), namespace, serviceName, port);
            }
        } else if (client.supports(Ingress.class) && (ingresses = (IngressList)((NonNamespaceOperation)client.network().v1().ingresses().inNamespace(namespace)).list()) != null && !ingresses.getItems().isEmpty()) {
            return URLFromServiceUtil.getURLFromNetworkingV1IngressList(ingresses.getItems(), namespace, serviceName, port);
        }
        return null;
    }

    public int getPriority() {
        return ServiceToURLProvider.ServiceToUrlImplPriority.FIRST.getValue();
    }
}

