/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_7.resource.v1alpha1;

import io.fabric8.kubernetes.api.builder.v6_7.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_7.Nested;
import io.fabric8.kubernetes.api.model.v6_7.resource.v1alpha1.ResourceClaimParametersReference;
import io.fabric8.kubernetes.api.model.v6_7.resource.v1alpha1.ResourceClaimParametersReferenceBuilder;
import io.fabric8.kubernetes.api.model.v6_7.resource.v1alpha1.ResourceClaimParametersReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.v6_7.resource.v1alpha1.ResourceClaimSpec;
import io.fabric8.kubernetes.api.model.v6_7.resource.v1alpha1.ResourceClaimSpecFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class ResourceClaimSpecFluentImpl<A extends ResourceClaimSpecFluent<A>>
extends BaseFluent<A>
implements ResourceClaimSpecFluent<A> {
    private String allocationMode;
    private ResourceClaimParametersReferenceBuilder parametersRef;
    private String resourceClassName;
    private Map<String, Object> additionalProperties;

    public ResourceClaimSpecFluentImpl() {
    }

    public ResourceClaimSpecFluentImpl(ResourceClaimSpec instance) {
        if (instance != null) {
            this.withAllocationMode(instance.getAllocationMode());
            this.withParametersRef(instance.getParametersRef());
            this.withResourceClassName(instance.getResourceClassName());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    @Override
    public String getAllocationMode() {
        return this.allocationMode;
    }

    @Override
    public A withAllocationMode(String allocationMode) {
        this.allocationMode = allocationMode;
        return (A)this;
    }

    @Override
    public Boolean hasAllocationMode() {
        return this.allocationMode != null;
    }

    @Override
    @Deprecated
    public ResourceClaimParametersReference getParametersRef() {
        return this.parametersRef != null ? this.parametersRef.build() : null;
    }

    @Override
    public ResourceClaimParametersReference buildParametersRef() {
        return this.parametersRef != null ? this.parametersRef.build() : null;
    }

    @Override
    public A withParametersRef(ResourceClaimParametersReference parametersRef) {
        this._visitables.get("parametersRef").remove(this.parametersRef);
        if (parametersRef != null) {
            this.parametersRef = new ResourceClaimParametersReferenceBuilder(parametersRef);
            this._visitables.get("parametersRef").add(this.parametersRef);
        } else {
            this.parametersRef = null;
            this._visitables.get("parametersRef").remove(this.parametersRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasParametersRef() {
        return this.parametersRef != null;
    }

    @Override
    public A withNewParametersRef(String apiGroup, String kind, String name) {
        return this.withParametersRef(new ResourceClaimParametersReference(apiGroup, kind, name));
    }

    @Override
    public ResourceClaimSpecFluent.ParametersRefNested<A> withNewParametersRef() {
        return new ParametersRefNestedImpl();
    }

    @Override
    public ResourceClaimSpecFluent.ParametersRefNested<A> withNewParametersRefLike(ResourceClaimParametersReference item) {
        return new ParametersRefNestedImpl(item);
    }

    @Override
    public ResourceClaimSpecFluent.ParametersRefNested<A> editParametersRef() {
        return this.withNewParametersRefLike(this.getParametersRef());
    }

    @Override
    public ResourceClaimSpecFluent.ParametersRefNested<A> editOrNewParametersRef() {
        return this.withNewParametersRefLike(this.getParametersRef() != null ? this.getParametersRef() : new ResourceClaimParametersReferenceBuilder().build());
    }

    @Override
    public ResourceClaimSpecFluent.ParametersRefNested<A> editOrNewParametersRefLike(ResourceClaimParametersReference item) {
        return this.withNewParametersRefLike(this.getParametersRef() != null ? this.getParametersRef() : item);
    }

    @Override
    public String getResourceClassName() {
        return this.resourceClassName;
    }

    @Override
    public A withResourceClassName(String resourceClassName) {
        this.resourceClassName = resourceClassName;
        return (A)this;
    }

    @Override
    public Boolean hasResourceClassName() {
        return this.resourceClassName != null;
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ResourceClaimSpecFluentImpl that = (ResourceClaimSpecFluentImpl)o;
        if (!Objects.equals(this.allocationMode, that.allocationMode)) {
            return false;
        }
        if (!Objects.equals(this.parametersRef, that.parametersRef)) {
            return false;
        }
        if (!Objects.equals(this.resourceClassName, that.resourceClassName)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.allocationMode, this.parametersRef, this.resourceClassName, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.allocationMode != null) {
            sb.append("allocationMode:");
            sb.append(this.allocationMode + ",");
        }
        if (this.parametersRef != null) {
            sb.append("parametersRef:");
            sb.append(this.parametersRef + ",");
        }
        if (this.resourceClassName != null) {
            sb.append("resourceClassName:");
            sb.append(this.resourceClassName + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class ParametersRefNestedImpl<N>
    extends ResourceClaimParametersReferenceFluentImpl<ResourceClaimSpecFluent.ParametersRefNested<N>>
    implements ResourceClaimSpecFluent.ParametersRefNested<N>,
    Nested<N> {
        ResourceClaimParametersReferenceBuilder builder;

        ParametersRefNestedImpl(ResourceClaimParametersReference item) {
            this.builder = new ResourceClaimParametersReferenceBuilder(this, item);
        }

        ParametersRefNestedImpl() {
            this.builder = new ResourceClaimParametersReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)ResourceClaimSpecFluentImpl.this.withParametersRef(this.builder.build());
        }

        @Override
        public N endParametersRef() {
            return this.and();
        }
    }
}

