/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_7.gatewayapi.v1beta1;

import io.fabric8.kubernetes.api.builder.v6_7.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_7.Nested;
import io.fabric8.kubernetes.api.model.v6_7.gatewayapi.v1beta1.GatewayAddress;
import io.fabric8.kubernetes.api.model.v6_7.gatewayapi.v1beta1.GatewayAddressBuilder;
import io.fabric8.kubernetes.api.model.v6_7.gatewayapi.v1beta1.GatewayAddressFluentImpl;
import io.fabric8.kubernetes.api.model.v6_7.gatewayapi.v1beta1.GatewaySpec;
import io.fabric8.kubernetes.api.model.v6_7.gatewayapi.v1beta1.GatewaySpecFluent;
import io.fabric8.kubernetes.api.model.v6_7.gatewayapi.v1beta1.Listener;
import io.fabric8.kubernetes.api.model.v6_7.gatewayapi.v1beta1.ListenerBuilder;
import io.fabric8.kubernetes.api.model.v6_7.gatewayapi.v1beta1.ListenerFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class GatewaySpecFluentImpl<A extends GatewaySpecFluent<A>>
extends BaseFluent<A>
implements GatewaySpecFluent<A> {
    private ArrayList<GatewayAddressBuilder> addresses = new ArrayList();
    private String gatewayClassName;
    private ArrayList<ListenerBuilder> listeners = new ArrayList();
    private Map<String, Object> additionalProperties;

    public GatewaySpecFluentImpl() {
    }

    public GatewaySpecFluentImpl(GatewaySpec instance) {
        if (instance != null) {
            this.withAddresses(instance.getAddresses());
            this.withGatewayClassName(instance.getGatewayClassName());
            this.withListeners(instance.getListeners());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    @Override
    public A addToAddresses(int index, GatewayAddress item) {
        if (this.addresses == null) {
            this.addresses = new ArrayList();
        }
        GatewayAddressBuilder builder = new GatewayAddressBuilder(item);
        if (index < 0 || index >= this.addresses.size()) {
            this._visitables.get("addresses").add(builder);
            this.addresses.add(builder);
        } else {
            this._visitables.get("addresses").add(index, builder);
            this.addresses.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToAddresses(int index, GatewayAddress item) {
        if (this.addresses == null) {
            this.addresses = new ArrayList();
        }
        GatewayAddressBuilder builder = new GatewayAddressBuilder(item);
        if (index < 0 || index >= this.addresses.size()) {
            this._visitables.get("addresses").add(builder);
            this.addresses.add(builder);
        } else {
            this._visitables.get("addresses").set(index, builder);
            this.addresses.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToAddresses(GatewayAddress ... items) {
        if (this.addresses == null) {
            this.addresses = new ArrayList();
        }
        for (GatewayAddress item : items) {
            GatewayAddressBuilder builder = new GatewayAddressBuilder(item);
            this._visitables.get("addresses").add(builder);
            this.addresses.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToAddresses(Collection<GatewayAddress> items) {
        if (this.addresses == null) {
            this.addresses = new ArrayList();
        }
        for (GatewayAddress item : items) {
            GatewayAddressBuilder builder = new GatewayAddressBuilder(item);
            this._visitables.get("addresses").add(builder);
            this.addresses.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromAddresses(GatewayAddress ... items) {
        for (GatewayAddress item : items) {
            GatewayAddressBuilder builder = new GatewayAddressBuilder(item);
            this._visitables.get("addresses").remove(builder);
            if (this.addresses == null) continue;
            this.addresses.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAddresses(Collection<GatewayAddress> items) {
        for (GatewayAddress item : items) {
            GatewayAddressBuilder builder = new GatewayAddressBuilder(item);
            this._visitables.get("addresses").remove(builder);
            if (this.addresses == null) continue;
            this.addresses.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromAddresses(Predicate<GatewayAddressBuilder> predicate) {
        if (this.addresses == null) {
            return (A)this;
        }
        Iterator<GatewayAddressBuilder> each = this.addresses.iterator();
        Object visitables = this._visitables.get("addresses");
        while (each.hasNext()) {
            GatewayAddressBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<GatewayAddress> getAddresses() {
        return this.addresses != null ? GatewaySpecFluentImpl.build(this.addresses) : null;
    }

    @Override
    public List<GatewayAddress> buildAddresses() {
        return this.addresses != null ? GatewaySpecFluentImpl.build(this.addresses) : null;
    }

    @Override
    public GatewayAddress buildAddress(int index) {
        return this.addresses.get(index).build();
    }

    @Override
    public GatewayAddress buildFirstAddress() {
        return this.addresses.get(0).build();
    }

    @Override
    public GatewayAddress buildLastAddress() {
        return this.addresses.get(this.addresses.size() - 1).build();
    }

    @Override
    public GatewayAddress buildMatchingAddress(Predicate<GatewayAddressBuilder> predicate) {
        for (GatewayAddressBuilder item : this.addresses) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingAddress(Predicate<GatewayAddressBuilder> predicate) {
        for (GatewayAddressBuilder item : this.addresses) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withAddresses(List<GatewayAddress> addresses) {
        if (this.addresses != null) {
            this._visitables.get("addresses").clear();
        }
        if (addresses != null) {
            this.addresses = new ArrayList();
            for (GatewayAddress item : addresses) {
                this.addToAddresses(item);
            }
        } else {
            this.addresses = null;
        }
        return (A)this;
    }

    @Override
    public A withAddresses(GatewayAddress ... addresses) {
        if (this.addresses != null) {
            this.addresses.clear();
            this._visitables.remove("addresses");
        }
        if (addresses != null) {
            for (GatewayAddress item : addresses) {
                this.addToAddresses(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasAddresses() {
        return this.addresses != null && !this.addresses.isEmpty();
    }

    @Override
    public A addNewAddress(String type, String value) {
        return this.addToAddresses(new GatewayAddress(type, value));
    }

    @Override
    public GatewaySpecFluent.AddressesNested<A> addNewAddress() {
        return new AddressesNestedImpl();
    }

    @Override
    public GatewaySpecFluent.AddressesNested<A> addNewAddressLike(GatewayAddress item) {
        return new AddressesNestedImpl(-1, item);
    }

    @Override
    public GatewaySpecFluent.AddressesNested<A> setNewAddressLike(int index, GatewayAddress item) {
        return new AddressesNestedImpl(index, item);
    }

    @Override
    public GatewaySpecFluent.AddressesNested<A> editAddress(int index) {
        if (this.addresses.size() <= index) {
            throw new RuntimeException("Can't edit addresses. Index exceeds size.");
        }
        return this.setNewAddressLike(index, this.buildAddress(index));
    }

    @Override
    public GatewaySpecFluent.AddressesNested<A> editFirstAddress() {
        if (this.addresses.size() == 0) {
            throw new RuntimeException("Can't edit first addresses. The list is empty.");
        }
        return this.setNewAddressLike(0, this.buildAddress(0));
    }

    @Override
    public GatewaySpecFluent.AddressesNested<A> editLastAddress() {
        int index = this.addresses.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last addresses. The list is empty.");
        }
        return this.setNewAddressLike(index, this.buildAddress(index));
    }

    @Override
    public GatewaySpecFluent.AddressesNested<A> editMatchingAddress(Predicate<GatewayAddressBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.addresses.size(); ++i) {
            if (!predicate.test(this.addresses.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching addresses. No match found.");
        }
        return this.setNewAddressLike(index, this.buildAddress(index));
    }

    @Override
    public String getGatewayClassName() {
        return this.gatewayClassName;
    }

    @Override
    public A withGatewayClassName(String gatewayClassName) {
        this.gatewayClassName = gatewayClassName;
        return (A)this;
    }

    @Override
    public Boolean hasGatewayClassName() {
        return this.gatewayClassName != null;
    }

    @Override
    public A addToListeners(int index, Listener item) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        ListenerBuilder builder = new ListenerBuilder(item);
        if (index < 0 || index >= this.listeners.size()) {
            this._visitables.get("listeners").add(builder);
            this.listeners.add(builder);
        } else {
            this._visitables.get("listeners").add(index, builder);
            this.listeners.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToListeners(int index, Listener item) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        ListenerBuilder builder = new ListenerBuilder(item);
        if (index < 0 || index >= this.listeners.size()) {
            this._visitables.get("listeners").add(builder);
            this.listeners.add(builder);
        } else {
            this._visitables.get("listeners").set(index, builder);
            this.listeners.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToListeners(Listener ... items) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        for (Listener item : items) {
            ListenerBuilder builder = new ListenerBuilder(item);
            this._visitables.get("listeners").add(builder);
            this.listeners.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToListeners(Collection<Listener> items) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        for (Listener item : items) {
            ListenerBuilder builder = new ListenerBuilder(item);
            this._visitables.get("listeners").add(builder);
            this.listeners.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromListeners(Listener ... items) {
        for (Listener item : items) {
            ListenerBuilder builder = new ListenerBuilder(item);
            this._visitables.get("listeners").remove(builder);
            if (this.listeners == null) continue;
            this.listeners.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromListeners(Collection<Listener> items) {
        for (Listener item : items) {
            ListenerBuilder builder = new ListenerBuilder(item);
            this._visitables.get("listeners").remove(builder);
            if (this.listeners == null) continue;
            this.listeners.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromListeners(Predicate<ListenerBuilder> predicate) {
        if (this.listeners == null) {
            return (A)this;
        }
        Iterator<ListenerBuilder> each = this.listeners.iterator();
        Object visitables = this._visitables.get("listeners");
        while (each.hasNext()) {
            ListenerBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Listener> getListeners() {
        return this.listeners != null ? GatewaySpecFluentImpl.build(this.listeners) : null;
    }

    @Override
    public List<Listener> buildListeners() {
        return this.listeners != null ? GatewaySpecFluentImpl.build(this.listeners) : null;
    }

    @Override
    public Listener buildListener(int index) {
        return this.listeners.get(index).build();
    }

    @Override
    public Listener buildFirstListener() {
        return this.listeners.get(0).build();
    }

    @Override
    public Listener buildLastListener() {
        return this.listeners.get(this.listeners.size() - 1).build();
    }

    @Override
    public Listener buildMatchingListener(Predicate<ListenerBuilder> predicate) {
        for (ListenerBuilder item : this.listeners) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingListener(Predicate<ListenerBuilder> predicate) {
        for (ListenerBuilder item : this.listeners) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withListeners(List<Listener> listeners) {
        if (this.listeners != null) {
            this._visitables.get("listeners").clear();
        }
        if (listeners != null) {
            this.listeners = new ArrayList();
            for (Listener item : listeners) {
                this.addToListeners(item);
            }
        } else {
            this.listeners = null;
        }
        return (A)this;
    }

    @Override
    public A withListeners(Listener ... listeners) {
        if (this.listeners != null) {
            this.listeners.clear();
            this._visitables.remove("listeners");
        }
        if (listeners != null) {
            for (Listener item : listeners) {
                this.addToListeners(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasListeners() {
        return this.listeners != null && !this.listeners.isEmpty();
    }

    @Override
    public GatewaySpecFluent.ListenersNested<A> addNewListener() {
        return new ListenersNestedImpl();
    }

    @Override
    public GatewaySpecFluent.ListenersNested<A> addNewListenerLike(Listener item) {
        return new ListenersNestedImpl(-1, item);
    }

    @Override
    public GatewaySpecFluent.ListenersNested<A> setNewListenerLike(int index, Listener item) {
        return new ListenersNestedImpl(index, item);
    }

    @Override
    public GatewaySpecFluent.ListenersNested<A> editListener(int index) {
        if (this.listeners.size() <= index) {
            throw new RuntimeException("Can't edit listeners. Index exceeds size.");
        }
        return this.setNewListenerLike(index, this.buildListener(index));
    }

    @Override
    public GatewaySpecFluent.ListenersNested<A> editFirstListener() {
        if (this.listeners.size() == 0) {
            throw new RuntimeException("Can't edit first listeners. The list is empty.");
        }
        return this.setNewListenerLike(0, this.buildListener(0));
    }

    @Override
    public GatewaySpecFluent.ListenersNested<A> editLastListener() {
        int index = this.listeners.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last listeners. The list is empty.");
        }
        return this.setNewListenerLike(index, this.buildListener(index));
    }

    @Override
    public GatewaySpecFluent.ListenersNested<A> editMatchingListener(Predicate<ListenerBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.listeners.size(); ++i) {
            if (!predicate.test(this.listeners.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching listeners. No match found.");
        }
        return this.setNewListenerLike(index, this.buildListener(index));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GatewaySpecFluentImpl that = (GatewaySpecFluentImpl)o;
        if (!Objects.equals(this.addresses, that.addresses)) {
            return false;
        }
        if (!Objects.equals(this.gatewayClassName, that.gatewayClassName)) {
            return false;
        }
        if (!Objects.equals(this.listeners, that.listeners)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.addresses, this.gatewayClassName, this.listeners, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.addresses != null) {
            sb.append("addresses:");
            sb.append(this.addresses + ",");
        }
        if (this.gatewayClassName != null) {
            sb.append("gatewayClassName:");
            sb.append(this.gatewayClassName + ",");
        }
        if (this.listeners != null) {
            sb.append("listeners:");
            sb.append(this.listeners + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class ListenersNestedImpl<N>
    extends ListenerFluentImpl<GatewaySpecFluent.ListenersNested<N>>
    implements GatewaySpecFluent.ListenersNested<N>,
    Nested<N> {
        ListenerBuilder builder;
        int index;

        ListenersNestedImpl(int index, Listener item) {
            this.index = index;
            this.builder = new ListenerBuilder(this, item);
        }

        ListenersNestedImpl() {
            this.index = -1;
            this.builder = new ListenerBuilder(this);
        }

        @Override
        public N and() {
            return (N)GatewaySpecFluentImpl.this.setToListeners(this.index, this.builder.build());
        }

        @Override
        public N endListener() {
            return this.and();
        }
    }

    class AddressesNestedImpl<N>
    extends GatewayAddressFluentImpl<GatewaySpecFluent.AddressesNested<N>>
    implements GatewaySpecFluent.AddressesNested<N>,
    Nested<N> {
        GatewayAddressBuilder builder;
        int index;

        AddressesNestedImpl(int index, GatewayAddress item) {
            this.index = index;
            this.builder = new GatewayAddressBuilder(this, item);
        }

        AddressesNestedImpl() {
            this.index = -1;
            this.builder = new GatewayAddressBuilder(this);
        }

        @Override
        public N and() {
            return (N)GatewaySpecFluentImpl.this.setToAddresses(this.index, this.builder.build());
        }

        @Override
        public N endAddress() {
            return this.and();
        }
    }
}

