/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_7.autoscaling.v1;

import io.fabric8.kubernetes.api.builder.v6_7.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v6_7.autoscaling.v1.ScaleSpec;
import io.fabric8.kubernetes.api.model.v6_7.autoscaling.v1.ScaleSpecFluent;
import io.fabric8.kubernetes.api.model.v6_7.autoscaling.v1.ScaleSpecFluentImpl;

public class ScaleSpecBuilder
extends ScaleSpecFluentImpl<ScaleSpecBuilder>
implements VisitableBuilder<ScaleSpec, ScaleSpecBuilder> {
    ScaleSpecFluent<?> fluent;
    Boolean validationEnabled;

    public ScaleSpecBuilder() {
        this(false);
    }

    public ScaleSpecBuilder(Boolean validationEnabled) {
        this(new ScaleSpec(), validationEnabled);
    }

    public ScaleSpecBuilder(ScaleSpecFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public ScaleSpecBuilder(ScaleSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ScaleSpec(), validationEnabled);
    }

    public ScaleSpecBuilder(ScaleSpecFluent<?> fluent, ScaleSpec instance) {
        this(fluent, instance, false);
    }

    public ScaleSpecBuilder(ScaleSpecFluent<?> fluent, ScaleSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        if (instance != null) {
            fluent.withReplicas(instance.getReplicas());
            fluent.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    public ScaleSpecBuilder(ScaleSpec instance) {
        this(instance, (Boolean)false);
    }

    public ScaleSpecBuilder(ScaleSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        if (instance != null) {
            this.withReplicas(instance.getReplicas());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    @Override
    public ScaleSpec build() {
        ScaleSpec buildable = new ScaleSpec(this.fluent.getReplicas());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }
}

