/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_7.authentication;

import io.fabric8.kubernetes.api.builder.v6_7.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v6_7.authentication.TokenRequestStatus;
import io.fabric8.kubernetes.api.model.v6_7.authentication.TokenRequestStatusFluent;
import io.fabric8.kubernetes.api.model.v6_7.authentication.TokenRequestStatusFluentImpl;

public class TokenRequestStatusBuilder
extends TokenRequestStatusFluentImpl<TokenRequestStatusBuilder>
implements VisitableBuilder<TokenRequestStatus, TokenRequestStatusBuilder> {
    TokenRequestStatusFluent<?> fluent;
    Boolean validationEnabled;

    public TokenRequestStatusBuilder() {
        this(false);
    }

    public TokenRequestStatusBuilder(Boolean validationEnabled) {
        this(new TokenRequestStatus(), validationEnabled);
    }

    public TokenRequestStatusBuilder(TokenRequestStatusFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public TokenRequestStatusBuilder(TokenRequestStatusFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new TokenRequestStatus(), validationEnabled);
    }

    public TokenRequestStatusBuilder(TokenRequestStatusFluent<?> fluent, TokenRequestStatus instance) {
        this(fluent, instance, false);
    }

    public TokenRequestStatusBuilder(TokenRequestStatusFluent<?> fluent, TokenRequestStatus instance, Boolean validationEnabled) {
        this.fluent = fluent;
        if (instance != null) {
            fluent.withExpirationTimestamp(instance.getExpirationTimestamp());
            fluent.withToken(instance.getToken());
            fluent.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    public TokenRequestStatusBuilder(TokenRequestStatus instance) {
        this(instance, (Boolean)false);
    }

    public TokenRequestStatusBuilder(TokenRequestStatus instance, Boolean validationEnabled) {
        this.fluent = this;
        if (instance != null) {
            this.withExpirationTimestamp(instance.getExpirationTimestamp());
            this.withToken(instance.getToken());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    @Override
    public TokenRequestStatus build() {
        TokenRequestStatus buildable = new TokenRequestStatus(this.fluent.getExpirationTimestamp(), this.fluent.getToken());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }
}

