/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_7.authentication;

import io.fabric8.kubernetes.api.builder.v6_7.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v6_7.authentication.TokenRequestSpec;
import io.fabric8.kubernetes.api.model.v6_7.authentication.TokenRequestSpecFluent;
import io.fabric8.kubernetes.api.model.v6_7.authentication.TokenRequestSpecFluentImpl;

public class TokenRequestSpecBuilder
extends TokenRequestSpecFluentImpl<TokenRequestSpecBuilder>
implements VisitableBuilder<TokenRequestSpec, TokenRequestSpecBuilder> {
    TokenRequestSpecFluent<?> fluent;
    Boolean validationEnabled;

    public TokenRequestSpecBuilder() {
        this(false);
    }

    public TokenRequestSpecBuilder(Boolean validationEnabled) {
        this(new TokenRequestSpec(), validationEnabled);
    }

    public TokenRequestSpecBuilder(TokenRequestSpecFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public TokenRequestSpecBuilder(TokenRequestSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new TokenRequestSpec(), validationEnabled);
    }

    public TokenRequestSpecBuilder(TokenRequestSpecFluent<?> fluent, TokenRequestSpec instance) {
        this(fluent, instance, false);
    }

    public TokenRequestSpecBuilder(TokenRequestSpecFluent<?> fluent, TokenRequestSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        if (instance != null) {
            fluent.withAudiences(instance.getAudiences());
            fluent.withBoundObjectRef(instance.getBoundObjectRef());
            fluent.withExpirationSeconds(instance.getExpirationSeconds());
            fluent.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    public TokenRequestSpecBuilder(TokenRequestSpec instance) {
        this(instance, (Boolean)false);
    }

    public TokenRequestSpecBuilder(TokenRequestSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        if (instance != null) {
            this.withAudiences(instance.getAudiences());
            this.withBoundObjectRef(instance.getBoundObjectRef());
            this.withExpirationSeconds(instance.getExpirationSeconds());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    @Override
    public TokenRequestSpec build() {
        TokenRequestSpec buildable = new TokenRequestSpec(this.fluent.getAudiences(), this.fluent.getBoundObjectRef(), this.fluent.getExpirationSeconds());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }
}

