/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_7;

import io.fabric8.kubernetes.api.builder.v6_7.BaseFluent;
import io.fabric8.kubernetes.api.model.v6_7.ScopedResourceSelectorRequirement;
import io.fabric8.kubernetes.api.model.v6_7.ScopedResourceSelectorRequirementFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ScopedResourceSelectorRequirementFluentImpl<A extends ScopedResourceSelectorRequirementFluent<A>>
extends BaseFluent<A>
implements ScopedResourceSelectorRequirementFluent<A> {
    private String operator;
    private String scopeName;
    private List<String> values = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public ScopedResourceSelectorRequirementFluentImpl() {
    }

    public ScopedResourceSelectorRequirementFluentImpl(ScopedResourceSelectorRequirement instance) {
        if (instance != null) {
            this.withOperator(instance.getOperator());
            this.withScopeName(instance.getScopeName());
            this.withValues(instance.getValues());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    @Override
    public String getOperator() {
        return this.operator;
    }

    @Override
    public A withOperator(String operator) {
        this.operator = operator;
        return (A)this;
    }

    @Override
    public Boolean hasOperator() {
        return this.operator != null;
    }

    @Override
    public String getScopeName() {
        return this.scopeName;
    }

    @Override
    public A withScopeName(String scopeName) {
        this.scopeName = scopeName;
        return (A)this;
    }

    @Override
    public Boolean hasScopeName() {
        return this.scopeName != null;
    }

    @Override
    public A addToValues(int index, String item) {
        if (this.values == null) {
            this.values = new ArrayList<String>();
        }
        this.values.add(index, item);
        return (A)this;
    }

    @Override
    public A setToValues(int index, String item) {
        if (this.values == null) {
            this.values = new ArrayList<String>();
        }
        this.values.set(index, item);
        return (A)this;
    }

    @Override
    public A addToValues(String ... items) {
        if (this.values == null) {
            this.values = new ArrayList<String>();
        }
        for (String item : items) {
            this.values.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToValues(Collection<String> items) {
        if (this.values == null) {
            this.values = new ArrayList<String>();
        }
        for (String item : items) {
            this.values.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromValues(String ... items) {
        for (String item : items) {
            if (this.values == null) continue;
            this.values.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromValues(Collection<String> items) {
        for (String item : items) {
            if (this.values == null) continue;
            this.values.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getValues() {
        return this.values;
    }

    @Override
    public String getValue(int index) {
        return this.values.get(index);
    }

    @Override
    public String getFirstValue() {
        return this.values.get(0);
    }

    @Override
    public String getLastValue() {
        return this.values.get(this.values.size() - 1);
    }

    @Override
    public String getMatchingValue(Predicate<String> predicate) {
        for (String item : this.values) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingValue(Predicate<String> predicate) {
        for (String item : this.values) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withValues(List<String> values) {
        if (values != null) {
            this.values = new ArrayList<String>();
            for (String item : values) {
                this.addToValues(item);
            }
        } else {
            this.values = null;
        }
        return (A)this;
    }

    @Override
    public A withValues(String ... values) {
        if (this.values != null) {
            this.values.clear();
            this._visitables.remove("values");
        }
        if (values != null) {
            for (String item : values) {
                this.addToValues(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasValues() {
        return this.values != null && !this.values.isEmpty();
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ScopedResourceSelectorRequirementFluentImpl that = (ScopedResourceSelectorRequirementFluentImpl)o;
        if (!Objects.equals(this.operator, that.operator)) {
            return false;
        }
        if (!Objects.equals(this.scopeName, that.scopeName)) {
            return false;
        }
        if (!Objects.equals(this.values, that.values)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.operator, this.scopeName, this.values, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.operator != null) {
            sb.append("operator:");
            sb.append(this.operator + ",");
        }
        if (this.scopeName != null) {
            sb.append("scopeName:");
            sb.append(this.scopeName + ",");
        }
        if (this.values != null && !this.values.isEmpty()) {
            sb.append("values:");
            sb.append(this.values + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

