/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_7;

import io.fabric8.kubernetes.api.builder.v6_7.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_7.Nested;
import io.fabric8.kubernetes.api.model.v6_7.LocalObjectReference;
import io.fabric8.kubernetes.api.model.v6_7.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.v6_7.LocalObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.v6_7.ScaleIOVolumeSource;
import io.fabric8.kubernetes.api.model.v6_7.ScaleIOVolumeSourceFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class ScaleIOVolumeSourceFluentImpl<A extends ScaleIOVolumeSourceFluent<A>>
extends BaseFluent<A>
implements ScaleIOVolumeSourceFluent<A> {
    private String fsType;
    private String gateway;
    private String protectionDomain;
    private Boolean readOnly;
    private LocalObjectReferenceBuilder secretRef;
    private Boolean sslEnabled;
    private String storageMode;
    private String storagePool;
    private String system;
    private String volumeName;
    private Map<String, Object> additionalProperties;

    public ScaleIOVolumeSourceFluentImpl() {
    }

    public ScaleIOVolumeSourceFluentImpl(ScaleIOVolumeSource instance) {
        if (instance != null) {
            this.withFsType(instance.getFsType());
            this.withGateway(instance.getGateway());
            this.withProtectionDomain(instance.getProtectionDomain());
            this.withReadOnly(instance.getReadOnly());
            this.withSecretRef(instance.getSecretRef());
            this.withSslEnabled(instance.getSslEnabled());
            this.withStorageMode(instance.getStorageMode());
            this.withStoragePool(instance.getStoragePool());
            this.withSystem(instance.getSystem());
            this.withVolumeName(instance.getVolumeName());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    @Override
    public String getFsType() {
        return this.fsType;
    }

    @Override
    public A withFsType(String fsType) {
        this.fsType = fsType;
        return (A)this;
    }

    @Override
    public Boolean hasFsType() {
        return this.fsType != null;
    }

    @Override
    public String getGateway() {
        return this.gateway;
    }

    @Override
    public A withGateway(String gateway) {
        this.gateway = gateway;
        return (A)this;
    }

    @Override
    public Boolean hasGateway() {
        return this.gateway != null;
    }

    @Override
    public String getProtectionDomain() {
        return this.protectionDomain;
    }

    @Override
    public A withProtectionDomain(String protectionDomain) {
        this.protectionDomain = protectionDomain;
        return (A)this;
    }

    @Override
    public Boolean hasProtectionDomain() {
        return this.protectionDomain != null;
    }

    @Override
    public Boolean getReadOnly() {
        return this.readOnly;
    }

    @Override
    public A withReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return (A)this;
    }

    @Override
    public Boolean hasReadOnly() {
        return this.readOnly != null;
    }

    @Override
    @Deprecated
    public LocalObjectReference getSecretRef() {
        return this.secretRef != null ? this.secretRef.build() : null;
    }

    @Override
    public LocalObjectReference buildSecretRef() {
        return this.secretRef != null ? this.secretRef.build() : null;
    }

    @Override
    public A withSecretRef(LocalObjectReference secretRef) {
        this._visitables.get("secretRef").remove(this.secretRef);
        if (secretRef != null) {
            this.secretRef = new LocalObjectReferenceBuilder(secretRef);
            this._visitables.get("secretRef").add(this.secretRef);
        } else {
            this.secretRef = null;
            this._visitables.get("secretRef").remove(this.secretRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSecretRef() {
        return this.secretRef != null;
    }

    @Override
    public A withNewSecretRef(String name) {
        return this.withSecretRef(new LocalObjectReference(name));
    }

    @Override
    public ScaleIOVolumeSourceFluent.SecretRefNested<A> withNewSecretRef() {
        return new SecretRefNestedImpl();
    }

    @Override
    public ScaleIOVolumeSourceFluent.SecretRefNested<A> withNewSecretRefLike(LocalObjectReference item) {
        return new SecretRefNestedImpl(item);
    }

    @Override
    public ScaleIOVolumeSourceFluent.SecretRefNested<A> editSecretRef() {
        return this.withNewSecretRefLike(this.getSecretRef());
    }

    @Override
    public ScaleIOVolumeSourceFluent.SecretRefNested<A> editOrNewSecretRef() {
        return this.withNewSecretRefLike(this.getSecretRef() != null ? this.getSecretRef() : new LocalObjectReferenceBuilder().build());
    }

    @Override
    public ScaleIOVolumeSourceFluent.SecretRefNested<A> editOrNewSecretRefLike(LocalObjectReference item) {
        return this.withNewSecretRefLike(this.getSecretRef() != null ? this.getSecretRef() : item);
    }

    @Override
    public Boolean getSslEnabled() {
        return this.sslEnabled;
    }

    @Override
    public A withSslEnabled(Boolean sslEnabled) {
        this.sslEnabled = sslEnabled;
        return (A)this;
    }

    @Override
    public Boolean hasSslEnabled() {
        return this.sslEnabled != null;
    }

    @Override
    public String getStorageMode() {
        return this.storageMode;
    }

    @Override
    public A withStorageMode(String storageMode) {
        this.storageMode = storageMode;
        return (A)this;
    }

    @Override
    public Boolean hasStorageMode() {
        return this.storageMode != null;
    }

    @Override
    public String getStoragePool() {
        return this.storagePool;
    }

    @Override
    public A withStoragePool(String storagePool) {
        this.storagePool = storagePool;
        return (A)this;
    }

    @Override
    public Boolean hasStoragePool() {
        return this.storagePool != null;
    }

    @Override
    public String getSystem() {
        return this.system;
    }

    @Override
    public A withSystem(String system) {
        this.system = system;
        return (A)this;
    }

    @Override
    public Boolean hasSystem() {
        return this.system != null;
    }

    @Override
    public String getVolumeName() {
        return this.volumeName;
    }

    @Override
    public A withVolumeName(String volumeName) {
        this.volumeName = volumeName;
        return (A)this;
    }

    @Override
    public Boolean hasVolumeName() {
        return this.volumeName != null;
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ScaleIOVolumeSourceFluentImpl that = (ScaleIOVolumeSourceFluentImpl)o;
        if (!Objects.equals(this.fsType, that.fsType)) {
            return false;
        }
        if (!Objects.equals(this.gateway, that.gateway)) {
            return false;
        }
        if (!Objects.equals(this.protectionDomain, that.protectionDomain)) {
            return false;
        }
        if (!Objects.equals(this.readOnly, that.readOnly)) {
            return false;
        }
        if (!Objects.equals(this.secretRef, that.secretRef)) {
            return false;
        }
        if (!Objects.equals(this.sslEnabled, that.sslEnabled)) {
            return false;
        }
        if (!Objects.equals(this.storageMode, that.storageMode)) {
            return false;
        }
        if (!Objects.equals(this.storagePool, that.storagePool)) {
            return false;
        }
        if (!Objects.equals(this.system, that.system)) {
            return false;
        }
        if (!Objects.equals(this.volumeName, that.volumeName)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fsType, this.gateway, this.protectionDomain, this.readOnly, this.secretRef, this.sslEnabled, this.storageMode, this.storagePool, this.system, this.volumeName, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.fsType != null) {
            sb.append("fsType:");
            sb.append(this.fsType + ",");
        }
        if (this.gateway != null) {
            sb.append("gateway:");
            sb.append(this.gateway + ",");
        }
        if (this.protectionDomain != null) {
            sb.append("protectionDomain:");
            sb.append(this.protectionDomain + ",");
        }
        if (this.readOnly != null) {
            sb.append("readOnly:");
            sb.append(this.readOnly + ",");
        }
        if (this.secretRef != null) {
            sb.append("secretRef:");
            sb.append(this.secretRef + ",");
        }
        if (this.sslEnabled != null) {
            sb.append("sslEnabled:");
            sb.append(this.sslEnabled + ",");
        }
        if (this.storageMode != null) {
            sb.append("storageMode:");
            sb.append(this.storageMode + ",");
        }
        if (this.storagePool != null) {
            sb.append("storagePool:");
            sb.append(this.storagePool + ",");
        }
        if (this.system != null) {
            sb.append("system:");
            sb.append(this.system + ",");
        }
        if (this.volumeName != null) {
            sb.append("volumeName:");
            sb.append(this.volumeName + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public A withReadOnly() {
        return this.withReadOnly(true);
    }

    @Override
    public A withSslEnabled() {
        return this.withSslEnabled(true);
    }

    class SecretRefNestedImpl<N>
    extends LocalObjectReferenceFluentImpl<ScaleIOVolumeSourceFluent.SecretRefNested<N>>
    implements ScaleIOVolumeSourceFluent.SecretRefNested<N>,
    Nested<N> {
        LocalObjectReferenceBuilder builder;

        SecretRefNestedImpl(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder(this, item);
        }

        SecretRefNestedImpl() {
            this.builder = new LocalObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)ScaleIOVolumeSourceFluentImpl.this.withSecretRef(this.builder.build());
        }

        @Override
        public N endSecretRef() {
            return this.and();
        }
    }
}

