/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_7;

import io.fabric8.kubernetes.api.builder.v6_7.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_7.Nested;
import io.fabric8.kubernetes.api.model.v6_7.EndpointAddress;
import io.fabric8.kubernetes.api.model.v6_7.EndpointAddressBuilder;
import io.fabric8.kubernetes.api.model.v6_7.EndpointAddressFluentImpl;
import io.fabric8.kubernetes.api.model.v6_7.EndpointPort;
import io.fabric8.kubernetes.api.model.v6_7.EndpointPortBuilder;
import io.fabric8.kubernetes.api.model.v6_7.EndpointPortFluentImpl;
import io.fabric8.kubernetes.api.model.v6_7.EndpointSubset;
import io.fabric8.kubernetes.api.model.v6_7.EndpointSubsetFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class EndpointSubsetFluentImpl<A extends EndpointSubsetFluent<A>>
extends BaseFluent<A>
implements EndpointSubsetFluent<A> {
    private ArrayList<EndpointAddressBuilder> addresses = new ArrayList();
    private ArrayList<EndpointAddressBuilder> notReadyAddresses = new ArrayList();
    private ArrayList<EndpointPortBuilder> ports = new ArrayList();
    private Map<String, Object> additionalProperties;

    public EndpointSubsetFluentImpl() {
    }

    public EndpointSubsetFluentImpl(EndpointSubset instance) {
        if (instance != null) {
            this.withAddresses(instance.getAddresses());
            this.withNotReadyAddresses(instance.getNotReadyAddresses());
            this.withPorts(instance.getPorts());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    @Override
    public A addToAddresses(int index, EndpointAddress item) {
        if (this.addresses == null) {
            this.addresses = new ArrayList();
        }
        EndpointAddressBuilder builder = new EndpointAddressBuilder(item);
        if (index < 0 || index >= this.addresses.size()) {
            this._visitables.get("addresses").add(builder);
            this.addresses.add(builder);
        } else {
            this._visitables.get("addresses").add(index, builder);
            this.addresses.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToAddresses(int index, EndpointAddress item) {
        if (this.addresses == null) {
            this.addresses = new ArrayList();
        }
        EndpointAddressBuilder builder = new EndpointAddressBuilder(item);
        if (index < 0 || index >= this.addresses.size()) {
            this._visitables.get("addresses").add(builder);
            this.addresses.add(builder);
        } else {
            this._visitables.get("addresses").set(index, builder);
            this.addresses.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToAddresses(EndpointAddress ... items) {
        if (this.addresses == null) {
            this.addresses = new ArrayList();
        }
        for (EndpointAddress item : items) {
            EndpointAddressBuilder builder = new EndpointAddressBuilder(item);
            this._visitables.get("addresses").add(builder);
            this.addresses.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToAddresses(Collection<EndpointAddress> items) {
        if (this.addresses == null) {
            this.addresses = new ArrayList();
        }
        for (EndpointAddress item : items) {
            EndpointAddressBuilder builder = new EndpointAddressBuilder(item);
            this._visitables.get("addresses").add(builder);
            this.addresses.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromAddresses(EndpointAddress ... items) {
        for (EndpointAddress item : items) {
            EndpointAddressBuilder builder = new EndpointAddressBuilder(item);
            this._visitables.get("addresses").remove(builder);
            if (this.addresses == null) continue;
            this.addresses.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAddresses(Collection<EndpointAddress> items) {
        for (EndpointAddress item : items) {
            EndpointAddressBuilder builder = new EndpointAddressBuilder(item);
            this._visitables.get("addresses").remove(builder);
            if (this.addresses == null) continue;
            this.addresses.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromAddresses(Predicate<EndpointAddressBuilder> predicate) {
        if (this.addresses == null) {
            return (A)this;
        }
        Iterator<EndpointAddressBuilder> each = this.addresses.iterator();
        Object visitables = this._visitables.get("addresses");
        while (each.hasNext()) {
            EndpointAddressBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<EndpointAddress> getAddresses() {
        return this.addresses != null ? EndpointSubsetFluentImpl.build(this.addresses) : null;
    }

    @Override
    public List<EndpointAddress> buildAddresses() {
        return this.addresses != null ? EndpointSubsetFluentImpl.build(this.addresses) : null;
    }

    @Override
    public EndpointAddress buildAddress(int index) {
        return this.addresses.get(index).build();
    }

    @Override
    public EndpointAddress buildFirstAddress() {
        return this.addresses.get(0).build();
    }

    @Override
    public EndpointAddress buildLastAddress() {
        return this.addresses.get(this.addresses.size() - 1).build();
    }

    @Override
    public EndpointAddress buildMatchingAddress(Predicate<EndpointAddressBuilder> predicate) {
        for (EndpointAddressBuilder item : this.addresses) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingAddress(Predicate<EndpointAddressBuilder> predicate) {
        for (EndpointAddressBuilder item : this.addresses) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withAddresses(List<EndpointAddress> addresses) {
        if (this.addresses != null) {
            this._visitables.get("addresses").clear();
        }
        if (addresses != null) {
            this.addresses = new ArrayList();
            for (EndpointAddress item : addresses) {
                this.addToAddresses(item);
            }
        } else {
            this.addresses = null;
        }
        return (A)this;
    }

    @Override
    public A withAddresses(EndpointAddress ... addresses) {
        if (this.addresses != null) {
            this.addresses.clear();
            this._visitables.remove("addresses");
        }
        if (addresses != null) {
            for (EndpointAddress item : addresses) {
                this.addToAddresses(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasAddresses() {
        return this.addresses != null && !this.addresses.isEmpty();
    }

    @Override
    public EndpointSubsetFluent.AddressesNested<A> addNewAddress() {
        return new AddressesNestedImpl();
    }

    @Override
    public EndpointSubsetFluent.AddressesNested<A> addNewAddressLike(EndpointAddress item) {
        return new AddressesNestedImpl(-1, item);
    }

    @Override
    public EndpointSubsetFluent.AddressesNested<A> setNewAddressLike(int index, EndpointAddress item) {
        return new AddressesNestedImpl(index, item);
    }

    @Override
    public EndpointSubsetFluent.AddressesNested<A> editAddress(int index) {
        if (this.addresses.size() <= index) {
            throw new RuntimeException("Can't edit addresses. Index exceeds size.");
        }
        return this.setNewAddressLike(index, this.buildAddress(index));
    }

    @Override
    public EndpointSubsetFluent.AddressesNested<A> editFirstAddress() {
        if (this.addresses.size() == 0) {
            throw new RuntimeException("Can't edit first addresses. The list is empty.");
        }
        return this.setNewAddressLike(0, this.buildAddress(0));
    }

    @Override
    public EndpointSubsetFluent.AddressesNested<A> editLastAddress() {
        int index = this.addresses.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last addresses. The list is empty.");
        }
        return this.setNewAddressLike(index, this.buildAddress(index));
    }

    @Override
    public EndpointSubsetFluent.AddressesNested<A> editMatchingAddress(Predicate<EndpointAddressBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.addresses.size(); ++i) {
            if (!predicate.test(this.addresses.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching addresses. No match found.");
        }
        return this.setNewAddressLike(index, this.buildAddress(index));
    }

    @Override
    public A addToNotReadyAddresses(int index, EndpointAddress item) {
        if (this.notReadyAddresses == null) {
            this.notReadyAddresses = new ArrayList();
        }
        EndpointAddressBuilder builder = new EndpointAddressBuilder(item);
        if (index < 0 || index >= this.notReadyAddresses.size()) {
            this._visitables.get("notReadyAddresses").add(builder);
            this.notReadyAddresses.add(builder);
        } else {
            this._visitables.get("notReadyAddresses").add(index, builder);
            this.notReadyAddresses.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToNotReadyAddresses(int index, EndpointAddress item) {
        if (this.notReadyAddresses == null) {
            this.notReadyAddresses = new ArrayList();
        }
        EndpointAddressBuilder builder = new EndpointAddressBuilder(item);
        if (index < 0 || index >= this.notReadyAddresses.size()) {
            this._visitables.get("notReadyAddresses").add(builder);
            this.notReadyAddresses.add(builder);
        } else {
            this._visitables.get("notReadyAddresses").set(index, builder);
            this.notReadyAddresses.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToNotReadyAddresses(EndpointAddress ... items) {
        if (this.notReadyAddresses == null) {
            this.notReadyAddresses = new ArrayList();
        }
        for (EndpointAddress item : items) {
            EndpointAddressBuilder builder = new EndpointAddressBuilder(item);
            this._visitables.get("notReadyAddresses").add(builder);
            this.notReadyAddresses.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToNotReadyAddresses(Collection<EndpointAddress> items) {
        if (this.notReadyAddresses == null) {
            this.notReadyAddresses = new ArrayList();
        }
        for (EndpointAddress item : items) {
            EndpointAddressBuilder builder = new EndpointAddressBuilder(item);
            this._visitables.get("notReadyAddresses").add(builder);
            this.notReadyAddresses.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromNotReadyAddresses(EndpointAddress ... items) {
        for (EndpointAddress item : items) {
            EndpointAddressBuilder builder = new EndpointAddressBuilder(item);
            this._visitables.get("notReadyAddresses").remove(builder);
            if (this.notReadyAddresses == null) continue;
            this.notReadyAddresses.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromNotReadyAddresses(Collection<EndpointAddress> items) {
        for (EndpointAddress item : items) {
            EndpointAddressBuilder builder = new EndpointAddressBuilder(item);
            this._visitables.get("notReadyAddresses").remove(builder);
            if (this.notReadyAddresses == null) continue;
            this.notReadyAddresses.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromNotReadyAddresses(Predicate<EndpointAddressBuilder> predicate) {
        if (this.notReadyAddresses == null) {
            return (A)this;
        }
        Iterator<EndpointAddressBuilder> each = this.notReadyAddresses.iterator();
        Object visitables = this._visitables.get("notReadyAddresses");
        while (each.hasNext()) {
            EndpointAddressBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<EndpointAddress> getNotReadyAddresses() {
        return this.notReadyAddresses != null ? EndpointSubsetFluentImpl.build(this.notReadyAddresses) : null;
    }

    @Override
    public List<EndpointAddress> buildNotReadyAddresses() {
        return this.notReadyAddresses != null ? EndpointSubsetFluentImpl.build(this.notReadyAddresses) : null;
    }

    @Override
    public EndpointAddress buildNotReadyAddress(int index) {
        return this.notReadyAddresses.get(index).build();
    }

    @Override
    public EndpointAddress buildFirstNotReadyAddress() {
        return this.notReadyAddresses.get(0).build();
    }

    @Override
    public EndpointAddress buildLastNotReadyAddress() {
        return this.notReadyAddresses.get(this.notReadyAddresses.size() - 1).build();
    }

    @Override
    public EndpointAddress buildMatchingNotReadyAddress(Predicate<EndpointAddressBuilder> predicate) {
        for (EndpointAddressBuilder item : this.notReadyAddresses) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingNotReadyAddress(Predicate<EndpointAddressBuilder> predicate) {
        for (EndpointAddressBuilder item : this.notReadyAddresses) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withNotReadyAddresses(List<EndpointAddress> notReadyAddresses) {
        if (this.notReadyAddresses != null) {
            this._visitables.get("notReadyAddresses").clear();
        }
        if (notReadyAddresses != null) {
            this.notReadyAddresses = new ArrayList();
            for (EndpointAddress item : notReadyAddresses) {
                this.addToNotReadyAddresses(item);
            }
        } else {
            this.notReadyAddresses = null;
        }
        return (A)this;
    }

    @Override
    public A withNotReadyAddresses(EndpointAddress ... notReadyAddresses) {
        if (this.notReadyAddresses != null) {
            this.notReadyAddresses.clear();
            this._visitables.remove("notReadyAddresses");
        }
        if (notReadyAddresses != null) {
            for (EndpointAddress item : notReadyAddresses) {
                this.addToNotReadyAddresses(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasNotReadyAddresses() {
        return this.notReadyAddresses != null && !this.notReadyAddresses.isEmpty();
    }

    @Override
    public EndpointSubsetFluent.NotReadyAddressesNested<A> addNewNotReadyAddress() {
        return new NotReadyAddressesNestedImpl();
    }

    @Override
    public EndpointSubsetFluent.NotReadyAddressesNested<A> addNewNotReadyAddressLike(EndpointAddress item) {
        return new NotReadyAddressesNestedImpl(-1, item);
    }

    @Override
    public EndpointSubsetFluent.NotReadyAddressesNested<A> setNewNotReadyAddressLike(int index, EndpointAddress item) {
        return new NotReadyAddressesNestedImpl(index, item);
    }

    @Override
    public EndpointSubsetFluent.NotReadyAddressesNested<A> editNotReadyAddress(int index) {
        if (this.notReadyAddresses.size() <= index) {
            throw new RuntimeException("Can't edit notReadyAddresses. Index exceeds size.");
        }
        return this.setNewNotReadyAddressLike(index, this.buildNotReadyAddress(index));
    }

    @Override
    public EndpointSubsetFluent.NotReadyAddressesNested<A> editFirstNotReadyAddress() {
        if (this.notReadyAddresses.size() == 0) {
            throw new RuntimeException("Can't edit first notReadyAddresses. The list is empty.");
        }
        return this.setNewNotReadyAddressLike(0, this.buildNotReadyAddress(0));
    }

    @Override
    public EndpointSubsetFluent.NotReadyAddressesNested<A> editLastNotReadyAddress() {
        int index = this.notReadyAddresses.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last notReadyAddresses. The list is empty.");
        }
        return this.setNewNotReadyAddressLike(index, this.buildNotReadyAddress(index));
    }

    @Override
    public EndpointSubsetFluent.NotReadyAddressesNested<A> editMatchingNotReadyAddress(Predicate<EndpointAddressBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.notReadyAddresses.size(); ++i) {
            if (!predicate.test(this.notReadyAddresses.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching notReadyAddresses. No match found.");
        }
        return this.setNewNotReadyAddressLike(index, this.buildNotReadyAddress(index));
    }

    @Override
    public A addToPorts(int index, EndpointPort item) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        EndpointPortBuilder builder = new EndpointPortBuilder(item);
        if (index < 0 || index >= this.ports.size()) {
            this._visitables.get("ports").add(builder);
            this.ports.add(builder);
        } else {
            this._visitables.get("ports").add(index, builder);
            this.ports.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToPorts(int index, EndpointPort item) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        EndpointPortBuilder builder = new EndpointPortBuilder(item);
        if (index < 0 || index >= this.ports.size()) {
            this._visitables.get("ports").add(builder);
            this.ports.add(builder);
        } else {
            this._visitables.get("ports").set(index, builder);
            this.ports.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToPorts(EndpointPort ... items) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        for (EndpointPort item : items) {
            EndpointPortBuilder builder = new EndpointPortBuilder(item);
            this._visitables.get("ports").add(builder);
            this.ports.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToPorts(Collection<EndpointPort> items) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        for (EndpointPort item : items) {
            EndpointPortBuilder builder = new EndpointPortBuilder(item);
            this._visitables.get("ports").add(builder);
            this.ports.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromPorts(EndpointPort ... items) {
        for (EndpointPort item : items) {
            EndpointPortBuilder builder = new EndpointPortBuilder(item);
            this._visitables.get("ports").remove(builder);
            if (this.ports == null) continue;
            this.ports.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromPorts(Collection<EndpointPort> items) {
        for (EndpointPort item : items) {
            EndpointPortBuilder builder = new EndpointPortBuilder(item);
            this._visitables.get("ports").remove(builder);
            if (this.ports == null) continue;
            this.ports.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromPorts(Predicate<EndpointPortBuilder> predicate) {
        if (this.ports == null) {
            return (A)this;
        }
        Iterator<EndpointPortBuilder> each = this.ports.iterator();
        Object visitables = this._visitables.get("ports");
        while (each.hasNext()) {
            EndpointPortBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<EndpointPort> getPorts() {
        return this.ports != null ? EndpointSubsetFluentImpl.build(this.ports) : null;
    }

    @Override
    public List<EndpointPort> buildPorts() {
        return this.ports != null ? EndpointSubsetFluentImpl.build(this.ports) : null;
    }

    @Override
    public EndpointPort buildPort(int index) {
        return this.ports.get(index).build();
    }

    @Override
    public EndpointPort buildFirstPort() {
        return this.ports.get(0).build();
    }

    @Override
    public EndpointPort buildLastPort() {
        return this.ports.get(this.ports.size() - 1).build();
    }

    @Override
    public EndpointPort buildMatchingPort(Predicate<EndpointPortBuilder> predicate) {
        for (EndpointPortBuilder item : this.ports) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingPort(Predicate<EndpointPortBuilder> predicate) {
        for (EndpointPortBuilder item : this.ports) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withPorts(List<EndpointPort> ports) {
        if (this.ports != null) {
            this._visitables.get("ports").clear();
        }
        if (ports != null) {
            this.ports = new ArrayList();
            for (EndpointPort item : ports) {
                this.addToPorts(item);
            }
        } else {
            this.ports = null;
        }
        return (A)this;
    }

    @Override
    public A withPorts(EndpointPort ... ports) {
        if (this.ports != null) {
            this.ports.clear();
            this._visitables.remove("ports");
        }
        if (ports != null) {
            for (EndpointPort item : ports) {
                this.addToPorts(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasPorts() {
        return this.ports != null && !this.ports.isEmpty();
    }

    @Override
    public A addNewPort(String appProtocol, String name, Integer port, String protocol) {
        return this.addToPorts(new EndpointPort(appProtocol, name, port, protocol));
    }

    @Override
    public EndpointSubsetFluent.PortsNested<A> addNewPort() {
        return new PortsNestedImpl();
    }

    @Override
    public EndpointSubsetFluent.PortsNested<A> addNewPortLike(EndpointPort item) {
        return new PortsNestedImpl(-1, item);
    }

    @Override
    public EndpointSubsetFluent.PortsNested<A> setNewPortLike(int index, EndpointPort item) {
        return new PortsNestedImpl(index, item);
    }

    @Override
    public EndpointSubsetFluent.PortsNested<A> editPort(int index) {
        if (this.ports.size() <= index) {
            throw new RuntimeException("Can't edit ports. Index exceeds size.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    @Override
    public EndpointSubsetFluent.PortsNested<A> editFirstPort() {
        if (this.ports.size() == 0) {
            throw new RuntimeException("Can't edit first ports. The list is empty.");
        }
        return this.setNewPortLike(0, this.buildPort(0));
    }

    @Override
    public EndpointSubsetFluent.PortsNested<A> editLastPort() {
        int index = this.ports.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last ports. The list is empty.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    @Override
    public EndpointSubsetFluent.PortsNested<A> editMatchingPort(Predicate<EndpointPortBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.ports.size(); ++i) {
            if (!predicate.test(this.ports.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching ports. No match found.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EndpointSubsetFluentImpl that = (EndpointSubsetFluentImpl)o;
        if (!Objects.equals(this.addresses, that.addresses)) {
            return false;
        }
        if (!Objects.equals(this.notReadyAddresses, that.notReadyAddresses)) {
            return false;
        }
        if (!Objects.equals(this.ports, that.ports)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.addresses, this.notReadyAddresses, this.ports, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.addresses != null && !this.addresses.isEmpty()) {
            sb.append("addresses:");
            sb.append(this.addresses + ",");
        }
        if (this.notReadyAddresses != null && !this.notReadyAddresses.isEmpty()) {
            sb.append("notReadyAddresses:");
            sb.append(this.notReadyAddresses + ",");
        }
        if (this.ports != null && !this.ports.isEmpty()) {
            sb.append("ports:");
            sb.append(this.ports + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class PortsNestedImpl<N>
    extends EndpointPortFluentImpl<EndpointSubsetFluent.PortsNested<N>>
    implements EndpointSubsetFluent.PortsNested<N>,
    Nested<N> {
        EndpointPortBuilder builder;
        int index;

        PortsNestedImpl(int index, EndpointPort item) {
            this.index = index;
            this.builder = new EndpointPortBuilder(this, item);
        }

        PortsNestedImpl() {
            this.index = -1;
            this.builder = new EndpointPortBuilder(this);
        }

        @Override
        public N and() {
            return (N)EndpointSubsetFluentImpl.this.setToPorts(this.index, this.builder.build());
        }

        @Override
        public N endPort() {
            return this.and();
        }
    }

    class NotReadyAddressesNestedImpl<N>
    extends EndpointAddressFluentImpl<EndpointSubsetFluent.NotReadyAddressesNested<N>>
    implements EndpointSubsetFluent.NotReadyAddressesNested<N>,
    Nested<N> {
        EndpointAddressBuilder builder;
        int index;

        NotReadyAddressesNestedImpl(int index, EndpointAddress item) {
            this.index = index;
            this.builder = new EndpointAddressBuilder(this, item);
        }

        NotReadyAddressesNestedImpl() {
            this.index = -1;
            this.builder = new EndpointAddressBuilder(this);
        }

        @Override
        public N and() {
            return (N)EndpointSubsetFluentImpl.this.setToNotReadyAddresses(this.index, this.builder.build());
        }

        @Override
        public N endNotReadyAddress() {
            return this.and();
        }
    }

    class AddressesNestedImpl<N>
    extends EndpointAddressFluentImpl<EndpointSubsetFluent.AddressesNested<N>>
    implements EndpointSubsetFluent.AddressesNested<N>,
    Nested<N> {
        EndpointAddressBuilder builder;
        int index;

        AddressesNestedImpl(int index, EndpointAddress item) {
            this.index = index;
            this.builder = new EndpointAddressBuilder(this, item);
        }

        AddressesNestedImpl() {
            this.index = -1;
            this.builder = new EndpointAddressBuilder(this);
        }

        @Override
        public N and() {
            return (N)EndpointSubsetFluentImpl.this.setToAddresses(this.index, this.builder.build());
        }

        @Override
        public N endAddress() {
            return this.and();
        }
    }
}

