/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_7.installer.gcp.v1;

import io.fabric8.kubernetes.api.builder.v6_7.VisitableBuilder;
import io.fabric8.openshift.api.model.v6_7.installer.gcp.v1.Platform;
import io.fabric8.openshift.api.model.v6_7.installer.gcp.v1.PlatformFluent;
import io.fabric8.openshift.api.model.v6_7.installer.gcp.v1.PlatformFluentImpl;

public class PlatformBuilder
extends PlatformFluentImpl<PlatformBuilder>
implements VisitableBuilder<Platform, PlatformBuilder> {
    PlatformFluent<?> fluent;
    Boolean validationEnabled;

    public PlatformBuilder() {
        this(false);
    }

    public PlatformBuilder(Boolean validationEnabled) {
        this(new Platform(), validationEnabled);
    }

    public PlatformBuilder(PlatformFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public PlatformBuilder(PlatformFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Platform(), validationEnabled);
    }

    public PlatformBuilder(PlatformFluent<?> fluent, Platform instance) {
        this(fluent, instance, false);
    }

    public PlatformBuilder(PlatformFluent<?> fluent, Platform instance, Boolean validationEnabled) {
        this.fluent = fluent;
        if (instance != null) {
            fluent.withComputeSubnet(instance.getComputeSubnet());
            fluent.withControlPlaneSubnet(instance.getControlPlaneSubnet());
            fluent.withDefaultMachinePlatform(instance.getDefaultMachinePlatform());
            fluent.withLicenses(instance.getLicenses());
            fluent.withNetwork(instance.getNetwork());
            fluent.withProjectID(instance.getProjectID());
            fluent.withRegion(instance.getRegion());
            fluent.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    public PlatformBuilder(Platform instance) {
        this(instance, (Boolean)false);
    }

    public PlatformBuilder(Platform instance, Boolean validationEnabled) {
        this.fluent = this;
        if (instance != null) {
            this.withComputeSubnet(instance.getComputeSubnet());
            this.withControlPlaneSubnet(instance.getControlPlaneSubnet());
            this.withDefaultMachinePlatform(instance.getDefaultMachinePlatform());
            this.withLicenses(instance.getLicenses());
            this.withNetwork(instance.getNetwork());
            this.withProjectID(instance.getProjectID());
            this.withRegion(instance.getRegion());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    @Override
    public Platform build() {
        Platform buildable = new Platform(this.fluent.getComputeSubnet(), this.fluent.getControlPlaneSubnet(), this.fluent.getDefaultMachinePlatform(), this.fluent.getLicenses(), this.fluent.getNetwork(), this.fluent.getProjectID(), this.fluent.getRegion());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }
}

