/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_7.hive.v1;

import io.fabric8.kubernetes.api.builder.v6_7.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_7.Nested;
import io.fabric8.kubernetes.api.model.v6_7.Duration;
import io.fabric8.kubernetes.api.model.v6_7.LocalObjectReference;
import io.fabric8.kubernetes.api.model.v6_7.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.v6_7.LocalObjectReferenceFluentImpl;
import io.fabric8.openshift.api.model.v6_7.hive.v1.ClusterImageSetReference;
import io.fabric8.openshift.api.model.v6_7.hive.v1.ClusterImageSetReferenceBuilder;
import io.fabric8.openshift.api.model.v6_7.hive.v1.ClusterImageSetReferenceFluentImpl;
import io.fabric8.openshift.api.model.v6_7.hive.v1.ClusterPoolClaimLifetime;
import io.fabric8.openshift.api.model.v6_7.hive.v1.ClusterPoolClaimLifetimeBuilder;
import io.fabric8.openshift.api.model.v6_7.hive.v1.ClusterPoolClaimLifetimeFluentImpl;
import io.fabric8.openshift.api.model.v6_7.hive.v1.ClusterPoolSpec;
import io.fabric8.openshift.api.model.v6_7.hive.v1.ClusterPoolSpecFluent;
import io.fabric8.openshift.api.model.v6_7.hive.v1.Platform;
import io.fabric8.openshift.api.model.v6_7.hive.v1.PlatformBuilder;
import io.fabric8.openshift.api.model.v6_7.hive.v1.PlatformFluentImpl;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class ClusterPoolSpecFluentImpl<A extends ClusterPoolSpecFluent<A>>
extends BaseFluent<A>
implements ClusterPoolSpecFluent<A> {
    private Map<String, String> annotations;
    private String baseDomain;
    private ClusterPoolClaimLifetimeBuilder claimLifetime;
    private Duration hibernateAfter;
    private ClusterImageSetReferenceBuilder imageSetRef;
    private Integer installAttemptsLimit;
    private LocalObjectReferenceBuilder installConfigSecretTemplateRef;
    private Map<String, String> labels;
    private Integer maxConcurrent;
    private Integer maxSize;
    private PlatformBuilder platform;
    private LocalObjectReferenceBuilder pullSecretRef;
    private Integer runningCount;
    private Integer size;
    private Boolean skipMachinePools;
    private Map<String, Object> additionalProperties;

    public ClusterPoolSpecFluentImpl() {
    }

    public ClusterPoolSpecFluentImpl(ClusterPoolSpec instance) {
        if (instance != null) {
            this.withAnnotations(instance.getAnnotations());
            this.withBaseDomain(instance.getBaseDomain());
            this.withClaimLifetime(instance.getClaimLifetime());
            this.withHibernateAfter(instance.getHibernateAfter());
            this.withImageSetRef(instance.getImageSetRef());
            this.withInstallAttemptsLimit(instance.getInstallAttemptsLimit());
            this.withInstallConfigSecretTemplateRef(instance.getInstallConfigSecretTemplateRef());
            this.withLabels(instance.getLabels());
            this.withMaxConcurrent(instance.getMaxConcurrent());
            this.withMaxSize(instance.getMaxSize());
            this.withPlatform(instance.getPlatform());
            this.withPullSecretRef(instance.getPullSecretRef());
            this.withRunningCount(instance.getRunningCount());
            this.withSize(instance.getSize());
            this.withSkipMachinePools(instance.getSkipMachinePools());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    @Override
    public A addToAnnotations(String key, String value) {
        if (this.annotations == null && key != null && value != null) {
            this.annotations = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.annotations.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAnnotations(Map<String, String> map) {
        if (this.annotations == null && map != null) {
            this.annotations = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.annotations.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAnnotations(String key) {
        if (this.annotations == null) {
            return (A)this;
        }
        if (key != null && this.annotations != null) {
            this.annotations.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAnnotations(Map<String, String> map) {
        if (this.annotations == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.annotations == null) continue;
                this.annotations.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getAnnotations() {
        return this.annotations;
    }

    @Override
    public <K, V> A withAnnotations(Map<String, String> annotations) {
        this.annotations = annotations == null ? null : new LinkedHashMap<String, String>(annotations);
        return (A)this;
    }

    @Override
    public Boolean hasAnnotations() {
        return this.annotations != null;
    }

    @Override
    public String getBaseDomain() {
        return this.baseDomain;
    }

    @Override
    public A withBaseDomain(String baseDomain) {
        this.baseDomain = baseDomain;
        return (A)this;
    }

    @Override
    public Boolean hasBaseDomain() {
        return this.baseDomain != null;
    }

    @Override
    @Deprecated
    public ClusterPoolClaimLifetime getClaimLifetime() {
        return this.claimLifetime != null ? this.claimLifetime.build() : null;
    }

    @Override
    public ClusterPoolClaimLifetime buildClaimLifetime() {
        return this.claimLifetime != null ? this.claimLifetime.build() : null;
    }

    @Override
    public A withClaimLifetime(ClusterPoolClaimLifetime claimLifetime) {
        this._visitables.get("claimLifetime").remove(this.claimLifetime);
        if (claimLifetime != null) {
            this.claimLifetime = new ClusterPoolClaimLifetimeBuilder(claimLifetime);
            this._visitables.get("claimLifetime").add(this.claimLifetime);
        } else {
            this.claimLifetime = null;
            this._visitables.get("claimLifetime").remove(this.claimLifetime);
        }
        return (A)this;
    }

    @Override
    public Boolean hasClaimLifetime() {
        return this.claimLifetime != null;
    }

    @Override
    public ClusterPoolSpecFluent.ClaimLifetimeNested<A> withNewClaimLifetime() {
        return new ClaimLifetimeNestedImpl();
    }

    @Override
    public ClusterPoolSpecFluent.ClaimLifetimeNested<A> withNewClaimLifetimeLike(ClusterPoolClaimLifetime item) {
        return new ClaimLifetimeNestedImpl(item);
    }

    @Override
    public ClusterPoolSpecFluent.ClaimLifetimeNested<A> editClaimLifetime() {
        return this.withNewClaimLifetimeLike(this.getClaimLifetime());
    }

    @Override
    public ClusterPoolSpecFluent.ClaimLifetimeNested<A> editOrNewClaimLifetime() {
        return this.withNewClaimLifetimeLike(this.getClaimLifetime() != null ? this.getClaimLifetime() : new ClusterPoolClaimLifetimeBuilder().build());
    }

    @Override
    public ClusterPoolSpecFluent.ClaimLifetimeNested<A> editOrNewClaimLifetimeLike(ClusterPoolClaimLifetime item) {
        return this.withNewClaimLifetimeLike(this.getClaimLifetime() != null ? this.getClaimLifetime() : item);
    }

    @Override
    public Duration getHibernateAfter() {
        return this.hibernateAfter;
    }

    @Override
    public A withHibernateAfter(Duration hibernateAfter) {
        this.hibernateAfter = hibernateAfter;
        return (A)this;
    }

    @Override
    public Boolean hasHibernateAfter() {
        return this.hibernateAfter != null;
    }

    @Override
    @Deprecated
    public ClusterImageSetReference getImageSetRef() {
        return this.imageSetRef != null ? this.imageSetRef.build() : null;
    }

    @Override
    public ClusterImageSetReference buildImageSetRef() {
        return this.imageSetRef != null ? this.imageSetRef.build() : null;
    }

    @Override
    public A withImageSetRef(ClusterImageSetReference imageSetRef) {
        this._visitables.get("imageSetRef").remove(this.imageSetRef);
        if (imageSetRef != null) {
            this.imageSetRef = new ClusterImageSetReferenceBuilder(imageSetRef);
            this._visitables.get("imageSetRef").add(this.imageSetRef);
        } else {
            this.imageSetRef = null;
            this._visitables.get("imageSetRef").remove(this.imageSetRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasImageSetRef() {
        return this.imageSetRef != null;
    }

    @Override
    public A withNewImageSetRef(String name) {
        return this.withImageSetRef(new ClusterImageSetReference(name));
    }

    @Override
    public ClusterPoolSpecFluent.ImageSetRefNested<A> withNewImageSetRef() {
        return new ImageSetRefNestedImpl();
    }

    @Override
    public ClusterPoolSpecFluent.ImageSetRefNested<A> withNewImageSetRefLike(ClusterImageSetReference item) {
        return new ImageSetRefNestedImpl(item);
    }

    @Override
    public ClusterPoolSpecFluent.ImageSetRefNested<A> editImageSetRef() {
        return this.withNewImageSetRefLike(this.getImageSetRef());
    }

    @Override
    public ClusterPoolSpecFluent.ImageSetRefNested<A> editOrNewImageSetRef() {
        return this.withNewImageSetRefLike(this.getImageSetRef() != null ? this.getImageSetRef() : new ClusterImageSetReferenceBuilder().build());
    }

    @Override
    public ClusterPoolSpecFluent.ImageSetRefNested<A> editOrNewImageSetRefLike(ClusterImageSetReference item) {
        return this.withNewImageSetRefLike(this.getImageSetRef() != null ? this.getImageSetRef() : item);
    }

    @Override
    public Integer getInstallAttemptsLimit() {
        return this.installAttemptsLimit;
    }

    @Override
    public A withInstallAttemptsLimit(Integer installAttemptsLimit) {
        this.installAttemptsLimit = installAttemptsLimit;
        return (A)this;
    }

    @Override
    public Boolean hasInstallAttemptsLimit() {
        return this.installAttemptsLimit != null;
    }

    @Override
    @Deprecated
    public LocalObjectReference getInstallConfigSecretTemplateRef() {
        return this.installConfigSecretTemplateRef != null ? this.installConfigSecretTemplateRef.build() : null;
    }

    @Override
    public LocalObjectReference buildInstallConfigSecretTemplateRef() {
        return this.installConfigSecretTemplateRef != null ? this.installConfigSecretTemplateRef.build() : null;
    }

    @Override
    public A withInstallConfigSecretTemplateRef(LocalObjectReference installConfigSecretTemplateRef) {
        this._visitables.get("installConfigSecretTemplateRef").remove(this.installConfigSecretTemplateRef);
        if (installConfigSecretTemplateRef != null) {
            this.installConfigSecretTemplateRef = new LocalObjectReferenceBuilder(installConfigSecretTemplateRef);
            this._visitables.get("installConfigSecretTemplateRef").add(this.installConfigSecretTemplateRef);
        } else {
            this.installConfigSecretTemplateRef = null;
            this._visitables.get("installConfigSecretTemplateRef").remove(this.installConfigSecretTemplateRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasInstallConfigSecretTemplateRef() {
        return this.installConfigSecretTemplateRef != null;
    }

    @Override
    public A withNewInstallConfigSecretTemplateRef(String name) {
        return this.withInstallConfigSecretTemplateRef(new LocalObjectReference(name));
    }

    @Override
    public ClusterPoolSpecFluent.InstallConfigSecretTemplateRefNested<A> withNewInstallConfigSecretTemplateRef() {
        return new InstallConfigSecretTemplateRefNestedImpl();
    }

    @Override
    public ClusterPoolSpecFluent.InstallConfigSecretTemplateRefNested<A> withNewInstallConfigSecretTemplateRefLike(LocalObjectReference item) {
        return new InstallConfigSecretTemplateRefNestedImpl(item);
    }

    @Override
    public ClusterPoolSpecFluent.InstallConfigSecretTemplateRefNested<A> editInstallConfigSecretTemplateRef() {
        return this.withNewInstallConfigSecretTemplateRefLike(this.getInstallConfigSecretTemplateRef());
    }

    @Override
    public ClusterPoolSpecFluent.InstallConfigSecretTemplateRefNested<A> editOrNewInstallConfigSecretTemplateRef() {
        return this.withNewInstallConfigSecretTemplateRefLike(this.getInstallConfigSecretTemplateRef() != null ? this.getInstallConfigSecretTemplateRef() : new LocalObjectReferenceBuilder().build());
    }

    @Override
    public ClusterPoolSpecFluent.InstallConfigSecretTemplateRefNested<A> editOrNewInstallConfigSecretTemplateRefLike(LocalObjectReference item) {
        return this.withNewInstallConfigSecretTemplateRefLike(this.getInstallConfigSecretTemplateRef() != null ? this.getInstallConfigSecretTemplateRef() : item);
    }

    @Override
    public A addToLabels(String key, String value) {
        if (this.labels == null && key != null && value != null) {
            this.labels = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.labels.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToLabels(Map<String, String> map) {
        if (this.labels == null && map != null) {
            this.labels = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.labels.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromLabels(String key) {
        if (this.labels == null) {
            return (A)this;
        }
        if (key != null && this.labels != null) {
            this.labels.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromLabels(Map<String, String> map) {
        if (this.labels == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.labels == null) continue;
                this.labels.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getLabels() {
        return this.labels;
    }

    @Override
    public <K, V> A withLabels(Map<String, String> labels) {
        this.labels = labels == null ? null : new LinkedHashMap<String, String>(labels);
        return (A)this;
    }

    @Override
    public Boolean hasLabels() {
        return this.labels != null;
    }

    @Override
    public Integer getMaxConcurrent() {
        return this.maxConcurrent;
    }

    @Override
    public A withMaxConcurrent(Integer maxConcurrent) {
        this.maxConcurrent = maxConcurrent;
        return (A)this;
    }

    @Override
    public Boolean hasMaxConcurrent() {
        return this.maxConcurrent != null;
    }

    @Override
    public Integer getMaxSize() {
        return this.maxSize;
    }

    @Override
    public A withMaxSize(Integer maxSize) {
        this.maxSize = maxSize;
        return (A)this;
    }

    @Override
    public Boolean hasMaxSize() {
        return this.maxSize != null;
    }

    @Override
    @Deprecated
    public Platform getPlatform() {
        return this.platform != null ? this.platform.build() : null;
    }

    @Override
    public Platform buildPlatform() {
        return this.platform != null ? this.platform.build() : null;
    }

    @Override
    public A withPlatform(Platform platform) {
        this._visitables.get("platform").remove(this.platform);
        if (platform != null) {
            this.platform = new PlatformBuilder(platform);
            this._visitables.get("platform").add(this.platform);
        } else {
            this.platform = null;
            this._visitables.get("platform").remove(this.platform);
        }
        return (A)this;
    }

    @Override
    public Boolean hasPlatform() {
        return this.platform != null;
    }

    @Override
    public ClusterPoolSpecFluent.PlatformNested<A> withNewPlatform() {
        return new PlatformNestedImpl();
    }

    @Override
    public ClusterPoolSpecFluent.PlatformNested<A> withNewPlatformLike(Platform item) {
        return new PlatformNestedImpl(item);
    }

    @Override
    public ClusterPoolSpecFluent.PlatformNested<A> editPlatform() {
        return this.withNewPlatformLike(this.getPlatform());
    }

    @Override
    public ClusterPoolSpecFluent.PlatformNested<A> editOrNewPlatform() {
        return this.withNewPlatformLike(this.getPlatform() != null ? this.getPlatform() : new PlatformBuilder().build());
    }

    @Override
    public ClusterPoolSpecFluent.PlatformNested<A> editOrNewPlatformLike(Platform item) {
        return this.withNewPlatformLike(this.getPlatform() != null ? this.getPlatform() : item);
    }

    @Override
    @Deprecated
    public LocalObjectReference getPullSecretRef() {
        return this.pullSecretRef != null ? this.pullSecretRef.build() : null;
    }

    @Override
    public LocalObjectReference buildPullSecretRef() {
        return this.pullSecretRef != null ? this.pullSecretRef.build() : null;
    }

    @Override
    public A withPullSecretRef(LocalObjectReference pullSecretRef) {
        this._visitables.get("pullSecretRef").remove(this.pullSecretRef);
        if (pullSecretRef != null) {
            this.pullSecretRef = new LocalObjectReferenceBuilder(pullSecretRef);
            this._visitables.get("pullSecretRef").add(this.pullSecretRef);
        } else {
            this.pullSecretRef = null;
            this._visitables.get("pullSecretRef").remove(this.pullSecretRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasPullSecretRef() {
        return this.pullSecretRef != null;
    }

    @Override
    public A withNewPullSecretRef(String name) {
        return this.withPullSecretRef(new LocalObjectReference(name));
    }

    @Override
    public ClusterPoolSpecFluent.PullSecretRefNested<A> withNewPullSecretRef() {
        return new PullSecretRefNestedImpl();
    }

    @Override
    public ClusterPoolSpecFluent.PullSecretRefNested<A> withNewPullSecretRefLike(LocalObjectReference item) {
        return new PullSecretRefNestedImpl(item);
    }

    @Override
    public ClusterPoolSpecFluent.PullSecretRefNested<A> editPullSecretRef() {
        return this.withNewPullSecretRefLike(this.getPullSecretRef());
    }

    @Override
    public ClusterPoolSpecFluent.PullSecretRefNested<A> editOrNewPullSecretRef() {
        return this.withNewPullSecretRefLike(this.getPullSecretRef() != null ? this.getPullSecretRef() : new LocalObjectReferenceBuilder().build());
    }

    @Override
    public ClusterPoolSpecFluent.PullSecretRefNested<A> editOrNewPullSecretRefLike(LocalObjectReference item) {
        return this.withNewPullSecretRefLike(this.getPullSecretRef() != null ? this.getPullSecretRef() : item);
    }

    @Override
    public Integer getRunningCount() {
        return this.runningCount;
    }

    @Override
    public A withRunningCount(Integer runningCount) {
        this.runningCount = runningCount;
        return (A)this;
    }

    @Override
    public Boolean hasRunningCount() {
        return this.runningCount != null;
    }

    @Override
    public Integer getSize() {
        return this.size;
    }

    @Override
    public A withSize(Integer size) {
        this.size = size;
        return (A)this;
    }

    @Override
    public Boolean hasSize() {
        return this.size != null;
    }

    @Override
    public Boolean getSkipMachinePools() {
        return this.skipMachinePools;
    }

    @Override
    public A withSkipMachinePools(Boolean skipMachinePools) {
        this.skipMachinePools = skipMachinePools;
        return (A)this;
    }

    @Override
    public Boolean hasSkipMachinePools() {
        return this.skipMachinePools != null;
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClusterPoolSpecFluentImpl that = (ClusterPoolSpecFluentImpl)o;
        if (!Objects.equals(this.annotations, that.annotations)) {
            return false;
        }
        if (!Objects.equals(this.baseDomain, that.baseDomain)) {
            return false;
        }
        if (!Objects.equals(this.claimLifetime, that.claimLifetime)) {
            return false;
        }
        if (!Objects.equals(this.hibernateAfter, that.hibernateAfter)) {
            return false;
        }
        if (!Objects.equals(this.imageSetRef, that.imageSetRef)) {
            return false;
        }
        if (!Objects.equals(this.installAttemptsLimit, that.installAttemptsLimit)) {
            return false;
        }
        if (!Objects.equals(this.installConfigSecretTemplateRef, that.installConfigSecretTemplateRef)) {
            return false;
        }
        if (!Objects.equals(this.labels, that.labels)) {
            return false;
        }
        if (!Objects.equals(this.maxConcurrent, that.maxConcurrent)) {
            return false;
        }
        if (!Objects.equals(this.maxSize, that.maxSize)) {
            return false;
        }
        if (!Objects.equals(this.platform, that.platform)) {
            return false;
        }
        if (!Objects.equals(this.pullSecretRef, that.pullSecretRef)) {
            return false;
        }
        if (!Objects.equals(this.runningCount, that.runningCount)) {
            return false;
        }
        if (!Objects.equals(this.size, that.size)) {
            return false;
        }
        if (!Objects.equals(this.skipMachinePools, that.skipMachinePools)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.annotations, this.baseDomain, this.claimLifetime, this.hibernateAfter, this.imageSetRef, this.installAttemptsLimit, this.installConfigSecretTemplateRef, this.labels, this.maxConcurrent, this.maxSize, this.platform, this.pullSecretRef, this.runningCount, this.size, this.skipMachinePools, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.annotations != null && !this.annotations.isEmpty()) {
            sb.append("annotations:");
            sb.append(this.annotations + ",");
        }
        if (this.baseDomain != null) {
            sb.append("baseDomain:");
            sb.append(this.baseDomain + ",");
        }
        if (this.claimLifetime != null) {
            sb.append("claimLifetime:");
            sb.append(this.claimLifetime + ",");
        }
        if (this.hibernateAfter != null) {
            sb.append("hibernateAfter:");
            sb.append(this.hibernateAfter + ",");
        }
        if (this.imageSetRef != null) {
            sb.append("imageSetRef:");
            sb.append(this.imageSetRef + ",");
        }
        if (this.installAttemptsLimit != null) {
            sb.append("installAttemptsLimit:");
            sb.append(this.installAttemptsLimit + ",");
        }
        if (this.installConfigSecretTemplateRef != null) {
            sb.append("installConfigSecretTemplateRef:");
            sb.append(this.installConfigSecretTemplateRef + ",");
        }
        if (this.labels != null && !this.labels.isEmpty()) {
            sb.append("labels:");
            sb.append(this.labels + ",");
        }
        if (this.maxConcurrent != null) {
            sb.append("maxConcurrent:");
            sb.append(this.maxConcurrent + ",");
        }
        if (this.maxSize != null) {
            sb.append("maxSize:");
            sb.append(this.maxSize + ",");
        }
        if (this.platform != null) {
            sb.append("platform:");
            sb.append(this.platform + ",");
        }
        if (this.pullSecretRef != null) {
            sb.append("pullSecretRef:");
            sb.append(this.pullSecretRef + ",");
        }
        if (this.runningCount != null) {
            sb.append("runningCount:");
            sb.append(this.runningCount + ",");
        }
        if (this.size != null) {
            sb.append("size:");
            sb.append(this.size + ",");
        }
        if (this.skipMachinePools != null) {
            sb.append("skipMachinePools:");
            sb.append(this.skipMachinePools + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public A withSkipMachinePools() {
        return this.withSkipMachinePools(true);
    }

    class PullSecretRefNestedImpl<N>
    extends LocalObjectReferenceFluentImpl<ClusterPoolSpecFluent.PullSecretRefNested<N>>
    implements ClusterPoolSpecFluent.PullSecretRefNested<N>,
    Nested<N> {
        LocalObjectReferenceBuilder builder;

        PullSecretRefNestedImpl(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder(this, item);
        }

        PullSecretRefNestedImpl() {
            this.builder = new LocalObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)ClusterPoolSpecFluentImpl.this.withPullSecretRef(this.builder.build());
        }

        @Override
        public N endPullSecretRef() {
            return this.and();
        }
    }

    class PlatformNestedImpl<N>
    extends PlatformFluentImpl<ClusterPoolSpecFluent.PlatformNested<N>>
    implements ClusterPoolSpecFluent.PlatformNested<N>,
    Nested<N> {
        PlatformBuilder builder;

        PlatformNestedImpl(Platform item) {
            this.builder = new PlatformBuilder(this, item);
        }

        PlatformNestedImpl() {
            this.builder = new PlatformBuilder(this);
        }

        @Override
        public N and() {
            return (N)ClusterPoolSpecFluentImpl.this.withPlatform(this.builder.build());
        }

        @Override
        public N endPlatform() {
            return this.and();
        }
    }

    class InstallConfigSecretTemplateRefNestedImpl<N>
    extends LocalObjectReferenceFluentImpl<ClusterPoolSpecFluent.InstallConfigSecretTemplateRefNested<N>>
    implements ClusterPoolSpecFluent.InstallConfigSecretTemplateRefNested<N>,
    Nested<N> {
        LocalObjectReferenceBuilder builder;

        InstallConfigSecretTemplateRefNestedImpl(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder(this, item);
        }

        InstallConfigSecretTemplateRefNestedImpl() {
            this.builder = new LocalObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)ClusterPoolSpecFluentImpl.this.withInstallConfigSecretTemplateRef(this.builder.build());
        }

        @Override
        public N endInstallConfigSecretTemplateRef() {
            return this.and();
        }
    }

    class ImageSetRefNestedImpl<N>
    extends ClusterImageSetReferenceFluentImpl<ClusterPoolSpecFluent.ImageSetRefNested<N>>
    implements ClusterPoolSpecFluent.ImageSetRefNested<N>,
    Nested<N> {
        ClusterImageSetReferenceBuilder builder;

        ImageSetRefNestedImpl(ClusterImageSetReference item) {
            this.builder = new ClusterImageSetReferenceBuilder(this, item);
        }

        ImageSetRefNestedImpl() {
            this.builder = new ClusterImageSetReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)ClusterPoolSpecFluentImpl.this.withImageSetRef(this.builder.build());
        }

        @Override
        public N endImageSetRef() {
            return this.and();
        }
    }

    class ClaimLifetimeNestedImpl<N>
    extends ClusterPoolClaimLifetimeFluentImpl<ClusterPoolSpecFluent.ClaimLifetimeNested<N>>
    implements ClusterPoolSpecFluent.ClaimLifetimeNested<N>,
    Nested<N> {
        ClusterPoolClaimLifetimeBuilder builder;

        ClaimLifetimeNestedImpl(ClusterPoolClaimLifetime item) {
            this.builder = new ClusterPoolClaimLifetimeBuilder(this, item);
        }

        ClaimLifetimeNestedImpl() {
            this.builder = new ClusterPoolClaimLifetimeBuilder(this);
        }

        @Override
        public N and() {
            return (N)ClusterPoolSpecFluentImpl.this.withClaimLifetime(this.builder.build());
        }

        @Override
        public N endClaimLifetime() {
            return this.and();
        }
    }
}

